/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.i18n.gettext;

import com.jetbrains.toolbox.i18n.gettext.BinaryOp;
import com.jetbrains.toolbox.i18n.gettext.PluralRuleExpression;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BinaryExpression
implements PluralRuleExpression {
    @NotNull
    private final PluralRuleExpression left;
    @NotNull
    private final BinaryOp op;
    @NotNull
    private final PluralRuleExpression right;

    public BinaryExpression(@NotNull PluralRuleExpression left, @NotNull BinaryOp op, @NotNull PluralRuleExpression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        this.left = left;
        this.op = op;
        this.right = right;
    }

    @Override
    public int evaluate(int n) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.op.ordinal()]) {
            case 1 -> {
                if (this.left.evaluate(n) != this.right.evaluate(n)) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> {
                if (this.left.evaluate(n) == this.right.evaluate(n)) {
                    yield 1;
                }
                yield 0;
            }
            case 3 -> {
                if (this.left.evaluate(n) < this.right.evaluate(n)) {
                    yield 1;
                }
                yield 0;
            }
            case 4 -> {
                if (this.left.evaluate(n) <= this.right.evaluate(n)) {
                    yield 1;
                }
                yield 0;
            }
            case 5 -> {
                if (this.left.evaluate(n) > this.right.evaluate(n)) {
                    yield 1;
                }
                yield 0;
            }
            case 6 -> {
                if (this.left.evaluate(n) >= this.right.evaluate(n)) {
                    yield 1;
                }
                yield 0;
            }
            case 7 -> this.left.evaluate(n) % this.right.evaluate(n);
            case 8 -> {
                if (this.left.evaluate(n) != 0 && this.right.evaluate(n) != 0) {
                    yield 1;
                }
                yield 0;
            }
            case 9 -> {
                if (this.left.evaluate(n) != 0 || this.right.evaluate(n) != 0) {
                    yield 1;
                }
                yield 0;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BinaryExpression)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.left, (Object)((BinaryExpression)other).left)) {
            return false;
        }
        if (this.op != ((BinaryExpression)other).op) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.right, (Object)((BinaryExpression)other).right);
    }

    public int hashCode() {
        int result2 = this.left.hashCode();
        result2 = 31 * result2 + this.op.hashCode();
        result2 = 31 * result2 + this.right.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return this.left + " " + this.op + " " + this.right;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BinaryOp.values().length];
            try {
                nArray[BinaryOp.NotEquals.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinaryOp.Equals.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinaryOp.Less.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinaryOp.LessOrEquals.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinaryOp.Greater.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinaryOp.GreaterOrEquals.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinaryOp.Remainder.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinaryOp.And.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinaryOp.Or.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

