/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.i18n;

import com.jetbrains.toolbox.i18n.I18nManager;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import java.util.Arrays;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormattableLocalizableString
implements LocalizableStringEx {
    @Nullable
    private final String context;
    @NotNull
    private final String value;
    @Nullable
    private final I18nManager localI18n;
    @NotNull
    private final Pair<String, String>[] args;

    public FormattableLocalizableString(@Nullable String context2, @NotNull String value2, @Nullable I18nManager localI18n, Pair<String, String> ... args) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.context = context2;
        this.value = value2;
        this.localI18n = localI18n;
        this.args = args;
    }

    public /* synthetic */ FormattableLocalizableString(String string, String string2, I18nManager i18nManager, Pair[] pairArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            i18nManager = null;
        }
        this(string, string2, i18nManager, pairArray);
    }

    @NotNull
    public final String getValue$i18n() {
        return this.value;
    }

    @NotNull
    public final Pair<String, String>[] getArgs$i18n() {
        return this.args;
    }

    @Override
    @NotNull
    public String localize(@NotNull I18n i18n) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        if (this.context == null) {
            Pair<String, String>[] pairArray;
            object = this.localI18n;
            if (object == null || (object = object.getState()) == null || (object = (I18n)object.getValue()) == null || (object = object.tr(this.value, Arrays.copyOf(pairArray = this.args, pairArray.length))) == null) {
                pairArray = this.args;
                object = i18n.tr(this.value, Arrays.copyOf(pairArray, pairArray.length));
            }
        } else {
            Pair<String, String>[] pairArray;
            object = this.localI18n;
            if (object == null || (object = object.getState()) == null || (object = (I18n)object.getValue()) == null || (object = object.trc(this.context, this.value, Arrays.copyOf(pairArray = this.args, pairArray.length))) == null) {
                pairArray = this.args;
                object = i18n.trc(this.context, this.value, Arrays.copyOf(pairArray, pairArray.length));
            }
        }
        return object;
    }

    @NotNull
    public String toString() {
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        return string + "(value=" + this.value + ArraysKt.joinToString$default((Object[])this.args, (CharSequence)"", null, null, (int)0, null, FormattableLocalizableString::toString$lambda$0, (int)30, null) + ")";
    }

    public int hashCode() {
        String string = this.context;
        int result2 = string != null ? string.hashCode() : 0;
        result2 = 31 * result2 + this.value.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.args);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.i18n.FormattableLocalizableString");
        FormattableLocalizableString cfr_ignored_0 = (FormattableLocalizableString)other;
        if (!Intrinsics.areEqual((Object)this.context, (Object)((FormattableLocalizableString)other).context)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.value, (Object)((FormattableLocalizableString)other).value)) {
            return false;
        }
        return Arrays.equals(this.args, ((FormattableLocalizableString)other).args);
    }

    private static final CharSequence toString$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ", " + it.getFirst() + "=" + it.getSecond();
    }
}

