/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.i18n;

import com.jetbrains.toolbox.i18n.UILanguage;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.LocalDateTime;
import org.jetbrains.annotations.NotNull;

public final class Date_formatKt {
    @NotNull
    private static final Map<String, String> localesToDateFormats;

    @NotNull
    public static final String trd(@NotNull I18n $this$trd, @NotNull LocalDateTime date) {
        Intrinsics.checkNotNullParameter((Object)$this$trd, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String languageTag = $this$trd.getLocale().toLanguageTag();
        Intrinsics.checkNotNull((Object)languageTag);
        String dateFormat = localesToDateFormats.getOrDefault(languageTag, "yyyy-MM-dd");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
        String string = formatter.withLocale($this$trd.getLocale()).localizedBy($this$trd.getLocale()).format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)date));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)UILanguage.BE.toString(), (Object)"dd.MM.yy"), TuplesKt.to((Object)UILanguage.BG.toString(), (Object)"d.MM.yy"), TuplesKt.to((Object)UILanguage.CS.toString(), (Object)"d. M. yyyy"), TuplesKt.to((Object)UILanguage.DE.toString(), (Object)"dd.MM.yy"), TuplesKt.to((Object)UILanguage.EN.toString(), (Object)"yyyy-MM-dd"), TuplesKt.to((Object)UILanguage.ES_ES.toString(), (Object)"d/M/yy"), TuplesKt.to((Object)UILanguage.FR.toString(), (Object)"dd/MM/yy"), TuplesKt.to((Object)UILanguage.HU.toString(), (Object)"yyyy. MM. dd."), TuplesKt.to((Object)UILanguage.IT.toString(), (Object)"dd/MM/yy"), TuplesKt.to((Object)UILanguage.JA.toString(), (Object)"y/MM/dd"), TuplesKt.to((Object)UILanguage.KO.toString(), (Object)"yy. M. d."), TuplesKt.to((Object)UILanguage.NL.toString(), (Object)"d-M-yy"), TuplesKt.to((Object)UILanguage.PL.toString(), (Object)"yyyy-MM-dd"), TuplesKt.to((Object)UILanguage.PT_BR.toString(), (Object)"dd/MM/yy"), TuplesKt.to((Object)UILanguage.RU.toString(), (Object)"dd.MM.yy"), TuplesKt.to((Object)UILanguage.UKR.toString(), (Object)"dd.MM.yy"), TuplesKt.to((Object)UILanguage.ZH_CN.toString(), (Object)"y/M/d"), TuplesKt.to((Object)UILanguage.ZH_TW.toString(), (Object)"y/M/d")};
        localesToDateFormats = MapsKt.mapOf((Pair[])pairArray);
    }
}

