/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh.parser;

import com.jetbrains.toolbox.gateway.ssh.SupportedSshOptions;
import com.jetbrains.toolbox.gateway.ssh.parser.ParsingResult;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SshConnectionStringParser {
    @NotNull
    public static final SshConnectionStringParser INSTANCE = new SshConnectionStringParser();
    @NotNull
    private static final String USERNAME_REGEX = "[a-zA-Z0-9._-]+";
    @NotNull
    private static final String HOSTNAME_REGEX = "[a-zA-Z0-9._-]+|\\[[a-fA-F0-9:]+]|[a-fA-F0-9:]+";
    @NotNull
    private static final String PORT_REGEX = "\\d+";
    @NotNull
    private static final Regex userAndHostRegexPattern = new Regex("^(?:(?<user>[a-zA-Z0-9._-]+?)@)?(?<host>[a-zA-Z0-9._-]+|\\[[a-fA-F0-9:]+]|[a-fA-F0-9:]+)(?::(?<port>\\d+))?$");

    private SshConnectionStringParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ParsingResult parseUri(@Nullable String user, @Nullable String host, @Nullable String port2) {
        try {
            Integer n;
            String string;
            String string2;
            String string3 = user;
            if (string3 != null) {
                String u = string3;
                boolean bl = false;
                if (!new Regex(USERNAME_REGEX).matches((CharSequence)u)) throw new ParsingException("Malformed username: " + u);
                string2 = u;
            } else {
                string2 = null;
            }
            String parsedUser = string2;
            String string4 = host;
            if (string4 != null) {
                String h = string4;
                boolean bl = false;
                if (!new Regex(HOSTNAME_REGEX).matches((CharSequence)h)) throw new ParsingException("Malformed hostname: " + h);
                string = h;
            } else {
                string = null;
            }
            String parsedHost = string;
            String string5 = port2;
            if (string5 != null) {
                String p = string5;
                boolean bl = false;
                if (!new Regex(PORT_REGEX).matches((CharSequence)p)) throw new ParsingException("Malformed port: " + p);
                n = StringsKt.toIntOrNull((String)p);
            } else {
                n = null;
            }
            Integer parsedPort = n;
            String string6 = parsedHost;
            String string7 = string6;
            if (string6 != null) return new ParsingResult.Success(parsedUser, string7, parsedPort, MapsKt.emptyMap());
            string7 = "";
            return new ParsingResult.Success(parsedUser, string7, parsedPort, MapsKt.emptyMap());
        }
        catch (ParsingException e) {
            return new ParsingResult.Failure(e.getReason());
        }
    }

    @NotNull
    public final ParsingResult parse(@NotNull String str) {
        UserHostPort userHostPort;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (StringsKt.startsWith$default((String)str, (String)"ssh ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)str, (String)"ssh.exe ", (boolean)false, (int)2, null)) {
            return this.parseSshCommand(str);
        }
        try {
            userHostPort = this.parseUserHostPart(str);
        }
        catch (ParsingException e) {
            return new ParsingResult.Failure(e.getReason());
        }
        UserHostPort userHostPort2 = userHostPort;
        return new ParsingResult.Success(userHostPort2.getUser(), userHostPort2.getHost(), userHostPort2.getPort(), MapsKt.emptyMap());
    }

    private final UserHostPort parseUserHostPart(String str) {
        Integer n;
        Object it;
        Object object;
        String user;
        MatchResult matchResult;
        block11: {
            block10: {
                Object object2;
                String input = ((Object)StringsKt.trim((CharSequence)str)).toString();
                if (((CharSequence)input).length() == 0) {
                    return new UserHostPort(null, "", null);
                }
                MatchResult matchResult2 = Regex.find$default((Regex)userAndHostRegexPattern, (CharSequence)input, (int)0, (int)2, null);
                if (matchResult2 == null) {
                    throw new ParsingException("Malformed [<user>@]<host>[:<port>] part");
                }
                matchResult = matchResult2;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"user");
                user = matchGroup != null ? matchGroup.getValue() : null;
                object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"host");
                if (object == null || (object = object.getValue()) == null) break block10;
                it = object;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"]", (boolean)false, (int)2, null)) {
                    String string = ((String)it).substring(1, ((String)it).length() - 1);
                    object2 = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                } else {
                    object2 = it;
                }
                object = object2;
                if (object2 != null) break block11;
            }
            throw new ParsingException("No port specified");
        }
        Object host = object;
        Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"port");
        if (object3 != null && (object3 = object3.getValue()) != null) {
            it = object3;
            boolean bl = false;
            Integer n2 = StringsKt.toIntOrNull((String)it);
            if (n2 == null) {
                throw new ParsingException("Port should be a number");
            }
            n = (int)n2;
        } else {
            n = null;
        }
        Integer port2 = n;
        return new UserHostPort(user, (String)host, port2);
    }

    private final ParsingResult parseSshCommand(String str) {
        Pair<Map<String, String>, UserHostPort> pair;
        String command2 = StringsKt.startsWith$default((String)str, (String)"ssh ", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)str, (CharSequence)"ssh ") : StringsKt.removePrefix((String)str, (CharSequence)"ssh.exe ");
        String escapedCommand = StringsKt.replace$default((String)command2, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
        List<String> tokens = this.tokenize(escapedCommand);
        try {
            pair = this.parseOptionsAndUserHost(tokens);
        }
        catch (ParsingException e) {
            return new ParsingResult.Failure(e.getReason());
        }
        Pair<Map<String, String>, UserHostPort> pair2 = pair;
        Map options = (Map)pair2.component1();
        UserHostPort userHostPort = (UserHostPort)pair2.component2();
        return new ParsingResult.Success(userHostPort.getUser(), userHostPort.getHost(), userHostPort.getPort(), options);
    }

    private final List<String> tokenize(String str) {
        StreamTokenizer tok = new StreamTokenizer(new StringReader(str));
        tok.resetSyntax();
        tok.wordChars(32, 255);
        tok.whitespaceChars(0, 32);
        tok.quoteChar(34);
        tok.quoteChar(39);
        tok.commentChar(35);
        List arguments = new ArrayList();
        while (tok.nextToken() != -1) {
            String string = tok.sval;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sval");
            arguments.add(string);
        }
        return arguments;
    }

    private final Pair<Map<String, String>, UserHostPort> parseOptionsAndUserHost(List<String> tokens) {
        List mutableTokens = CollectionsKt.toMutableList((Collection)tokens);
        Map parsedOptions = new LinkedHashMap();
        String currentOption = null;
        UserHostPort userHostPort = null;
        while (!((Collection)mutableTokens).isEmpty()) {
            String next2 = (String)CollectionsKt.first((List)mutableTokens);
            if (StringsKt.startsWith$default((String)next2, (String)"-", (boolean)false, (int)2, null)) {
                if (currentOption != null) {
                    var7_7 = parsedOptions;
                    var8_8 = TuplesKt.to((Object)currentOption, (Object)"");
                    var7_7.put(var8_8.getFirst(), var8_8.getSecond());
                }
                currentOption = next2;
            } else if (currentOption != null) {
                if (!SupportedSshOptions.INSTANCE.getOptions().contains(currentOption)) {
                    throw new ParsingException("Illegal option " + currentOption + ".\nFor more detailed SSH configuration, use an ssh_config file.\nSupported options: " + CollectionsKt.joinToString$default((Iterable)SupportedSshOptions.INSTANCE.getOptions(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
                }
                var7_7 = parsedOptions;
                var8_8 = TuplesKt.to((Object)currentOption, (Object)next2);
                var7_7.put(var8_8.getFirst(), var8_8.getSecond());
                currentOption = null;
            } else if (userHostPort == null) {
                userHostPort = this.parseUserHostPart(next2);
            } else {
                throw new ParsingException("Malformed input: expected flag and found value: " + next2);
            }
            mutableTokens.removeFirst();
        }
        if (userHostPort == null) {
            throw new ParsingException("[<user>@]<host>[:<port>] not specified");
        }
        return TuplesKt.to((Object)parsedOptions, userHostPort);
    }

    private static final class ParsingException
    extends Exception {
        @NotNull
        private final String reason;

        public ParsingException(@NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super(reason);
            this.reason = reason;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }
    }

    private static final class UserHostPort {
        @Nullable
        private final String user;
        @NotNull
        private final String host;
        @Nullable
        private final Integer port;

        public UserHostPort(@Nullable String user, @NotNull String host, @Nullable Integer port2) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.user = user;
            this.host = host;
            this.port = port2;
        }

        @Nullable
        public final String getUser() {
            return this.user;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @Nullable
        public final Integer getPort() {
            return this.port;
        }

        @Nullable
        public final String component1() {
            return this.user;
        }

        @NotNull
        public final String component2() {
            return this.host;
        }

        @Nullable
        public final Integer component3() {
            return this.port;
        }

        @NotNull
        public final UserHostPort copy(@Nullable String user, @NotNull String host, @Nullable Integer port2) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return new UserHostPort(user, host, port2);
        }

        public static /* synthetic */ UserHostPort copy$default(UserHostPort userHostPort, String string, String string2, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = userHostPort.user;
            }
            if ((n2 & 2) != 0) {
                string2 = userHostPort.host;
            }
            if ((n2 & 4) != 0) {
                n = userHostPort.port;
            }
            return userHostPort.copy(string, string2, n);
        }

        @NotNull
        public String toString() {
            return "UserHostPort(user=" + this.user + ", host=" + this.host + ", port=" + this.port + ")";
        }

        public int hashCode() {
            int result2 = this.user == null ? 0 : this.user.hashCode();
            result2 = result2 * 31 + this.host.hashCode();
            result2 = result2 * 31 + (this.port == null ? 0 : ((Object)this.port).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserHostPort)) {
                return false;
            }
            UserHostPort userHostPort = (UserHostPort)other;
            if (!Intrinsics.areEqual((Object)this.user, (Object)userHostPort.user)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.host, (Object)userHostPort.host)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.port, (Object)userHostPort.port);
        }
    }
}

