/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh.openssh;

import com.jetbrains.toolbox.api.remoteDev.ssh.SshConnectionInfo;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.ssh.SshAuthenticationManager;
import com.jetbrains.toolbox.gateway.ssh.SshConnection;
import com.jetbrains.toolbox.gateway.ssh.SshConnectionService;
import com.jetbrains.toolbox.gateway.ssh.SshExecutableLocation;
import com.jetbrains.toolbox.gateway.ssh.SshOutputDumpImpl;
import com.jetbrains.toolbox.gateway.ssh.openssh.GatewayAskpassHandler;
import com.jetbrains.toolbox.gateway.ssh.openssh.OpenSshConnection;
import com.jetbrains.toolbox.gateway.ssh.openssh.SshConnectionInfoPreprocessor;
import com.jetbrains.toolbox.manager.DialogManager;
import com.jetbrains.toolbox.openssh.OpenSshFactory;
import com.jetbrains.toolbox.openssh.SshExecutable;
import com.jetbrains.toolbox.opensshAskpass.AskpassService;
import com.jetbrains.toolbox.opensshAskpass.AskpassServiceStarter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import okio.FileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OpenSshConnectionServiceImpl
extends SshConnectionService {
    @NotNull
    private final SshExecutableLocation sshExecutableLocation;
    @NotNull
    private final SshAuthenticationManager authenticationManager;
    @NotNull
    private final DialogManager dialogManager;
    @NotNull
    private final OpenSshFactory openSshFactory;
    @NotNull
    private final SshConnectionInfoPreprocessor preprocessor;
    @NotNull
    private final FileSystem fileSystem;
    @Nullable
    private final SshOutputDumpImpl sshOutputDumpImpl;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Lazy askpassService$delegate;

    public OpenSshConnectionServiceImpl(@NotNull SshExecutableLocation sshExecutableLocation, @NotNull SshAuthenticationManager authenticationManager, @NotNull DialogManager dialogManager, @NotNull OpenSshFactory openSshFactory, @NotNull AskpassServiceStarter openSshAskpassServiceStarter, @NotNull GatewayAskpassHandler gatewayPromptHandler, @NotNull SshConnectionInfoPreprocessor preprocessor, @NotNull FileSystem fileSystem, @Nullable SshOutputDumpImpl sshOutputDumpImpl, @NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)sshExecutableLocation, (String)"sshExecutableLocation");
        Intrinsics.checkNotNullParameter((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkNotNullParameter((Object)dialogManager, (String)"dialogManager");
        Intrinsics.checkNotNullParameter((Object)openSshFactory, (String)"openSshFactory");
        Intrinsics.checkNotNullParameter((Object)openSshAskpassServiceStarter, (String)"openSshAskpassServiceStarter");
        Intrinsics.checkNotNullParameter((Object)gatewayPromptHandler, (String)"gatewayPromptHandler");
        Intrinsics.checkNotNullParameter((Object)preprocessor, (String)"preprocessor");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.sshExecutableLocation = sshExecutableLocation;
        this.authenticationManager = authenticationManager;
        this.dialogManager = dialogManager;
        this.openSshFactory = openSshFactory;
        this.preprocessor = preprocessor;
        this.fileSystem = fileSystem;
        this.sshOutputDumpImpl = sshOutputDumpImpl;
        this.scope = scope2;
        this.askpassService$delegate = LazyKt.lazy(() -> OpenSshConnectionServiceImpl.askpassService_delegate$lambda$0(openSshAskpassServiceStarter, gatewayPromptHandler, this));
    }

    private final AskpassService getAskpassService() {
        Lazy lazy = this.askpassService$delegate;
        return (AskpassService)lazy.getValue();
    }

    @Override
    @Nullable
    protected Object createNewSshConnection(@NotNull DevEnvironmentId devEnvironmentId, @NotNull SshConnectionInfo sshConnectionInfo, @NotNull Continuation<? super SshConnection> $completion) {
        return new OpenSshConnection(devEnvironmentId, FlowExtensionsKt.mapState(this.sshExecutableLocation.getState(), OpenSshConnectionServiceImpl::createNewSshConnection$lambda$1), sshConnectionInfo, this.getAskpassService(), this.authenticationManager, this.preprocessor, this.openSshFactory, this.dialogManager, this.fileSystem, this.sshOutputDumpImpl, this.scope);
    }

    private static final AskpassService askpassService_delegate$lambda$0(AskpassServiceStarter $openSshAskpassServiceStarter, GatewayAskpassHandler $gatewayPromptHandler, OpenSshConnectionServiceImpl this$0) {
        return $openSshAskpassServiceStarter.start($gatewayPromptHandler, this$0.scope);
    }

    private static final String createNewSshConnection$lambda$1(SshExecutable it) {
        SshExecutable sshExecutable = it;
        return sshExecutable != null ? sshExecutable.getLocation() : null;
    }
}

