/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh.connection;

import com.jetbrains.toolbox.api.remoteDev.connection.ForwardedConnectionHandle;
import com.jetbrains.toolbox.api.remoteDev.connection.HostTunnelConnector;
import com.jetbrains.toolbox.gateway.ssh.SshPortForwarder;
import com.jetbrains.toolbox.gateway.ssh.SshProcess;
import java.net.InetAddress;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

public final class SshHostTunnelConnector
implements HostTunnelConnector {
    @NotNull
    private final SshProcess sshProcess;
    @NotNull
    private final CoroutineScope globalCoroutineScope;

    public SshHostTunnelConnector(@NotNull SshProcess sshProcess, @NotNull CoroutineScope globalCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)sshProcess, (String)"sshProcess");
        Intrinsics.checkNotNullParameter((Object)globalCoroutineScope, (String)"globalCoroutineScope");
        this.sshProcess = sshProcess;
        this.globalCoroutineScope = globalCoroutineScope;
    }

    @NotNull
    public ForwardedConnectionHandle forwardIdePort(@NotNull HostTunnelConnector.Protocol protocol, @NotNull InetAddress remoteAddress2, int remotePort, @NotNull InetAddress localAddress) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)remoteAddress2, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        return SshPortForwarder.INSTANCE.forwardPort(localAddress, remoteAddress2, remotePort, this.sshProcess, this.globalCoroutineScope);
    }

    public boolean isProtocolSupported(@NotNull HostTunnelConnector.Protocol protocol) {
        return super.isProtocolSupported(protocol);
    }
}

