/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh.configImport.openssh;

import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfig;
import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfigProvider;
import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfigs;
import com.jetbrains.toolbox.gateway.ssh.configImport.openssh.OpenSshImportedSshConnectionInfo;
import com.jetbrains.toolbox.util.GetPresentablePathKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nOpenSshImportedConfigsProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshImportedConfigsProviderImpl.kt\ncom/jetbrains/toolbox/gateway/ssh/configImport/openssh/OpenSshImportedConfigsProviderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 FileSystem.kt\nokio/FileSystem\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1#2:56\n66#3:57\n52#3,4:59\n60#3,10:64\n56#3,3:74\n71#3,3:77\n67#4:58\n68#4:63\n1563#5:80\n1634#5,3:81\n774#5:84\n865#5,2:85\n1563#5:87\n1634#5,3:88\n827#5:91\n855#5,2:92\n1374#5:94\n1460#5,5:95\n1563#5:100\n1634#5,3:101\n*S KotlinDebug\n*F\n+ 1 OpenSshImportedConfigsProviderImpl.kt\ncom/jetbrains/toolbox/gateway/ssh/configImport/openssh/OpenSshImportedConfigsProviderImpl\n*L\n27#1:57\n27#1:59,4\n27#1:64,10\n27#1:74,3\n27#1:77,3\n27#1:58\n27#1:63\n36#1:80\n36#1:81,3\n37#1:84\n37#1:85,2\n38#1:87\n38#1:88,3\n39#1:91\n39#1:92,2\n40#1:94\n40#1:95,5\n42#1:100\n42#1:101,3\n*E\n"})
public final class OpenSshImportedConfigsProviderImpl
implements ImportedSshConfigProvider {
    @NotNull
    private final String configPath;
    @NotNull
    private final FileSystem fs;

    public OpenSshImportedConfigsProviderImpl(@NotNull String configPath, @NotNull FileSystem fs) {
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        this.configPath = configPath;
        this.fs = fs;
    }

    @Override
    @NotNull
    public List<ImportedSshConfigs> getImportedSshConfigs() {
        Object object;
        String source;
        block3: {
            block2: {
                source = GetPresentablePathKt.getPresentablePath$default(Path.Companion.get$default((Path.Companion)Path.Companion, (String)this.configPath, (boolean)false, (int)1, null), null, null, 6, null);
                object = this.getUserSshConfigContent();
                if (object == null) break block2;
                String p0 = object;
                boolean bl = false;
                List<ImportedSshConfig> list2 = this.parseSshConfig(p0);
                object = list2;
                if (list2 != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        List<ImportedSshConfig> entries2 = object;
        return CollectionsKt.listOf((Object)new ImportedSshConfigs(source, "ssh_config", entries2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String getUserSshConfigContent() {
        Object object;
        Path sshConfigPath = Path.Companion.get$default((Path.Companion)Path.Companion, (String)this.configPath, (boolean)false, (int)1, null);
        if (!this.fs.exists(sshConfigPath)) {
            return null;
        }
        try {
            String string;
            Throwable thrown$iv$iv;
            block18: {
                void this_$iv;
                object = this.fs;
                Path file$iv = sshConfigPath;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$getUserSshConfigContent_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    string = $this$getUserSshConfigContent_u24lambda_u240.readString(Charsets.UTF_8);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        string = null;
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block19: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block19;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            String result$iv$iv = string;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            object = result$iv$iv;
        }
        catch (IOException e) {
            Logger.INSTANCE.warn((Throwable)e, "Failed to read user's ssh config at path: " + sshConfigPath);
            return null;
        }
        FileSystem fileSystem = object;
        return fileSystem;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ImportedSshConfig> parseSshConfig(@NotNull String config) {
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Iterable $this$map$iv = StringsKt.lines((CharSequence)config);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trimStart((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"Host ", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.removePrefix((String)it, (CharSequence)"Host "));
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)it, (CharSequence)"*", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"?", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"!", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)",", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterNotTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            list$iv$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void alias;
            list$iv$iv = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            OpenSshImportedSshConnectionInfo info = new OpenSshImportedSshConnectionInfo((String)alias, this.configPath);
            collection.add(new ImportedSshConfig("openssh_" + (String)alias, (String)alias, info, CollectionsKt.emptyList()));
        }
        return (List)destination$iv$iv;
    }
}

