/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh.configImport.intellij;

import com.jetbrains.toolbox.common.extensions.NodeListExtensions;
import com.jetbrains.toolbox.gateway.ssh.configImport.intellij.IntellijSshConfig;
import com.jetbrains.toolbox.gateway.ssh.configImport.intellij.UtilKt;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SourceDebugExtension(value={"SMAP\nIntellijSshConfigParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijSshConfigParser.kt\ncom/jetbrains/toolbox/gateway/ssh/configImport/intellij/IntellijSshConfigsParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1#2:59\n1#2:70\n1617#3,9:60\n1869#3:69\n1870#3:71\n1626#3:72\n*S KotlinDebug\n*F\n+ 1 IntellijSshConfigParser.kt\ncom/jetbrains/toolbox/gateway/ssh/configImport/intellij/IntellijSshConfigsParser\n*L\n28#1:70\n28#1:60,9\n28#1:69\n28#1:71\n28#1:72\n*E\n"})
public final class IntellijSshConfigsParser {
    @NotNull
    public static final IntellijSshConfigsParser INSTANCE = new IntellijSshConfigsParser();

    private IntellijSshConfigsParser() {
    }

    @NotNull
    public final List<IntellijSshConfig> parse(@NotNull InputStream inputStream) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                Document document = UtilKt.preparseXml(inputStream);
                object = document;
                if (object == null) break block2;
                Document p0 = object;
                boolean bl = false;
                List<IntellijSshConfig> list2 = this.parseDocument(p0);
                object = list2;
                if (list2 != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IntellijSshConfig> parseDocument(Document document) {
        void $this$mapNotNullTo$iv$iv;
        Iterable<Node> sshConfigs;
        NodeList nodeList = document.getElementsByTagName("sshConfig");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
        Iterable<Node> $this$mapNotNull$iv = sshConfigs = NodeListExtensions.INSTANCE.toIterable(nodeList);
        boolean $i$f$mapNotNull = false;
        Iterable<Node> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IntellijSshConfig it$iv$iv;
            String keyPath;
            String authType;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Node node2 = (Node)element$iv$iv;
            boolean bl2 = false;
            NamedNodeMap attributes = node2.getAttributes();
            Node node3 = attributes.getNamedItem("id");
            String id = node3 != null ? node3.getNodeValue() : null;
            Node node4 = attributes.getNamedItem("customName");
            String customName = node4 != null ? node4.getNodeValue() : null;
            Node node5 = attributes.getNamedItem("host");
            String host = node5 != null ? node5.getNodeValue() : null;
            Object object = attributes.getNamedItem("port");
            Integer port2 = object != null && (object = object.getNodeValue()) != null ? StringsKt.toIntOrNull((String)object) : null;
            Node node6 = attributes.getNamedItem("username");
            String username = node6 != null ? node6.getNodeValue() : null;
            Node node7 = attributes.getNamedItem("authType");
            String string = authType = node7 != null ? node7.getNodeValue() : null;
            if (!Intrinsics.areEqual((Object)authType, (Object)"PASSWORD")) {
                Object object2 = attributes.getNamedItem("keyPath");
                if (object2 != null && (object2 = object2.getNodeValue()) != null) {
                    Object object3 = object2;
                    IntellijSshConfigsParser intellijSshConfigsParser = INSTANCE;
                    Object p0 = object3;
                    boolean bl3 = false;
                    v9 = intellijSshConfigsParser.expandKeyPathMacro((String)p0);
                } else {
                    v9 = null;
                }
            } else {
                v9 = keyPath = null;
            }
            if ((id == null || host == null || port2 == null || username == null ? null : new IntellijSshConfig(id, customName, host, port2, username, keyPath)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List configs = (List)destination$iv$iv;
        return configs;
    }

    private final String expandKeyPathMacro(String keyPath) {
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return StringsKt.replace$default((String)keyPath, (String)"$USER_HOME$", (String)string, (boolean)false, (int)4, null);
    }
}

