/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.localization.LocalizableStringFactory;
import com.jetbrains.toolbox.api.remoteDev.AfterDisconnectHook;
import com.jetbrains.toolbox.api.remoteDev.BeforeConnectionHook;
import com.jetbrains.toolbox.api.remoteDev.EnvironmentVisibilityState;
import com.jetbrains.toolbox.api.remoteDev.RemoteEnvironmentAbility;
import com.jetbrains.toolbox.api.remoteDev.RemoteProviderEnvironment;
import com.jetbrains.toolbox.api.remoteDev.deploy.DeploymentSettings;
import com.jetbrains.toolbox.api.remoteDev.environments.EnvironmentContentsView;
import com.jetbrains.toolbox.api.remoteDev.environments.SshEnvironmentContentsView;
import com.jetbrains.toolbox.api.remoteDev.ssh.SshConnectionInfo;
import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentDescription;
import com.jetbrains.toolbox.api.remoteDev.states.RemoteEnvironmentState;
import com.jetbrains.toolbox.api.remoteDev.states.StandardRemoteEnvironmentState;
import com.jetbrains.toolbox.api.ui.actions.ActionDescription;
import com.jetbrains.toolbox.gateway.ssh.SshRemoteEnvironment;
import com.jetbrains.toolbox.gateway.ssh.SshRemoteProvider;
import com.jetbrains.toolbox.gateway.ssh.model.Endpoint;
import com.jetbrains.toolbox.gateway.ssh.presentation.UtilKt;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class SshRemoteEnvironment
extends RemoteProviderEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SshRemoteProvider extension;
    @NotNull
    private final Endpoint endpoint;
    @NotNull
    private final CompletableDeferred<Unit> onFirstVisibility;
    @NotNull
    private final Set<RemoteEnvironmentAbility> supportedFeatures;
    @NotNull
    private final MutableStateFlow<RemoteEnvironmentState> state;
    @NotNull
    private final MutableStateFlow<EnvironmentDescription> description;
    @NotNull
    private final MutableSharedFlow<Boolean> connectionRequest;
    @NotNull
    private final MutableStateFlow<List<ActionDescription>> actionsList;
    @NotNull
    private final Map<LocalizableString, String> additionalEnvironmentInformation;
    @NotNull
    private final BeforeConnectionHook autoConnectBefore;
    @NotNull
    private final autoConnectAfter.1 autoConnectAfter;

    public SshRemoteEnvironment(@NotNull SshRemoteProvider extension2, @NotNull Endpoint endpoint, @NotNull LocalizableStringFactory i18n) {
        Intrinsics.checkNotNullParameter((Object)((Object)extension2), (String)"extension");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        super(Companion.toUsernameHostPortString(endpoint));
        this.extension = extension2;
        this.endpoint = endpoint;
        this.onFirstVisibility = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.supportedFeatures = SetsKt.setOf((Object)RemoteEnvironmentAbility.CAN_RENAME);
        this.state = StateFlowKt.MutableStateFlow((Object)StandardRemoteEnvironmentState.Active);
        this.description = StateFlowKt.MutableStateFlow((Object)new EnvironmentDescription.General(null));
        this.connectionRequest = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.actionsList = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        LocalizableString localizableString = i18n.ptrl("Connection string");
        String string = this.endpoint.originalConnectionString;
        if (string == null) {
            string = Companion.toSshConnectionString(this.endpoint);
        }
        this.additionalEnvironmentInformation = MapsKt.mapOf((Pair)TuplesKt.to((Object)localizableString, (Object)string));
        this.autoConnectBefore = () -> SshRemoteEnvironment.autoConnectBefore$lambda$0(this);
        this.autoConnectAfter = new AfterDisconnectHook(this){
            final /* synthetic */ SshRemoteEnvironment this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterDisconnect() {
                this.this$0.getExtension().setAutoConnect(this.this$0.getId(), false);
            }

            public void afterDisconnect(boolean isManual) {
                super.afterDisconnect(isManual);
            }
        };
        if (this.extension.getAutoConnect(this.getId())) {
            BuildersKt.launch$default((CoroutineScope)this.extension.getPluginScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ SshRemoteEnvironment this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = SshRemoteEnvironment.access$getOnFirstVisibility$p(this.this$0).await((Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.label = 2;
                            v1 = this.this$0.connect((Continuation<? super Unit>)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl21
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl21:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @NotNull
    public final SshRemoteProvider getExtension() {
        return this.extension;
    }

    @NotNull
    public final Endpoint getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public String getName() {
        String string = this.endpoint.alias;
        if (string == null) {
            string = UtilKt.defaultPresentableName(this.endpoint);
        }
        return string;
    }

    public void setName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        if (Intrinsics.areEqual((Object)newName, (Object)this.getName())) {
            return;
        }
        this.endpoint.alias = newName;
        this.extension.refresh();
    }

    @NotNull
    public Set<RemoteEnvironmentAbility> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @NotNull
    public MutableStateFlow<RemoteEnvironmentState> getState() {
        return this.state;
    }

    @NotNull
    public MutableStateFlow<EnvironmentDescription> getDescription() {
        return this.description;
    }

    @NotNull
    public MutableSharedFlow<Boolean> getConnectionRequest() {
        return this.connectionRequest;
    }

    @Nullable
    public Object getContentsView(@NotNull Continuation<? super EnvironmentContentsView> $completion) {
        return new SshEnvironmentContentsView(this){
            final /* synthetic */ SshRemoteEnvironment this$0;
            {
                this.this$0 = $receiver;
            }

            public final Object getConnectionInfo(Continuation<? super SshConnectionInfo> $completion) {
                return Endpoint.copy$default(this.this$0.getEndpoint(), null, 0, null, null, false, null, null, null, null, null, this.this$0.getExtension().getTimeoutMillis(), 1023, null);
            }

            public boolean getSupportsRedeploy() {
                return super.getSupportsRedeploy();
            }

            public void close() {
                super.close();
            }

            public DeploymentSettings getDeploymentSettings() {
                return super.getDeploymentSettings();
            }
        };
    }

    public void setVisible(@NotNull EnvironmentVisibilityState environmentVisibilityState) {
        Intrinsics.checkNotNullParameter((Object)environmentVisibilityState, (String)"environmentVisibilityState");
        Logger.INSTANCE.debug("Visibility changed " + environmentVisibilityState);
        if (environmentVisibilityState.getStatusVisible() || environmentVisibilityState.getContentsVisible() || environmentVisibilityState.isBackendConnected()) {
            this.onFirstVisibility.complete((Object)Unit.INSTANCE);
        }
    }

    @NotNull
    public MutableStateFlow<List<ActionDescription>> getActionsList() {
        return this.actionsList;
    }

    @Nullable
    public final Object connect(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.getConnectionRequest().emit((Object)Boxing.boxBoolean((boolean)true), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public Map<LocalizableString, String> getAdditionalEnvironmentInformation() {
        return this.additionalEnvironmentInformation;
    }

    @NotNull
    public List<BeforeConnectionHook> getBeforeConnectionHooks() {
        return CollectionsKt.listOf((Object)this.autoConnectBefore);
    }

    @NotNull
    public List<AfterDisconnectHook> getAfterDisconnectHooks() {
        return CollectionsKt.listOf((Object)this.autoConnectAfter);
    }

    public void onDelete() {
        this.extension.removeEnvironment(this);
    }

    private static final void autoConnectBefore$lambda$0(SshRemoteEnvironment this$0) {
        this$0.extension.setAutoConnect(this$0.getId(), true);
    }

    public static final /* synthetic */ CompletableDeferred access$getOnFirstVisibility$p(SshRemoteEnvironment $this) {
        return $this.onFirstVisibility;
    }

    @SourceDebugExtension(value={"SMAP\nSshRemoteEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshRemoteEnvironment.kt\ncom/jetbrains/toolbox/gateway/ssh/SshRemoteEnvironment$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String toUsernameHostPortString(@NotNull SshConnectionInfo $this$toUsernameHostPortString) {
            Intrinsics.checkNotNullParameter((Object)$this$toUsernameHostPortString, (String)"<this>");
            String userNamePrefix = $this$toUsernameHostPortString.getUserName() != null ? $this$toUsernameHostPortString.getUserName() + "@" : "";
            String portSuffix = $this$toUsernameHostPortString.getPort() != 0 ? ":" + $this$toUsernameHostPortString.getPort() : "";
            return userNamePrefix + $this$toUsernameHostPortString.getHost() + portSuffix;
        }

        @NotNull
        public final String toSshConnectionString(@NotNull SshConnectionInfo $this$toSshConnectionString) {
            Object object;
            Object keys;
            String portOption;
            String userNamePrefix;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)$this$toSshConnectionString, (String)"<this>");
                    userNamePrefix = $this$toSshConnectionString.getUserName() != null ? $this$toSshConnectionString.getUserName() + "@" : "";
                    portOption = $this$toSshConnectionString.getPort() != 0 ? " -p " + $this$toSshConnectionString.getPort() : "";
                    Object object2 = $this$toSshConnectionString.getPrivateKeyPaths();
                    if (object2 == null || (object2 = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)" ", null, null, (int)0, null, Companion::toSshConnectionString$lambda$0, (int)30, null)) == null) {
                        object2 = keys = "";
                    }
                    if ((object = $this$toSshConnectionString.getSshConfigPath()) == null) break block4;
                    String it = object;
                    boolean bl = false;
                    String string = " -F \"" + it + "\"";
                    object = string;
                    if (string != null) break block5;
                }
                object = "";
            }
            String config = object;
            return "ssh" + portOption + (String)keys + config + " " + userNamePrefix + $this$toSshConnectionString.getHost();
        }

        private static final CharSequence toSshConnectionString$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return " -i \"" + it + "\"";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

