/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.api.remoteDev.connection.ForwardedConnection;
import com.jetbrains.toolbox.api.remoteDev.connection.ForwardedConnectionHandle;
import com.jetbrains.toolbox.gateway.ssh.SshPortForwarderKt;
import com.jetbrains.toolbox.gateway.ssh.SshProcess;
import java.io.Closeable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CancellationException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.selects.SelectBuilder;
import kotlinx.coroutines.selects.SelectImplementation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nSshPortForwarder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshPortForwarder.kt\ncom/jetbrains/toolbox/gateway/ssh/SshForwardedConnectionHandle\n+ 2 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n+ 3 Select.kt\nkotlinx/coroutines/selects/SelectKt\n*L\n1#1,277:1\n7#2,7:278\n54#3,5:285\n*S KotlinDebug\n*F\n+ 1 SshPortForwarder.kt\ncom/jetbrains/toolbox/gateway/ssh/SshForwardedConnectionHandle\n*L\n82#1:278,7\n108#1:285,5\n*E\n"})
public final class SshForwardedConnectionHandle
implements ForwardedConnectionHandle {
    @NotNull
    private final InetAddress localAddress;
    @NotNull
    private final InetAddress remoteAddress;
    private final int remotePort;
    @NotNull
    private final SshProcess sshProcess;
    @NotNull
    private final CompletableDeferred<Unit> isClosed;
    @NotNull
    private final CompletableDeferred<ForwardedConnection> forwardedConnection;
    @NotNull
    private final Job sshProcessFinish;
    @NotNull
    private final Job forwardersJob;
    @NotNull
    private final CoroutineScope forwardersScope;
    @NotNull
    private final String remoteReadable;
    @NotNull
    private final ServerSocket persistentSocket;

    /*
     * WARNING - void declaration
     */
    public SshForwardedConnectionHandle(@NotNull InetAddress localAddress, @NotNull InetAddress remoteAddress2, int remotePort, @NotNull SshProcess sshProcess, @NotNull CoroutineScope outerScope) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        Intrinsics.checkNotNullParameter((Object)remoteAddress2, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)sshProcess, (String)"sshProcess");
        Intrinsics.checkNotNullParameter((Object)outerScope, (String)"outerScope");
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress2;
        this.remotePort = remotePort;
        this.sshProcess = sshProcess;
        this.isClosed = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.forwardedConnection = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.sshProcessFinish = BuildersKt.launch$default((CoroutineScope)outerScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SshForwardedConnectionHandle this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = SshForwardedConnectionHandle.access$getSshProcess$p(this.this$0).awaitFinished((Continuation<? super Integer>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.forwardersJob = BuildersKt.launch$default((CoroutineScope)outerScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SshForwardedConnectionHandle this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$launch;
                        this.label = 1;
                        Object object2 = SshForwardedConnectionHandle.access$awaitClosed(this.this$0, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        void $this$launch;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            CoroutineScopeKt.cancel$default((CoroutineScope)$this$launch, null, (int)1, null);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.forwardersScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)outerScope.getCoroutineContext().plus((CoroutineContext)JobKt.Job((Job)this.forwardersJob)));
        this.remoteReadable = this.remoteAddress.getHostAddress() + ":" + this.remotePort;
        SshForwardedConnectionHandle sshForwardedConnectionHandle = this;
        boolean $i$f$catching = false;
        try {
            boolean bl = false;
            ServerSocket socket = new ServerSocket();
            try {
                socket.bind(new InetSocketAddress(this.localAddress, this.remotePort));
            }
            catch (Exception e) {
                socket.close();
                throw e;
            }
            object2 = Result.constructor-impl((Object)socket);
        }
        catch (CancellationException c$iv) {
            throw c$iv;
        }
        catch (Throwable t$iv) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
        }
        SshForwardedConnectionHandle sshForwardedConnectionHandle2 = sshForwardedConnectionHandle;
        Object object3 = object2;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable == null) {
            object = object3;
        } else {
            void it;
            t$iv = throwable;
            sshForwardedConnectionHandle = sshForwardedConnectionHandle2;
            boolean bl = false;
            Logger.INSTANCE.debug((Throwable)it, "Failed to open a persistent local socket on port " + this.remotePort + ". Opening on random port");
            ServerSocket socket = new ServerSocket();
            try {
                socket.bind(new InetSocketAddress(this.localAddress, 0));
                object2 = socket;
            }
            catch (Exception e) {
                socket.close();
                throw e;
            }
            object = object2;
            sshForwardedConnectionHandle2 = sshForwardedConnectionHandle;
        }
        sshForwardedConnectionHandle2.persistentSocket = (ServerSocket)object;
        this.forwardPort();
    }

    private final Object awaitClosed(Continuation<? super Unit> $completion) {
        boolean $i$f$select = false;
        SelectImplementation $this$select_u24lambda_u240$iv = new SelectImplementation($completion.getContext());
        boolean bl = false;
        SelectBuilder $this$awaitClosed_u24lambda_u242 = (SelectBuilder)$this$select_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$awaitClosed_u24lambda_u242.invoke(this.isClosed.getOnJoin(), (Function1)new Function1<Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
        $this$awaitClosed_u24lambda_u242.invoke(this.sshProcessFinish.getOnJoin(), (Function1)new Function1<Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
        Object object = $this$select_u24lambda_u240$iv.doSelect($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void close() {
        this.isClosed.complete((Object)Unit.INSTANCE);
        this.persistentSocket.close();
    }

    @Nullable
    public Object getForwardedConnection(@NotNull Continuation<? super ForwardedConnection> $completion) {
        return this.forwardedConnection.await($completion);
    }

    private final void forwardPort() {
        Logger.INSTANCE.info("Starting forwarding remote " + this.remoteReadable);
        int port2 = this.persistentSocket.getLocalPort();
        Logger.INSTANCE.debug("Created server socket listening on " + this.persistentSocket.getInetAddress().getHostAddress() + ":" + port2 + " " + this.persistentSocket.hashCode());
        this.forwardedConnection.complete((Object)new ForwardedConnection(port2, this.remotePort));
        BuildersKt.launch$default((CoroutineScope)this.forwardersScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int I$0;
            int I$1;
            int I$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SshForwardedConnectionHandle this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var16_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.L$0 = $this$launch;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.L$3 = null;
                            this.L$4 = null;
                            this.label = 1;
                            v0 = SshForwardedConnectionHandle.access$waitForClientConnection(this.this$0, SshForwardedConnectionHandle.access$getPersistentSocket$p(this.this$0), (Continuation)this);
                            if (v0 == var16_3) {
                                return var16_3;
                            }
                            ** GOTO lbl21
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl21:
                        // 2 sources

                        if ((Socket)v0 == null) break;
                        var4_5 = clientConnection;
                        var5_6 = this.this$0;
                        var6_7 = null;
                        it = (Socket)var4_5;
                        $i$a$-use-SshForwardedConnectionHandle$forwardPort$1$1 = 0;
                        $i$f$catching = 0;
                        $i$a$-catching-SshForwardedConnectionHandle$forwardPort$1$1$socket$1 = 0;
                        this.L$0 = $this$launch;
                        this.L$1 = clientConnection;
                        this.L$2 = var4_5;
                        this.L$3 = var5_6;
                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)it);
                        this.I$0 = $i$a$-use-SshForwardedConnectionHandle$forwardPort$1$1;
                        this.I$1 = $i$f$catching;
                        this.I$2 = $i$a$-catching-SshForwardedConnectionHandle$forwardPort$1$1$socket$1;
                        this.label = 2;
                        v1 = SshForwardedConnectionHandle.access$setupPortForwardingAndConnect(var5_6, (Continuation)this);
                        ** if (v1 != var16_3) goto lbl46
lbl45:
                        // 1 sources

                        return var16_3;
lbl46:
                        // 1 sources

                        ** GOTO lbl61
                    }
                    case 2: {
                        $i$a$-catching-SshForwardedConnectionHandle$forwardPort$1$1$socket$1 = this.I$2;
                        $i$f$catching = this.I$1;
                        $i$a$-use-SshForwardedConnectionHandle$forwardPort$1$1 = this.I$0;
                        it = (Socket)this.L$4;
                        var6_7 = null;
                        var5_6 = (SshForwardedConnectionHandle)this.L$3;
                        var4_5 = (Closeable)this.L$2;
                        clientConnection = (Socket)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl61:
                            // 2 sources

                            var11_18 = Result.constructor-impl((Object)((Socket)v1));
                            {
                                catch (CancellationException c$iv) {
                                    throw c$iv;
                                }
                                catch (Throwable t$iv) {
                                    var11_18 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                                }
                            }
                            var9_12 = var11_18;
                            if (Result.exceptionOrNull-impl((Object)var9_12) == null) ** GOTO lbl74
                            $i$a$-getOrElse-SshForwardedConnectionHandle$forwardPort$1$1$socket$2 = false;
                            Logger.INSTANCE.warn(it, "Failed to set up forwarding from " + SshForwardedConnectionHandle.access$getRemoteReadable$p(var5_6) + ", waiting for client to retry connection");
                            ** GOTO lbl104
lbl74:
                            // 1 sources

                            socket = (Socket)var9_12;
                            var9_12 = socket;
                            var10_14 = null;
                            try {
                                it = (Socket)var9_12;
                                $i$a$-use-SshForwardedConnectionHandle$forwardPort$1$1$1 = false;
                                try {
                                    t1 = ThreadsKt.thread$default((boolean)true, (boolean)false, null, (String)("socket " + clientConnection.getPort() + ":" + socket.getPort() + " forwarder 1"), (int)0, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$5$lambda$4$lambda$2(java.net.Socket java.net.Socket ), ()Lkotlin/Unit;)((Socket)clientConnection, (Socket)socket), (int)22, null);
                                    t2 = ThreadsKt.thread$default((boolean)true, (boolean)false, null, (String)("socket " + clientConnection.getPort() + ":" + socket.getPort() + " forwarder 2"), (int)0, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$5$lambda$4$lambda$3(java.net.Socket java.net.Socket ), ()Lkotlin/Unit;)((Socket)socket, (Socket)clientConnection), (int)22, null);
                                    t1.join();
                                    t2.join();
                                }
                                catch (CancellationException ce) {
                                    throw ce;
                                }
                                catch (Throwable e) {
                                    Logger.INSTANCE.warn(e, "Exception thrown during port forwarding");
                                }
                                finally {
                                    Logger.INSTANCE.info("Finished forwarding remote " + SshForwardedConnectionHandle.access$getRemoteReadable$p(var5_6));
                                }
                                var11_18 = Unit.INSTANCE;
                            }
                            catch (Throwable var13_22) {
                                var10_14 = var13_22;
                                throw var13_22;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var9_12, (Throwable)var10_14);
                            }
lbl104:
                            // 2 sources

                            var7_8 = Unit.INSTANCE;
                            ** GOTO lbl6
                        }
                        catch (Throwable var8_10) {
                            var6_7 = var8_10;
                            throw var8_10;
                        }
                    }
                    catch (Throwable var8_11) {
                        throw var8_11;
                    }
                    {
                        finally {
                            CloseableKt.closeFinally((Closeable)var4_5, (Throwable)var6_7);
                            ** GOTO lbl6
                        }
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$5$lambda$4$lambda$2(Socket $clientConnection, Socket $socket) {
                $clientConnection.getInputStream().transferTo($socket.getOutputStream());
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$5$lambda$4$lambda$3(Socket $socket, Socket $clientConnection) {
                $socket.getInputStream().transferTo($clientConnection.getOutputStream());
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    private final Object waitForClientConnection(ServerSocket socket, Continuation<? super Socket> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Socket>, Object>(socket, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ServerSocket $socket;
            {
                this.$socket = $socket;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Logger.INSTANCE.info("Waiting for new connection attempt from the client on " + this.$socket.getInetAddress().getHostAddress());
lbl7:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$withContext)) {
                            this.L$0 = $this$withContext;
                            this.label = 1;
                            v0 = InterruptibleKt.runInterruptible$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(java.net.ServerSocket ), ()Ljava/net/Socket;)((ServerSocket)this.$socket), (Continuation)((Continuation)this), (int)1, null);
                            ** if (v0 != var4_3) goto lbl15
lbl14:
                            // 1 sources

                            return var4_3;
lbl15:
                            // 1 sources

                            ** GOTO lbl22
                        }
                        break;
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl22:
                            // 2 sources

                            if ((newConnection = (Socket)v0) != null) {
                                Logger.INSTANCE.info("Client connected to " + this.$socket.getInetAddress().getHostAddress());
                                return newConnection;
                            }
                        }
                        catch (ClosedChannelException e) {
                            if (CoroutineScopeKt.isActive((CoroutineScope)$this$withContext)) {
                                Logger.INSTANCE.info((Throwable)e, "Accept thread for persistent channel closing due to closed acceptor socket");
                            }
                            return null;
                        }
                        this.L$0 = $this$withContext;
                        this.label = 2;
                        v1 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                        if (v1 != var4_3) ** GOTO lbl7
                        return var4_3;
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl7
                    }
                }
                return null;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Socket> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Socket invokeSuspend$lambda$0(ServerSocket $socket) {
                return $socket.accept();
            }
        }), $completion);
    }

    private final Object setupPortForwardingAndConnect(Continuation<? super Socket> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Socket>, Object>(this, null){
            int label;
            final /* synthetic */ SshForwardedConnectionHandle this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Logger.INSTANCE.info("Setting up port forwarding from " + SshForwardedConnectionHandle.access$getRemoteReadable$p(this.this$0));
                        this.label = 1;
                        Object object2 = SshPortForwarderKt.access$createSocketOverProxy(SshForwardedConnectionHandle.access$getSshProcess$p(this.this$0), SshForwardedConnectionHandle.access$getLocalAddress$p(this.this$0), SshForwardedConnectionHandle.access$getRemoteAddress$p(this.this$0), SshForwardedConnectionHandle.access$getRemotePort$p(this.this$0), (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Socket> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ Object access$awaitClosed(SshForwardedConnectionHandle $this, Continuation $completion) {
        return $this.awaitClosed((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$waitForClientConnection(SshForwardedConnectionHandle $this, ServerSocket socket, Continuation $completion) {
        return $this.waitForClientConnection(socket, (Continuation<? super Socket>)$completion);
    }

    public static final /* synthetic */ ServerSocket access$getPersistentSocket$p(SshForwardedConnectionHandle $this) {
        return $this.persistentSocket;
    }

    public static final /* synthetic */ Object access$setupPortForwardingAndConnect(SshForwardedConnectionHandle $this, Continuation $completion) {
        return $this.setupPortForwardingAndConnect((Continuation<? super Socket>)$completion);
    }

    public static final /* synthetic */ String access$getRemoteReadable$p(SshForwardedConnectionHandle $this) {
        return $this.remoteReadable;
    }

    public static final /* synthetic */ SshProcess access$getSshProcess$p(SshForwardedConnectionHandle $this) {
        return $this.sshProcess;
    }

    public static final /* synthetic */ InetAddress access$getLocalAddress$p(SshForwardedConnectionHandle $this) {
        return $this.localAddress;
    }

    public static final /* synthetic */ InetAddress access$getRemoteAddress$p(SshForwardedConnectionHandle $this) {
        return $this.remoteAddress;
    }

    public static final /* synthetic */ int access$getRemotePort$p(SshForwardedConnectionHandle $this) {
        return $this.remotePort;
    }
}

