/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.gateway.ssh.SshExecutableLocation;
import com.jetbrains.toolbox.openssh.CommonOpenSshPathsProvider;
import com.jetbrains.toolbox.openssh.SshExecutable;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

public final class SshExecutableLocationImpl
implements SshExecutableLocation {
    @NotNull
    private final CommonOpenSshPathsProvider commonOpenSshPathsProvider;
    @NotNull
    private final StateFlow<SshExecutable> state;

    public SshExecutableLocationImpl(@NotNull SettingsManager settingsManager, @NotNull CommonOpenSshPathsProvider commonOpenSshPathsProvider) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)commonOpenSshPathsProvider, (String)"commonOpenSshPathsProvider");
        this.commonOpenSshPathsProvider = commonOpenSshPathsProvider;
        this.state = FlowExtensionsKt.mapState(settingsManager.getSettings(), arg_0 -> SshExecutableLocationImpl.state$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    public StateFlow<SshExecutable> getState() {
        return this.state;
    }

    private static final SshExecutable state$lambda$0(SshExecutableLocationImpl this$0, SelfSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SshExecutable sshExecutable = it.getAdvanced().getUserSelectedSshExecutable();
        if (sshExecutable == null) {
            sshExecutable = this$0.commonOpenSshPathsProvider.getDefaultRecommendedExecutable();
        }
        return sshExecutable;
    }
}

