/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.gateway.DialogService;
import com.jetbrains.toolbox.gateway.ssh.SshCustomLinkHandler;
import com.jetbrains.toolbox.gateway.ssh.parser.ParsingResult;
import com.jetbrains.toolbox.gateway.ssh.parser.SshConnectionStringParser;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSshCustomLinkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshCustomLinkHandler.kt\ncom/jetbrains/toolbox/gateway/ssh/SshCustomLinkHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class SshCustomLinkHandler {
    @NotNull
    public static final SshCustomLinkHandler INSTANCE = new SshCustomLinkHandler();

    private SshCustomLinkHandler() {
    }

    private final String toUsernameHostString(String userName, String host) {
        return userName != null ? userName + "@" + host : host;
    }

    private final String toPortString(Integer port2) {
        return port2 == null ? "" : "-p " + port2 + " ";
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createEnvironment(@NotNull URI uri, @NotNull DialogService dialogService, @NotNull Continuation<? super Result> $completion) {
        if (!($completion instanceof createEnvironment.1)) ** GOTO lbl-1000
        var17_4 = $completion;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ SshCustomLinkHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createEnvironment(null, null, (Continuation<? super Result>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                queryParameters = URIExtensionsKt.parseQuery(uri);
                hostname = queryParameters.get("h");
                user = queryParameters.get("u");
                port = queryParameters.get("p");
                v0 = queryParameters.get("launchIde");
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-SshCustomLinkHandler$createEnvironment$launchIde$1 = false;
                    v1 = (int)Intrinsics.areEqual((Object)it, (Object)"true");
                } else {
                    v1 = 0;
                }
                launchIde = v1;
                ideHint = queryParameters.get("ideHint");
                projectHint = queryParameters.get("projectHint");
                if (hostname == null) {
                    throw new IllegalArgumentException("'h' parameter must be specified");
                }
                res = SshConnectionStringParser.INSTANCE.parseUri(user, hostname, port);
                if (!(res instanceof ParsingResult.Success)) {
                    if (res instanceof ParsingResult.Failure) {
                        throw new IllegalArgumentException(((ParsingResult.Failure)res).getReason());
                    }
                    throw new NoWhenBranchMatchedException();
                }
                var11_21 = new Triple((Object)((ParsingResult.Success)res).getUser(), (Object)((ParsingResult.Success)res).getHost(), (Object)((ParsingResult.Success)res).getPort());
                verifiedUser = (String)var11_21.component1();
                verifiedHost = (String)var11_21.component2();
                verifiedPort = (Integer)var11_21.component3();
                v2 = dialogService.showEnvironmentAdditionDialog(verifiedHost, verifiedUser, verifiedPort);
                Intrinsics.checkNotNullExpressionValue(v2, (String)"showEnvironmentAdditionDialog(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)dialogService);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(queryParameters);
                $continuation.L$3 = hostname;
                $continuation.L$4 = user;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)port);
                $continuation.L$6 = ideHint;
                $continuation.L$7 = projectHint;
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)verifiedUser);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)verifiedHost);
                $continuation.L$10 = verifiedPort;
                $continuation.I$0 = launchIde;
                $continuation.label = 1;
                v3 = FutureKt.await((CompletionStage)v2, (Continuation)$continuation);
                if (v3 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl72
            }
            case 1: {
                launchIde = $continuation.I$0;
                verifiedPort = (Integer)$continuation.L$10;
                verifiedHost = (String)$continuation.L$9;
                verifiedUser = (String)$continuation.L$8;
                projectHint = (String)$continuation.L$7;
                ideHint = (String)$continuation.L$6;
                port = (String)$continuation.L$5;
                user = (String)$continuation.L$4;
                hostname = (String)$continuation.L$3;
                queryParameters = (Map)$continuation.L$2;
                dialogService = (DialogService)$continuation.L$1;
                uri = (URI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl72:
                // 2 sources

                if (((Boolean)v3).booleanValue()) {
                    connStr = "ssh " + this.toPortString(verifiedPort) + this.toUsernameHostString(user, hostname);
                    v4 = new Result(connStr, launchIde != 0, ideHint, projectHint);
                } else {
                    v4 = null;
                }
                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final class Result {
        @NotNull
        private final String connectionString;
        private final boolean launchIde;
        @Nullable
        private final String ideHint;
        @Nullable
        private final String projectHint;

        public Result(@NotNull String connectionString, boolean launchIde, @Nullable String ideHint, @Nullable String projectHint) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            this.connectionString = connectionString;
            this.launchIde = launchIde;
            this.ideHint = ideHint;
            this.projectHint = projectHint;
        }

        @NotNull
        public final String getConnectionString() {
            return this.connectionString;
        }

        public final boolean getLaunchIde() {
            return this.launchIde;
        }

        @Nullable
        public final String getIdeHint() {
            return this.ideHint;
        }

        @Nullable
        public final String getProjectHint() {
            return this.projectHint;
        }

        @NotNull
        public final String component1() {
            return this.connectionString;
        }

        public final boolean component2() {
            return this.launchIde;
        }

        @Nullable
        public final String component3() {
            return this.ideHint;
        }

        @Nullable
        public final String component4() {
            return this.projectHint;
        }

        @NotNull
        public final Result copy(@NotNull String connectionString, boolean launchIde, @Nullable String ideHint, @Nullable String projectHint) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            return new Result(connectionString, launchIde, ideHint, projectHint);
        }

        public static /* synthetic */ Result copy$default(Result result2, String string, boolean bl, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = result2.connectionString;
            }
            if ((n & 2) != 0) {
                bl = result2.launchIde;
            }
            if ((n & 4) != 0) {
                string2 = result2.ideHint;
            }
            if ((n & 8) != 0) {
                string3 = result2.projectHint;
            }
            return result2.copy(string, bl, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Result(connectionString=" + this.connectionString + ", launchIde=" + this.launchIde + ", ideHint=" + this.ideHint + ", projectHint=" + this.projectHint + ")";
        }

        public int hashCode() {
            int result2 = this.connectionString.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.launchIde);
            result2 = result2 * 31 + (this.ideHint == null ? 0 : this.ideHint.hashCode());
            result2 = result2 * 31 + (this.projectHint == null ? 0 : this.projectHint.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual((Object)this.connectionString, (Object)result2.connectionString)) {
                return false;
            }
            if (this.launchIde != result2.launchIde) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ideHint, (Object)result2.ideHint)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.projectHint, (Object)result2.projectHint);
        }
    }
}

