/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.ssh.PromptHandler;
import com.jetbrains.toolbox.gateway.ssh.UserInput;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PassphrasePromptHandler
implements PromptHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserInput userInput;
    @NotNull
    private static final Regex PASSPHRASE_REGEX = new Regex("passphrase");

    public PassphrasePromptHandler(@NotNull UserInput userInput) {
        Intrinsics.checkNotNullParameter((Object)userInput, (String)"userInput");
        this.userInput = userInput;
    }

    @Override
    @Nullable
    public Object onData(@NotNull String str, @NotNull DevEnvironmentId id, @NotNull Continuation<? super String> $completion) {
        String string;
        if (PASSPHRASE_REGEX.containsMatchIn((CharSequence)str)) {
            Object object = this.userInput.ask(str, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            string = (String)object;
        } else {
            string = null;
        }
        return string;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

