/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.spaceport.auth;

import com.jetbrains.toolbox.accounts.RefreshConfigurationImpl;
import com.jetbrains.toolbox.api.core.auth.AuthConfiguration;
import com.jetbrains.toolbox.api.core.auth.ContentType;
import com.jetbrains.toolbox.api.core.auth.OAuthToken;
import com.jetbrains.toolbox.api.core.auth.PluginAuthInterface;
import com.jetbrains.toolbox.api.core.auth.RefreshConfiguration;
import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.gateway.spaceport.auth.OrganizationDetails;
import com.jetbrains.toolbox.gateway.spaceport.auth.SpaceportAccount;
import com.jetbrains.toolbox.gateway.spaceport.auth.SpaceportAccountConstants;
import com.jetbrains.toolbox.gateway.spaceport.auth.SpaceportDetailsProvider;
import com.jetbrains.toolbox.gateway.spaceport.auth.SpaceportLoginConfiguration;
import com.jetbrains.toolbox.gateway.spaceport.auth.SpaceportProfileDetails;
import com.jetbrains.toolbox.network.DownloadManager;
import com.jetbrains.toolbox.network.DownloadManagerKt;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSpaceportPluginAuthInterface.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceportPluginAuthInterface.kt\ncom/jetbrains/toolbox/gateway/spaceport/auth/SpaceportPluginAuthInterface\n+ 2 SpaceportAccountConstants.kt\ncom/jetbrains/toolbox/gateway/spaceport/auth/SpaceportAccountConstants\n*L\n1#1,91:1\n4#2,2:92\n4#2:94\n4#2:95\n10#2:96\n4#2:97\n*S KotlinDebug\n*F\n+ 1 SpaceportPluginAuthInterface.kt\ncom/jetbrains/toolbox/gateway/spaceport/auth/SpaceportPluginAuthInterface\n*L\n16#1:92,2\n35#1:94\n46#1:95\n48#1:96\n54#1:97\n*E\n"})
public final class SpaceportPluginAuthInterface
implements PluginAuthInterface<SpaceportAccount, SpaceportLoginConfiguration> {
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final String appAuth;

    public SpaceportPluginAuthInterface(@NotNull DownloadManager downloadManager) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        this.downloadManager = downloadManager;
        Base64.Encoder encoder = Base64.getEncoder();
        SpaceportAccountConstants this_$iv = SpaceportAccountConstants.INSTANCE;
        boolean $i$f$getSPACEPORT_OAUTH_CLIENT_ID = false;
        this_$iv = SpaceportAccountConstants.INSTANCE;
        boolean $i$f$getSPACEPORT_OAUTH_SECRET = false;
        String string = "toolbox-app" + ":" + "toolbox-app-secret";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = encoder.encode(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
        byte[] byArray3 = byArray2;
        this.appAuth = "Basic " + new String(byArray3, Charsets.UTF_8);
    }

    @NotNull
    public String serialize(@NotNull SpaceportAccount account2) {
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        return JsonKt.getJsonx().encodeToString((SerializationStrategy)SpaceportAccount.Companion.serializer(), (Object)account2);
    }

    @NotNull
    public SpaceportAccount deserialize(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return (SpaceportAccount)JsonKt.getJsonx().decodeFromString((DeserializationStrategy)SpaceportAccount.Companion.serializer(), string);
    }

    @Nullable
    public Object createAccount(@NotNull OAuthToken token2, @NotNull AuthConfiguration config, @NotNull Continuation<? super SpaceportAccount> $completion) {
        return this.queryAccount(config.getBaseUrl(), token2, $completion);
    }

    @NotNull
    public RefreshConfiguration createRefreshConfig(@NotNull SpaceportAccount account2) {
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"grant_type", (Object)"refresh_token");
        SpaceportAccountConstants this_$iv = SpaceportAccountConstants.INSTANCE;
        boolean $i$f$getSPACEPORT_OAUTH_CLIENT_ID = false;
        pairArray[1] = TuplesKt.to((Object)"client_id", (Object)"toolbox-app");
        return new RefreshConfigurationImpl(account2.getInstanceUrl() + "/oauth/token", MapsKt.mapOf((Pair[])pairArray), this.appAuth, ContentType.FORM_URL_ENCODED, false, 16, null);
    }

    @NotNull
    public AuthConfiguration createAuthConfig(@NotNull SpaceportLoginConfiguration loginConfiguration) {
        Intrinsics.checkNotNullParameter((Object)loginConfiguration, (String)"loginConfiguration");
        String instanceUrl = loginConfiguration.getHost();
        Pair[] pairArray = new Pair[4];
        SpaceportAccountConstants this_$iv = SpaceportAccountConstants.INSTANCE;
        boolean $i$f$getSPACEPORT_OAUTH_CLIENT_ID = false;
        pairArray[0] = TuplesKt.to((Object)"client_id", (Object)"toolbox-app");
        pairArray[1] = TuplesKt.to((Object)"response_type", (Object)"code");
        this_$iv = SpaceportAccountConstants.INSTANCE;
        boolean $i$f$getSPACEPORT_OAUTH_SCOPE = false;
        pairArray[2] = TuplesKt.to((Object)"scope", (Object)"**");
        pairArray[3] = TuplesKt.to((Object)"access_type", (Object)"offline");
        Map authParams = MapsKt.mapOf((Pair[])pairArray);
        Pair[] pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to((Object)"grant_type", (Object)"authorization_code");
        SpaceportAccountConstants this_$iv2 = SpaceportAccountConstants.INSTANCE;
        boolean $i$f$getSPACEPORT_OAUTH_CLIENT_ID2 = false;
        pairArray2[1] = TuplesKt.to((Object)"client_id", (Object)"toolbox-app");
        Map tokenParams = MapsKt.mapOf((Pair[])pairArray2);
        return new AuthConfiguration(authParams, tokenParams, instanceUrl, instanceUrl + "/oauth/auth", instanceUrl + "/oauth/token", "code_challenge", "S256", "code_verifier", this.appAuth);
    }

    @Nullable
    public Object updateAccount(@NotNull OAuthToken token2, @NotNull SpaceportAccount account2, @NotNull Continuation<? super SpaceportAccount> $completion) {
        return this.queryAccount(account2.getInstanceUrl(), token2, $completion);
    }

    private final Object queryAccount(String instanceUrl, OAuthToken token2, Continuation<? super SpaceportAccount> $completion) {
        return DownloadManagerKt.withSession(this.downloadManager, (Function1)new Function1<Continuation<? super SpaceportAccount>, Object>(token2, instanceUrl, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ OAuthToken $token;
            final /* synthetic */ String $instanceUrl;
            {
                this.$token = $token;
                this.$instanceUrl = $instanceUrl;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        authorization = this.$token.getAuthorizationHeader();
                        this.L$0 = authorization;
                        this.label = 1;
                        v0 = SpaceportDetailsProvider.INSTANCE.provideProfileDetails(this.$instanceUrl, authorization, (Continuation<? super SpaceportProfileDetails>)((Continuation)this));
                        if (v0 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        authorization = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        profileDetails = (SpaceportProfileDetails)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)authorization);
                        this.L$1 = profileDetails;
                        this.label = 2;
                        v1 = SpaceportDetailsProvider.INSTANCE.provideOrganizationDetails(this.$instanceUrl, authorization, (Continuation<? super OrganizationDetails>)((Continuation)this));
                        if (v1 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        profileDetails = (SpaceportProfileDetails)this.L$1;
                        authorization = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        organizationDetails = (OrganizationDetails)v1;
                        v2 = (profileDetails.getUsername() + "-" + this.$instanceUrl).toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
                        var5_7 = v2;
                        var6_8 = profileDetails.getName().getFirstName();
                        var7_9 = profileDetails.getName().getLastName();
                        var8_10 = profileDetails.getUsername();
                        var9_11 = organizationDetails.getLogoIconContent-fijqFwY();
                        var10_12 = organizationDetails.getName();
                        return new SpaceportAccount(var5_7, var6_8, var7_9, var8_10, var10_12, var9_11, this.$instanceUrl, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super SpaceportAccount> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    public static final /* synthetic */ Object access$queryAccount(SpaceportPluginAuthInterface $this, String instanceUrl, OAuthToken token2, Continuation $completion) {
        return $this.queryAccount(instanceUrl, token2, (Continuation<? super SpaceportAccount>)$completion);
    }
}

