/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.spaceport;

import com.jetbrains.toolbox.api.core.diagnostics.Logger;
import com.jetbrains.toolbox.api.core.os.LocalDesktopManager;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.localization.LocalizableStringFactory;
import com.jetbrains.toolbox.api.remoteDev.AfterDisconnectHook;
import com.jetbrains.toolbox.api.remoteDev.EnvironmentVisibilityState;
import com.jetbrains.toolbox.api.remoteDev.RemoteEnvironmentAbility;
import com.jetbrains.toolbox.api.remoteDev.RemoteProviderEnvironment;
import com.jetbrains.toolbox.api.remoteDev.SettingsSection;
import com.jetbrains.toolbox.api.remoteDev.TabDefinition;
import com.jetbrains.toolbox.api.remoteDev.deploy.AgentDistributionProvider;
import com.jetbrains.toolbox.api.remoteDev.environments.EnvironmentContentsView;
import com.jetbrains.toolbox.api.remoteDev.states.CustomRemoteEnvironmentStateV2;
import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentDescription;
import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentIssue;
import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentStateColorPalette;
import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentStateIcons;
import com.jetbrains.toolbox.api.remoteDev.states.RemoteEnvironmentState;
import com.jetbrains.toolbox.api.remoteDev.states.StandardRemoteEnvironmentState;
import com.jetbrains.toolbox.api.ui.DescriptionTree;
import com.jetbrains.toolbox.api.ui.ToolboxUi;
import com.jetbrains.toolbox.api.ui.actions.ActionDescription;
import com.jetbrains.toolbox.api.ui.actions.RunnableActionDescription;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.gateway.ConnectionState;
import com.jetbrains.toolbox.gateway.CustomLaunchService;
import com.jetbrains.toolbox.gateway.EnvironmentConnectionStateListener;
import com.jetbrains.toolbox.gateway.ProjectOpenCancelledException;
import com.jetbrains.toolbox.gateway.spaceport.CodeCanvasContentsView;
import com.jetbrains.toolbox.gateway.spaceport.CodeCanvasErrorManager;
import com.jetbrains.toolbox.gateway.spaceport.CodeCanvasReporter;
import com.jetbrains.toolbox.gateway.spaceport.CodeCanvasSettings;
import com.jetbrains.toolbox.gateway.spaceport.DevEnv;
import com.jetbrains.toolbox.gateway.spaceport.IdeConnectionHelper;
import com.jetbrains.toolbox.gateway.spaceport.OpenIdeLinks;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportActions;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportEnvironment;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportEnvironment$special$;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportEnvironmentKt;
import com.jetbrains.toolbox.gateway.spaceport.SshConnectionParams;
import com.jetbrains.toolbox.gateway.spaceport.auth.SpaceportAccount;
import com.jetbrains.toolbox.gateway.spaceport.ssh.CodeCanvasSshParamsKt;
import com.jetbrains.toolbox.gateway.spaceport.utils.ActionGuard;
import com.jetbrains.toolbox.gateway.spaceport.utils.LockableState;
import com.jetbrains.toolbox.gateway.spaceport.utils.ProductIcons;
import com.jetbrains.toolbox.platform.image.ImageResource;
import java.io.Closeable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.coroutines.jvm.internal.SuspendFunction;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSpaceportEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceportEnvironment.kt\ncom/jetbrains/toolbox/gateway/spaceport/SpaceportEnvironment\n+ 2 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 3 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 4 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n*L\n1#1,578:1\n49#2:579\n51#2:583\n46#3:580\n51#3:582\n105#4:581\n*S KotlinDebug\n*F\n+ 1 SpaceportEnvironment.kt\ncom/jetbrains/toolbox/gateway/spaceport/SpaceportEnvironment\n*L\n458#1:579\n458#1:583\n458#1:580\n458#1:582\n458#1:581\n*E\n"})
public final class SpaceportEnvironment
extends RemoteProviderEnvironment
implements Closeable {
    @NotNull
    private final DevEnv initialDevEnv;
    @NotNull
    private final String instanceUrl;
    @NotNull
    private final SpaceportActions actions;
    @NotNull
    private final SpaceportAccount account;
    @NotNull
    private final AgentDistributionProvider agentDistribution;
    @NotNull
    private final LocalDesktopManager desktopManager;
    @NotNull
    private final ToolboxUi toolboxUi;
    @NotNull
    private final CodeCanvasErrorManager errorsManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final EnvironmentStateColorPalette environmentStateColorPalette;
    @NotNull
    private final StateFlow<List<String>> featureFlags;
    @NotNull
    private final CodeCanvasSettings settingsStore;
    @NotNull
    private final IdeConnectionHelper ideConnectionHelper;
    @NotNull
    private final CodeCanvasReporter reporter;
    @NotNull
    private final CustomLaunchService customLaunchService;
    @NotNull
    private final EnvironmentConnectionStateListener environmentConnectionListener;
    @NotNull
    private final LocalizableStringFactory i18n;
    @NotNull
    private final CoroutineScope environmentScope;
    @NotNull
    private final LockableState<DevEnv> internalDevEnvFlow;
    @NotNull
    private final ActionGuard actionGuard;
    @NotNull
    private final CustomRemoteEnvironmentStateV2 stoppingState;
    @NotNull
    private final CustomRemoteEnvironmentStateV2 stoppedState;
    @NotNull
    private final CustomRemoteEnvironmentStateV2 delayedDeletionState;
    @NotNull
    private final CustomRemoteEnvironmentStateV2 activeState;
    @NotNull
    private final StateFlow<RemoteEnvironmentState> state;
    @NotNull
    private final MutableStateFlow<EnvironmentDescription> description;
    @NotNull
    private final MutableSharedFlow<Boolean> connectionRequest;
    @NotNull
    private final DevEnv devEnv;
    @NotNull
    private final StateFlow<ConnectionState> connectionState;
    @NotNull
    private final StateFlow<Boolean> environmentReady;
    @NotNull
    private final CodeCanvasContentsView contentsView;
    @NotNull
    private final beforeDisconnect.1 beforeDisconnect;
    @NotNull
    private final MutableStateFlow<String> nameFlow;
    @NotNull
    private final String secondaryInformation;
    @NotNull
    private final Set<RemoteEnvironmentAbility> supportedFeatures;
    @NotNull
    private final StateFlow<List<ActionDescription>> actionsList;
    @NotNull
    private final StateFlow<KFunction<Unit>> deleteActionFlow;
    @NotNull
    private final List<TabDefinition> pageTabs;
    @NotNull
    private final Set<SettingsSection> availableSettingsSections;
    @NotNull
    private final wakeAction.1 wakeAction;
    @NotNull
    private final cancelDeleteAction.1 cancelDeleteAction;

    /*
     * WARNING - void declaration
     */
    public SpaceportEnvironment(@NotNull DevEnv initialDevEnv, @NotNull String instanceUrl, @NotNull SpaceportActions actions2, @NotNull SpaceportAccount account2, @NotNull CoroutineScope pluginScope, @NotNull AgentDistributionProvider agentDistribution, @NotNull LocalDesktopManager desktopManager, @NotNull ToolboxUi toolboxUi, @NotNull CodeCanvasErrorManager errorsManager, @NotNull Logger logger, @NotNull EnvironmentStateColorPalette environmentStateColorPalette, @NotNull StateFlow<? extends List<String>> featureFlags, @NotNull CodeCanvasSettings settingsStore, @NotNull IdeConnectionHelper ideConnectionHelper, @NotNull CodeCanvasReporter reporter, @NotNull CustomLaunchService customLaunchService, @NotNull EnvironmentConnectionStateListener environmentConnectionListener, @NotNull LocalizableStringFactory i18n) {
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)initialDevEnv, (String)"initialDevEnv");
        Intrinsics.checkNotNullParameter((Object)instanceUrl, (String)"instanceUrl");
        Intrinsics.checkNotNullParameter((Object)actions2, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        Intrinsics.checkNotNullParameter((Object)agentDistribution, (String)"agentDistribution");
        Intrinsics.checkNotNullParameter((Object)desktopManager, (String)"desktopManager");
        Intrinsics.checkNotNullParameter((Object)toolboxUi, (String)"toolboxUi");
        Intrinsics.checkNotNullParameter((Object)errorsManager, (String)"errorsManager");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)environmentStateColorPalette, (String)"environmentStateColorPalette");
        Intrinsics.checkNotNullParameter(featureFlags, (String)"featureFlags");
        Intrinsics.checkNotNullParameter((Object)settingsStore, (String)"settingsStore");
        Intrinsics.checkNotNullParameter((Object)ideConnectionHelper, (String)"ideConnectionHelper");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)customLaunchService, (String)"customLaunchService");
        Intrinsics.checkNotNullParameter((Object)environmentConnectionListener, (String)"environmentConnectionListener");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        super(initialDevEnv.getId());
        this.initialDevEnv = initialDevEnv;
        this.instanceUrl = instanceUrl;
        this.actions = actions2;
        this.account = account2;
        this.agentDistribution = agentDistribution;
        this.desktopManager = desktopManager;
        this.toolboxUi = toolboxUi;
        this.errorsManager = errorsManager;
        this.logger = logger;
        this.environmentStateColorPalette = environmentStateColorPalette;
        this.featureFlags = featureFlags;
        this.settingsStore = settingsStore;
        this.ideConnectionHelper = ideConnectionHelper;
        this.reporter = reporter;
        this.customLaunchService = customLaunchService;
        this.environmentConnectionListener = environmentConnectionListener;
        this.i18n = i18n;
        this.environmentScope = CoroutineScopeKt.plus((CoroutineScope)pluginScope, (CoroutineContext)((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.internalDevEnvFlow = new LockableState<DevEnv>(this.initialDevEnv);
        this.actionGuard = new ActionGuard(this.environmentScope);
        this.stoppingState = new CustomRemoteEnvironmentStateV2(this.i18n.ptrl("Stopping"), this.environmentStateColorPalette.getColor(StandardRemoteEnvironmentState.Restarting), false, EnvironmentStateIcons.Connecting);
        this.stoppedState = new CustomRemoteEnvironmentStateV2(this.i18n.ptrl("Stopped"), this.environmentStateColorPalette.getColor(StandardRemoteEnvironmentState.Hibernated), false, EnvironmentStateIcons.Hibernated.getId(), true);
        this.delayedDeletionState = new CustomRemoteEnvironmentStateV2(this.i18n.ptrl("Scheduled for deletion"), this.environmentStateColorPalette.getColor(StandardRemoteEnvironmentState.Deleting), false, EnvironmentStateIcons.NoIcon);
        this.activeState = new CustomRemoteEnvironmentStateV2(this.i18n.ptrl("Active"), this.environmentStateColorPalette.getColor(StandardRemoteEnvironmentState.Active), true, EnvironmentStateIcons.Active.getId(), true);
        this.state = FlowExtensionsKt.mapState(this.internalDevEnvFlow.getState(), arg_0 -> SpaceportEnvironment.state$lambda$0(this, arg_0));
        this.description = StateFlowKt.MutableStateFlow((Object)new EnvironmentDescription.General(null));
        this.connectionRequest = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.devEnv = (DevEnv)this.internalDevEnvFlow.getState().getValue();
        this.connectionState = FlowKt.stateIn(this.environmentConnectionListener.getAgentState(this.devEnv.getId()), (CoroutineScope)this.environmentScope, (SharingStarted)SharingStarted.Companion.WhileSubscribed$default((SharingStarted.Companion)SharingStarted.Companion, (long)0L, (long)0L, (int)3, null), (Object)((Object)ConnectionState.Disconnected));
        this.environmentReady = FlowKt.stateIn((Flow)FlowKt.combine((Flow)((Flow)this.connectionState), (Flow)((Flow)this.getState()), (Function3)((Function3)new Function3<ConnectionState, RemoteEnvironmentState, Continuation<? super Boolean>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ConnectionState connectionState = (ConnectionState)((Object)this.L$0);
                RemoteEnvironmentState remoteEnvironmentState = (RemoteEnvironmentState)this.L$1;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void connectionState2;
                        void state2;
                        ResultKt.throwOnFailure((Object)$result);
                        return Boxing.boxBoolean((Intrinsics.areEqual((Object)state2, (Object)SpaceportEnvironment.access$getActiveState$p(this.this$0)) && connectionState2 == ConnectionState.Connected ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ConnectionState p1, RemoteEnvironmentState p2, Continuation<? super Boolean> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.environmentScope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)false);
        this.contentsView = new CodeCanvasContentsView(this.internalDevEnvFlow.getState(), this.actions, this.account, this.logger, this.agentDistribution, this.environmentScope, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new SuspendFunction(this){

            public final Object invoke(Continuation<? super Unit> $completion) {
                return SpaceportEnvironment.access$contentsView$handleBeforeProjectOpen((SpaceportEnvironment)this.receiver, $completion);
            }
        }));
        this.beforeDisconnect = new AfterDisconnectHook(this){
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterDisconnect(boolean isManual) {
                if (isManual) {
                    SpaceportEnvironment.access$getSettingsStore$p(this.this$0).setAutoConnect(SpaceportEnvironment.access$getDevEnv$p(this.this$0).getId(), false);
                }
            }

            @Deprecated(message="Use afterDisconnect with parameter instead", replaceWith=@ReplaceWith(expression="afterDisconnect", imports={}))
            public void afterDisconnect() {
                super.afterDisconnect();
            }
        };
        this.nameFlow = StateFlowKt.MutableStateFlow((Object)this.devEnv.getName());
        this.secondaryInformation = this.devEnv.getConfigurationSource().getDevConfiguration().getName();
        if (this.settingsStore.autoConnectStatus(this.devEnv.getId()) == null) {
            this.settingsStore.setAutoConnect(this.devEnv.getId(), true);
        }
        if (Intrinsics.areEqual((Object)this.devEnv.getIdeType().getToolboxId(), (Object)"VSCode")) {
            this.customLaunchService.addProvider(this.devEnv.getId(), new CustomLaunchService.Provider(){
                private final String name;
                private final ImageResource icon;
                {
                    this.name = $receiver.devEnv.getIdeType().getNames().getClientShortName();
                    this.icon = ProductIcons.INSTANCE.getVsCode();
                }

                @Override
                public String getName() {
                    return this.name;
                }

                @Override
                public ImageResource getIcon() {
                    return this.icon;
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public Object getUri(Continuation<? super URI> $completion) {
                    if (!($completion instanceof getUri.1)) ** GOTO lbl-1000
                    var7_2 = $completion;
                    if ((var7_2.label & -2147483648) != 0) {
                        var7_2.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, $completion){
                            /* synthetic */ Object result;
                            final /* synthetic */ 1 this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return this.this$0.getUri((Continuation<? super URI>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $continuation.label = 1;
                            v0 = SpaceportEnvironment.access$getActions$p(this).fetchOpenLinks-0E7RQCE$gateway_plugin_space_port(SpaceportEnvironment.access$getAccount$p(this), SpaceportEnvironment.access$getDevEnv$p(this).getId(), (Continuation<? super Result<OpenIdeLinks>>)$continuation);
                            ** if (v0 != var8_4) goto lbl18
lbl17:
                            // 1 sources

                            return var8_4;
lbl18:
                            // 1 sources

                            ** GOTO lbl24
                        }
                        case 1: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = ((Result)$result).unbox-impl();
lbl24:
                                // 2 sources

                                var3_5 = v0;
                                ResultKt.throwOnFailure((Object)var3_5);
                                result = (OpenIdeLinks)var3_5;
                                v1 = result.getRedirectUrl();
                                if (v1 != null) {
                                    it = v1;
                                    $i$a$-let-SpaceportEnvironment$1$getUri$2 = false;
                                    v2 = URI.create(it);
                                } else {
                                    v2 = null;
                                }
                                var2_7 = v2;
                            }
                            catch (Throwable e) {
                                SpaceportEnvironment.access$getLogger$p(this).error(e, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getUri$lambda$1(com.jetbrains.toolbox.gateway.spaceport.SpaceportEnvironment ), ()Ljava/lang/String;)((SpaceportEnvironment)this));
                                var2_7 = null;
                            }
                            return var2_7;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                private static final String getUri$lambda$1(SpaceportEnvironment this$0) {
                    return "Failed to load open link for dev env (" + this$0.devEnv.getId() + ")";
                }
            });
        }
        BuildersKt.launch$default((CoroutineScope)this.environmentScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.getState()), (Function2)((Function2)new Function2<RemoteEnvironmentState, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ SpaceportEnvironment this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                CustomRemoteEnvironmentStateV2 customRemoteEnvironmentStateV2;
                                void state2;
                                RemoteEnvironmentState remoteEnvironmentState = (RemoteEnvironmentState)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (!(state2 instanceof CustomRemoteEnvironmentStateV2)) return Unit.INSTANCE;
                                        customRemoteEnvironmentStateV2 = (CustomRemoteEnvironmentStateV2)state2;
                                        if (!Intrinsics.areEqual((Object)customRemoteEnvironmentStateV2, (Object)this.this$0.activeState)) break;
                                        if (!Intrinsics.areEqual((Object)this.this$0.settingsStore.autoConnectStatus(this.this$0.devEnv.getId()), (Object)Boxing.boxBoolean((boolean)true))) return Unit.INSTANCE;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)state2);
                                        this.label = 1;
                                        Object object2 = this.this$0.connect((Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                if (!Intrinsics.areEqual((Object)customRemoteEnvironmentStateV2, (Object)this.this$0.delayedDeletionState) && !Intrinsics.areEqual((Object)customRemoteEnvironmentStateV2, (Object)this.this$0.stoppedState) && !Intrinsics.areEqual((Object)customRemoteEnvironmentStateV2, (Object)this.this$0.stoppingState)) return Unit.INSTANCE;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)state2);
                                this.label = 2;
                                Object object3 = this.this$0.disconnect((Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object) return Unit.INSTANCE;
                                return object;
                                {
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(RemoteEnvironmentState p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.environmentScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowExtensionsKt.mapState(this.this$0.internalDevEnvFlow.getState(), 3::invokeSuspend$lambda$0).collect(new FlowCollector(){

                            public final Object emit(String envName, Continuation<? super Unit> $completion) {
                                this$0.getNameFlow().setValue((Object)envName);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(DevEnv it) {
                return it.getName();
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.environmentScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getNameFlow().collect(new FlowCollector(){

                            /*
                             * Unable to fully structure code
                             */
                            public final Object emit(String newName, Continuation<? super Unit> $completion) {
                                if (!($completion instanceof emit.1)) ** GOTO lbl-1000
                                var14_3 = $completion;
                                if ((var14_3.label & -2147483648) != 0) {
                                    var14_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, $completion){
                                        Object L$0;
                                        Object L$1;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ 1<T> this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (Intrinsics.areEqual((Object)newName, (Object)((DevEnv)SpaceportEnvironment.access$getInternalDevEnvFlow$p(this$0).getState().getValue()).getName())) ** GOTO lbl65
                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)newName);
                                        $continuation.label = 1;
                                        v0 = SpaceportEnvironment.access$getActions$p(this$0).renameDevEnvironment-BWLJW6A$gateway_plugin_space_port(SpaceportEnvironment.access$getAccount$p(this$0), this$0.getId(), newName, (Continuation<? super Result<DevEnv>>)$continuation);
                                        ** if (v0 != var15_5) goto lbl20
lbl19:
                                        // 1 sources

                                        return var15_5;
lbl20:
                                        // 1 sources

                                        ** GOTO lbl27
                                    }
                                    case 1: {
                                        newName = (String)$continuation.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = ((Result)$result).unbox-impl();
lbl27:
                                            // 2 sources

                                            var3_6 = v0;
                                            ResultKt.throwOnFailure((Object)var3_6);
                                            ** GOTO lbl65
                                        }
                                        catch (Throwable e) {
                                            SpaceportEnvironment.access$getLogger$p(this$0).error(e, "Failed to rename environment");
                                            v1 = SpaceportEnvironment.access$getErrorsManager$p(this$0);
                                            v2 = "env-rename-failed";
                                            v3 = SpaceportEnvironment.access$getI18n$p(this$0).ptrl("Failed to rename environment");
                                            v4 = e.getMessage();
                                            if (v4 == null) ** GOTO lbl52
                                            var5_9 = v4;
                                            var6_10 = SpaceportEnvironment.access$getI18n$p(this$0);
                                            var7_11 = var5_9;
                                            var11_12 = v3;
                                            var10_13 = v2;
                                            var9_14 = v1;
                                            $i$a$-run-SpaceportEnvironment$4$1$1 = false;
                                            var12_16 = var6_10.pnotr((String)p0);
                                            v1 = var9_14;
                                            v2 = var10_13;
                                            v3 = var11_12;
                                            v5 = var12_16;
                                            v4 = v5;
                                            if (v5 != null) ** GOTO lbl53
lbl52:
                                            // 2 sources

                                            v4 = SpaceportEnvironment.access$getI18n$p(this$0).ptrl("Unknown error, try again later");
lbl53:
                                            // 2 sources

                                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)newName);
                                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)e);
                                            $continuation.label = 2;
                                            v6 = v1.showError(v2, v3, (LocalizableString)v4, (Continuation<? super Unit>)$continuation);
                                            if (v6 == var15_5) {
                                                return var15_5;
                                            }
                                            ** GOTO lbl65
                                        }
                                    }
                                    case 2: {
                                        e = (Throwable)$continuation.L$1;
                                        newName = (String)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v6 = $result;
lbl65:
                                        // 4 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.environmentScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.internalDevEnvFlow.getState().collect(new FlowCollector(){

                            public final Object emit(DevEnv env, Continuation<? super Unit> $completion) {
                                if (env.getDelayedDeletion() != null) {
                                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"delayedDeletion", (Object)SpaceportEnvironmentKt.access$toHumanReadableTime(env.getDelayedDeletion().getDeleteAt().getTimestamp()))};
                                    this$0.getDescription().setValue((Object)new EnvironmentDescription.General(this$0.i18n.ptrl("That environment will be deleted at {{delayedDeletion}}.", pairArray)));
                                } else if (!(this$0.getDescription().getValue() instanceof EnvironmentDescription.Error)) {
                                    this$0.getDescription().setValue((Object)new EnvironmentDescription.General(null));
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        Object[] objectArray = new RemoteEnvironmentAbility[]{RemoteEnvironmentAbility.CAN_RENAME, RemoteEnvironmentAbility.ALWAYS_CONNECTED};
        this.supportedFeatures = SetsKt.setOf((Object[])objectArray);
        objectArray = FlowKt.flowCombine((Flow)((Flow)this.internalDevEnvFlow.getState()), (Flow)((Flow)this.featureFlags), (Function3)((Function3)new Function3<DevEnv, List<? extends String>, Continuation<? super Pair<? extends DevEnv, ? extends List<? extends String>>>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                DevEnv devEnv = (DevEnv)this.L$0;
                List list2 = (List)this.L$1;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void flags;
                        void env;
                        ResultKt.throwOnFailure((Object)$result);
                        return TuplesKt.to((Object)env, (Object)flags);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(DevEnv p1, List<String> p2, Continuation<? super Pair<DevEnv, ? extends List<String>>> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }));
        boolean $i$f$map = false;
        void $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        this.actionsList = FlowKt.stateIn((Flow)((Flow)new Flow<List<? extends RunnableActionDescription>>((Flow)$this$unsafeTransform$iv$iv, this){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.$this_unsafeTransform$inlined = flow2;
                this.this$0 = spaceportEnvironment;
            }

            public Object collect(FlowCollector collector, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.this$0){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    final /* synthetic */ SpaceportEnvironment this$0;
                    {
                        this.$this_unsafeFlow = $receiver;
                        this.this$0 = spaceportEnvironment;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object emit(Object value, Continuation $completion) {
                        if (!($completion instanceof special$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ special$$inlined$map$1$2 this$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = $continuation;
                                var7_8 = value;
                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                var10_14 = $this$map_u24lambda_u245;
                                var11_15 = (Continuation)$continuation;
                                var12_16 = (Pair)value;
                                $i$a$-map-SpaceportEnvironment$actionsList$2 = false;
                                env = (DevEnv)var12_16.component1();
                                flags = (List)var12_16.component2();
                                v0 = flags;
                                if (v0 == null) {
                                    v0 = CollectionsKt.emptyList();
                                }
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map_u24lambda_u245);
                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                $continuation.label = 1;
                                v1 = var10_14.emit((Object)SpaceportEnvironment.access$createActions(this.this$0, env, v0), (Continuation)$continuation);
                                if (v1 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl43
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                value = $continuation.L$2;
                                $completion = $continuation.L$1;
                                value = $continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl43:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }), (CoroutineScope)this.environmentScope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)CollectionsKt.emptyList());
        this.deleteActionFlow = FlowExtensionsKt.mapState(this.getState(), arg_0 -> SpaceportEnvironment.deleteActionFlow$lambda$3(this, arg_0));
        this.pageTabs = CollectionsKt.listOf((Object)TabDefinition.Companion.projectsTab());
        objectArray = new SettingsSection[]{SettingsSection.ABOUT_ENVIRONMENT, SettingsSection.ADVANCED};
        this.availableSettingsSections = SetsKt.setOf((Object[])objectArray);
        this.wakeAction = new RunnableActionDescription(this){
            private final LocalizableString label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                this.label = SpaceportEnvironment.access$getI18n$p($receiver).ptrl("Activate environment");
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            public void run() {
                SpaceportEnvironment.access$activateEnvironment(this.this$0);
            }

            public boolean validate() {
                return super.validate();
            }

            public String getIcon() {
                return super.getIcon();
            }

            public boolean isParentDuplicate() {
                return super.isParentDuplicate();
            }

            public boolean isSuitableForEnvironmentView() {
                return super.isSuitableForEnvironmentView();
            }

            public boolean isEnabled() {
                return super.isEnabled();
            }

            public boolean isDangerous() {
                return super.isDangerous();
            }

            public boolean getShouldClosePage() {
                return super.getShouldClosePage();
            }
        };
        this.cancelDeleteAction = new RunnableActionDescription(this){
            private final LocalizableString label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                this.label = SpaceportEnvironment.access$getI18n$p($receiver).ptrl("Cancel deletion");
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            public void run() {
                SpaceportEnvironment.access$cancelDeletion(this.this$0);
            }

            public boolean validate() {
                return super.validate();
            }

            public String getIcon() {
                return super.getIcon();
            }

            public boolean isParentDuplicate() {
                return super.isParentDuplicate();
            }

            public boolean isSuitableForEnvironmentView() {
                return super.isSuitableForEnvironmentView();
            }

            public boolean isEnabled() {
                return super.isEnabled();
            }

            public boolean isDangerous() {
                return super.isDangerous();
            }

            public boolean getShouldClosePage() {
                return super.getShouldClosePage();
            }
        };
    }

    @NotNull
    public StateFlow<RemoteEnvironmentState> getState() {
        return this.state;
    }

    @NotNull
    public MutableStateFlow<EnvironmentDescription> getDescription() {
        return this.description;
    }

    @NotNull
    public MutableSharedFlow<Boolean> getConnectionRequest() {
        return this.connectionRequest;
    }

    private final RemoteEnvironmentState transformInternalToRemoteState(DevEnv devEnv) {
        if (devEnv.getDelayedDeletion() != null) {
            return (RemoteEnvironmentState)this.delayedDeletionState;
        }
        return switch (devEnv.getState()) {
            case "Active" -> (RemoteEnvironmentState)this.activeState;
            case "Hibernated" -> (RemoteEnvironmentState)this.stoppedState;
            case "Hibernating" -> (RemoteEnvironmentState)this.stoppingState;
            case "Unhealthy" -> (RemoteEnvironmentState)StandardRemoteEnvironmentState.Unhealthy;
            case "Activating" -> (RemoteEnvironmentState)StandardRemoteEnvironmentState.Activating;
            case "Deleting" -> (RemoteEnvironmentState)StandardRemoteEnvironmentState.Deleting;
            case "Deleted" -> (RemoteEnvironmentState)StandardRemoteEnvironmentState.Deleted;
            case "Failed" -> (RemoteEnvironmentState)StandardRemoteEnvironmentState.Failed;
            case "FailedToStart" -> (RemoteEnvironmentState)StandardRemoteEnvironmentState.FailedToStart;
            case "Created" -> (RemoteEnvironmentState)StandardRemoteEnvironmentState.Created;
            case "ScheduledForDeletion" -> (RemoteEnvironmentState)this.delayedDeletionState;
            default -> (RemoteEnvironmentState)StandardRemoteEnvironmentState.Initializing;
        };
    }

    private final void handleBeforeProjectOpen() {
        this.settingsStore.setAutoConnect(this.devEnv.getId(), true);
        this.ideConnectionHelper.connectToIde(this.devEnv.getId(), this.devEnv.getIdeType().getProductCode(), this.devEnv.getIdeVersionDetails().getBuild());
        if (((Boolean)this.environmentReady.getValue()).booleanValue()) {
            return;
        }
        this.handleEnvironmentActivation();
        this.handleConnectionFlow();
        throw new ProjectOpenCancelledException("Environment is being prepared. IDE will open soon.");
    }

    private final void handleEnvironmentActivation() {
        boolean canActivate = ((DevEnv)this.internalDevEnvFlow.getState().getValue()).getAccess().getAvailableActions().contains("REACTIVATE");
        if (canActivate) {
            this.activateEnvironment();
        }
    }

    private final void handleConnectionFlow() {
        if (((RemoteEnvironmentState)this.getState().getValue()).isReachable()) {
            switch (WhenMappings.$EnumSwitchMapping$0[((ConnectionState)((Object)this.connectionState.getValue())).ordinal()]) {
                case 1: 
                case 2: {
                    this.actionGuard.executeIfNotRunning("connect", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ SpaceportEnvironment this$0;
                        {
                            this.this$0 = $receiver;
                            super(1, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = SpaceportEnvironment.access$connect(this.this$0, (Continuation)this);
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Continuation<? super Unit> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                }
            }
        }
    }

    @NotNull
    public List<AfterDisconnectHook> getAfterDisconnectHooks() {
        return CollectionsKt.listOf((Object)this.beforeDisconnect);
    }

    @NotNull
    public MutableStateFlow<String> getNameFlow() {
        return this.nameFlow;
    }

    @NotNull
    public String getSecondaryInformation() {
        return this.secondaryInformation;
    }

    private final void optimisticUpdate(String optimisticState) {
        this.update(DevEnv.copy$default((DevEnv)this.internalDevEnvFlow.getState().getValue(), null, false, null, null, null, null, null, 0, null, null, null, optimisticState, null, null, null, null, null, null, null, 522239, null));
    }

    private final void activateEnvironment() {
        this.actionGuard.executeIfNotRunning("activate env", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SpaceportEnvironment.access$optimisticUpdate(this.this$0, "Activating");
                        this.label = 1;
                        Object object2 = SpaceportEnvironment.access$getInternalDevEnvFlow$p(this.this$0).withLock((Function1<Continuation<Unit>, Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ SpaceportEnvironment this$0;
                            {
                                this.this$0 = $receiver;
                                super(1, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = SpaceportEnvironment.access$getActions$p(this.this$0).activateDevEnvironment-0E7RQCE$gateway_plugin_space_port(SpaceportEnvironment.access$getAccount$p(this.this$0), this.this$0.getId(), (Continuation<? super Result<DevEnv>>)((Continuation)this));
                                        if (v0 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = ((Result)$result).unbox-impl();
lbl13:
                                        // 2 sources

                                        var3_3 = v0;
                                        ResultKt.throwOnFailure((Object)var3_3);
                                        devEnv = (DevEnv)var3_3;
                                        SpaceportEnvironment.access$getSettingsStore$p(this.this$0).setAutoConnect(devEnv.getId(), true);
                                        this.this$0.update(devEnv);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation<Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void restartEnvironment() {
        this.actionGuard.executeIfNotRunning("restart env", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SpaceportEnvironment.access$optimisticUpdate(this.this$0, "Initializing");
                        SpaceportEnvironment.access$getSettingsStore$p(this.this$0).setAutoConnect(SpaceportEnvironment.access$getDevEnv$p(this.this$0).getId(), true);
                        this.label = 1;
                        Object object2 = SpaceportEnvironment.access$getInternalDevEnvFlow$p(this.this$0).withLock((Function1<Continuation<Unit>, Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ SpaceportEnvironment this$0;
                            {
                                this.this$0 = $receiver;
                                super(1, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = SpaceportEnvironment.access$getActions$p(this.this$0).restartDevEnvironment-0E7RQCE$gateway_plugin_space_port(SpaceportEnvironment.access$getAccount$p(this.this$0), this.this$0.getId(), (Continuation<? super Result<DevEnv>>)((Continuation)this));
                                        if (v0 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = ((Result)$result).unbox-impl();
lbl13:
                                        // 2 sources

                                        var3_3 = v0;
                                        ResultKt.throwOnFailure((Object)var3_3);
                                        devEnv = (DevEnv)var3_3;
                                        this.this$0.update(devEnv);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation<Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void stopEnvironment() {
        this.actionGuard.executeIfNotRunning("stop env", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SpaceportEnvironment.access$optimisticUpdate(this.this$0, "Hibernating");
                        this.label = 1;
                        v0 = this.this$0.disconnect((Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        this.label = 2;
                        v1 = SpaceportEnvironment.access$getInternalDevEnvFlow$p(this.this$0).withLock((Function1<Continuation<Unit>, Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ SpaceportEnvironment this$0;
                            {
                                this.this$0 = $receiver;
                                super(1, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = SpaceportEnvironment.access$getActions$p(this.this$0).stopDevEnvironment-0E7RQCE$gateway_plugin_space_port(SpaceportEnvironment.access$getAccount$p(this.this$0), this.this$0.getId(), (Continuation<? super Result<DevEnv>>)((Continuation)this));
                                        if (v0 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = ((Result)$result).unbox-impl();
lbl13:
                                        // 2 sources

                                        var3_3 = v0;
                                        ResultKt.throwOnFailure((Object)var3_3);
                                        devEnv = (DevEnv)var3_3;
                                        this.this$0.update(devEnv);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation<Unit>)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void cancelDeletion() {
        this.update(DevEnv.copy$default((DevEnv)this.internalDevEnvFlow.getState().getValue(), null, false, null, null, null, null, null, 0, null, null, null, "Hibernated", null, null, null, null, null, null, null, 391167, null));
        this.actionGuard.executeIfNotRunning("cancel deletion", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = SpaceportEnvironment.access$getInternalDevEnvFlow$p(this.this$0).withLock((Function1<Continuation<Unit>, Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ SpaceportEnvironment this$0;
                            {
                                this.this$0 = $receiver;
                                super(1, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.this$0.getDescription().setValue((Object)new EnvironmentDescription.General(null));
                                        this.label = 1;
                                        v0 = SpaceportEnvironment.access$getActions$p(this.this$0).cancelDeletion-0E7RQCE$gateway_plugin_space_port(SpaceportEnvironment.access$getAccount$p(this.this$0), this.this$0.getId(), (Continuation<? super Result<DevEnv>>)((Continuation)this));
                                        if (v0 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl14
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = ((Result)$result).unbox-impl();
lbl14:
                                        // 2 sources

                                        var3_3 = v0;
                                        ResultKt.throwOnFailure((Object)var3_3);
                                        devEnv = (DevEnv)var3_3;
                                        this.this$0.update(devEnv);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation<Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final List<RunnableActionDescription> createActions(DevEnv env, List<String> flags) {
        List<DescriptionTree> sshConnectionString;
        List list2;
        List $this$createActions_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (env.getDelayedDeletion() != null) {
            $this$createActions_u24lambda_u241.add(this.cancelDeleteAction);
        }
        if (env.getAccess().getAvailableActions().contains("RESTART")) {
            $this$createActions_u24lambda_u241.add(new RunnableActionDescription(this){
                private final LocalizableString label;
                final /* synthetic */ SpaceportEnvironment this$0;
                {
                    this.this$0 = $receiver;
                    this.label = SpaceportEnvironment.access$getI18n$p($receiver).ptrl("Restart");
                }

                public LocalizableString getLabel() {
                    return this.label;
                }

                public void run() {
                    SpaceportEnvironment.access$restartEnvironment(this.this$0);
                }

                public boolean validate() {
                    return super.validate();
                }

                public String getIcon() {
                    return super.getIcon();
                }

                public boolean isParentDuplicate() {
                    return super.isParentDuplicate();
                }

                public boolean isSuitableForEnvironmentView() {
                    return super.isSuitableForEnvironmentView();
                }

                public boolean isEnabled() {
                    return super.isEnabled();
                }

                public boolean isDangerous() {
                    return super.isDangerous();
                }

                public boolean getShouldClosePage() {
                    return super.getShouldClosePage();
                }
            });
        }
        $this$createActions_u24lambda_u241.add(new RunnableActionDescription(this){
            private final LocalizableString label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                this.label = SpaceportEnvironment.access$getI18n$p($receiver).ptrl("Open in Web");
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            public void run() {
                LocalDesktopManager localDesktopManager = SpaceportEnvironment.access$getDesktopManager$p(this.this$0);
                URL uRL = new URI(SpaceportEnvironment.access$getInstanceUrl$p(this.this$0) + "/all-ns/rd/environment/" + SpaceportEnvironment.access$getDevEnv$p(this.this$0).getId()).toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                localDesktopManager.openUrl(uRL);
            }

            public boolean validate() {
                return super.validate();
            }

            public String getIcon() {
                return super.getIcon();
            }

            public boolean isParentDuplicate() {
                return super.isParentDuplicate();
            }

            public boolean isSuitableForEnvironmentView() {
                return super.isSuitableForEnvironmentView();
            }

            public boolean isEnabled() {
                return super.isEnabled();
            }

            public boolean isDangerous() {
                return super.isDangerous();
            }

            public boolean getShouldClosePage() {
                return super.getShouldClosePage();
            }
        });
        if (env.getAccess().getAvailableActions().contains("STOP")) {
            $this$createActions_u24lambda_u241.add(new RunnableActionDescription(this){
                private final LocalizableString label;
                final /* synthetic */ SpaceportEnvironment this$0;
                {
                    this.this$0 = $receiver;
                    this.label = SpaceportEnvironment.access$getI18n$p($receiver).ptrl("Stop");
                }

                public LocalizableString getLabel() {
                    return this.label;
                }

                public void run() {
                    SpaceportEnvironment.access$stopEnvironment(this.this$0);
                }

                public boolean validate() {
                    return super.validate();
                }

                public String getIcon() {
                    return super.getIcon();
                }

                public boolean isParentDuplicate() {
                    return super.isParentDuplicate();
                }

                public boolean isSuitableForEnvironmentView() {
                    return super.isSuitableForEnvironmentView();
                }

                public boolean isEnabled() {
                    return super.isEnabled();
                }

                public boolean isDangerous() {
                    return super.isDangerous();
                }

                public boolean getShouldClosePage() {
                    return super.getShouldClosePage();
                }
            });
        }
        if (env.getAccess().getAvailableActions().contains("REACTIVATE")) {
            $this$createActions_u24lambda_u241.add(new RunnableActionDescription(this){
                private final LocalizableString label;
                private final boolean isEnabled;
                final /* synthetic */ SpaceportEnvironment this$0;
                {
                    this.this$0 = $receiver;
                    this.label = SpaceportEnvironment.access$getI18n$p($receiver).ptrl("Activate");
                    this.isEnabled = Intrinsics.areEqual((Object)$receiver.getState().getValue(), (Object)SpaceportEnvironment.access$getStoppedState$p($receiver));
                }

                public LocalizableString getLabel() {
                    return this.label;
                }

                public boolean isEnabled() {
                    return this.isEnabled;
                }

                public void run() {
                    SpaceportEnvironment.access$activateEnvironment(this.this$0);
                }

                public boolean validate() {
                    return super.validate();
                }

                public String getIcon() {
                    return super.getIcon();
                }

                public boolean isParentDuplicate() {
                    return super.isParentDuplicate();
                }

                public boolean isSuitableForEnvironmentView() {
                    return super.isSuitableForEnvironmentView();
                }

                public boolean isDangerous() {
                    return super.isDangerous();
                }

                public boolean getShouldClosePage() {
                    return super.getShouldClosePage();
                }
            });
        }
        SshConnectionParams sshConnectionParams = env.getSshConnectionParams();
        List<DescriptionTree> list3 = sshConnectionString = sshConnectionParams != null ? CodeCanvasSshParamsKt.sshConnectionString(sshConnectionParams, this.i18n) : null;
        if (sshConnectionString != null) {
            List<DescriptionTree> sshConfig;
            $this$createActions_u24lambda_u241.add(new RunnableActionDescription(this, sshConnectionString){
                private final LocalizableString label;
                private final boolean isSuitableForEnvironmentView;
                final /* synthetic */ SpaceportEnvironment this$0;
                final /* synthetic */ List<DescriptionTree> $sshConnectionString;
                {
                    this.this$0 = $receiver;
                    this.$sshConnectionString = $sshConnectionString;
                    this.label = SpaceportEnvironment.access$getI18n$p($receiver).ptrl("SSH connection\u2026");
                }

                public LocalizableString getLabel() {
                    return this.label;
                }

                public void run() {
                    BuildersKt.launch$default((CoroutineScope)SpaceportEnvironment.access$getEnvironmentScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$sshConnectionString, null){
                        int label;
                        final /* synthetic */ SpaceportEnvironment this$0;
                        final /* synthetic */ List<DescriptionTree> $sshConnectionString;
                        {
                            this.this$0 = $receiver;
                            this.$sshConnectionString = $sshConnectionString;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = SpaceportEnvironment.access$getToolboxUi$p(this.this$0).showInfoPopup(SpaceportEnvironment.access$getI18n$p(this.this$0).ptrl("SSH Connection"), this.$sshConnectionString, SpaceportEnvironment.access$getI18n$p(this.this$0).ptrl("Close"), (Continuation)this);
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }

                public boolean isSuitableForEnvironmentView() {
                    return this.isSuitableForEnvironmentView;
                }

                public boolean validate() {
                    return super.validate();
                }

                public String getIcon() {
                    return super.getIcon();
                }

                public boolean isParentDuplicate() {
                    return super.isParentDuplicate();
                }

                public boolean isEnabled() {
                    return super.isEnabled();
                }

                public boolean isDangerous() {
                    return super.isDangerous();
                }

                public boolean getShouldClosePage() {
                    return super.getShouldClosePage();
                }
            });
            SshConnectionParams sshConnectionParams2 = this.devEnv.getSshConnectionParams();
            List<DescriptionTree> list4 = sshConfig = sshConnectionParams2 != null ? CodeCanvasSshParamsKt.fullSSHDescription(sshConnectionParams2, this.i18n) : null;
            if (sshConfig != null) {
                $this$createActions_u24lambda_u241.add(new RunnableActionDescription(this, sshConfig){
                    private final LocalizableString label;
                    private final boolean isSuitableForEnvironmentView;
                    final /* synthetic */ SpaceportEnvironment this$0;
                    final /* synthetic */ List<DescriptionTree> $sshConfig;
                    {
                        this.this$0 = $receiver;
                        this.$sshConfig = $sshConfig;
                        this.label = SpaceportEnvironment.access$getI18n$p($receiver).ptrl("SSH config\u2026");
                    }

                    public LocalizableString getLabel() {
                        return this.label;
                    }

                    public void run() {
                        BuildersKt.launch$default((CoroutineScope)SpaceportEnvironment.access$getEnvironmentScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$sshConfig, null){
                            int label;
                            final /* synthetic */ SpaceportEnvironment this$0;
                            final /* synthetic */ List<DescriptionTree> $sshConfig;
                            {
                                this.this$0 = $receiver;
                                this.$sshConfig = $sshConfig;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = SpaceportEnvironment.access$getToolboxUi$p(this.this$0).showInfoPopup(SpaceportEnvironment.access$getI18n$p(this.this$0).ptrl("SSH Config"), this.$sshConfig, SpaceportEnvironment.access$getI18n$p(this.this$0).ptrl("Close"), (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }

                    public boolean isSuitableForEnvironmentView() {
                        return this.isSuitableForEnvironmentView;
                    }

                    public boolean validate() {
                        return super.validate();
                    }

                    public String getIcon() {
                        return super.getIcon();
                    }

                    public boolean isParentDuplicate() {
                        return super.isParentDuplicate();
                    }

                    public boolean isEnabled() {
                        return super.isEnabled();
                    }

                    public boolean isDangerous() {
                        return super.isDangerous();
                    }

                    public boolean getShouldClosePage() {
                        return super.getShouldClosePage();
                    }
                });
            }
        }
        if (flags.contains("RD_TROUBLESHOOT_CLIENT_LOGS")) {
            $this$createActions_u24lambda_u241.add(new RunnableActionDescription(this){
                private final LocalizableString label;
                private final boolean isSuitableForEnvironmentView;
                final /* synthetic */ SpaceportEnvironment this$0;
                {
                    this.this$0 = $receiver;
                    this.label = SpaceportEnvironment.access$getI18n$p($receiver).ptrl("Report problem");
                }

                public LocalizableString getLabel() {
                    return this.label;
                }

                public void run() {
                    SpaceportEnvironment.access$getActionGuard$p(this.this$0).executeIfNotRunning("report problem", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        final /* synthetic */ SpaceportEnvironment this$0;
                        {
                            this.this$0 = $receiver;
                            super(1, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = SpaceportEnvironment.access$getReporter$p(this.this$0).reportProblem(this.this$0.getId(), (Continuation<? super Unit>)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Continuation<? super Unit> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                }

                public boolean isSuitableForEnvironmentView() {
                    return this.isSuitableForEnvironmentView;
                }

                public boolean validate() {
                    return super.validate();
                }

                public String getIcon() {
                    return super.getIcon();
                }

                public boolean isParentDuplicate() {
                    return super.isParentDuplicate();
                }

                public boolean isEnabled() {
                    return super.isEnabled();
                }

                public boolean isDangerous() {
                    return super.isDangerous();
                }

                public boolean getShouldClosePage() {
                    return super.getShouldClosePage();
                }
            });
        }
        return CollectionsKt.build((List)list2);
    }

    private final Object connect(Continuation<? super Unit> $completion) {
        this.logger.debug("Connecting to " + this.devEnv.getName());
        Object object = this.getConnectionRequest().emit((Object)Boxing.boxBoolean((boolean)true), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object disconnect(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.getConnectionRequest().emit((Object)Boxing.boxBoolean((boolean)false), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object getContentsView(@NotNull Continuation<? super EnvironmentContentsView> $completion) {
        return this.contentsView;
    }

    public void setVisible(@NotNull EnvironmentVisibilityState visibilityState) {
        Intrinsics.checkNotNullParameter((Object)visibilityState, (String)"visibilityState");
    }

    @NotNull
    public Set<RemoteEnvironmentAbility> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @NotNull
    public StateFlow<List<ActionDescription>> getActionsList() {
        return this.actionsList;
    }

    @NotNull
    public StateFlow<KFunction<Unit>> getDeleteActionFlow() {
        return this.deleteActionFlow;
    }

    private final void deleteEnvironment() {
        this.actionGuard.executeIfNotRunning("delete env", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpaceportEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SpaceportEnvironment.access$optimisticUpdate(this.this$0, "Deleting");
                        this.label = 1;
                        v0 = this.this$0.disconnect((Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        SpaceportEnvironment.access$getCustomLaunchService$p(this.this$0).removeProvider(this.this$0.getId());
                        this.label = 2;
                        v1 = SpaceportEnvironment.access$getInternalDevEnvFlow$p(this.this$0).withLock((Function1<Continuation<Unit>, Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ SpaceportEnvironment this$0;
                            {
                                this.this$0 = $receiver;
                                super(1, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = SpaceportEnvironment.access$getActions$p(this.this$0).deleteDevEnvironment-0E7RQCE$gateway_plugin_space_port(SpaceportEnvironment.access$getAccount$p(this.this$0), this.this$0.getId(), (Continuation<? super Result<DevEnv>>)((Continuation)this));
                                        if (v0 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = ((Result)$result).unbox-impl();
lbl13:
                                        // 2 sources

                                        var3_3 = v0;
                                        ResultKt.throwOnFailure((Object)var3_3);
                                        devEnv = (DevEnv)var3_3;
                                        this.this$0.update(devEnv);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation<Unit>)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl23
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl23:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void update(@NotNull DevEnv env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.internalDevEnvFlow.update(env);
        this.contentsView.updateProjects(env);
    }

    @NotNull
    public List<TabDefinition> getPageTabs() {
        return this.pageTabs;
    }

    @NotNull
    public Set<SettingsSection> getAvailableSettingsSections() {
        return this.availableSettingsSections;
    }

    @NotNull
    public Flow<EnvironmentIssue> getEnvironmentIssueFlow() {
        return (Flow)FlowExtensionsKt.mapState(this.getState(), arg_0 -> SpaceportEnvironment.getEnvironmentIssueFlow$lambda$4(this, arg_0));
    }

    @Override
    public void close() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.environmentScope, null, (int)1, null);
    }

    private static final RemoteEnvironmentState state$lambda$0(SpaceportEnvironment this$0, DevEnv it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.transformInternalToRemoteState(it);
    }

    private static final /* synthetic */ Object contentsView$handleBeforeProjectOpen(SpaceportEnvironment $this$contentsView_u24handleBeforeProjectOpen, Continuation $completion) {
        $this$contentsView_u24handleBeforeProjectOpen.handleBeforeProjectOpen();
        return Unit.INSTANCE;
    }

    private static final KFunction deleteActionFlow$lambda$3(SpaceportEnvironment this$0, RemoteEnvironmentState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        return Intrinsics.areEqual((Object)state2, (Object)this$0.delayedDeletionState) || state2 == StandardRemoteEnvironmentState.Deleting || state2 == StandardRemoteEnvironmentState.Deleted ? null : (KFunction)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                SpaceportEnvironment.access$deleteEnvironment((SpaceportEnvironment)this.receiver);
            }
        };
    }

    private static final EnvironmentIssue getEnvironmentIssueFlow$lambda$4(SpaceportEnvironment this$0, RemoteEnvironmentState status2) {
        CustomRemoteEnvironmentStateV2 customRemoteEnvironmentStateV2;
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        RemoteEnvironmentState remoteEnvironmentState = status2;
        return remoteEnvironmentState instanceof CustomRemoteEnvironmentStateV2 ? (Intrinsics.areEqual((Object)(customRemoteEnvironmentStateV2 = (CustomRemoteEnvironmentStateV2)status2), (Object)this$0.delayedDeletionState) ? new EnvironmentIssue(this$0.i18n.ptrl("The environment is scheduled for deletion"), CollectionsKt.listOf((Object)this$0.cancelDeleteAction), false, false, 12, null) : (Intrinsics.areEqual((Object)customRemoteEnvironmentStateV2, (Object)this$0.stoppedState) ? new EnvironmentIssue(this$0.i18n.ptrl("The environment is stopped"), CollectionsKt.listOf((Object)this$0.wakeAction), false, false, 12, null) : (Intrinsics.areEqual((Object)customRemoteEnvironmentStateV2, (Object)this$0.stoppingState) ? new EnvironmentIssue(this$0.i18n.ptrl("The environment is stopping\u2026"), CollectionsKt.emptyList(), false, true, 4, null) : null))) : (remoteEnvironmentState == StandardRemoteEnvironmentState.Unhealthy ? new EnvironmentIssue(this$0.i18n.ptrl("The IDE is unhealthy"), CollectionsKt.emptyList(), false, true, 4, null) : (remoteEnvironmentState == StandardRemoteEnvironmentState.Restarting || remoteEnvironmentState == StandardRemoteEnvironmentState.Initializing || remoteEnvironmentState == StandardRemoteEnvironmentState.Activating ? new EnvironmentIssue(this$0.i18n.ptrl("The environment is starting\u2026"), CollectionsKt.emptyList(), false, true, 4, null) : (remoteEnvironmentState == StandardRemoteEnvironmentState.Deleting || remoteEnvironmentState == StandardRemoteEnvironmentState.Deleted ? new EnvironmentIssue(this$0.i18n.ptrl("The environment is deleted"), CollectionsKt.emptyList(), true, false, 8, null) : (remoteEnvironmentState == StandardRemoteEnvironmentState.Failed || remoteEnvironmentState == StandardRemoteEnvironmentState.FailedToStart ? new EnvironmentIssue(this$0.i18n.ptrl("The environment failed to start"), CollectionsKt.emptyList(), true, false, 8, null) : null))));
    }

    public static final /* synthetic */ void access$optimisticUpdate(SpaceportEnvironment $this, String optimisticState) {
        $this.optimisticUpdate(optimisticState);
    }

    public static final /* synthetic */ SpaceportActions access$getActions$p(SpaceportEnvironment $this) {
        return $this.actions;
    }

    public static final /* synthetic */ SpaceportAccount access$getAccount$p(SpaceportEnvironment $this) {
        return $this.account;
    }

    public static final /* synthetic */ CustomLaunchService access$getCustomLaunchService$p(SpaceportEnvironment $this) {
        return $this.customLaunchService;
    }

    public static final /* synthetic */ Object access$contentsView$handleBeforeProjectOpen(SpaceportEnvironment $receiver, Continuation $completion) {
        return SpaceportEnvironment.contentsView$handleBeforeProjectOpen($receiver, $completion);
    }

    public static final /* synthetic */ void access$restartEnvironment(SpaceportEnvironment $this) {
        $this.restartEnvironment();
    }

    public static final /* synthetic */ LocalDesktopManager access$getDesktopManager$p(SpaceportEnvironment $this) {
        return $this.desktopManager;
    }

    public static final /* synthetic */ String access$getInstanceUrl$p(SpaceportEnvironment $this) {
        return $this.instanceUrl;
    }

    public static final /* synthetic */ void access$stopEnvironment(SpaceportEnvironment $this) {
        $this.stopEnvironment();
    }

    public static final /* synthetic */ void access$activateEnvironment(SpaceportEnvironment $this) {
        $this.activateEnvironment();
    }

    public static final /* synthetic */ CoroutineScope access$getEnvironmentScope$p(SpaceportEnvironment $this) {
        return $this.environmentScope;
    }

    public static final /* synthetic */ ToolboxUi access$getToolboxUi$p(SpaceportEnvironment $this) {
        return $this.toolboxUi;
    }

    public static final /* synthetic */ ActionGuard access$getActionGuard$p(SpaceportEnvironment $this) {
        return $this.actionGuard;
    }

    public static final /* synthetic */ CodeCanvasReporter access$getReporter$p(SpaceportEnvironment $this) {
        return $this.reporter;
    }

    public static final /* synthetic */ List access$createActions(SpaceportEnvironment $this, DevEnv env, List flags) {
        return $this.createActions(env, flags);
    }

    public static final /* synthetic */ void access$deleteEnvironment(SpaceportEnvironment $this) {
        $this.deleteEnvironment();
    }

    public static final /* synthetic */ Logger access$getLogger$p(SpaceportEnvironment $this) {
        return $this.logger;
    }

    public static final /* synthetic */ CodeCanvasErrorManager access$getErrorsManager$p(SpaceportEnvironment $this) {
        return $this.errorsManager;
    }

    public static final /* synthetic */ void access$cancelDeletion(SpaceportEnvironment $this) {
        $this.cancelDeletion();
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionState.values().length];
            try {
                nArray[ConnectionState.Disconnected.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionState.Error.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

