/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.spaceport;

import com.jetbrains.toolbox.api.core.diagnostics.Logger;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.localization.LocalizableStringFactory;
import com.jetbrains.toolbox.api.ui.ToolboxUi;
import com.jetbrains.toolbox.api.ui.actions.ActionDescription;
import com.jetbrains.toolbox.api.ui.actions.RunnableActionDescription;
import com.jetbrains.toolbox.api.ui.components.AutocompleteTextField;
import com.jetbrains.toolbox.api.ui.components.AutocompleteTextFieldKt;
import com.jetbrains.toolbox.api.ui.components.BaseUiField;
import com.jetbrains.toolbox.api.ui.components.CallToActionFieldKt;
import com.jetbrains.toolbox.api.ui.components.ComboBoxField;
import com.jetbrains.toolbox.api.ui.components.FieldModifier;
import com.jetbrains.toolbox.api.ui.components.LabelFieldKt;
import com.jetbrains.toolbox.api.ui.components.LabelFieldMutable;
import com.jetbrains.toolbox.api.ui.components.SectionFieldKt;
import com.jetbrains.toolbox.api.ui.components.SectionFieldMutable;
import com.jetbrains.toolbox.api.ui.components.TextField;
import com.jetbrains.toolbox.api.ui.components.TextFieldKt;
import com.jetbrains.toolbox.api.ui.components.TextType;
import com.jetbrains.toolbox.api.ui.components.UiComponents;
import com.jetbrains.toolbox.api.ui.components.UiField;
import com.jetbrains.toolbox.api.ui.components.UiPage;
import com.jetbrains.toolbox.api.ui.components.ValidationResult;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.common.coroutines.flow.SingleStateFlow;
import com.jetbrains.toolbox.gateway.DialogService;
import com.jetbrains.toolbox.gateway.ParameterResult;
import com.jetbrains.toolbox.gateway.spaceport.CodeCanvasErrorManager;
import com.jetbrains.toolbox.gateway.spaceport.DevEnvCreationResult;
import com.jetbrains.toolbox.gateway.spaceport.EnvParametersPage;
import com.jetbrains.toolbox.gateway.spaceport.EnvParametersPageKt;
import com.jetbrains.toolbox.gateway.spaceport.EnvParametersVm;
import com.jetbrains.toolbox.gateway.spaceport.PersonalParameter;
import com.jetbrains.toolbox.gateway.spaceport.RepoConnectionWithBranch;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportActions;
import com.jetbrains.toolbox.gateway.spaceport.Template;
import com.jetbrains.toolbox.gateway.spaceport.TemplateParametersState;
import com.jetbrains.toolbox.gateway.spaceport.UserParameter;
import com.jetbrains.toolbox.gateway.spaceport.auth.SpaceportAccount;
import com.jetbrains.toolbox.gateway.spaceport.utils.LoadingState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.KotlinNothingValueException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nEnvParametersPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvParametersPage.kt\ncom/jetbrains/toolbox/gateway/spaceport/EnvParametersPage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,559:1\n1869#2,2:560\n1869#2,2:562\n1869#2,2:564\n1634#2,3:570\n216#3,2:566\n216#3,2:568\n*S KotlinDebug\n*F\n+ 1 EnvParametersPage.kt\ncom/jetbrains/toolbox/gateway/spaceport/EnvParametersPage\n*L\n395#1:560,2\n406#1:562,2\n423#1:564,2\n438#1:570,3\n532#1:566,2\n546#1:568,2\n*E\n"})
public final class EnvParametersPage
extends UiPage {
    @NotNull
    private final ToolboxUi toolboxUi;
    @NotNull
    private final DialogService dialogService;
    @NotNull
    private final LocalizableStringFactory i18n;
    @NotNull
    private final UiComponents components;
    @NotNull
    private final Function1<DevEnvCreationResult, Unit> afterCreationHandle;
    @NotNull
    private final Template template;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final EnvParametersVm vm;
    @NotNull
    private final StateFlow<Boolean> isBusy;
    @NotNull
    private final createParameterAction.1 createParameterAction;
    @NotNull
    private final TextField nameField;
    @NotNull
    private final Map<String, MutableStateFlow<List<AutocompleteTextField.ValueItem>>> branchesFieldsValues;
    @NotNull
    private final Map<String, AutocompleteTextField> branchesFields;
    @NotNull
    private final List<UiField> branchesSectionContent;
    @NotNull
    private final SectionFieldMutable branchesSection;
    @NotNull
    private final LabelFieldMutable templateNameField;
    @NotNull
    private final StateFlow<List<UiField>> fields;
    @NotNull
    private final StateFlow<List<ActionDescription>> actionButtons;

    /*
     * WARNING - void declaration
     */
    public EnvParametersPage(@NotNull StateFlow<Template> templateFlow, @NotNull CoroutineScope pluginScope, @NotNull ToolboxUi toolboxUi, @NotNull DialogService dialogService, @NotNull SpaceportActions spaceportActions, @NotNull SpaceportAccount spaceportAccount, @NotNull CodeCanvasErrorManager errorsManager, @NotNull Logger logger, @NotNull LocalizableStringFactory i18n, @NotNull UiComponents components, @NotNull Function1<? super DevEnvCreationResult, Unit> afterCreationHandle) {
        AutocompleteTextField field;
        String repoId;
        Map.Entry<String, AutocompleteTextField> element$iv;
        Object $this$branchesFields_u24lambda_u244;
        Object $this$branchesFieldsValues_u24lambda_u242;
        String key2;
        RepoConnectionWithBranch repo;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(templateFlow, (String)"templateFlow");
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        Intrinsics.checkNotNullParameter((Object)toolboxUi, (String)"toolboxUi");
        Intrinsics.checkNotNullParameter((Object)dialogService, (String)"dialogService");
        Intrinsics.checkNotNullParameter((Object)spaceportActions, (String)"spaceportActions");
        Intrinsics.checkNotNullParameter((Object)spaceportAccount, (String)"spaceportAccount");
        Intrinsics.checkNotNullParameter((Object)errorsManager, (String)"errorsManager");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Intrinsics.checkNotNullParameter(afterCreationHandle, (String)"afterCreationHandle");
        super((StateFlow)new SingleStateFlow<LocalizableString>(i18n.ptrl("New Environment")));
        this.toolboxUi = toolboxUi;
        this.dialogService = dialogService;
        this.i18n = i18n;
        this.components = components;
        this.afterCreationHandle = afterCreationHandle;
        Object object = templateFlow.getValue();
        Intrinsics.checkNotNull((Object)object);
        this.template = (Template)object;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob((Job)JobKt.getJob((CoroutineContext)pluginScope.getCoroutineContext())).plus((CoroutineContext)new CoroutineName("EnvParametersPage scope")));
        Object object2 = this.template;
        Object object3 = this.coroutineScope;
        LocalizableStringFactory localizableStringFactory = this.i18n;
        this.vm = new EnvParametersVm((Template)object2, spaceportAccount, spaceportActions, errorsManager, logger, localizableStringFactory, (CoroutineScope)object3);
        this.isBusy = this.vm.isBusy();
        this.createParameterAction = new RunnableActionDescription(this){
            private final LocalizableString label;
            final /* synthetic */ EnvParametersPage this$0;
            {
                this.this$0 = $receiver;
                this.label = EnvParametersPage.access$getI18n$p($receiver).ptrl("Create new");
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            public void run() {
                BuildersKt.launch$default((CoroutineScope)EnvParametersPage.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                    int label;
                    final /* synthetic */ EnvParametersPage this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    Object L$0;
                                    int label;
                                    final /* synthetic */ EnvParametersPage this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                Object object2;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = this.this$0;
                                                boolean $i$f$catching = false;
                                                try {
                                                    boolean bl = false;
                                                    object2 = Result.constructor-impl((Object)EnvParametersPage.access$getDialogService$p((EnvParametersPage)((Object)object3)).showAddNewParameterDialog("New protected parameter").join());
                                                }
                                                catch (CancellationException c$iv) {
                                                    throw c$iv;
                                                }
                                                catch (Throwable t$iv) {
                                                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                                                }
                                                object3 = object2;
                                                ParameterResult parameterResult = (ParameterResult)(Result.isFailure-impl((Object)object3) ? null : object3);
                                                if (parameterResult == null) {
                                                    return Unit.INSTANCE;
                                                }
                                                ParameterResult result2 = parameterResult;
                                                EnvParametersVm envParametersVm = EnvParametersPage.access$getVm$p(this.this$0);
                                                String string = result2.key();
                                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key(...)");
                                                String string2 = result2.value();
                                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value(...)");
                                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)result2);
                                                this.label = 1;
                                                Object object4 = envParametersVm.createPersonalParameter(string, string2, (Continuation<? super Unit>)((Continuation)this));
                                                if (object4 != object) return Unit.INSTANCE;
                                                return object;
                                            }
                                            case 1: {
                                                ParameterResult result3 = (ParameterResult)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object4 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }

            public boolean validate() {
                return super.validate();
            }

            public String getIcon() {
                return super.getIcon();
            }

            public boolean isParentDuplicate() {
                return super.isParentDuplicate();
            }

            public boolean isSuitableForEnvironmentView() {
                return super.isSuitableForEnvironmentView();
            }

            public boolean isEnabled() {
                return super.isEnabled();
            }

            public boolean isDangerous() {
                return super.isDangerous();
            }

            public boolean getShouldClosePage() {
                return super.getShouldClosePage();
            }
        };
        this.nameField = TextFieldKt.TextField((StateFlow)new SingleStateFlow<LocalizableString>(this.i18n.ptrl("Name")), this.vm.getName(), (StateFlow)new SingleStateFlow<TextType>(TextType.General), (StateFlow)new SingleStateFlow<Boolean>(false), (StateFlow)new SingleStateFlow<Object>(null), (StateFlow)new SingleStateFlow<Object>(null), (StateFlow)new SingleStateFlow<Function1>(arg_0 -> EnvParametersPage.nameField$lambda$0(this, arg_0)));
        object2 = MapsKt.createMapBuilder();
        object3 = object2;
        EnvParametersPage envParametersPage = this;
        boolean bl = false;
        List<RepoConnectionWithBranch> list2 = this.template.getRepoConnections();
        if (list2 != null) {
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                repo = (RepoConnectionWithBranch)element$iv2;
                boolean bl2 = false;
                key2 = repo.getConnection().getId();
                String string = repo.getDefaultBranch();
                if (string == null) {
                    string = "default";
                }
                String defaultBranch = string;
                $this$branchesFieldsValues_u24lambda_u242.put(key2, StateFlowKt.MutableStateFlow((Object)CollectionsKt.listOf((Object)new AutocompleteTextField.ValueItem(defaultBranch, null, null, 6, null))));
            }
        }
        envParametersPage.branchesFieldsValues = MapsKt.build((Map)object2);
        $this$branchesFieldsValues_u24lambda_u242 = object2 = MapsKt.createMapBuilder();
        envParametersPage = this;
        boolean bl3 = false;
        List<RepoConnectionWithBranch> list3 = this.template.getRepoConnections();
        if (list3 != null) {
            $this$forEach$iv = list3;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                repo = (RepoConnectionWithBranch)element$iv2;
                boolean bl4 = false;
                key2 = repo.getConnection().getId();
                StateFlow stateFlow = new SingleStateFlow<LocalizableString>(this.i18n.pnotr(repo.getConnection().getName()));
                MutableStateFlow<List<AutocompleteTextField.ValueItem>> mutableStateFlow = this.branchesFieldsValues.get(key2);
                Intrinsics.checkNotNull(mutableStateFlow);
                $this$branchesFields_u24lambda_u244.put(key2, AutocompleteTextFieldKt.AutocompleteTextField((StateFlow)stateFlow, (String)"", (StateFlow)((StateFlow)mutableStateFlow), (StateFlow)new SingleStateFlow<Object>(null), (StateFlow)new SingleStateFlow<Object>(null)));
            }
        }
        envParametersPage.branchesFields = MapsKt.build((Map)object2);
        $this$branchesFields_u24lambda_u244 = object2 = CollectionsKt.createListBuilder();
        envParametersPage = this;
        boolean bl5 = false;
        List<RepoConnectionWithBranch> list4 = this.template.getRepoConnections();
        if (list4 != null) {
            $this$forEach$iv = list4;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                void $this$branchesSectionContent_u24lambda_u246;
                repo = (RepoConnectionWithBranch)element$iv2;
                boolean bl6 = false;
                AutocompleteTextField autocompleteTextField = this.branchesFields.get(repo.getConnection().getId());
                Intrinsics.checkNotNull((Object)autocompleteTextField);
                $this$branchesSectionContent_u24lambda_u246.add(autocompleteTextField);
            }
        }
        envParametersPage.branchesSectionContent = CollectionsKt.build((List)object2);
        this.branchesSection = SectionFieldKt.SectionField((String)"Repository branches", (boolean)true, this.branchesSectionContent);
        this.templateNameField = LabelFieldKt.LabelField$default((LocalizableString)this.i18n.ptrl("Template: " + this.template.getName()), null, (int)2, null);
        this.fields = FlowExtensionsKt.combineStates(this.vm.getTemplateParametersState(), this.vm.getAvailableParameters(), (arg_0, arg_1) -> EnvParametersPage.fields$lambda$11(this, arg_0, arg_1));
        this.actionButtons = FlowExtensionsKt.mapState(this.vm.isValid(), arg_0 -> EnvParametersPage.actionButtons$lambda$12(this, arg_0));
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EnvParametersPage this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.vm.getRepoBranches()), (Function2)((Function2)new Function2<Map<String, ? extends List<? extends String>>, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ EnvParametersPage this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                Map map2 = (Map)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$forEach$iv;
                                        void branches;
                                        ResultKt.throwOnFailure((Object)$result);
                                        void var3_3 = branches;
                                        EnvParametersPage envParametersPage = this.this$0;
                                        boolean $i$f$forEach = false;
                                        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                                        while (iterator2.hasNext()) {
                                            MutableStateFlow field;
                                            void $this$mapTo$iv$iv;
                                            void $this$map$iv;
                                            String it;
                                            void $this$filterTo$iv$iv;
                                            Map.Entry element$iv;
                                            Map.Entry entry = element$iv = iterator2.next();
                                            boolean bl = false;
                                            String key2 = (String)entry.getKey();
                                            List branchList = (List)entry.getValue();
                                            if (!(!((Collection)branchList).isEmpty()) || (MutableStateFlow)envParametersPage.branchesFieldsValues.get(key2) == null) continue;
                                            String string = envParametersPage.vm.getDefaultBranches().get(key2);
                                            if (string == null) {
                                                string = "default";
                                            }
                                            String defaultBranch = string;
                                            Iterable $this$filter$iv = branchList;
                                            boolean $i$f$filter = false;
                                            Iterable iterable = $this$filter$iv;
                                            Collection destination$iv$iv = new ArrayList();
                                            boolean $i$f$filterTo = false;
                                            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                                it = (String)element$iv$iv;
                                                boolean bl2 = false;
                                                if (!(!Intrinsics.areEqual((Object)it, (Object)defaultBranch))) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            $this$filter$iv = (List)destination$iv$iv;
                                            boolean $i$f$map = false;
                                            $this$filterTo$iv$iv = $this$map$iv;
                                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                            boolean $i$f$mapTo = false;
                                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                                it = (String)item$iv$iv;
                                                Collection collection = destination$iv$iv;
                                                boolean bl3 = false;
                                                collection.add(new AutocompleteTextField.ValueItem(it, null, null, 6, null));
                                            }
                                            List branchValues = (List)destination$iv$iv;
                                            field.setValue((Object)branchValues);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Map<String, ? extends List<String>> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        Map<String, AutocompleteTextField> $this$forEach$iv2 = this.branchesFields;
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<String, AutocompleteTextField>> iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, AutocompleteTextField> entry = element$iv = iterator2.next();
            boolean bl7 = false;
            repoId = entry.getKey();
            field = entry.getValue();
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(field, this, repoId, null){
                int label;
                final /* synthetic */ AutocompleteTextField $field;
                final /* synthetic */ EnvParametersPage this$0;
                final /* synthetic */ String $repoId;
                {
                    this.$field = $field;
                    this.this$0 = $receiver;
                    this.$repoId = $repoId;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.$field.getContentState()), (long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this.this$0, this.$repoId, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ EnvParametersPage this$0;
                                final /* synthetic */ String $repoId;
                                {
                                    this.this$0 = $receiver;
                                    this.$repoId = $repoId;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var2_2 = (String)this.L$0;
                                    var17_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)branchQuery);
                                            this.label = 1;
                                            v0 = EnvParametersPage.access$getVm$p(this.this$0).fetchBranchesForQuery(this.$repoId, (String)branchQuery, (Continuation<? super List<String>>)((Continuation)this));
                                            if (v0 == var17_3) {
                                                return var17_3;
                                            }
                                            ** GOTO lbl15
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl15:
                                            // 2 sources

                                            branches = (List)v0;
                                            v1 = (MutableStateFlow)EnvParametersPage.access$getBranchesFieldsValues$p(this.this$0).get(this.$repoId);
                                            if (v1 == null) {
                                                return Unit.INSTANCE;
                                            }
                                            branchesField = v1;
                                            v2 = EnvParametersPage.access$getVm$p(this.this$0).getDefaultBranches().get(this.$repoId);
                                            if (v2 == null) {
                                                v2 = "default";
                                            }
                                            defaultBranch = v2;
                                            $this$filter$iv = branches;
                                            $i$f$filter = false;
                                            var9_9 = $this$filter$iv;
                                            destination$iv$iv = new ArrayList<E>();
                                            $i$f$filterTo = false;
                                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                                it = (String)element$iv$iv;
                                                $i$a$-filter-EnvParametersPage$2$1$1$branchValues$1 = false;
                                                if (!(Intrinsics.areEqual((Object)it, (Object)defaultBranch) == false)) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            $this$filter$iv = (List)destination$iv$iv;
                                            $i$f$map = false;
                                            $this$filterTo$iv$iv = $this$map$iv;
                                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                            $i$f$mapTo = false;
                                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                it = (String)item$iv$iv;
                                                var16_16 = destination$iv$iv;
                                                $i$a$-map-EnvParametersPage$2$1$1$branchValues$2 = false;
                                                var16_16.add(new AutocompleteTextField.ValueItem(it, null, null, 6, null));
                                            }
                                            branchValues = (List)destination$iv$iv;
                                            branchesField.setValue((Object)branchValues);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(String p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        $this$forEach$iv2 = this.branchesFields;
        $i$f$forEach2 = false;
        iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, AutocompleteTextField> entry = element$iv = iterator2.next();
            boolean bl8 = false;
            repoId = entry.getKey();
            field = entry.getValue();
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, repoId, field, null){
                Object L$0;
                int label;
                final /* synthetic */ EnvParametersPage this$0;
                final /* synthetic */ String $repoId;
                final /* synthetic */ AutocompleteTextField $field;
                {
                    this.this$0 = $receiver;
                    this.$repoId = $repoId;
                    this.$field = $field;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            MutableStateFlow<String> branchState = EnvParametersPage.access$getVm$p(this.this$0).getBranchOverrides().get(this.$repoId);
                            if (branchState == null) return Unit.INSTANCE;
                            this.L$0 = SpillingKt.nullOutSpilledVariable(branchState);
                            this.label = 1;
                            Object object2 = this.$field.getContentState().collect(new FlowCollector(branchState){
                                final /* synthetic */ MutableStateFlow<String> $branchState;
                                {
                                    this.$branchState = $branchState;
                                }

                                public final Object emit(String it, Continuation<? super Unit> $completion) {
                                    this.$branchState.setValue((Object)it);
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) throw new KotlinNothingValueException();
                            return object;
                        }
                        case 1: {
                            MutableStateFlow branchState = (MutableStateFlow)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @NotNull
    public StateFlow<Boolean> isBusy() {
        return this.isBusy;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ComboBoxField.LabelledValue<String>> parameterFieldsValues(List<UserParameter> parameters) {
        void $this$mapTo$iv;
        List list2;
        List $this$parameterFieldsValues_u24lambda_u248 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$parameterFieldsValues_u24lambda_u248.add(new ComboBoxField.LabelledValue(this.i18n.ptrl("Not set"), null, null, 4, null));
        Iterable iterable = parameters;
        Collection destination$iv = $this$parameterFieldsValues_u24lambda_u248;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            UserParameter userParameter = (UserParameter)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            collection.add(new ComboBoxField.LabelledValue(this.i18n.pnotr(it.getKey()), (Object)it.getId(), null, 4, null));
        }
        return CollectionsKt.build((List)list2);
    }

    private final List<UiField> buildParameterFields(TemplateParametersState state2, LoadingState<? extends List<UserParameter>> availableParameters) {
        List list2;
        List $this$buildParameterFields_u24lambda_u2410 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (PersonalParameter p : state2.getParameters()) {
            MutableStateFlow<String> valueState;
            List list3;
            List list4;
            String key2 = EnvParametersPageKt.access$label(p);
            if (state2.getPersonalParametersValues().get(key2) == null) continue;
            LocalizableString labelText = this.i18n.pnotr(EnvParametersPageKt.access$label(p) + ":");
            LoadingState<? extends List<UserParameter>> loadingState = availableParameters;
            if (Intrinsics.areEqual(loadingState, (Object)LoadingState.Loading.INSTANCE)) {
                list4 = CollectionsKt.listOf((Object)new ComboBoxField.LabelledValue(this.i18n.ptrl("Loading..."), (Object)p.getLastValueId(), null, 4, null));
            } else if (loadingState instanceof LoadingState.Failed) {
                list4 = CollectionsKt.emptyList();
            } else if (loadingState instanceof LoadingState.Loaded) {
                list4 = this.parameterFieldsValues((List)((LoadingState.Loaded)availableParameters).getResult());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List values = list4;
            List $this$buildParameterFields_u24lambda_u2410_u24lambda_u249 = list3 = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            if (availableParameters instanceof LoadingState.Loading) {
                $this$buildParameterFields_u24lambda_u2410_u24lambda_u249.add(new FieldModifier.Disabled());
            }
            if (state2.getRequiredParams().contains(key2) && valueState.getValue() == null) {
                $this$buildParameterFields_u24lambda_u2410_u24lambda_u249.add(new FieldModifier.LocalizableError(this.i18n.ptrl("Fill in required parameter")));
            }
            List fieldModifiers = CollectionsKt.build((List)list3);
            ((Collection)$this$buildParameterFields_u24lambda_u2410).add(UiComponents.combobox$default((UiComponents)this.components, null, (LocalizableString)labelText, (StateFlow)((StateFlow)StateFlowKt.MutableStateFlow((Object)values)), valueState, null, (List)fieldModifiers, (int)17, null));
        }
        $this$buildParameterFields_u24lambda_u2410.add(CallToActionFieldKt.CallToActionField((LocalizableString)this.i18n.ptrl("If you do not have suitable parameter"), (RunnableActionDescription)this.createParameterAction));
        return CollectionsKt.build((List)list2);
    }

    private final SectionFieldMutable parametersSection(List<? extends UiField> parameterFields) {
        return SectionFieldKt.SectionField((String)"Personal parameters", (boolean)true, parameterFields);
    }

    @NotNull
    public StateFlow<List<UiField>> getFields() {
        return this.fields;
    }

    private final void close() {
        this.toolboxUi.hideUiPage((UiPage)this);
    }

    private final List<ActionDescription> buildActionButtons(boolean canCreate) {
        return CollectionsKt.listOf((Object)new RunnableActionDescription(this, canCreate){
            private final LocalizableString label;
            private final boolean shouldClosePage;
            private final boolean isEnabled;
            final /* synthetic */ EnvParametersPage this$0;
            {
                this.this$0 = $receiver;
                this.label = EnvParametersPage.access$getI18n$p($receiver).ptrl("Create");
                this.isEnabled = $canCreate;
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            public void run() {
                BuildersKt.launch$default((CoroutineScope)EnvParametersPage.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                    int label;
                    final /* synthetic */ EnvParametersPage this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = EnvParametersPage.access$getVm$p(this.this$0).createEnvironment((Continuation<? super DevEnvCreationResult>)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                if ((result = (DevEnvCreationResult)v0) != null) {
                                    EnvParametersPage.access$getAfterCreationHandle$p(this.this$0).invoke((Object)result);
                                    EnvParametersPage.access$close(this.this$0);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }

            public boolean getShouldClosePage() {
                return this.shouldClosePage;
            }

            public boolean isEnabled() {
                return this.isEnabled;
            }

            public boolean validate() {
                return super.validate();
            }

            public String getIcon() {
                return super.getIcon();
            }

            public boolean isParentDuplicate() {
                return super.isParentDuplicate();
            }

            public boolean isSuitableForEnvironmentView() {
                return super.isSuitableForEnvironmentView();
            }

            public boolean isDangerous() {
                return super.isDangerous();
            }
        });
    }

    @NotNull
    public StateFlow<List<ActionDescription>> getActionButtons() {
        return this.actionButtons;
    }

    public final void cleanup() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    private static final ValidationResult nameField$lambda$0(EnvParametersPage this$0, String v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return StringsKt.isBlank((CharSequence)v) ? (ValidationResult)new ValidationResult.Invalid(this$0.i18n.ptrl("New environment must have a name")) : (ValidationResult)ValidationResult.Valid.INSTANCE;
    }

    private static final List fields$lambda$11(EnvParametersPage this$0, TemplateParametersState state2, LoadingState availableParameters) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)availableParameters, (String)"availableParameters");
        List<UiField> parameterFields = this$0.buildParameterFields(state2, availableParameters);
        Object[] objectArray = new BaseUiField[]{this$0.templateNameField, this$0.nameField, this$0.branchesSection, this$0.parametersSection(parameterFields)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List actionButtons$lambda$12(EnvParametersPage this$0, boolean it) {
        return this$0.buildActionButtons(it);
    }

    public static final /* synthetic */ LocalizableStringFactory access$getI18n$p(EnvParametersPage $this) {
        return $this.i18n;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(EnvParametersPage $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ Function1 access$getAfterCreationHandle$p(EnvParametersPage $this) {
        return $this.afterCreationHandle;
    }

    public static final /* synthetic */ void access$close(EnvParametersPage $this) {
        $this.close();
    }

    public static final /* synthetic */ DialogService access$getDialogService$p(EnvParametersPage $this) {
        return $this.dialogService;
    }
}

