/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.project;

import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.project.RemoteProjectSource;
import com.jetbrains.toolbox.gateway.project.RemoteToolLaunchMethodUpdaterKt;
import com.jetbrains.toolbox.gateway.project.UtilsKt;
import com.jetbrains.toolbox.gateway.project.model.CachedEnvironmentDto;
import com.jetbrains.toolbox.project.LaunchMethodPriority;
import com.jetbrains.toolbox.project.LaunchMethodUpdater;
import com.jetbrains.toolbox.project.LaunchMethodWithPriority;
import com.jetbrains.toolbox.project.Project;
import com.jetbrains.toolbox.project.ProjectKt;
import com.jetbrains.toolbox.project.ProjectSource;
import com.jetbrains.toolbox.project.RemoteProject;
import com.jetbrains.toolbox.tools.model.ProjectId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nRemoteToolLaunchMethodUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteToolLaunchMethodUpdater.kt\ncom/jetbrains/toolbox/gateway/project/RemoteToolLaunchMethodUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1869#2:76\n1869#2:77\n1583#2,11:78\n1878#2,2:89\n1880#2:92\n1594#2:93\n1870#2:94\n1870#2:95\n1#3:91\n*S KotlinDebug\n*F\n+ 1 RemoteToolLaunchMethodUpdater.kt\ncom/jetbrains/toolbox/gateway/project/RemoteToolLaunchMethodUpdater\n*L\n42#1:76\n44#1:77\n45#1:78,11\n45#1:89,2\n45#1:92\n45#1:93\n44#1:94\n42#1:95\n45#1:91\n*E\n"})
public final class RemoteToolLaunchMethodUpdater
extends LaunchMethodUpdater<Map<ProjectId, ? extends List<? extends LaunchMethodWithPriority>>> {
    private final int order;
    @NotNull
    private final StateFlow<Map<ProjectId, List<LaunchMethodWithPriority>>> externalStateFlow;

    public RemoteToolLaunchMethodUpdater(@NotNull RemoteProjectSource source, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(coroutineScope);
        this.order = 6;
        this.externalStateFlow = FlowExtensionsKt.mapState(source.getProjects(), (Function1)new Function1<Map<DevEnvironmentId, ? extends CachedEnvironmentDto>, Map<ProjectId, ? extends List<? extends LaunchMethodWithPriority>>>((Object)this){

            public final Map<ProjectId, List<LaunchMethodWithPriority>> invoke(Map<DevEnvironmentId, CachedEnvironmentDto> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((RemoteToolLaunchMethodUpdater)this.receiver).getProjectLaunchMethods(p0);
            }
        });
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    @NotNull
    protected StateFlow<Map<ProjectId, List<LaunchMethodWithPriority>>> getExternalStateFlow() {
        return this.externalStateFlow;
    }

    @Override
    @Nullable
    protected Object getLaunchMethods(@NotNull Project project2, @NotNull Collection<? extends ProjectSource> sources, @NotNull Map<ProjectId, ? extends List<LaunchMethodWithPriority>> externalState, @NotNull Continuation<? super List<LaunchMethodWithPriority>> $completion) {
        if (!(project2 instanceof RemoteProject)) {
            return CollectionsKt.emptyList();
        }
        List list2 = externalState.get(ProjectId.box-impl(((RemoteProject)project2).getId-kZr3Ip4()));
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final Map<ProjectId, List<LaunchMethodWithPriority>> getProjectLaunchMethods(@NotNull Map<DevEnvironmentId, CachedEnvironmentDto> map2) {
        Map map3;
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Map $this$getProjectLaunchMethods_u24lambda_u243 = map3 = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = map2.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            DevEnvironmentId environmentId = (DevEnvironmentId)entry.getKey();
            CachedEnvironmentDto environment = (CachedEnvironmentDto)entry.getValue();
            String projectEnvironmentId = UtilsKt.toProjectEnvironmentId(environmentId);
            Iterable $this$forEach$iv2 = environment.getProjects();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                void $this$mapIndexedNotNullTo$iv$iv;
                CachedEnvironmentDto.Project project2 = (CachedEnvironmentDto.Project)element$iv2;
                boolean bl3 = false;
                Iterable $this$mapIndexedNotNull$iv = project2.getLaunchMethods();
                boolean $i$f$mapIndexedNotNull = false;
                Iterable iterable = $this$mapIndexedNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapIndexedNotNullTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    LaunchMethodWithPriority launchMethodWithPriority;
                    void methodIdx;
                    void element$iv$iv;
                    int n;
                    if ((n = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t2 = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl4 = false;
                    int n2 = ((Number)element$iv$iv).intValue();
                    int idx = index$iv$iv;
                    boolean bl5 = false;
                    if ((CachedEnvironmentDto.LaunchMethod)CollectionsKt.getOrNull(environment.getLaunchMethods(), (int)methodIdx) == null) {
                        launchMethodWithPriority = null;
                    } else {
                        CachedEnvironmentDto.LaunchMethod launchMethod;
                        long tieBreaker = CollectionsKt.getLastIndex(project2.getLaunchMethods()) - idx;
                        launchMethodWithPriority = new LaunchMethodWithPriority(RemoteToolLaunchMethodUpdaterKt.access$toDomainMethod-TcAgYd0(launchMethod, projectEnvironmentId), new LaunchMethodPriority(LaunchMethodPriority.Type.OTHER, tieBreaker, false, 4, null));
                    }
                    if (launchMethodWithPriority == null) continue;
                    LaunchMethodWithPriority it$iv$iv = launchMethodWithPriority;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List methods = (List)destination$iv$iv;
                $this$getProjectLaunchMethods_u24lambda_u243.put(ProjectId.box-impl(ProjectKt.fullRemoteProjectId-57yk8NA(projectEnvironmentId, project2.getId())), methods);
            }
        }
        return MapsKt.build((Map)map3);
    }
}

