/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.pluginManagement;

import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.io.Temp_directoryKt;
import com.jetbrains.toolbox.gateway.pluginManagement.OkioResourceHandler;
import com.jetbrains.toolbox.gateway.pluginManagement.Url_class_loaderKt;
import java.io.Closeable;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nurl-class-loader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 url-class-loader.kt\ncom/jetbrains/toolbox/gateway/pluginManagement/Url_class_loaderKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Okio.kt\nokio/Okio__OkioKt\n+ 5 FileSystem.kt\nokio/FileSystem\n*L\n1#1,203:1\n11546#2,9:204\n13472#2:213\n13473#2:215\n11555#2:216\n1#3:214\n66#4:217\n52#4,4:219\n60#4,10:224\n56#4,3:234\n71#4,3:237\n66#4:240\n52#4,4:242\n60#4,10:247\n56#4,3:257\n71#4,3:260\n67#5:218\n68#5:223\n67#5:241\n68#5:246\n*S KotlinDebug\n*F\n+ 1 url-class-loader.kt\ncom/jetbrains/toolbox/gateway/pluginManagement/Url_class_loaderKt\n*L\n76#1:204,9\n76#1:213\n76#1:215\n76#1:216\n76#1:214\n100#1:217\n100#1:219,4\n100#1:224,10\n100#1:234,3\n100#1:237,3\n107#1:240\n107#1:242,4\n107#1:247,10\n107#1:257,3\n107#1:260,3\n100#1:218\n100#1:223\n107#1:241\n107#1:246\n*E\n"})
public final class Url_class_loaderKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final URLClassLoader urlClassLoader(@NotNull URL[] classpath, @NotNull ClassLoader parentClassLoader, @NotNull FileSystem fs) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)parentClassLoader, (String)"parentClassLoader");
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        URL[] $this$mapNotNull$iv = classpath;
        boolean $i$f$mapNotNull = false;
        URL[] uRLArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            public final class Root {
                private final URL url;
                private final Path path;
                private final boolean isJar;

                public Root(URL url, Path path2, boolean isJar) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                    this.url = url;
                    this.path = path2;
                    this.isJar = isJar;
                }

                public final URL getUrl() {
                    return this.url;
                }

                public final Path getPath() {
                    return this.path;
                }

                public final boolean isJar() {
                    return this.isJar;
                }

                public final URL component1() {
                    return this.url;
                }

                public final Path component2() {
                    return this.path;
                }

                public final boolean component3() {
                    return this.isJar;
                }

                public final Root copy(URL url, Path path2, boolean isJar) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                    return new Root(url, path2, isJar);
                }

                public static /* synthetic */ Root copy$default(Root root, URL uRL, Path path2, boolean bl, int n, Object object) {
                    if ((n & 1) != 0) {
                        uRL = root.url;
                    }
                    if ((n & 2) != 0) {
                        path2 = root.path;
                    }
                    if ((n & 4) != 0) {
                        bl = root.isJar;
                    }
                    return root.copy(uRL, path2, bl);
                }

                public String toString() {
                    return "Root(url=" + this.url + ", path=" + this.path + ", isJar=" + this.isJar + ")";
                }

                public int hashCode() {
                    int result2 = this.url.hashCode();
                    result2 = result2 * 31 + this.path.hashCode();
                    result2 = result2 * 31 + Boolean.hashCode(this.isJar);
                    return result2;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Root)) {
                        return false;
                    }
                    Root root = (Root)other;
                    if (!Intrinsics.areEqual((Object)this.url, (Object)root.url)) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)this.path, (Object)root.path)) {
                        return false;
                    }
                    return this.isJar == root.isJar;
                }
            }
            Root root;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void url = element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)url.getProtocol(), (Object)"file")) {
                root = null;
            } else {
                URI uRI = url.toURI();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                java.nio.file.Path path2 = Paths.get(uRI);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                Path path3 = Path.Companion.get$default((Path.Companion)Path.Companion, (java.nio.file.Path)path2, (boolean)false, (int)1, null);
                Path p = fs.canonicalize(path3);
                root = new Root((URL)url, p, StringsKt.endsWith$default((String)p.name(), (String)".jar", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)p.name(), (String)".zip", (boolean)false, (int)2, null));
            }
            if (root == null) continue;
            Root it$iv$iv = root;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List roots = (List)destination$iv$iv;
        return new URLClassLoader(classpath, parentClassLoader, roots, fs){
            final /* synthetic */ List<Root> $roots;
            final /* synthetic */ FileSystem $fs;
            {
                this.$roots = $roots;
                this.$fs = $fs;
                super($classpath, $parentClassLoader);
            }

            protected void addURL(URL url) {
                URL[] uRLArray = this.getURLs();
                Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"getURLs(...)");
                if (!ArraysKt.contains((Object[])uRLArray, (Object)url)) {
                    super.addURL(url);
                }
            }

            /*
             * WARNING - void declaration
             */
            public URL findResource(String name2) {
                Object v0;
                block1: {
                    void $this$firstOrNull$iv;
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Iterable iterable = this.$roots;
                    FileSystem fileSystem = this.$fs;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        Root it = (Root)element$iv;
                        boolean bl = false;
                        if (!Url_class_loaderKt.access$urlClassLoader$resourceExists(it, fileSystem, name2)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                Root root = v0;
                return root != null ? Url_class_loaderKt.access$urlClassLoader$resourceUrl(root, this.$fs, name2) : null;
            }

            /*
             * WARNING - void declaration
             */
            public Enumeration<URL> findResources(String name2) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Root it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Iterable iterable = this.$roots;
                FileSystem fileSystem = this.$fs;
                boolean $i$f$filter = false;
                void var6_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Root)element$iv$iv;
                    boolean bl = false;
                    if (!Url_class_loaderKt.access$urlClassLoader$resourceExists(it, fileSystem, name2)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                fileSystem = this.$fs;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Root)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Url_class_loaderKt.access$urlClassLoader$resourceUrl(it, fileSystem, name2));
                }
                List hits = (List)destination$iv$iv;
                Enumeration<URL> enumeration = Collections.enumeration(hits);
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"enumeration(...)");
                return enumeration;
            }

            public URL getResource(String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                URL uRL = this.findResource(name2);
                if (uRL == null) {
                    uRL = this.getParent().getResource(name2);
                }
                return uRL;
            }

            public Enumeration<URL> getResources(String name2) {
                URL p0;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                LinkedHashSet<URL> all2 = new LinkedHashSet<URL>();
                Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(this.findResources(name2)));
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    p0 = (URL)element$iv;
                    boolean bl = false;
                    all2.add(p0);
                }
                Sequence sequence2 = this.getParent().getResources(name2);
                if (sequence2 == null || (sequence2 = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(sequence2))) == null) {
                    sequence2 = SequencesKt.emptySequence();
                }
                $this$forEach$iv = sequence2;
                $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    p0 = (URL)element$iv;
                    boolean bl = false;
                    all2.add(p0);
                }
                Enumeration<URL> enumeration = Collections.enumeration((Collection)all2);
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"enumeration(...)");
                return enumeration;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected String findLibrary(String libname) {
                BufferedSink bufferedSink;
                Throwable thrown$iv$iv;
                Path tmp;
                String string;
                block20: {
                    void file$iv;
                    void $this$iv;
                    Object v0;
                    FileSystem $this$firstOrNull$iv;
                    FileSystem fileSystem;
                    String relative;
                    String mapped;
                    block19: {
                        if (libname == null) {
                            return null;
                        }
                        mapped = System.mapLibraryName(libname);
                        relative = "native/" + mapped;
                        Iterable iterable = this.$roots;
                        fileSystem = this.$fs;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            Root it = (Root)element$iv;
                            boolean bl = false;
                            if (!Url_class_loaderKt.access$urlClassLoader$resourceExists(it, fileSystem, relative)) continue;
                            v0 = element$iv;
                            break block19;
                        }
                        v0 = null;
                    }
                    Root root = v0;
                    if (root == null) {
                        return super.findLibrary(libname);
                    }
                    Root hit = root;
                    if (!hit.isJar()) {
                        string = this.$fs.canonicalize(hit.getPath().resolve(relative)).toFile().getAbsolutePath();
                        return string;
                    }
                    Path path2 = Temp_directoryKt.createTempDirectory(this.$fs, StandardPaths.INSTANCE.getPluginDataPath(), "tbx-native-" + libname);
                    Intrinsics.checkNotNull((Object)mapped);
                    tmp = path2.resolve(mapped);
                    $this$firstOrNull$iv = this.$fs;
                    fileSystem = tmp;
                    FileSystem fileSystem2 = this.$fs;
                    boolean mustCreate$iv = false;
                    boolean bl = false;
                    Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink((Path)file$iv, mustCreate$iv));
                    boolean $i$f$use = false;
                    thrown$iv$iv = null;
                    try {
                        BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                        boolean bl2 = false;
                        BufferedSink $this$findLibrary_u24lambda_u245 = it$iv;
                        boolean bl3 = false;
                        byte[] byArray = Url_class_loaderKt.access$urlClassLoader$readResource(hit, fileSystem2, relative);
                        Intrinsics.checkNotNull((Object)byArray);
                        bufferedSink = $this$findLibrary_u24lambda_u245.write(byArray);
                    }
                    catch (Throwable t$iv$iv) {
                        try {
                            thrown$iv$iv = t$iv$iv;
                            bufferedSink = null;
                            break block20;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            block21: {
                                try {
                                    Closeable closeable = $this$use$iv$iv;
                                    if (closeable != null) {
                                        closeable.close();
                                    }
                                }
                                catch (Throwable t$iv$iv2) {
                                    if (thrown$iv$iv == null) {
                                        thrown$iv$iv = t$iv$iv2;
                                        break block21;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                                }
                            }
                        }
                    }
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                }
                BufferedSink result$iv$iv = bufferedSink;
                Throwable throwable = thrown$iv$iv;
                if (throwable != null) {
                    throw throwable;
                }
                string = this.$fs.canonicalize(tmp).toFile().getAbsolutePath();
                return string;
            }

            protected Class<?> findClass(String name2) {
                byte[] byArray;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    String resource2 = StringsKt.replace$default((String)name2, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
                    Iterable iterable = this.$roots;
                    FileSystem fileSystem = this.$fs;
                    for (Root it : iterable) {
                        boolean bl = false;
                        byte[] byArray2 = Url_class_loaderKt.access$urlClassLoader$readResource(it, fileSystem, resource2);
                        if (byArray2 == null) continue;
                        byArray = byArray2;
                        break block2;
                    }
                    byArray = null;
                }
                if (byArray == null) {
                    throw new ClassNotFoundException(name2);
                }
                byte[] bytes2 = byArray;
                CodeSource codeSource = new CodeSource(((Root)CollectionsKt.first(this.$roots)).getUrl(), null);
                Class<?> clazz = this.defineClass(name2, bytes2, 0, bytes2.length, codeSource);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"defineClass(...)");
                return clazz;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Class<?> loadClass(String name2, boolean resolve2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Object object = this.getClassLoadingLock(name2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getClassLoadingLock(...)");
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    Class<?> c = this.findLoadedClass(name2);
                    if (c == null) {
                        try {
                            c = this.findClass(name2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (c == null) {
                        c = super.loadClass(name2, resolve2);
                    }
                    if (resolve2) {
                        this.resolveClass(c);
                    }
                    Class<?> clazz = c;
                    Intrinsics.checkNotNull(clazz);
                    Class<?> clazz2 = clazz;
                    return clazz2;
                }
            }
        };
    }

    private static final boolean urlClassLoader$resourceExists(urlClassLoader.Root $this$urlClassLoader_u24resourceExists, FileSystem $fs, String resource2) {
        boolean bl;
        if (!$this$urlClassLoader_u24resourceExists.isJar()) {
            FileMetadata fileMetadata2 = $fs.metadataOrNull($this$urlClassLoader_u24resourceExists.getPath().resolve(resource2));
            bl = fileMetadata2 != null ? fileMetadata2.isRegularFile() : false;
        } else {
            boolean bl2;
            try {
                FileSystem zipFs = Okio.openZip((FileSystem)$fs, (Path)$this$urlClassLoader_u24resourceExists.getPath());
                FileMetadata fileMetadata3 = zipFs.metadataOrNull(Path.Companion.get$default((Path.Companion)Path.Companion, (String)resource2, (boolean)false, (int)1, null));
                bl2 = fileMetadata3 != null ? fileMetadata3.isRegularFile() : false;
            }
            catch (Throwable throwable) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final byte[] urlClassLoader$readResource(urlClassLoader.Root $this$urlClassLoader_u24readResource, FileSystem $fs, String resource2) {
        byte[] byArray2;
        byte[] byArray;
        if (!$this$urlClassLoader_u24readResource.isJar()) {
            byte[] $i$a$-use-FileSystem$read$1$iv23332;
            Throwable thrown$iv$iv;
            block34: {
                void this_$iv;
                Path target = $this$urlClassLoader_u24readResource.getPath().resolve(resource2);
                FileMetadata fileMetadata2 = $fs.metadataOrNull(target);
                if (fileMetadata2 == null) return null;
                if (!fileMetadata2.isRegularFile()) return null;
                boolean bl = true;
                if (!bl) {
                    return null;
                }
                FileSystem fileSystem = $fs;
                Path file$iv = target;
                boolean bl2 = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean $i$a$-use-FileSystem$read$1$iv23332 = false;
                    BufferedSource $this$urlClassLoader_u24readResource_u24lambda_u241 = it$iv;
                    boolean bl3 = false;
                    $i$a$-use-FileSystem$read$1$iv23332 = $this$urlClassLoader_u24readResource_u24lambda_u241.readByteArray();
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        $i$a$-use-FileSystem$read$1$iv23332 = null;
                        break block34;
                    }
                    catch (Throwable t$iv$iv2) {
                        throw t$iv$iv2;
                    }
                    finally {
                        block35: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block35;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            byte[] result$iv$iv = $i$a$-use-FileSystem$read$1$iv23332;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            byArray = result$iv$iv;
            return byArray;
        }
        try {
            byte[] byArray4;
            Throwable thrown$iv$iv;
            block36: {
                void this_$iv;
                FileSystem zipFs = Okio.openZip((FileSystem)$fs, (Path)$this$urlClassLoader_u24readResource.getPath());
                Path target = Path.Companion.get$default((Path.Companion)Path.Companion, (String)resource2, (boolean)false, (int)1, null);
                FileMetadata fileMetadata3 = zipFs.metadataOrNull(target);
                if (fileMetadata3 == null) return null;
                if (!fileMetadata3.isRegularFile()) return null;
                boolean bl = true;
                if (!bl) return null;
                FileSystem file$iv = zipFs;
                Path file$iv2 = target;
                boolean bl4 = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv2));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl5 = false;
                    BufferedSource $this$urlClassLoader_u24readResource_u24lambda_u242 = it$iv;
                    boolean bl6 = false;
                    byArray4 = $this$urlClassLoader_u24readResource_u24lambda_u242.readByteArray();
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        byArray4 = null;
                        break block36;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block37: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv3) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv3;
                                    break block37;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv3);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            byte[] result$iv$iv = byArray4;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            byte[] byArray3 = result$iv$iv;
            byArray2 = byArray3;
        }
        catch (Throwable throwable) {
            return null;
        }
        byArray = byArray2;
        return byArray;
    }

    private static final URL urlClassLoader$resourceUrl(urlClassLoader.Root $this$urlClassLoader_u24resourceUrl, FileSystem $fs, String resource2) {
        return $this$urlClassLoader_u24resourceUrl.isJar() ? new URL(null, "jar:" + $this$urlClassLoader_u24resourceUrl.getUrl().toExternalForm() + "!/" + resource2, new OkioResourceHandler($fs)) : new URL(null, $this$urlClassLoader_u24resourceUrl.getPath().resolve(resource2).toFile().toURI().toString(), new OkioResourceHandler($fs));
    }

    public static final /* synthetic */ URL access$urlClassLoader$resourceUrl(urlClassLoader.Root $receiver, FileSystem $fs, String resource2) {
        return Url_class_loaderKt.urlClassLoader$resourceUrl($receiver, $fs, resource2);
    }

    public static final /* synthetic */ boolean access$urlClassLoader$resourceExists(urlClassLoader.Root $receiver, FileSystem $fs, String resource2) {
        return Url_class_loaderKt.urlClassLoader$resourceExists($receiver, $fs, resource2);
    }

    public static final /* synthetic */ byte[] access$urlClassLoader$readResource(urlClassLoader.Root $receiver, FileSystem $fs, String resource2) {
        return Url_class_loaderKt.urlClassLoader$readResource($receiver, $fs, resource2);
    }
}

