/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.pluginManagement;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.common.ActionProgress;
import com.jetbrains.toolbox.common.Progress;
import com.jetbrains.toolbox.common.WellKnownPaths;
import com.jetbrains.toolbox.gateway.MarketplaceInstance;
import com.jetbrains.toolbox.gateway.MarketplacePluginUpdate;
import com.jetbrains.toolbox.gateway.PluginId;
import com.jetbrains.toolbox.gateway.pluginManagement.GraphQLResponse;
import com.jetbrains.toolbox.gateway.pluginManagement.IconTheme;
import com.jetbrains.toolbox.gateway.pluginManagement.MarketplaceCompatibilityRange;
import com.jetbrains.toolbox.gateway.pluginManagement.MarketplaceExceptionFactory;
import com.jetbrains.toolbox.gateway.pluginManagement.MarketplacePluginDto;
import com.jetbrains.toolbox.gateway.pluginManagement.MarketplacePluginFetcher;
import com.jetbrains.toolbox.gateway.pluginManagement.MarketplacePluginUpdateDto;
import com.jetbrains.toolbox.gateway.pluginManagement.MarketplacePluginsWithCount;
import com.jetbrains.toolbox.gateway.pluginManagement.MarketplacePluginsWithCountDto;
import com.jetbrains.toolbox.gateway.pluginManagement.MarketplaceUpdatesWithCountDto;
import com.jetbrains.toolbox.gateway.pluginManagement.UtilsKt;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.network.BasicDownloadManager;
import com.jetbrains.toolbox.network.DownloadResult;
import com.jetbrains.toolbox.network.DownloadSession;
import com.jetbrains.toolbox.network.DownloadSessionKt;
import com.jetbrains.toolbox.network.FileDownloader;
import com.jetbrains.toolbox.platform.image.internal.Image;
import com.jetbrains.toolbox.platform.image.internal.ImageId;
import com.jetbrains.toolbox.platform.image.internal.ImagesKt;
import com.jetbrains.toolbox.tools.image.ImageManager;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.ExceptionsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JvmStreamsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.datasource.ByteBufferDataSource;
import org.jetbrains.zip.signer.verifier.InvalidSignatureResult;
import org.jetbrains.zip.signer.verifier.MissingSignatureResult;
import org.jetbrains.zip.signer.verifier.SuccessfulVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerifier;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nMarketplacePluginFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketplacePluginFetcher.kt\ncom/jetbrains/toolbox/gateway/pluginManagement/MarketplacePluginFetcher\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 Okio.kt\nokio/Okio__OkioKt\n+ 7 FileSystem.kt\nokio/FileSystem\n*L\n1#1,650:1\n29#2,3:651\n1#3:654\n1563#4:655\n1634#4,3:656\n1491#4:659\n1516#4,3:660\n1519#4,3:670\n774#4:680\n865#4:681\n1969#4,14:682\n866#4:696\n1491#4:697\n1516#4,3:698\n1519#4,3:708\n774#4:718\n865#4:719\n1969#4,14:720\n866#4:734\n774#4:735\n865#4,2:736\n382#5,7:663\n536#5:673\n521#5,6:674\n382#5,7:701\n536#5:711\n521#5,6:712\n66#6:738\n52#6,4:740\n60#6,10:745\n56#6,3:755\n71#6,3:758\n81#7:739\n82#7:744\n*S KotlinDebug\n*F\n+ 1 MarketplacePluginFetcher.kt\ncom/jetbrains/toolbox/gateway/pluginManagement/MarketplacePluginFetcher\n*L\n165#1:651,3\n254#1:655\n254#1:656,3\n263#1:659\n263#1:660,3\n263#1:670,3\n270#1:680\n270#1:681\n273#1:682,14\n270#1:696\n282#1:697\n282#1:698,3\n282#1:708,3\n289#1:718\n289#1:719\n292#1:720,14\n289#1:734\n400#1:735\n400#1:736,2\n263#1:663,7\n264#1:673\n264#1:674,6\n282#1:701,7\n283#1:711\n283#1:712,6\n504#1:738\n504#1:740,4\n504#1:745,10\n504#1:755,3\n504#1:758,3\n504#1:739\n504#1:744\n*E\n"})
public final class MarketplacePluginFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BasicDownloadManager downloadManager;
    @NotNull
    private final ImageManager imageManager;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Json json;
    @NotNull
    private final Path pluginIconsFolder;
    @NotNull
    private final String marketplaceCA;
    @NotNull
    private final X509Certificate x509marketplaceCA;
    private static final int VERSION_PATCH_LENGTH = 20;
    private static final int VERSION_MINOR_LENGTH = 13;
    private static final int VERSION_MAJOR_PART_MAX_VALUE = 7449;
    private static final int VERSION_MINOR_PART_MAX_VALUE = 8191;
    private static final int VERSION_PATCH_PART_MAX_VALUE = 1048575;
    private static final long maximumCompatibleVersionLong = Companion.convertSemverToLong-Szkhn3Q(UtilsKt.getMaximumCompatibleVersion());
    private static final long minimumCompatibleVersionLong = Companion.convertSemverToLong-Szkhn3Q(UtilsKt.getMinimumCompatibleVersion());

    public MarketplacePluginFetcher(@NotNull BasicDownloadManager downloadManager, @NotNull WellKnownPaths wellKnownPaths, @NotNull ImageManager imageManager, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)wellKnownPaths, (String)"wellKnownPaths");
        Intrinsics.checkNotNullParameter((Object)imageManager, (String)"imageManager");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.downloadManager = downloadManager;
        this.imageManager = imageManager;
        this.fileSystem = fileSystem;
        this.json = JsonKt.Json$default(null, MarketplacePluginFetcher::json$lambda$0, (int)1, null);
        this.pluginIconsFolder = wellKnownPaths.getToolboxCacheLocation().resolve("plugin-icons");
        this.marketplaceCA = "-----BEGIN CERTIFICATE-----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\nYntw4xiTLPA7QQVFZ9rLa0g=\n-----END CERTIFICATE-----";
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        String string = this.marketplaceCA;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Certificate certificate2 = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        Intrinsics.checkNotNull((Object)certificate2, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        this.x509marketplaceCA = (X509Certificate)certificate2;
    }

    @NotNull
    public final Json getJson() {
        return this.json;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object executeGraphQlQuery(@NotNull MarketplaceInstance marketplaceInstance, @NotNull String query, @NotNull String queryMarker, @NotNull Continuation<? super GraphQLResponse> $completion) {
        if (!($completion instanceof executeGraphQlQuery.1)) ** GOTO lbl-1000
        var17_5 = $completion;
        if ((var17_5.label & -2147483648) != 0) {
            var17_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ MarketplacePluginFetcher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeGraphQlQuery(null, null, null, (Continuation<? super GraphQLResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, executeGraphQlQuery$lambda$1(java.lang.String ), ()Ljava/lang/String;)((String)query));
                $continuation.L$0 = marketplaceInstance;
                $continuation.L$1 = query;
                $continuation.L$2 = queryMarker;
                $continuation.label = 1;
                v0 = this.downloadManager.createSession((Continuation<? super DownloadSession>)$continuation);
                if (v0 == var18_7) {
                    return var18_7;
                }
                ** GOTO lbl27
            }
            case 1: {
                queryMarker = (String)$continuation.L$2;
                query = (String)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                session = (DownloadSession)v0;
                url = marketplaceInstance.getSearchUrl();
                $i$f$buildJsonObject = false;
                var10_15 = builder$iv = new JsonObjectBuilder();
                var14_16 = url;
                var13_17 = session;
                $i$a$-buildJsonObject-MarketplacePluginFetcher$executeGraphQlQuery$response$1 = false;
                $this$executeGraphQlQuery_u24lambda_u242.put("query", (JsonElement)JsonElementKt.JsonPrimitive((String)query));
                var15_20 = Unit.INSTANCE;
                $i$f$buildJsonObject = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)"application/json"), TuplesKt.to((Object)"Accept", (Object)"application/json"), TuplesKt.to((Object)"QueryMarker", (Object)queryMarker)};
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)marketplaceInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)queryMarker);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)session);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.label = 2;
                v1 = DownloadSession.post$default(var13_17, var14_16, builder$iv.build(), MapsKt.mapOf((Pair[])$i$f$buildJsonObject), false, (Continuation)$continuation, 8, null);
                if (v1 == var18_7) {
                    return var18_7;
                }
                ** GOTO lbl58
            }
            case 2: {
                url = (String)$continuation.L$4;
                session = (DownloadSession)$continuation.L$3;
                queryMarker = (String)$continuation.L$2;
                query = (String)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl58:
                // 2 sources

                response = (Pair)v1;
                result = (DownloadResult)response.getFirst();
                bytes = (byte[])response.getSecond();
                if (result instanceof DownloadResult.Downloaded) {
                    try {
                        Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, executeGraphQlQuery$lambda$3(byte[] ), ()Ljava/lang/String;)((byte[])bytes));
                        return JvmStreamsKt.decodeFromStream((Json)this.json, (DeserializationStrategy)((DeserializationStrategy)GraphQLResponse.Companion.serializer()), (InputStream)new ByteArrayInputStream(bytes));
                    }
                    catch (Exception e) {
                        message = "Unexpected error while decoding GraphQL query result: " + result;
                        Logger.INSTANCE.error((Throwable)e, message);
                        throw new IOException(message, e);
                    }
                }
                message = "Unexpected error while executing GraphQL query: " + result;
                Logger.INSTANCE.error(message);
                throw new IOException(message);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object fetchPlugins(@NotNull MarketplaceInstance marketplaceInstance, @NotNull CoroutineScope coroutineScope, int offset, int limit, @NotNull Continuation<? super MarketplacePluginsWithCount> $completion) {
        if (!($completion instanceof fetchPlugins.1)) ** GOTO lbl-1000
        var24_6 = $completion;
        if ((var24_6.label & -2147483648) != 0) {
            var24_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ MarketplacePluginFetcher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fetchPlugins(null, null, 0, 0, (Continuation<? super MarketplacePluginsWithCount>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var27_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                query = StringsKt.trimIndent((String)("\n      query {\n        plugins(search: {\n          filters: [\n            {field:\"family\", value:\"toolbox\"}\n          ]\n          compatibility:{\n            range:{\n              lte: " + MarketplacePluginFetcher.maximumCompatibleVersionLong + "\n              gte: " + MarketplacePluginFetcher.minimumCompatibleVersionLong + "\n            }\n          }\n          max: " + limit + "\n          offset:" + offset + "\n          sortBy: RELEVANCE\n        }) {\n          total\n          plugins {\n            id\n            xmlId\n            name\n            description\n            family\n            icon\n            compatibility {\n                ranges {\n                    gte\n                    lte\n                }\n            }\n            lastUpdateDate\n            organization {\n                url\n                name\n            }\n            authors {\n                name\n                link\n            }\n            sourceCodeUrl\n          }\n        }\n      }\n    "));
                $continuation.L$0 = marketplaceInstance;
                $continuation.L$1 = coroutineScope;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.I$0 = offset;
                $continuation.I$1 = limit;
                $continuation.label = 1;
                v0 = this.executeGraphQlQuery(marketplaceInstance, query, "plugins", (Continuation<? super GraphQLResponse>)$continuation);
                if (v0 == var27_8) {
                    return var27_8;
                }
                ** GOTO lbl31
            }
            case 1: {
                limit = $continuation.I$1;
                offset = $continuation.I$0;
                query = (String)$continuation.L$2;
                coroutineScope = (CoroutineScope)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 2 sources

                response = (GraphQLResponse)v0;
                try {
                    v1 = (DeserializationStrategy)MarketplacePluginsWithCountDto.Companion.serializer();
                    v2 = response.getData().get((Object)"plugins");
                    Intrinsics.checkNotNull((Object)v2);
                    p0 = (MarketplacePluginsWithCountDto)this.json.decodeFromJsonElement(v1, (JsonElement)v2);
                    $i$a$-let-MarketplacePluginFetcher$fetchPlugins$plugins$1 = false;
                    var9_16 = this.filterByXmlId(p0);
                }
                catch (Exception e) {
                    Logger.INSTANCE.error((Throwable)e, "Failed to decode GraphQL response");
                    throw new IOException("Failed to decode GraphQL response", e);
                }
                plugins = var9_16;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)marketplaceInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)coroutineScope);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)response);
                $continuation.L$4 = plugins;
                $continuation.I$0 = offset;
                $continuation.I$1 = limit;
                $continuation.label = 2;
                v3 = this.fetchIcons(marketplaceInstance, plugins.getPlugins(), coroutineScope, (Continuation<? super Map<PluginId, ? extends Image>>)$continuation);
                ** if (v3 != var27_8) goto lbl58
lbl57:
                // 1 sources

                return var27_8;
lbl58:
                // 1 sources

                ** GOTO lbl71
            }
            case 2: {
                limit = $continuation.I$1;
                offset = $continuation.I$0;
                plugins = (MarketplacePluginsWithCountDto)$continuation.L$4;
                response = (GraphQLResponse)$continuation.L$3;
                query = (String)$continuation.L$2;
                coroutineScope = (CoroutineScope)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl71:
                    // 2 sources

                    e = (Map)v3;
                }
                catch (Exception e) {
                    Logger.INSTANCE.error((Throwable)e, "Failed to fetch plugin icons");
                    e = null;
                }
                icons = e;
                e = plugins.getPlugins();
                var21_18 = plugins.getTotal();
                $i$f$map = false;
                var13_20 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var18_25 = (MarketplacePluginDto)item$iv$iv;
                    var22_28 = destination$iv$iv;
                    $i$a$-map-MarketplacePluginFetcher$fetchPlugins$pluginsWithFetchedIcons$1 = false;
                    v4 = icons;
                    if (v4 == null || (v4 = (Image)v4.get(PluginId.box-impl(plugin.getXmlId-NE1ku3Q()))) == null) {
                        v4 = (Image)Image.Empty.INSTANCE;
                    }
                    pluginIcons = v4;
                    var22_28.add(plugin.toMarketplacePlugin((Image)pluginIcons));
                }
                var22_28 = (List)destination$iv$iv;
                var25_29 = var22_28;
                var26_30 = var21_18;
                pluginsWithFetchedIcons = new MarketplacePluginsWithCount(var26_30, var25_29);
                return pluginsWithFetchedIcons;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object fetchPlugins$default(MarketplacePluginFetcher marketplacePluginFetcher, MarketplaceInstance marketplaceInstance, CoroutineScope coroutineScope, int n, int n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 20;
        }
        return marketplacePluginFetcher.fetchPlugins(marketplaceInstance, coroutineScope, n, n2, (Continuation<? super MarketplacePluginsWithCount>)continuation);
    }

    /*
     * WARNING - void declaration
     */
    private final MarketplacePluginsWithCountDto filterByXmlId(MarketplacePluginsWithCountDto dto) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Map groupedByXmlId;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = dto.getPlugins();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object;
            MarketplacePluginDto p0 = (MarketplacePluginDto)element$iv$iv2;
            boolean bl = false;
            PluginId key$iv$iv = PluginId.box-impl(p0.getXmlId-NE1ku3Q());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        Map $this$filter$iv = groupedByXmlId = destination$iv$iv;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        element$iv$iv2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (element$iv$iv2.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry bl = element$iv$iv3 = (Map.Entry)element$iv$iv2.next();
            boolean bl3 = false;
            List plugins = (List)bl.getValue();
            if (!(plugins.size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
        }
        Object duplicates = destination$iv$iv2;
        if (duplicates.isEmpty()) {
            return dto;
        }
        Logger.INSTANCE.warn(() -> MarketplacePluginFetcher.filterByXmlId$lambda$7((Map)duplicates));
        Iterable $this$filter$iv2 = dto.getPlugins();
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv4 : $this$filterTo$iv$iv) {
            boolean bl;
            MarketplacePluginDto plugin = (MarketplacePluginDto)element$iv$iv4;
            boolean bl4 = false;
            List duplicatesForPlugin = (List)duplicates.get(PluginId.box-impl(plugin.getXmlId-NE1ku3Q()));
            if (duplicatesForPlugin == null) {
                bl = true;
            } else {
                Object t2;
                Iterable $this$maxBy$iv = duplicatesForPlugin;
                boolean $i$f$maxByOrThrow = false;
                Iterator iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t2 = maxElem$iv;
                } else {
                    MarketplacePluginDto plugin2 = (MarketplacePluginDto)maxElem$iv;
                    boolean bl5 = false;
                    Comparable maxValue$iv = (Comparable)((Object)plugin2.getId());
                    do {
                        Object e$iv = iterator$iv.next();
                        MarketplacePluginDto plugin3 = (MarketplacePluginDto)e$iv;
                        $i$a$-maxByOrThrow-MarketplacePluginFetcher$filterByXmlId$newPlugins$1$1 = false;
                        Comparable v$iv = (Comparable)((Object)plugin3.getId());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t2 = maxElem$iv;
                }
                bl = Intrinsics.areEqual(t2, (Object)plugin);
            }
            if (!bl) continue;
            destination$iv$iv3.add(element$iv$iv4);
        }
        List newPlugins2 = (List)destination$iv$iv3;
        Logger.INSTANCE.warn(() -> MarketplacePluginFetcher.filterByXmlId$lambda$10(newPlugins2));
        return new MarketplacePluginsWithCountDto(newPlugins2.size(), newPlugins2);
    }

    /*
     * WARNING - void declaration
     */
    private final MarketplaceUpdatesWithCountDto filterByXmlId(MarketplaceUpdatesWithCountDto dto) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Map groupedByXmlId;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = dto.getUpdates();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object;
            MarketplacePluginUpdateDto p0 = (MarketplacePluginUpdateDto)element$iv$iv2;
            boolean bl = false;
            PluginId key$iv$iv = PluginId.box-impl(p0.getXmlId-NE1ku3Q());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        Map $this$filter$iv = groupedByXmlId = destination$iv$iv;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        element$iv$iv2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (element$iv$iv2.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry bl = element$iv$iv3 = (Map.Entry)element$iv$iv2.next();
            boolean bl3 = false;
            List plugins = (List)bl.getValue();
            if (!(plugins.size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
        }
        Object duplicates = destination$iv$iv2;
        if (duplicates.isEmpty()) {
            return dto;
        }
        Logger.INSTANCE.warn(() -> MarketplacePluginFetcher.filterByXmlId$lambda$13((Map)duplicates));
        Iterable $this$filter$iv2 = dto.getUpdates();
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv4 : $this$filterTo$iv$iv) {
            boolean bl;
            MarketplacePluginUpdateDto plugin = (MarketplacePluginUpdateDto)element$iv$iv4;
            boolean bl4 = false;
            List duplicatesForPlugin = (List)duplicates.get(PluginId.box-impl(plugin.getXmlId-NE1ku3Q()));
            if (duplicatesForPlugin == null) {
                bl = true;
            } else {
                Object t2;
                Iterable $this$maxBy$iv = duplicatesForPlugin;
                boolean $i$f$maxByOrThrow = false;
                Iterator iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t2 = maxElem$iv;
                } else {
                    MarketplacePluginUpdateDto plugin2 = (MarketplacePluginUpdateDto)maxElem$iv;
                    boolean bl5 = false;
                    Comparable maxValue$iv = (Comparable)((Object)plugin2.getId());
                    do {
                        Object e$iv = iterator$iv.next();
                        MarketplacePluginUpdateDto plugin3 = (MarketplacePluginUpdateDto)e$iv;
                        $i$a$-maxByOrThrow-MarketplacePluginFetcher$filterByXmlId$newPlugins$2$1 = false;
                        Comparable v$iv = (Comparable)((Object)plugin3.getId());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t2 = maxElem$iv;
                }
                bl = Intrinsics.areEqual(t2, (Object)plugin);
            }
            if (!bl) continue;
            destination$iv$iv3.add(element$iv$iv4);
        }
        List newPlugins2 = (List)destination$iv$iv3;
        Logger.INSTANCE.warn(() -> MarketplacePluginFetcher.filterByXmlId$lambda$16(newPlugins2));
        return new MarketplaceUpdatesWithCountDto(newPlugins2.size(), newPlugins2);
    }

    /*
     * Unable to fully structure code
     */
    private final Object fetchIcons(MarketplaceInstance marketplaceInstance, List<MarketplacePluginDto> plugins, CoroutineScope coroutineScope, Continuation<? super Map<PluginId, ? extends Image>> $completion) {
        if (!($completion instanceof fetchIcons.1)) ** GOTO lbl-1000
        var11_5 = $completion;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ MarketplacePluginFetcher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MarketplacePluginFetcher.access$fetchIcons(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (plugins.isEmpty()) {
                    return MapsKt.emptyMap();
                }
                Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fetchIcons$lambda$18(java.util.List ), ()Ljava/lang/String;)(plugins));
                icons = new ArrayList<E>();
                var9_10 = SupervisorKt.SupervisorJob((Job)((Job)coroutineScope.getCoroutineContext().get((CoroutineContext.Key)Job.Key))).plus((CoroutineContext)Dispatchers.getIO());
                $continuation.L$0 = marketplaceInstance;
                $continuation.L$1 = plugins;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)coroutineScope);
                $continuation.L$3 = icons;
                $continuation.L$4 = var9_10;
                $continuation.label = 1;
                v0 = this.downloadManager.createSession((Continuation<? super DownloadSession>)$continuation);
                if (v0 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl35
            }
            case 1: {
                var9_10 = (CoroutineContext)$continuation.L$4;
                icons = (List)$continuation.L$3;
                coroutineScope = (CoroutineScope)$continuation.L$2;
                plugins = (List)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)var9_10.plus((CoroutineContext)v0));
                for (MarketplacePluginDto plugin : plugins) {
                    icons.add(BuildersKt.async$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends PluginId, ? extends Image>>, Object>(scope, plugin, this, marketplaceInstance, null){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        int label;
                        final /* synthetic */ CoroutineScope $scope;
                        final /* synthetic */ MarketplacePluginDto $plugin;
                        final /* synthetic */ MarketplacePluginFetcher this$0;
                        final /* synthetic */ MarketplaceInstance $marketplaceInstance;
                        {
                            this.$scope = $scope;
                            this.$plugin = $plugin;
                            this.this$0 = $receiver;
                            this.$marketplaceInstance = $marketplaceInstance;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    lightIconDeffered = BuildersKt.async$default((CoroutineScope)this.$scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ImageId>, Object>(this.this$0, this.$marketplaceInstance, this.$plugin, null){
                                        int label;
                                        final /* synthetic */ MarketplacePluginFetcher this$0;
                                        final /* synthetic */ MarketplaceInstance $marketplaceInstance;
                                        final /* synthetic */ MarketplacePluginDto $plugin;
                                        {
                                            this.this$0 = $receiver;
                                            this.$marketplaceInstance = $marketplaceInstance;
                                            this.$plugin = $plugin;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    this.label = 1;
                                                    v0 = MarketplacePluginFetcher.access$fetchIcon-zipM9wQ(this.this$0, this.$marketplaceInstance, this.$plugin, IconTheme.DEFAULT, (Continuation)this);
                                                    if (v0 == var2_2) {
                                                        return var2_2;
                                                    }
                                                    ** GOTO lbl14
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = (ImageId)$result;
                                                    v0 = v1 != null ? v1.unbox-impl() : null;
lbl14:
                                                    // 2 sources

                                                    return v0 != null ? ImageId.box-impl((String)v0) : null;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super ImageId> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                    darkIconDeferred = BuildersKt.async$default((CoroutineScope)this.$scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ImageId>, Object>(this.this$0, this.$marketplaceInstance, this.$plugin, null){
                                        int label;
                                        final /* synthetic */ MarketplacePluginFetcher this$0;
                                        final /* synthetic */ MarketplaceInstance $marketplaceInstance;
                                        final /* synthetic */ MarketplacePluginDto $plugin;
                                        {
                                            this.this$0 = $receiver;
                                            this.$marketplaceInstance = $marketplaceInstance;
                                            this.$plugin = $plugin;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    this.label = 1;
                                                    v0 = MarketplacePluginFetcher.access$fetchIcon-zipM9wQ(this.this$0, this.$marketplaceInstance, this.$plugin, IconTheme.DARCULA, (Continuation)this);
                                                    if (v0 == var2_2) {
                                                        return var2_2;
                                                    }
                                                    ** GOTO lbl14
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = (ImageId)$result;
                                                    v0 = v1 != null ? v1.unbox-impl() : null;
lbl14:
                                                    // 2 sources

                                                    return v0 != null ? ImageId.box-impl((String)v0) : null;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super ImageId> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)lightIconDeffered);
                                    this.L$1 = darkIconDeferred;
                                    this.label = 1;
                                    v0 = lightIconDeffered.await((Continuation)this);
                                    if (v0 == var8_2) {
                                        return var8_2;
                                    }
                                    ** GOTO lbl19
                                }
                                case 1: {
                                    darkIconDeferred = (Deferred)this.L$1;
                                    lightIconDeffered = (Deferred)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl19:
                                    // 2 sources

                                    v1 = (ImageId)v0;
                                    var6_6 = lightIcon = v1 != null ? v1.unbox-impl() : null;
                                    var5_7 = PluginId.box-impl(this.$plugin.getXmlId-NE1ku3Q());
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)lightIconDeffered);
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)darkIconDeferred);
                                    this.L$2 = lightIcon;
                                    this.L$3 = var5_7;
                                    this.L$4 = var6_6;
                                    this.label = 2;
                                    v2 = darkIconDeferred.await((Continuation)this);
                                    if (v2 == var8_2) {
                                        return var8_2;
                                    }
                                    ** GOTO lbl40
                                }
                                case 2: {
                                    var6_6 = (String)this.L$4;
                                    var5_7 = (PluginId)this.L$3;
                                    lightIcon = (String)this.L$2;
                                    darkIconDeferred = (Deferred)this.L$1;
                                    lightIconDeffered = (Deferred)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl40:
                                    // 2 sources

                                    var7_8 = v2;
                                    v3 = (ImageId)var7_8;
                                    v4 = v3 != null ? v3.unbox-impl() : null;
                                    if (v4 == null) {
                                        v4 = lightIcon;
                                    }
                                    return TuplesKt.to((Object)var5_7, (Object)ImagesKt.image-3de46xM((String)var6_6, (String)v4));
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Pair<PluginId, ? extends Image>> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null));
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)marketplaceInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)plugins);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)coroutineScope);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)icons);
                $continuation.L$4 = scope;
                $continuation.label = 2;
                v1 = AwaitKt.awaitAll((Collection)icons, (Continuation)$continuation);
                if (v1 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl58
            }
            case 2: {
                scope = (CoroutineScope)$continuation.L$4;
                icons = (List)$continuation.L$3;
                coroutineScope = (CoroutineScope)$continuation.L$2;
                plugins = (List)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl58:
                // 2 sources

                result = MapsKt.toMap((Iterable)CollectionsKt.filterNotNull((Iterable)((Iterable)v1)));
                v2 = scope.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
                Intrinsics.checkNotNull((Object)v2);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)marketplaceInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)plugins);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)coroutineScope);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)icons);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)scope);
                $continuation.L$5 = result;
                $continuation.label = 3;
                v3 = JobKt.cancelAndJoin((Job)((Job)v2), (Continuation)$continuation);
                if (v3 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl81
            }
            case 3: {
                result = (Map)$continuation.L$5;
                scope = (CoroutineScope)$continuation.L$4;
                icons = (List)$continuation.L$3;
                coroutineScope = (CoroutineScope)$continuation.L$2;
                plugins = (List)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl81:
                // 2 sources

                Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fetchIcons$lambda$19(java.util.Map ), ()Ljava/lang/String;)((Map)result));
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object fetchIcon-zipM9wQ(MarketplaceInstance marketplaceInstance, MarketplacePluginDto plugin, IconTheme iconTheme, Continuation<? super ImageId> $completion) {
        if (!($completion instanceof fetchIcon.1)) ** GOTO lbl-1000
        var14_5 = $completion;
        if ((var14_5.label & -2147483648) != 0) {
            var14_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ MarketplacePluginFetcher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    Object object = MarketplacePluginFetcher.access$fetchIcon-zipM9wQ(this.this$0, null, null, null, (Continuation)this);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    String string = (String)object;
                    return string != null ? ImageId.box-impl((String)string) : null;
                }
            };
        }
        $result = $continuation.result;
        var15_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                pluginId = plugin.getXmlId-NE1ku3Q();
                this.fileSystem.createDirectories(this.pluginIconsFolder);
                destination = this.pluginIconsFolder.resolve(PluginId.toString-impl(pluginId) + "-" + iconTheme.name() + ".svg");
                Logger.INSTANCE.trace((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fetchIcon_zipM9wQ$lambda$20(com.jetbrains.toolbox.gateway.pluginManagement.IconTheme java.lang.String ), ()Ljava/lang/String;)((IconTheme)iconTheme, (String)pluginId));
                requestUrl = marketplaceInstance.getIconUrl() + "?pluginId=" + PluginId.toString-impl(pluginId) + "&theme=" + iconTheme.name() + "&family=toolbox";
                try {
                    v0 = this.fileSystem.metadataOrNull(destination);
                    var10_13 = v0 != null && (v0 = v0.getSize()) != null ? v0.longValue() : -1L;
                }
                catch (Throwable t) {
                    var10_13 = -1L;
                }
                cachedFileSize = var10_13;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)marketplaceInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)plugin);
                $continuation.L$2 = iconTheme;
                $continuation.L$3 = pluginId;
                $continuation.L$4 = destination;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)requestUrl);
                $continuation.J$0 = cachedFileSize;
                $continuation.label = 1;
                v1 = FileDownloader.getFile$default(this.downloadManager.getFileDownloader(), (String)requestUrl, destination, cachedFileSize, new ActionProgress(0, LocalizableStringExKt.notr(""), Progress.ProgressType.HIDDEN, false, 0L, 24, null), null, false, (Continuation)$continuation, 48, null);
                ** if (v1 != var15_7) goto lbl38
lbl37:
                // 1 sources

                return var15_7;
lbl38:
                // 1 sources

                ** GOTO lbl51
            }
            case 1: {
                cachedFileSize = $continuation.J$0;
                requestUrl = (String)$continuation.L$5;
                destination = (Path)$continuation.L$4;
                pluginId = (String)$continuation.L$3;
                iconTheme = (IconTheme)$continuation.L$2;
                plugin = (MarketplacePluginDto)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl51:
                // 2 sources

                if (!((result = (DownloadResult)v1) instanceof DownloadResult.Downloaded != false || result instanceof DownloadResult.NotModified != false)) {
                    $i$a$-require-MarketplacePluginFetcher$fetchIcon$3 = false;
                    var12_18 = "Failed to download icon " + iconTheme + " for plugin " + PluginId.toString-impl(pluginId) + ": " + result;
                    throw new IllegalArgumentException(var12_18.toString());
                }
                Logger.INSTANCE.trace((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fetchIcon_zipM9wQ$lambda$22(com.jetbrains.toolbox.gateway.pluginManagement.IconTheme java.lang.String com.jetbrains.toolbox.network.DownloadResult ), ()Ljava/lang/String;)((IconTheme)iconTheme, (String)pluginId, (DownloadResult)result));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)marketplaceInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)plugin);
                $continuation.L$2 = iconTheme;
                $continuation.L$3 = pluginId;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)destination);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)requestUrl);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)result);
                $continuation.J$0 = cachedFileSize;
                $continuation.label = 2;
                v2 = this.imageManager.convert-lK-al4Y(destination, false, (Continuation<? super ImageId>)$continuation);
                ** if (v2 != var15_7) goto lbl68
lbl67:
                // 1 sources

                return var15_7;
lbl68:
                // 1 sources

                ** GOTO lbl83
            }
            case 2: {
                cachedFileSize = $continuation.J$0;
                result = (DownloadResult)$continuation.L$6;
                requestUrl = (String)$continuation.L$5;
                destination = (Path)$continuation.L$4;
                pluginId = (String)$continuation.L$3;
                iconTheme = (IconTheme)$continuation.L$2;
                plugin = (MarketplacePluginDto)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = (ImageId)$result;
                    v2 = v3 != null ? v3.unbox-impl() : null;
lbl83:
                    // 2 sources

                    return v2;
                }
                catch (Exception e) {
                    Logger.INSTANCE.info("Failed to download icon " + iconTheme + " for plugin " + PluginId.toString-impl(pluginId) + ": " + e.getMessage() + ". For more info set log level to trace");
                    Logger.INSTANCE.trace((Throwable)e, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fetchIcon_zipM9wQ$lambda$23(com.jetbrains.toolbox.gateway.pluginManagement.IconTheme java.lang.String ), ()Ljava/lang/String;)((IconTheme)iconTheme, (String)pluginId));
                    return null;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object fetchUpdates(@NotNull MarketplaceInstance marketplaceInstance, @NotNull List<PluginId> marketplacePluginsXmlId, @NotNull Continuation<? super MarketplaceUpdatesWithCountDto> $completion) {
        if (!($completion instanceof fetchUpdates.1)) ** GOTO lbl-1000
        var19_4 = $completion;
        if ((var19_4.label & -2147483648) != 0) {
            var19_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ MarketplacePluginFetcher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fetchUpdates(null, null, (Continuation<? super MarketplaceUpdatesWithCountDto>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (marketplacePluginsXmlId.isEmpty()) {
                    return new MarketplaceUpdatesWithCountDto(0, CollectionsKt.emptyList());
                }
                idsString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)marketplacePluginsXmlId), (CharSequence)",", null, null, (int)0, null, (Function1)fetchUpdates.idsString.1.INSTANCE, (int)30, null);
                query = StringsKt.trimIndent((String)("\n      query {\n        updates(search: {\n          filters: [\n            {field:\"family\", value:\"toolbox\"}\n            {field:\"xmlId\", value:[" + idsString + "]}\n          ]\n          compatibility:{\n            range:{\n              lte: " + MarketplacePluginFetcher.maximumCompatibleVersionLong + "\n              gte: " + MarketplacePluginFetcher.minimumCompatibleVersionLong + "\n            }\n          }\n          collapseField: PLUGIN_ID\n          max: 20\n        }) {\n          total\n          updates {\n            id\n            xmlId\n            pluginId\n            version\n            compatibility {\n              gte\n              lte\n            }\n            fields\n            channel\n            products\n            family\n            cdate\n            size\n          }\n        }\n      }\n    "));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)marketplaceInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)marketplacePluginsXmlId);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)idsString);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.label = 1;
                v0 = this.executeGraphQlQuery(marketplaceInstance, query, "updates", (Continuation<? super GraphQLResponse>)$continuation);
                if (v0 == var20_6) {
                    return var20_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                query = (String)$continuation.L$3;
                idsString = (String)$continuation.L$2;
                marketplacePluginsXmlId = (List)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                response = (GraphQLResponse)v0;
                try {
                    v1 = (DeserializationStrategy)MarketplaceUpdatesWithCountDto.Companion.serializer();
                    v2 = response.getData().get((Object)"updates");
                    Intrinsics.checkNotNull((Object)v2);
                    var8_10 = (MarketplaceUpdatesWithCountDto)this.json.decodeFromJsonElement(v1, (JsonElement)v2);
                }
                catch (Exception e) {
                    Logger.INSTANCE.error((Throwable)e, "Failed to decode GraphQL response");
                    throw new IOException("Failed to decode GraphQL response", e);
                }
                updates = var8_10;
                $this$filter$iv = this.filterByXmlId(updates).getUpdates();
                $i$f$filter = false;
                var11_15 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    p0 = (MarketplacePluginUpdateDto)element$iv$iv;
                    $i$a$-filter-MarketplacePluginFetcher$fetchUpdates$filteredUpdates$1 = false;
                    if (!this.isUpdateCompatible(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                filteredUpdates = (List)destination$iv$iv;
                return new MarketplaceUpdatesWithCountDto(updates.getTotal(), filteredUpdates);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isUpdateCompatible(MarketplacePluginUpdateDto update2) {
        MarketplaceCompatibilityRange compat = update2.getCompatibility();
        String updateReadable = PluginId.toString-impl(update2.getXmlId-NE1ku3Q()) + ":" + update2.getVersion();
        if (compat == null) {
            Logger.INSTANCE.warn(() -> MarketplacePluginFetcher.isUpdateCompatible$lambda$25(update2));
        } else {
            if (compat.getGte() == null) {
                Logger.INSTANCE.warn(() -> MarketplacePluginFetcher.isUpdateCompatible$lambda$26(updateReadable));
            } else if (compat.getGte() < minimumCompatibleVersionLong) {
                Logger.INSTANCE.warn(() -> MarketplacePluginFetcher.isUpdateCompatible$lambda$27(updateReadable, compat));
                return false;
            }
            if (compat.getLte() == null) {
                Logger.INSTANCE.warn(() -> MarketplacePluginFetcher.isUpdateCompatible$lambda$28(updateReadable));
            } else if (compat.getLte() > maximumCompatibleVersionLong) {
                Logger.INSTANCE.warn(() -> MarketplacePluginFetcher.isUpdateCompatible$lambda$29(updateReadable, compat));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadPlugin(@NotNull MarketplaceInstance marketplaceInstance, @NotNull MarketplacePluginUpdate marketplacePluginUpdate, @NotNull ActionProgress progressBar, @NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof downloadPlugin.1)) ** GOTO lbl-1000
        var24_5 = $completion;
        if ((var24_5.label & -2147483648) != 0) {
            var24_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                /* synthetic */ Object result;
                final /* synthetic */ MarketplacePluginFetcher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadPlugin(null, null, null, (Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var25_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                pluginMoniker = marketplacePluginUpdate.getPluginId() + " " + marketplacePluginUpdate.getVersion();
                pluginLogMoniker = PluginId.toString-impl(marketplacePluginUpdate.getXmlId-NE1ku3Q()) + ":" + marketplacePluginUpdate.getVersion() + " (updateId: " + marketplacePluginUpdate.getId() + ")";
                Logger.INSTANCE.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, downloadPlugin$lambda$30(java.lang.String ), ()Ljava/lang/String;)((String)pluginLogMoniker));
                ActionProgress.update$default(progressBar, LocalizableStringExKt.trl("Downloading\u2026"), false, 2, null);
                downloadUrl = marketplaceInstance.getDownloadUrl() + "?pluginId=" + marketplacePluginUpdate.getPluginId() + "&updateId=" + marketplacePluginUpdate.getId() + "&family=toolbox";
                downloadDir = this.downloadManager.getDownloadDirectory();
                tempPluginFile = downloadDir.resolve(PluginId.toString-impl(marketplacePluginUpdate.getXmlId-NE1ku3Q()) + "-" + marketplacePluginUpdate.getId() + "-" + marketplacePluginUpdate.getVersion() + ".zip");
                v0 = tempPluginFile.parent();
                Intrinsics.checkNotNull((Object)v0);
                this.fileSystem.createDirectories(v0);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)marketplaceInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)marketplacePluginUpdate);
                $continuation.L$2 = progressBar;
                $continuation.L$3 = pluginMoniker;
                $continuation.L$4 = pluginLogMoniker;
                $continuation.L$5 = downloadUrl;
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)downloadDir);
                $continuation.L$7 = tempPluginFile;
                $continuation.label = 1;
                v1 = this.downloadManager.createSession((Continuation<? super DownloadSession>)$continuation);
                if (v1 == var25_7) {
                    return var25_7;
                }
                ** GOTO lbl46
            }
            case 1: {
                tempPluginFile = (Path)$continuation.L$7;
                downloadDir = (Path)$continuation.L$6;
                downloadUrl = (String)$continuation.L$5;
                pluginLogMoniker = (String)$continuation.L$4;
                pluginMoniker = (String)$continuation.L$3;
                progressBar = (ActionProgress)$continuation.L$2;
                marketplacePluginUpdate = (MarketplacePluginUpdate)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl46:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)marketplaceInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)marketplacePluginUpdate);
                $continuation.L$2 = progressBar;
                $continuation.L$3 = pluginMoniker;
                $continuation.L$4 = pluginLogMoniker;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)downloadUrl);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)downloadDir);
                $continuation.L$7 = tempPluginFile;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)v1), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>((String)downloadUrl, progressBar, (String)pluginLogMoniker, (String)pluginMoniker, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ String $downloadUrl;
                    final /* synthetic */ ActionProgress $progressBar;
                    final /* synthetic */ String $pluginLogMoniker;
                    final /* synthetic */ String $pluginMoniker;
                    {
                        this.$downloadUrl = $downloadUrl;
                        this.$progressBar = $progressBar;
                        this.$pluginLogMoniker = $pluginLogMoniker;
                        this.$pluginMoniker = $pluginMoniker;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = (CoroutineScope)this.L$0;
                        var13_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                                this.label = 1;
                                v0 = DownloadSession.getAsync$default(DownloadSessionKt.getSession($this$withContext.getCoroutineContext()), this.$downloadUrl, -1L, this.$progressBar, null, false, false, (Continuation)this, 32, null);
                                if (v0 == var13_3) {
                                    return var13_3;
                                }
                                ** GOTO lbl15
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl15:
                                // 2 sources

                                var3_4 = (Pair)v0;
                                result = (DownloadResult)var3_4.component1();
                                byteArray = (byte[])var3_4.component2();
                                var6_7 = result;
                                if (var6_7 instanceof DownloadResult.Downloaded) {
                                    Logger.INSTANCE.info("Toolbox plugin " + this.$pluginLogMoniker + " is downloaded");
                                } else if (Intrinsics.areEqual((Object)var6_7, (Object)DownloadResult.Cancelled.INSTANCE)) {
                                    Logger.INSTANCE.warn("Toolbox plugin " + this.$pluginLogMoniker + " download cancelled");
                                } else if (var6_7 instanceof DownloadResult.Failed) {
                                    Logger.INSTANCE.error("Toolbox plugin " + this.$pluginLogMoniker + " download failed: " + ((DownloadResult.Failed)result).getError());
                                } else if (var6_7 instanceof DownloadResult.NotConnected) {
                                    Logger.INSTANCE.error("Toolbox plugin " + this.$pluginLogMoniker + " download failed, not connected: " + ((DownloadResult.NotConnected)result).getError());
                                } else if (Intrinsics.areEqual((Object)var6_7, (Object)DownloadResult.NotModified.INSTANCE)) {
                                    Logger.INSTANCE.info("Toolbox plugin " + this.$pluginLogMoniker + " not modified");
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                if (result.isSuccessful()) ** GOTO lbl64
                                var6_7 = result;
                                if (var6_7 instanceof DownloadResult.Cancelled) {
                                    throw MarketplaceExceptionFactory.createDownloadCancelledException$default(MarketplaceExceptionFactory.INSTANCE, "Plugin download was cancelled: " + this.$pluginMoniker, null, 2, null);
                                }
                                if (!(var6_7 instanceof DownloadResult.Failed)) ** GOTO lbl61
                                v1 = ((DownloadResult.Failed)result).getCode();
                                var7_8 = 404;
                                if (v1 != null && v1 == var7_8) {
                                    throw MarketplaceExceptionFactory.createPluginNotFoundException$default(MarketplaceExceptionFactory.INSTANCE, "Plugin " + this.$pluginMoniker + " not found", null, 2, null);
                                }
                                v2 = MarketplaceExceptionFactory.INSTANCE;
                                v3 = this.$pluginMoniker;
                                v4 = ((DownloadResult.Failed)result).getCode();
                                if (v4 == null) ** GOTO lbl59
                                var8_9 = ((Number)v4).intValue();
                                var11_10 = v3;
                                var10_11 = v2;
                                $i$a$-let-MarketplacePluginFetcher$downloadPlugin$byteArray$1$1 = false;
                                var12_13 = "Code " + (int)it;
                                v2 = var10_11;
                                v3 = var11_10;
                                v5 = var12_13;
                                v4 = v5;
                                if (v5 != null) ** GOTO lbl60
lbl59:
                                // 2 sources

                                v4 = "unknown";
lbl60:
                                // 2 sources

                                throw MarketplaceExceptionFactory.createDownloadFailedException$default(v2, "Failed to download plugin " + v3 + ". Error: " + (String)v4 + ".", null, 2, null);
lbl61:
                                // 1 sources

                                if (var6_7 instanceof DownloadResult.NotConnected) {
                                    throw MarketplaceExceptionFactory.createNetworkException$default(MarketplaceExceptionFactory.INSTANCE, "Failed to download plugin " + this.$pluginMoniker + " due to network issues. Error: " + ((DownloadResult.NotConnected)result).getError() + ".", null, 2, null);
                                }
                                throw MarketplaceExceptionFactory.createDownloadFailedException$default(MarketplaceExceptionFactory.INSTANCE, "Failed to download plugin " + this.$pluginMoniker, null, 2, null);
lbl64:
                                // 1 sources

                                return byteArray;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super byte[]> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var25_7) {
                    return var25_7;
                }
                ** GOTO lbl70
            }
            case 2: {
                tempPluginFile = (Path)$continuation.L$7;
                downloadDir = (Path)$continuation.L$6;
                downloadUrl = (String)$continuation.L$5;
                pluginLogMoniker = (String)$continuation.L$4;
                pluginMoniker = (String)$continuation.L$3;
                progressBar = (ActionProgress)$continuation.L$2;
                marketplacePluginUpdate = (MarketplacePluginUpdate)$continuation.L$1;
                marketplaceInstance = (MarketplaceInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl70:
                // 2 sources

                if ((byteArray = (byte[])v2).length == 0) {
                    Logger.INSTANCE.warn("Downloaded plugin " + (String)pluginLogMoniker + " is empty");
                    throw MarketplaceExceptionFactory.createDownloadFailedException$default(MarketplaceExceptionFactory.INSTANCE, "Failed to download plugin " + (String)pluginMoniker + ". Plugin file is empty.", null, 2, null);
                }
                Logger.INSTANCE.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, downloadPlugin$lambda$31(java.lang.String ), ()Ljava/lang/String;)((String)pluginLogMoniker));
                try {
                    newByteArray = (byte[])byteArray.clone();
                    this.checkPluginSignature(progressBar, newByteArray, (String)pluginMoniker, (String)pluginLogMoniker);
                    Logger.INSTANCE.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, downloadPlugin$lambda$32(java.lang.String ), ()Ljava/lang/String;)((String)pluginLogMoniker));
                }
                catch (Throwable e) {
                    Logger.INSTANCE.error(e, "Failed to download or verify plugin: " + (String)pluginLogMoniker);
                    throw e;
                }
                if (this.fileSystem.exists(tempPluginFile)) {
                    Logger.INSTANCE.warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, downloadPlugin$lambda$33(java.lang.String okio.Path ), ()Ljava/lang/String;)((String)pluginLogMoniker, (Path)tempPluginFile));
                    this.fileSystem.delete(tempPluginFile);
                }
                e = this.fileSystem;
                var12_18 = tempPluginFile;
                mustCreate$iv = true;
                $i$f$-write = false;
                $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink((Path)file$iv, true));
                $i$f$use = false;
                thrown$iv$iv = null;
                it$iv = (BufferedSink)$this$use$iv$iv;
                $i$a$-use-FileSystem$write$1$iv = false;
                $this$downloadPlugin_u24lambda_u2434 = it$iv;
                $i$a$--write-MarketplacePluginFetcher$downloadPlugin$6 = false;
                var19_26 = $this$downloadPlugin_u24lambda_u2434.write(byteArray);
                try {
                    v3 = $this$use$iv$iv;
                    if (v3 != null) {
                        v3.close();
                    }
                    ** GOTO lbl129
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
                ** GOTO lbl129
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        var19_26 = null;
                    }
                    catch (Throwable var22_33) {
                        throw var22_33;
                    }
                    finally {
                        try {
                            v4 = $this$use$iv$iv;
                            if (v4 != null) {
                                v4.close();
                            }
                        }
                        catch (Throwable t$iv$iv) {
                            if (thrown$iv$iv != null) ** GOTO lbl127
                            thrown$iv$iv = t$iv$iv;
                            ** GOTO lbl128
lbl127:
                            // 1 sources

                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
                        }
lbl128:
                        // 3 sources

                    }
                }
lbl129:
                // 3 sources

                result$iv$iv = var19_26;
                v5 = thrown$iv$iv;
                if (v5 != null) {
                    throw v5;
                }
                return tempPluginFile;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void checkPluginSignature(@NotNull ActionProgress progressBar, @NotNull byte[] pluginZipBytes, @NotNull String pluginMoniker, @NotNull String pluginLogMoniker) {
        ZipVerificationResult verificationResult;
        Intrinsics.checkNotNullParameter((Object)progressBar, (String)"progressBar");
        Intrinsics.checkNotNullParameter((Object)pluginZipBytes, (String)"pluginZipBytes");
        Intrinsics.checkNotNullParameter((Object)pluginMoniker, (String)"pluginMoniker");
        Intrinsics.checkNotNullParameter((Object)pluginLogMoniker, (String)"pluginLogMoniker");
        Logger.INSTANCE.debug("Verifying signature of plugin " + pluginLogMoniker);
        ActionProgress.update$default(progressBar, LocalizableStringExKt.trl("Verifying\u2026"), false, 2, null);
        ByteBuffer byteBuffer = ByteBuffer.wrap(pluginZipBytes);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        ByteBufferDataSource dataSource = new ByteBufferDataSource(byteBuffer);
        ZipVerificationResult zipVerificationResult = verificationResult = ZipVerifier.INSTANCE.verify(dataSource);
        if (zipVerificationResult instanceof InvalidSignatureResult) {
            throw MarketplaceExceptionFactory.createSignatureException$default(MarketplaceExceptionFactory.INSTANCE, "Failed to verify signature of plugin " + pluginMoniker + ": " + ((InvalidSignatureResult)verificationResult).getErrorMessage(), null, 2, null);
        }
        if (Intrinsics.areEqual((Object)zipVerificationResult, (Object)MissingSignatureResult.INSTANCE)) {
            throw MarketplaceExceptionFactory.createSignatureException$default(MarketplaceExceptionFactory.INSTANCE, "Failed to verify signature of plugin" + pluginMoniker + ": missing signature", null, 2, null);
        }
        if (zipVerificationResult instanceof SuccessfulVerificationResult) {
            boolean isMarketplaceSignedTheBundle = ((SuccessfulVerificationResult)verificationResult).isSignedBy(this.x509marketplaceCA);
            if (!isMarketplaceSignedTheBundle) {
                Logger.INSTANCE.error("Plugin " + pluginLogMoniker + " is not signed by Marketplace CA");
                throw MarketplaceExceptionFactory.createSignatureException$default(MarketplaceExceptionFactory.INSTANCE, "Plugin " + pluginMoniker + " is not signed by Marketplace CA", null, 2, null);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Logger.INSTANCE.debug("Successfully verified plugin signature of " + pluginLogMoniker);
    }

    @NotNull
    public final X509Certificate getX509marketplaceCA() {
        return this.x509marketplaceCA;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final String executeGraphQlQuery$lambda$1(String $query) {
        return "Executing GraphQL query: " + StringsKt.replace$default((String)$query, (String)"\n", (String)"", (boolean)false, (int)4, null);
    }

    private static final String executeGraphQlQuery$lambda$3(byte[] $bytes) {
        return "GraphQL query response: " + StringsKt.decodeToString((byte[])$bytes);
    }

    private static final String filterByXmlId$lambda$7(Map $duplicates) {
        return "Found " + $duplicates.size() + " duplicates in Marketplace: " + $duplicates.keySet();
    }

    private static final String filterByXmlId$lambda$10(List $newPlugins) {
        return "Result after deduplication: " + $newPlugins;
    }

    private static final String filterByXmlId$lambda$13(Map $duplicates) {
        return "Found " + $duplicates.size() + " duplicates in Marketplace: " + $duplicates.keySet();
    }

    private static final String filterByXmlId$lambda$16(List $newPlugins) {
        return "Result after deduplication: " + $newPlugins;
    }

    private static final CharSequence fetchIcons$lambda$18$lambda$17(MarketplacePluginDto it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getXmlId-NE1ku3Q();
    }

    private static final String fetchIcons$lambda$18(List $plugins) {
        return "Fetching icons for plugins: [" + CollectionsKt.joinToString$default((Iterable)$plugins, null, null, null, (int)0, null, MarketplacePluginFetcher::fetchIcons$lambda$18$lambda$17, (int)31, null) + "]";
    }

    private static final String fetchIcons$lambda$19(Map $result) {
        return "Fetched icons for plugins: [" + $result.keySet() + "]";
    }

    private static final String fetchIcon_zipM9wQ$lambda$20(IconTheme $iconTheme, String $pluginId) {
        return "Downloading icon " + $iconTheme + " for plugin " + PluginId.toString-impl($pluginId);
    }

    private static final String fetchIcon_zipM9wQ$lambda$22(IconTheme $iconTheme, String $pluginId, DownloadResult $result) {
        return "Downloaded icon " + $iconTheme + " for plugin " + PluginId.toString-impl($pluginId) + ". is modified: " + ($result instanceof DownloadResult.Downloaded);
    }

    private static final String fetchIcon_zipM9wQ$lambda$23(IconTheme $iconTheme, String $pluginId) {
        return "Failed to download icon " + $iconTheme + " for plugin " + PluginId.toString-impl($pluginId);
    }

    private static final String isUpdateCompatible$lambda$25(MarketplacePluginUpdateDto $update) {
        return "Compatibility is null for plugin " + PluginId.toString-impl($update.getXmlId-NE1ku3Q());
    }

    private static final String isUpdateCompatible$lambda$26(String $updateReadable) {
        return "Plugin " + $updateReadable + " has no gte version";
    }

    private static final String isUpdateCompatible$lambda$27(String $updateReadable, MarketplaceCompatibilityRange $compat) {
        return "Plugin " + $updateReadable + " has gte version " + $compat.getGte() + " which is less than minimum compatible version " + minimumCompatibleVersionLong;
    }

    private static final String isUpdateCompatible$lambda$28(String $updateReadable) {
        return "Plugin " + $updateReadable + " has no lte version";
    }

    private static final String isUpdateCompatible$lambda$29(String $updateReadable, MarketplaceCompatibilityRange $compat) {
        return "Plugin " + $updateReadable + " has lte version " + $compat.getLte() + " which is greater than maximum compatible version " + maximumCompatibleVersionLong;
    }

    private static final String downloadPlugin$lambda$30(String $pluginLogMoniker) {
        return "Going to download plugin: " + $pluginLogMoniker;
    }

    private static final String downloadPlugin$lambda$31(String $pluginLogMoniker) {
        return "Downloaded plugin: " + $pluginLogMoniker;
    }

    private static final String downloadPlugin$lambda$32(String $pluginLogMoniker) {
        return "Successfully downloaded and verified " + $pluginLogMoniker;
    }

    private static final String downloadPlugin$lambda$33(String $pluginLogMoniker, Path $tempPluginFile) {
        return "Plugin " + $pluginLogMoniker + " is already downloaded to " + $tempPluginFile + ", deleting it first";
    }

    public static final /* synthetic */ Object access$fetchIcons(MarketplacePluginFetcher $this, MarketplaceInstance marketplaceInstance, List plugins, CoroutineScope coroutineScope, Continuation $completion) {
        return $this.fetchIcons(marketplaceInstance, plugins, coroutineScope, (Continuation<? super Map<PluginId, ? extends Image>>)$completion);
    }

    public static final /* synthetic */ Object access$fetchIcon-zipM9wQ(MarketplacePluginFetcher $this, MarketplaceInstance marketplaceInstance, MarketplacePluginDto plugin, IconTheme iconTheme, Continuation $completion) {
        return $this.fetchIcon-zipM9wQ(marketplaceInstance, plugin, iconTheme, (Continuation<? super ImageId>)$completion);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @SourceDebugExtension(value={"SMAP\nMarketplacePluginFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketplacePluginFetcher.kt\ncom/jetbrains/toolbox/gateway/pluginManagement/MarketplacePluginFetcher$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,650:1\n1#2:651\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final long convertSemverToLong-Szkhn3Q(@NotNull String buildNumber) {
            Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
            if (!(BuildNumber.getComponents-impl(buildNumber).size() == 3)) {
                boolean bl = false;
                String string = "Build number must have 3 components";
                throw new IllegalArgumentException(string.toString());
            }
            long major = Long.parseLong(BuildNumber.getComponents-impl(buildNumber).get(0));
            if (!(major <= 7449L)) {
                boolean $i$a$-require-MarketplacePluginFetcher$Companion$convertSemverToLong$82 = false;
                String $i$a$-require-MarketplacePluginFetcher$Companion$convertSemverToLong$82 = "Major version must be less or equal to 7449";
                throw new IllegalArgumentException($i$a$-require-MarketplacePluginFetcher$Companion$convertSemverToLong$82.toString());
            }
            if (!(major >= 0L)) {
                boolean bl = false;
                String string = "Major version must be more or equal to 0";
                throw new IllegalArgumentException(string.toString());
            }
            long minor = Long.parseLong(BuildNumber.getComponents-impl(buildNumber).get(1));
            if (!(minor <= 8191L)) {
                boolean $i$a$-require-MarketplacePluginFetcher$Companion$convertSemverToLong$92 = false;
                String $i$a$-require-MarketplacePluginFetcher$Companion$convertSemverToLong$92 = "Minor version must be less or equal to 8191";
                throw new IllegalArgumentException($i$a$-require-MarketplacePluginFetcher$Companion$convertSemverToLong$92.toString());
            }
            if (!(minor >= 0L)) {
                boolean bl = false;
                String string = "Minor version must be more or equal to 0";
                throw new IllegalArgumentException(string.toString());
            }
            String it = BuildNumber.getComponents-impl(buildNumber).get(2);
            boolean bl = false;
            long patch = Intrinsics.areEqual((Object)it, (Object)"SNAPSHOT") ? 999999L : Long.parseLong(it);
            if (!(patch <= 1048575L)) {
                boolean $i$a$-require-MarketplacePluginFetcher$Companion$convertSemverToLong$102 = false;
                String $i$a$-require-MarketplacePluginFetcher$Companion$convertSemverToLong$102 = "Patch version must be less or equal to 1048575";
                throw new IllegalArgumentException($i$a$-require-MarketplacePluginFetcher$Companion$convertSemverToLong$102.toString());
            }
            if (!(patch >= 0L)) {
                boolean bl2 = false;
                String string = "Patch version must be more or equal to 0";
                throw new IllegalArgumentException(string.toString());
            }
            return (major << 33) + (minor << 20) + patch;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

