/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.pluginImpl;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.api.remoteDev.connection.RemoteToolsHelper;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.DevEnvironmentManager;
import com.jetbrains.toolbox.gateway.RawInterfaces;
import com.jetbrains.toolbox.gateway.pluginImpl.RemoteToolsHelperImpl;
import com.jetbrains.toolbox.gateway.tools.ToolHintParser;
import com.jetbrains.toolbox.gateway.utils.DevEnvironmentManagerExtensions;
import com.jetbrains.toolbox.tools.IntellijToolBuildQuery;
import com.jetbrains.toolbox.tools.ToolSearchRule;
import com.jetbrains.toolbox.tools.ToolStateManager;
import com.jetbrains.toolbox.tools.UniversalIntellijToolBuildDescriptor;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nRemoteToolsHelperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteToolsHelperImpl.kt\ncom/jetbrains/toolbox/gateway/pluginImpl/RemoteToolsHelperImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n*L\n1#1,86:1\n1563#2:87\n1634#2,3:88\n1563#2:91\n1634#2,3:92\n7#3,7:95\n*S KotlinDebug\n*F\n+ 1 RemoteToolsHelperImpl.kt\ncom/jetbrains/toolbox/gateway/pluginImpl/RemoteToolsHelperImpl\n*L\n37#1:87\n37#1:88,3\n52#1:91\n52#1:92,3\n73#1:95,7\n*E\n"})
public final class RemoteToolsHelperImpl
implements RemoteToolsHelper {
    @NotNull
    private final String providerId;
    @NotNull
    private final DevEnvironmentManager devEnvironmentManager;
    @NotNull
    private final ToolHintParser toolHintParser;
    @NotNull
    private final CoroutineScope pluginScope;

    private RemoteToolsHelperImpl(String providerId, DevEnvironmentManager devEnvironmentManager, ToolHintParser toolHintParser, CoroutineScope pluginScope) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)devEnvironmentManager, (String)"devEnvironmentManager");
        Intrinsics.checkNotNullParameter((Object)toolHintParser, (String)"toolHintParser");
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        this.providerId = providerId;
        this.devEnvironmentManager = devEnvironmentManager;
        this.toolHintParser = toolHintParser;
        this.pluginScope = pluginScope;
    }

    private final Object getRawInterfaces(String environmentId, Continuation<? super RawInterfaces> $completion) {
        RawInterfaces rawInterfaces;
        StateFlow<RawInterfaces> stateFlow = DevEnvironmentManagerExtensions.INSTANCE.findEnvironment(this.devEnvironmentManager, new DevEnvironmentId(this.providerId, environmentId, null));
        if (stateFlow != null && (stateFlow = stateFlow.getRawInterfaces()) != null) {
            Object object = FlowExtensionsKt.firstNotNull(stateFlow, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            rawInterfaces = (RawInterfaces)object;
        } else {
            rawInterfaces = null;
        }
        return rawInterfaces;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object getAvailableRemoteTools(@NotNull String environmentId, @NotNull String hint, @NotNull Continuation<? super List<String>> $completion) {
        if (!($completion instanceof getAvailableRemoteTools.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteToolsHelperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getAvailableRemoteTools(null, null, (Continuation<? super List<String>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.info("Received request to get available remote tools for environment " + environmentId + ", hint: " + hint);
                $continuation.L$0 = environmentId;
                $continuation.L$1 = hint;
                $continuation.label = 1;
                v0 = this.getRawInterfaces(environmentId, (Continuation<? super RawInterfaces>)$continuation);
                if (v0 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                v1 = (RawInterfaces)v0;
                if (v1 == null) {
                    $this$getAvailableRemoteTools_u24lambda_u240 = this;
                    $i$a$-run-RemoteToolsHelperImpl$getAvailableRemoteTools$rawInterfaces$1 = false;
                    Logger.INSTANCE.error("Couldn't list available remote tools because the environment " + environmentId + " doesn't exist");
                    return CollectionsKt.emptyList();
                }
                rawInterfaces = v1;
                query = rawInterfaces.getRemoteIdeaToolBuildQuery();
                rules = this.toolHintParser.parse(hint);
                Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAvailableRemoteTools$lambda$1(com.jetbrains.toolbox.gateway.pluginImpl.RemoteToolsHelperImpl java.util.Set ), ()Ljava/lang/String;)((RemoteToolsHelperImpl)this, rules));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)environmentId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)hint);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rawInterfaces);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(rules);
                $continuation.label = 2;
                v2 = query.findAvailableTools(rules, (Continuation<? super List<UniversalIntellijToolBuildDescriptor>>)$continuation);
                if (v2 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl53
            }
            case 2: {
                rules = (Set<ToolSearchRule>)$continuation.L$4;
                query = (IntellijToolBuildQuery)$continuation.L$3;
                rawInterfaces = (RawInterfaces)$continuation.L$2;
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl53:
                // 2 sources

                $this$map$iv = (Iterable)v2;
                $i$f$map = false;
                var9_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var14_19 = (UniversalIntellijToolBuildDescriptor)item$iv$iv;
                    var16_21 = destination$iv$iv;
                    $i$a$-map-RemoteToolsHelperImpl$getAvailableRemoteTools$3 = false;
                    var16_21.add(it.getProductCode() + "-" + BuildNumber.toString-impl(it.getBuildNumber-Y_E1uuk()));
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object getInstalledRemoteTools(@NotNull String environmentId, @NotNull String hint, @NotNull Continuation<? super List<String>> $completion) {
        if (!($completion instanceof getInstalledRemoteTools.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteToolsHelperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getInstalledRemoteTools(null, null, (Continuation<? super List<String>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.info("Received request to get installed remote tools for environment " + environmentId + ", hint: " + hint);
                $continuation.L$0 = environmentId;
                $continuation.L$1 = hint;
                $continuation.label = 1;
                v0 = this.getRawInterfaces(environmentId, (Continuation<? super RawInterfaces>)$continuation);
                if (v0 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                v1 = (RawInterfaces)v0;
                if (v1 == null) {
                    $this$getInstalledRemoteTools_u24lambda_u243 = this;
                    $i$a$-run-RemoteToolsHelperImpl$getInstalledRemoteTools$rawInterfaces$1 = false;
                    Logger.INSTANCE.error("Couldn't list installed remote tools because the environment " + environmentId + " doesn't exist");
                    return CollectionsKt.emptyList();
                }
                rawInterfaces = v1;
                query = rawInterfaces.getRemoteIdeaToolBuildQuery();
                rules = this.toolHintParser.parse(hint);
                Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getInstalledRemoteTools$lambda$4(com.jetbrains.toolbox.gateway.pluginImpl.RemoteToolsHelperImpl java.util.Set ), ()Ljava/lang/String;)((RemoteToolsHelperImpl)this, rules));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)environmentId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)hint);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rawInterfaces);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(rules);
                $continuation.label = 2;
                v2 = query.findInstalledTools(rules, (Continuation<? super List<UniversalIntellijToolBuildDescriptor>>)$continuation);
                if (v2 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl53
            }
            case 2: {
                rules = (Set<ToolSearchRule>)$continuation.L$4;
                query = (IntellijToolBuildQuery)$continuation.L$3;
                rawInterfaces = (RawInterfaces)$continuation.L$2;
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl53:
                // 2 sources

                $this$map$iv = (Iterable)v2;
                $i$f$map = false;
                var9_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var14_19 = (UniversalIntellijToolBuildDescriptor)item$iv$iv;
                    var16_21 = destination$iv$iv;
                    $i$a$-map-RemoteToolsHelperImpl$getInstalledRemoteTools$3 = false;
                    var16_21.add(it.getProductCode() + "-" + BuildNumber.toString-impl(it.getBuildNumber-Y_E1uuk()));
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object installRemoteTool(@NotNull String environmentId, @NotNull String hint, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof installRemoteTool.1)) ** GOTO lbl-1000
        var14_4 = $completion;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteToolsHelperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.installRemoteTool(null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.info("Received request to install remote tool in environment " + environmentId + ", hint: " + hint);
                $continuation.L$0 = environmentId;
                $continuation.L$1 = hint;
                $continuation.label = 1;
                v0 = this.getRawInterfaces(environmentId, (Continuation<? super RawInterfaces>)$continuation);
                if (v0 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                v1 = (RawInterfaces)v0;
                if (v1 == null) {
                    $this$installRemoteTool_u24lambda_u246 = this;
                    $i$a$-run-RemoteToolsHelperImpl$installRemoteTool$rawInterfaces$1 = false;
                    Logger.INSTANCE.error("Couldn't install remote tool because the environment " + environmentId + " doesn't exist");
                    return Boxing.boxBoolean((boolean)false);
                }
                rawInterfaces = v1;
                query = rawInterfaces.getRemoteIdeaToolBuildQuery();
                rules = this.toolHintParser.parse(hint);
                Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, installRemoteTool$lambda$7(com.jetbrains.toolbox.gateway.pluginImpl.RemoteToolsHelperImpl java.util.Set ), ()Ljava/lang/String;)((RemoteToolsHelperImpl)this, rules));
                $continuation.L$0 = environmentId;
                $continuation.L$1 = hint;
                $continuation.L$2 = rawInterfaces;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(rules);
                $continuation.label = 2;
                v2 = query.findLatestAvailableTool(rules, (Continuation<? super UniversalIntellijToolBuildDescriptor>)$continuation);
                if (v2 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl53
            }
            case 2: {
                rules = (Set<ToolSearchRule>)$continuation.L$4;
                query = (IntellijToolBuildQuery)$continuation.L$3;
                rawInterfaces = (RawInterfaces)$continuation.L$2;
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl53:
                // 2 sources

                v3 = (UniversalIntellijToolBuildDescriptor)v2;
                if (v3 == null) {
                    $this$installRemoteTool_u24lambda_u248 = this;
                    $i$a$-run-RemoteToolsHelperImpl$installRemoteTool$tool$1 = false;
                    Logger.INSTANCE.error("Couldn't find latest build of available tool " + environmentId + ", hint: " + hint);
                    return Boxing.boxBoolean((boolean)false);
                }
                tool = v3;
                Logger.INSTANCE.info("Trying to install tool " + tool.getProductCode() + "-" + BuildNumber.toString-impl(tool.getBuildNumber-Y_E1uuk()) + " in environment: " + environmentId);
                toolStateManager = rawInterfaces.getToolStateManager(this.pluginScope);
                $i$f$catching = 0;
                $i$a$-catching-RemoteToolsHelperImpl$installRemoteTool$3 = 0;
                $continuation.L$0 = environmentId;
                $continuation.L$1 = hint;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rawInterfaces);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(rules);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)tool);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)toolStateManager);
                $continuation.I$0 = $i$f$catching;
                $continuation.I$1 = $i$a$-catching-RemoteToolsHelperImpl$installRemoteTool$3;
                $continuation.label = 3;
                v4 = toolStateManager.install-yWuBznU(tool.getType-UtVBrGo(), tool.getVersionName(), tool.getBuildNumber-Y_E1uuk(), true, (Continuation<? super Unit>)$continuation);
                ** if (v4 != var15_6) goto lbl80
lbl79:
                // 1 sources

                return var15_6;
lbl80:
                // 1 sources

                ** GOTO lbl95
            }
            case 3: {
                $i$a$-catching-RemoteToolsHelperImpl$installRemoteTool$3 = $continuation.I$1;
                $i$f$catching = $continuation.I$0;
                toolStateManager = (ToolStateManager)$continuation.L$6;
                tool = (UniversalIntellijToolBuildDescriptor)$continuation.L$5;
                rules = (Set)$continuation.L$4;
                query = (IntellijToolBuildQuery)$continuation.L$3;
                rawInterfaces = (RawInterfaces)$continuation.L$2;
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl95:
                    // 2 sources

                    $i$a$-run-RemoteToolsHelperImpl$installRemoteTool$tool$1 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (CancellationException c$iv) {
                    throw c$iv;
                }
                catch (Throwable t$iv) {
                    $i$a$-run-RemoteToolsHelperImpl$installRemoteTool$tool$1 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                }
                var9_26 = $i$a$-run-RemoteToolsHelperImpl$installRemoteTool$tool$1;
                v5 = Result.exceptionOrNull-impl((Object)var9_26);
                if (v5 != null) {
                    it = v5;
                    $i$a$-getOrElse-RemoteToolsHelperImpl$installRemoteTool$4 = false;
                    Logger.INSTANCE.error(it, "Failed to install remote tool in environment " + environmentId + ", hint: " + hint);
                    return Boxing.boxBoolean((boolean)false);
                }
                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String dumpRules(Set<? extends ToolSearchRule> rules) {
        return CollectionsKt.joinToString$default((Iterable)rules, (CharSequence)"\n", null, null, (int)0, null, RemoteToolsHelperImpl::dumpRules$lambda$11, (int)30, null);
    }

    private static final String getAvailableRemoteTools$lambda$1(RemoteToolsHelperImpl this$0, Set $rules) {
        return "Requested available tools query:\n" + this$0.dumpRules($rules);
    }

    private static final String getInstalledRemoteTools$lambda$4(RemoteToolsHelperImpl this$0, Set $rules) {
        return "Requested installed tools query:\n" + this$0.dumpRules($rules);
    }

    private static final String installRemoteTool$lambda$7(RemoteToolsHelperImpl this$0, Set $rules) {
        return "Requested tool installation by query:\n" + this$0.dumpRules($rules);
    }

    private static final CharSequence dumpRules$lambda$11(ToolSearchRule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return " -" + it.toPrettyString();
    }

    public /* synthetic */ RemoteToolsHelperImpl(String providerId, DevEnvironmentManager devEnvironmentManager, ToolHintParser toolHintParser, CoroutineScope pluginScope, DefaultConstructorMarker $constructor_marker) {
        this(providerId, devEnvironmentManager, toolHintParser, pluginScope);
    }

    public static final /* synthetic */ Object access$getRawInterfaces(RemoteToolsHelperImpl $this, String environmentId, Continuation $completion) {
        return $this.getRawInterfaces(environmentId, (Continuation<? super RawInterfaces>)$completion);
    }
}

