/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.localization;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.localization.LocalizableStringFactory;
import com.jetbrains.toolbox.gateway.localization.PluginI18nManagerImpl;
import com.jetbrains.toolbox.i18n.FakeLocalizableString;
import com.jetbrains.toolbox.i18n.FormattableLocalizableString;
import com.jetbrains.toolbox.i18n.I18nManager;
import com.jetbrains.toolbox.i18n.LocalizableStringImpl;
import java.util.Arrays;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class LocalizableStringFactoryImpl
implements LocalizableStringFactory {
    @NotNull
    private final PluginI18nManagerImpl pluginI18nManagerImpl;

    public LocalizableStringFactoryImpl(@NotNull PluginI18nManagerImpl pluginI18nManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)pluginI18nManagerImpl, (String)"pluginI18nManagerImpl");
        this.pluginI18nManagerImpl = pluginI18nManagerImpl;
    }

    @NotNull
    public LocalizableString ptrl(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return new LocalizableStringImpl(text2, this.pluginI18nManagerImpl);
    }

    @NotNull
    public LocalizableString ptrl(@NotNull String text2, Pair<String, String> ... args) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return new FormattableLocalizableString(null, text2, (I18nManager)this.pluginI18nManagerImpl, Arrays.copyOf(args, args.length));
    }

    @NotNull
    public LocalizableString ptrc(@NotNull String context2, @NotNull String text2, Pair<String, String> ... args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return new FormattableLocalizableString(context2, text2, (I18nManager)this.pluginI18nManagerImpl, Arrays.copyOf(args, args.length));
    }

    @NotNull
    public LocalizableString pnotr(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return FakeLocalizableString.box-impl(FakeLocalizableString.constructor-impl(text2));
    }
}

