/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.impl;

import com.jetbrains.toolbox.gateway.CustomLaunchService;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomLaunchServiceImpl
implements CustomLaunchService {
    @NotNull
    private final String providerId;
    @NotNull
    private final CustomLaunchService globalLaunchService;

    private CustomLaunchServiceImpl(String providerId, CustomLaunchService globalLaunchService) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)globalLaunchService, (String)"globalLaunchService");
        this.providerId = providerId;
        this.globalLaunchService = globalLaunchService;
    }

    @Override
    @Nullable
    public CustomLaunchService.Provider getProvider(@NotNull String environmentId) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        return this.globalLaunchService.getProvider(environmentId);
    }

    @Override
    public void addProvider(@NotNull String environmentId, @NotNull CustomLaunchService.Provider provider2) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        this.globalLaunchService.addProvider(this.getId(environmentId), provider2);
    }

    @Override
    public void removeProvider(@NotNull String environmentId) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        this.globalLaunchService.removeProvider(this.getId(environmentId));
    }

    private final String getId(String environmentId) {
        return new DevEnvironmentId(this.providerId, environmentId, null).toString();
    }

    public /* synthetic */ CustomLaunchServiceImpl(String providerId, CustomLaunchService globalLaunchService, DefaultConstructorMarker $constructor_marker) {
        this(providerId, globalLaunchService);
    }
}

