/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.impl;

import com.intellij.station.comms.common.services.remoteDev.ClientToToolboxMessage;
import com.intellij.station.comms.common.services.remoteDev.ToolboxToClientMessage;
import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentIssue;
import com.jetbrains.toolbox.api.ui.actions.RunnableActionDescription;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.gateway.impl.ClientConnectionIssueTracker;
import com.jetbrains.toolbox.gateway.impl.ProblemFix;
import com.jetbrains.toolbox.i18n.I18nManager;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nClientConnectionIssueTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientConnectionIssueTracker.kt\ncom/jetbrains/toolbox/gateway/impl/ClientConnectionIssueTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1563#2:140\n1634#2,3:141\n1563#2:144\n1634#2,3:145\n1563#2:148\n1634#2,3:149\n1563#2:152\n1634#2,3:153\n*S KotlinDebug\n*F\n+ 1 ClientConnectionIssueTracker.kt\ncom/jetbrains/toolbox/gateway/impl/ClientConnectionIssueTracker\n*L\n52#1:140\n52#1:141,3\n79#1:144\n79#1:145,3\n87#1:148\n87#1:149,3\n88#1:152\n88#1:153,3\n*E\n"})
public final class ClientConnectionIssueTracker {
    @NotNull
    private final ClientToToolboxMessage.ConnectionRequest targetEnvironment;
    @NotNull
    private final I18nManager i18n;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MutableStateFlow<EnvironmentIssue> issueFromPlugin;
    @NotNull
    private final MutableStateFlow<ToolboxToClientMessage.ProblemReport> issueFromTbx;
    @NotNull
    private final Flow<ToolboxToClientMessage.ProblemReport> issueFlow;
    @NotNull
    private final FixReferenceHolder[] fixReferences;
    @NotNull
    private AtomicLong lastFixId;

    public ClientConnectionIssueTracker(@NotNull ClientToToolboxMessage.ConnectionRequest targetEnvironment, @NotNull I18nManager i18n, @NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.targetEnvironment = targetEnvironment;
        this.i18n = i18n;
        this.scope = scope2;
        this.issueFromPlugin = StateFlowKt.MutableStateFlow(null);
        this.issueFromTbx = StateFlowKt.MutableStateFlow(null);
        this.issueFlow = (Flow)FlowKt.shareIn((Flow)((Flow)FlowExtensionsKt.combineStates((StateFlow)this.issueFromPlugin, (StateFlow)this.issueFromTbx, this.i18n.getState(), (arg_0, arg_1, arg_2) -> ClientConnectionIssueTracker.issueFlow$lambda$2(this, arg_0, arg_1, arg_2))), (CoroutineScope)this.scope, (SharingStarted)SharingStarted.Companion.getEagerly(), (int)3);
        int n = 0;
        FixReferenceHolder[] fixReferenceHolderArray = new FixReferenceHolder[2];
        ClientConnectionIssueTracker clientConnectionIssueTracker = this;
        while (n < 2) {
            int n2 = n++;
            fixReferenceHolderArray[n2] = null;
        }
        clientConnectionIssueTracker.fixReferences = fixReferenceHolderArray;
        this.lastFixId = new AtomicLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object collectPluginIssues(@NotNull Flow<EnvironmentIssue> flow, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof collectPluginIssues.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ClientConnectionIssueTracker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.collectPluginIssues(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)flow);
                $continuation.label = 1;
                v0 = flow.collect(new FlowCollector(this){
                    final /* synthetic */ ClientConnectionIssueTracker this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final Object emit(EnvironmentIssue state2, Continuation<? super Unit> $completion) {
                        Logger.INSTANCE.debug(() -> collectPluginIssues.2.emit$lambda$0(state2, this.this$0));
                        ClientConnectionIssueTracker.access$getIssueFromPlugin$p(this.this$0).setValue((Object)state2);
                        return Unit.INSTANCE;
                    }

                    private static final String emit$lambda$0(EnvironmentIssue $state, ClientConnectionIssueTracker this$0) {
                        return "Plugin reported " + $state + " on " + ClientConnectionIssueTracker.access$getTargetEnvironment$p(this$0);
                    }
                }, (Continuation)$continuation);
                ** if (v0 != var6_5) goto lbl19
lbl18:
                // 1 sources

                return var6_5;
lbl19:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                flow = (Flow)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable var3_6) {
                    throw var3_6;
                }
                finally {
                    Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, collectPluginIssues$lambda$0(com.jetbrains.toolbox.gateway.impl.ClientConnectionIssueTracker ), ()Ljava/lang/String;)((ClientConnectionIssueTracker)this));
                    this.issueFromPlugin.setValue(null);
                }
lbl33:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final ToolboxToClientMessage.ProblemReport asProblemReport(EnvironmentIssue environmentIssue, I18n i18n) {
        Collection<ProblemFix> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (environmentIssue == null) {
            return null;
        }
        Iterable iterable = environmentIssue.getFixes();
        String string = null;
        boolean bl = false;
        boolean bl2 = environmentIssue.isFatal();
        boolean bl3 = environmentIssue.isTransient();
        int n = 1;
        String string2 = LocalizableStringExKt.localize(environmentIssue.getDescription(), i18n);
        ClientConnectionIssueTracker clientConnectionIssueTracker = this;
        boolean $i$f$map = false;
        void var5_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RunnableActionDescription runnableActionDescription = (RunnableActionDescription)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(new ProblemFix(LocalizableStringExKt.localize(it.getLabel(), i18n), (Function0)new Function0<Unit>((Object)it){

                public final void invoke() {
                    ((RunnableActionDescription)this.receiver).run();
                }
            }, false, 4, null));
        }
        collection = (List)destination$iv$iv;
        return clientConnectionIssueTracker.problemWithFixes(string2, n, bl3, bl2, bl, string, (List<ProblemFix>)collection);
    }

    @NotNull
    public final Flow<ToolboxToClientMessage.ProblemReport> getIssueFlow() {
        return this.issueFlow;
    }

    private final void sendProblem(ToolboxToClientMessage.ProblemReport problemReport) {
        this.issueFromTbx.setValue((Object)problemReport);
    }

    /*
     * WARNING - void declaration
     */
    private final ToolboxToClientMessage.ProblemReport problemWithFixes(String message2, int idBias, boolean canSolveItself, boolean isFatal, boolean seamlessReconnectImpossible, String problemId, List<ProblemFix> actions2) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Collection<Function0<Unit>> collection;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        long id = !((Collection)actions2).isEmpty() ? this.lastFixId.incrementAndGet() * (long)2 + (long)idBias : 0L;
        Iterable iterable = actions2;
        long l = id;
        int n = idBias;
        Object object = this.fixReferences;
        boolean $i$f$map = false;
        void var12_15 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            ProblemFix problemFix = (ProblemFix)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAction());
        }
        Collection<Function0<Unit>> collection2 = collection = (List)destination$iv$iv;
        long l2 = l;
        object[n] = new FixReferenceHolder(l2, (List<? extends Function0<Unit>>)collection2);
        Iterable $this$map$iv2 = actions2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ProblemFix bl = (ProblemFix)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add(it.getText());
        }
        iterable = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = actions2;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProblemFix bl2 = (ProblemFix)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            object.add(new ToolboxToClientMessage.FixAction(it.getText(), it.isRepeatable()));
        }
        List list2 = (List)destination$iv$iv3;
        return new ToolboxToClientMessage.ProblemReport(id, message2, canSolveItself, isFatal, (List<String>)iterable, list2, seamlessReconnectImpossible, problemId);
    }

    public final void invokeFix(@NotNull ClientToToolboxMessage.ProblemFixExecute request2) {
        Function0 targetFix;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        FixReferenceHolder currentFixes = this.fixReferences[(int)(request2.getUid() % (long)2)];
        Object object = currentFixes;
        Function0 function0 = object != null && (object = ((FixReferenceHolder)object).getActions()) != null ? (Function0)CollectionsKt.getOrNull((List)object, (int)request2.getAction()) : (targetFix = null);
        if (!(currentFixes != null ? request2.getUid() == currentFixes.getUid() : false) || targetFix == null) {
            Logger.INSTANCE.info("Client for " + this.targetEnvironment + " requested execution of a stale fix " + request2 + " with current fixes " + currentFixes);
        } else {
            targetFix.invoke();
        }
    }

    public final void reportProblemWithFixes(@NotNull String message2, @NotNull List<ProblemFix> actions2, boolean seamlessReconnectImpossible, @Nullable String problemId) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        this.sendProblem(this.problemWithFixes(message2, 0, false, false, seamlessReconnectImpossible, problemId, actions2));
    }

    public static /* synthetic */ void reportProblemWithFixes$default(ClientConnectionIssueTracker clientConnectionIssueTracker, String string, List list2, boolean bl, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        clientConnectionIssueTracker.reportProblemWithFixes(string, list2, bl, string2);
    }

    public final void reportProgressProblem(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.sendProblem(ToolboxToClientMessage.Companion.progressProblem(message2));
    }

    public final void reportNonFatalProblem(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.sendProblem(ToolboxToClientMessage.Companion.nonFatalProblem(message2));
    }

    public final void clearToolboxIssue() {
        this.issueFromTbx.setValue(null);
    }

    private static final String collectPluginIssues$lambda$0(ClientConnectionIssueTracker this$0) {
        return "Plugin issue flow ended/cancelled on " + this$0.targetEnvironment;
    }

    private static final ToolboxToClientMessage.ProblemReport issueFlow$lambda$2(ClientConnectionIssueTracker this$0, EnvironmentIssue p, ToolboxToClientMessage.ProblemReport t2, I18n i2) {
        Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
        ToolboxToClientMessage.ProblemReport problemReport = t2;
        boolean bl = problemReport != null ? problemReport.isFatal() : false;
        if (bl) {
            return t2;
        }
        ToolboxToClientMessage.ProblemReport problemReport2 = this$0.asProblemReport(p, i2);
        if (problemReport2 == null) {
            problemReport2 = t2;
        }
        return problemReport2;
    }

    public static final /* synthetic */ MutableStateFlow access$getIssueFromPlugin$p(ClientConnectionIssueTracker $this) {
        return $this.issueFromPlugin;
    }

    public static final /* synthetic */ ClientToToolboxMessage.ConnectionRequest access$getTargetEnvironment$p(ClientConnectionIssueTracker $this) {
        return $this.targetEnvironment;
    }

    private static final class FixReferenceHolder {
        private final long uid;
        @NotNull
        private final List<Function0<Unit>> actions;

        public FixReferenceHolder(long uid2, @NotNull List<? extends Function0<Unit>> actions2) {
            Intrinsics.checkNotNullParameter(actions2, (String)"actions");
            this.uid = uid2;
            this.actions = actions2;
        }

        public final long getUid() {
            return this.uid;
        }

        @NotNull
        public final List<Function0<Unit>> getActions() {
            return this.actions;
        }

        public final long component1() {
            return this.uid;
        }

        @NotNull
        public final List<Function0<Unit>> component2() {
            return this.actions;
        }

        @NotNull
        public final FixReferenceHolder copy(long uid2, @NotNull List<? extends Function0<Unit>> actions2) {
            Intrinsics.checkNotNullParameter(actions2, (String)"actions");
            return new FixReferenceHolder(uid2, actions2);
        }

        public static /* synthetic */ FixReferenceHolder copy$default(FixReferenceHolder fixReferenceHolder, long l, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                l = fixReferenceHolder.uid;
            }
            if ((n & 2) != 0) {
                list2 = fixReferenceHolder.actions;
            }
            return fixReferenceHolder.copy(l, list2);
        }

        @NotNull
        public String toString() {
            return "FixReferenceHolder(uid=" + this.uid + ", actions=" + this.actions + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.uid);
            result2 = result2 * 31 + ((Object)this.actions).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FixReferenceHolder)) {
                return false;
            }
            FixReferenceHolder fixReferenceHolder = (FixReferenceHolder)other;
            if (this.uid != fixReferenceHolder.uid) {
                return false;
            }
            return Intrinsics.areEqual(this.actions, fixReferenceHolder.actions);
        }
    }
}

