/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.error;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.gateway.error.EnvironmentError;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class ToolError
extends EnvironmentError {
    private ToolError() {
    }

    public /* synthetic */ ToolError(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class CompatibleClientNotFound
    extends ToolError {
        @NotNull
        private final String tool;
        @NotNull
        private final String buildNumber;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;

        private CompatibleClientNotFound(String tool, String buildNumber) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
            super((DefaultConstructorMarker)null);
            this.tool = tool;
            this.buildNumber = buildNumber;
            this.message = "No compatible client found for " + ApplicationType.toString-impl(this.tool) + "-" + BuildNumber.toString-impl(this.buildNumber);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"tool", (Object)this.tool), TuplesKt.to((Object)"build", (Object)this.buildNumber)};
            this.localized = LocalizableStringExKt.trl("No compatible client found for {{tool}}-{{build}}", pairArray);
        }

        @NotNull
        public final String getTool-UtVBrGo() {
            return this.tool;
        }

        @NotNull
        public final String getBuildNumber-Y_E1uuk() {
            return this.buildNumber;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @NotNull
        public final String component1-UtVBrGo() {
            return this.tool;
        }

        @NotNull
        public final String component2-Y_E1uuk() {
            return this.buildNumber;
        }

        @NotNull
        public final CompatibleClientNotFound copy-dgXOpgo(@NotNull String tool, @NotNull String buildNumber) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
            return new CompatibleClientNotFound(tool, buildNumber, null);
        }

        public static /* synthetic */ CompatibleClientNotFound copy-dgXOpgo$default(CompatibleClientNotFound compatibleClientNotFound, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = compatibleClientNotFound.tool;
            }
            if ((n & 2) != 0) {
                string2 = compatibleClientNotFound.buildNumber;
            }
            return compatibleClientNotFound.copy-dgXOpgo(string, string2);
        }

        @Override
        @NotNull
        public String toString() {
            return "CompatibleClientNotFound(tool=" + ApplicationType.toString-impl(this.tool) + ", buildNumber=" + BuildNumber.toString-impl(this.buildNumber) + ")";
        }

        public int hashCode() {
            int result2 = ApplicationType.hashCode-impl(this.tool);
            result2 = result2 * 31 + BuildNumber.hashCode-impl(this.buildNumber);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompatibleClientNotFound)) {
                return false;
            }
            CompatibleClientNotFound compatibleClientNotFound = (CompatibleClientNotFound)other;
            if (!ApplicationType.equals-impl0(this.tool, compatibleClientNotFound.tool)) {
                return false;
            }
            return BuildNumber.equals-impl0(this.buildNumber, compatibleClientNotFound.buildNumber);
        }

        public /* synthetic */ CompatibleClientNotFound(String tool, String buildNumber, DefaultConstructorMarker $constructor_marker) {
            this(tool, buildNumber);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ToolNotFoundInFeed
    extends ToolError {
        @NotNull
        private final String toolId;
        @NotNull
        private final String latestBuildNumber;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;

        private ToolNotFoundInFeed(String toolId, String latestBuildNumber) {
            Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
            Intrinsics.checkNotNullParameter((Object)latestBuildNumber, (String)"latestBuildNumber");
            super((DefaultConstructorMarker)null);
            this.toolId = toolId;
            this.latestBuildNumber = latestBuildNumber;
            this.message = "Build " + this.toolId + "-" + this.latestBuildNumber + " is no longer available for installation. If possible, try updating to a more recent version";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"tool", (Object)this.toolId), TuplesKt.to((Object)"build", (Object)this.latestBuildNumber)};
            this.localized = LocalizableStringExKt.trl("Build {{tool}}-{{build}} is no longer available for installation. If possible, try updating to a more recent version", pairArray);
        }

        @NotNull
        public final String getToolId-UtVBrGo() {
            return this.toolId;
        }

        @NotNull
        public final String getLatestBuildNumber-Y_E1uuk() {
            return this.latestBuildNumber;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @NotNull
        public final String component1-UtVBrGo() {
            return this.toolId;
        }

        @NotNull
        public final String component2-Y_E1uuk() {
            return this.latestBuildNumber;
        }

        @NotNull
        public final ToolNotFoundInFeed copy-dgXOpgo(@NotNull String toolId, @NotNull String latestBuildNumber) {
            Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
            Intrinsics.checkNotNullParameter((Object)latestBuildNumber, (String)"latestBuildNumber");
            return new ToolNotFoundInFeed(toolId, latestBuildNumber, null);
        }

        public static /* synthetic */ ToolNotFoundInFeed copy-dgXOpgo$default(ToolNotFoundInFeed toolNotFoundInFeed, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = toolNotFoundInFeed.toolId;
            }
            if ((n & 2) != 0) {
                string2 = toolNotFoundInFeed.latestBuildNumber;
            }
            return toolNotFoundInFeed.copy-dgXOpgo(string, string2);
        }

        @Override
        @NotNull
        public String toString() {
            return "ToolNotFoundInFeed(toolId=" + ApplicationType.toString-impl(this.toolId) + ", latestBuildNumber=" + BuildNumber.toString-impl(this.latestBuildNumber) + ")";
        }

        public int hashCode() {
            int result2 = ApplicationType.hashCode-impl(this.toolId);
            result2 = result2 * 31 + BuildNumber.hashCode-impl(this.latestBuildNumber);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToolNotFoundInFeed)) {
                return false;
            }
            ToolNotFoundInFeed toolNotFoundInFeed = (ToolNotFoundInFeed)other;
            if (!ApplicationType.equals-impl0(this.toolId, toolNotFoundInFeed.toolId)) {
                return false;
            }
            return BuildNumber.equals-impl0(this.latestBuildNumber, toolNotFoundInFeed.latestBuildNumber);
        }

        public /* synthetic */ ToolNotFoundInFeed(String toolId, String latestBuildNumber, DefaultConstructorMarker $constructor_marker) {
            this(toolId, latestBuildNumber);
        }
    }
}

