/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.error;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.gateway.error.EnvironmentError;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import java.net.URL;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class CWMLobbyError
extends EnvironmentError {
    private CWMLobbyError() {
    }

    public /* synthetic */ CWMLobbyError(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class AuthenticationRequired
    extends CWMLobbyError {
        @NotNull
        private final URL url;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableStringEx localized;

        public AuthenticationRequired(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super((DefaultConstructorMarker)null);
            this.url = url;
            this.message = "Code With Me: Not authenticated:\n" + this.url;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"url", (Object)this.url.toString())};
            this.localized = LocalizableStringExKt.trl("Code With Me: Not authenticated:\n{{url}}", pairArray);
        }

        @NotNull
        public final URL getUrl() {
            return this.url;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableStringEx getLocalized() {
            return this.localized;
        }

        @NotNull
        public final URL component1() {
            return this.url;
        }

        @NotNull
        public final AuthenticationRequired copy(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new AuthenticationRequired(url);
        }

        public static /* synthetic */ AuthenticationRequired copy$default(AuthenticationRequired authenticationRequired, URL uRL, int n, Object object) {
            if ((n & 1) != 0) {
                uRL = authenticationRequired.url;
            }
            return authenticationRequired.copy(uRL);
        }

        @Override
        @NotNull
        public String toString() {
            return "AuthenticationRequired(url=" + this.url + ")";
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthenticationRequired)) {
                return false;
            }
            AuthenticationRequired authenticationRequired = (AuthenticationRequired)other;
            return Intrinsics.areEqual((Object)this.url, (Object)authenticationRequired.url);
        }
    }

    public static final class CWMError
    extends CWMLobbyError {
        @NotNull
        private final String message;
        @Nullable
        private final Throwable cause;
        @NotNull
        private final LocalizableString localized;

        public CWMError(@NotNull String message2, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super((DefaultConstructorMarker)null);
            this.message = message2;
            this.cause = cause;
            this.localized = LocalizableStringExKt.trl("Something went wrong during Code With Me session creation");
        }

        public /* synthetic */ CWMError(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @Nullable
        public Throwable getCause() {
            return this.cause;
        }

        public CWMError(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            String string = cause.getMessage();
            if (string == null) {
                string = "Code With Me: Unknown error";
            }
            this(string, cause);
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @NotNull
        public final String component1() {
            return this.message;
        }

        @Nullable
        public final Throwable component2() {
            return this.cause;
        }

        @NotNull
        public final CWMError copy(@NotNull String message2, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            return new CWMError(message2, cause);
        }

        public static /* synthetic */ CWMError copy$default(CWMError cWMError, String string, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                string = cWMError.message;
            }
            if ((n & 2) != 0) {
                throwable = cWMError.cause;
            }
            return cWMError.copy(string, throwable);
        }

        @Override
        @NotNull
        public String toString() {
            return "CWMError(message=" + this.message + ", cause=" + this.cause + ")";
        }

        public int hashCode() {
            int result2 = this.message.hashCode();
            result2 = result2 * 31 + (this.cause == null ? 0 : this.cause.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CWMError)) {
                return false;
            }
            CWMError cWMError = (CWMError)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)cWMError.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cause, (Object)cWMError.cause);
        }
    }

    public static final class CWMInternalServerError
    extends CWMLobbyError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableStringEx localized;

        public CWMInternalServerError(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super((DefaultConstructorMarker)null);
            this.message = message2;
            this.localized = LocalizableStringExKt.trl("Code With Me: Internal server error");
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableStringEx getLocalized() {
            return this.localized;
        }

        @NotNull
        public final String component1() {
            return this.message;
        }

        @NotNull
        public final CWMInternalServerError copy(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            return new CWMInternalServerError(message2);
        }

        public static /* synthetic */ CWMInternalServerError copy$default(CWMInternalServerError cWMInternalServerError, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = cWMInternalServerError.message;
            }
            return cWMInternalServerError.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "CWMInternalServerError(message=" + this.message + ")";
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CWMInternalServerError)) {
                return false;
            }
            CWMInternalServerError cWMInternalServerError = (CWMInternalServerError)other;
            return Intrinsics.areEqual((Object)this.message, (Object)cWMInternalServerError.message);
        }
    }

    public static final class CodeWithMeUnavailable
    extends CWMLobbyError {
        @Nullable
        private final String errorMessage;
        @Nullable
        private final String reason;
        @Nullable
        private final String learnMoreLink;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableStringEx localized;

        public CodeWithMeUnavailable(@Nullable String errorMessage, @Nullable String reason, @Nullable String learnMoreLink) {
            super((DefaultConstructorMarker)null);
            LocalizableStringEx localizableStringEx;
            this.errorMessage = errorMessage;
            this.reason = reason;
            this.learnMoreLink = learnMoreLink;
            this.message = "Code With Me unavailable";
            if (this.errorMessage == null) {
                localizableStringEx = LocalizableStringExKt.trl("Code With Me unavailable");
            } else {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"reason", (Object)this.errorMessage)};
                localizableStringEx = LocalizableStringExKt.trl("Code With Me unavailable: {{reason}}", pairArray);
            }
            this.localized = localizableStringEx;
        }

        @Nullable
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Nullable
        public final String getReason() {
            return this.reason;
        }

        @Nullable
        public final String getLearnMoreLink() {
            return this.learnMoreLink;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableStringEx getLocalized() {
            return this.localized;
        }

        @Nullable
        public final String component1() {
            return this.errorMessage;
        }

        @Nullable
        public final String component2() {
            return this.reason;
        }

        @Nullable
        public final String component3() {
            return this.learnMoreLink;
        }

        @NotNull
        public final CodeWithMeUnavailable copy(@Nullable String errorMessage, @Nullable String reason, @Nullable String learnMoreLink) {
            return new CodeWithMeUnavailable(errorMessage, reason, learnMoreLink);
        }

        public static /* synthetic */ CodeWithMeUnavailable copy$default(CodeWithMeUnavailable codeWithMeUnavailable, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = codeWithMeUnavailable.errorMessage;
            }
            if ((n & 2) != 0) {
                string2 = codeWithMeUnavailable.reason;
            }
            if ((n & 4) != 0) {
                string3 = codeWithMeUnavailable.learnMoreLink;
            }
            return codeWithMeUnavailable.copy(string, string2, string3);
        }

        @Override
        @NotNull
        public String toString() {
            return "CodeWithMeUnavailable(errorMessage=" + this.errorMessage + ", reason=" + this.reason + ", learnMoreLink=" + this.learnMoreLink + ")";
        }

        public int hashCode() {
            int result2 = this.errorMessage == null ? 0 : this.errorMessage.hashCode();
            result2 = result2 * 31 + (this.reason == null ? 0 : this.reason.hashCode());
            result2 = result2 * 31 + (this.learnMoreLink == null ? 0 : this.learnMoreLink.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CodeWithMeUnavailable)) {
                return false;
            }
            CodeWithMeUnavailable codeWithMeUnavailable = (CodeWithMeUnavailable)other;
            if (!Intrinsics.areEqual((Object)this.errorMessage, (Object)codeWithMeUnavailable.errorMessage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.reason, (Object)codeWithMeUnavailable.reason)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.learnMoreLink, (Object)codeWithMeUnavailable.learnMoreLink);
        }
    }

    public static final class MalformedCWMRequest
    extends CWMLobbyError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableStringEx localized;

        public MalformedCWMRequest(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super((DefaultConstructorMarker)null);
            this.message = message2;
            this.localized = LocalizableStringExKt.trl("Code With Me lobby server didn't accept the request");
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableStringEx getLocalized() {
            return this.localized;
        }

        @NotNull
        public final String component1() {
            return this.message;
        }

        @NotNull
        public final MalformedCWMRequest copy(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            return new MalformedCWMRequest(message2);
        }

        public static /* synthetic */ MalformedCWMRequest copy$default(MalformedCWMRequest malformedCWMRequest, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = malformedCWMRequest.message;
            }
            return malformedCWMRequest.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "MalformedCWMRequest(message=" + this.message + ")";
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MalformedCWMRequest)) {
                return false;
            }
            MalformedCWMRequest malformedCWMRequest = (MalformedCWMRequest)other;
            return Intrinsics.areEqual((Object)this.message, (Object)malformedCWMRequest.message);
        }
    }

    public static final class SessionNotFound
    extends CWMLobbyError {
        @NotNull
        private final String sessionId;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableStringEx localized;

        public SessionNotFound(@NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            super((DefaultConstructorMarker)null);
            this.sessionId = sessionId;
            this.message = "Code With Me session " + this.sessionId + " not found";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"sessionId", (Object)this.sessionId)};
            this.localized = LocalizableStringExKt.trl("Code With Me session {{sessionId}} not found", pairArray);
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableStringEx getLocalized() {
            return this.localized;
        }

        @NotNull
        public final String component1() {
            return this.sessionId;
        }

        @NotNull
        public final SessionNotFound copy(@NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            return new SessionNotFound(sessionId);
        }

        public static /* synthetic */ SessionNotFound copy$default(SessionNotFound sessionNotFound, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = sessionNotFound.sessionId;
            }
            return sessionNotFound.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "SessionNotFound(sessionId=" + this.sessionId + ")";
        }

        public int hashCode() {
            return this.sessionId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SessionNotFound)) {
                return false;
            }
            SessionNotFound sessionNotFound = (SessionNotFound)other;
            return Intrinsics.areEqual((Object)this.sessionId, (Object)sessionNotFound.sessionId);
        }
    }

    public static final class SessionsLimitReached
    extends CWMLobbyError {
        @Nullable
        private final String errorMessage;
        @Nullable
        private final Integer sessionLimit;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableStringEx localized;

        public SessionsLimitReached(@Nullable String errorMessage, @Nullable Integer sessionLimit) {
            super((DefaultConstructorMarker)null);
            LocalizableStringEx localizableStringEx;
            this.errorMessage = errorMessage;
            this.sessionLimit = sessionLimit;
            String string = this.message = this.sessionLimit == null ? "Code With Me: Maximum number of concurrent sessions is reached on lobby server, please try again later" : "Code With Me: Maximum number of concurrent sessions (" + this.sessionLimit + ") is reached on lobby server, please try again later";
            if (this.sessionLimit == null) {
                localizableStringEx = LocalizableStringExKt.trl("Code With Me: Maximum number of concurrent sessions is reached on lobby server, please try again later");
            } else {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"sessionLimit", (Object)this.sessionLimit.toString())};
                localizableStringEx = LocalizableStringExKt.trl("Code With Me: Maximum number of concurrent sessions ({{sessionLimit}}) is reached on lobby server, please try again later", pairArray);
            }
            this.localized = localizableStringEx;
        }

        @Nullable
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Nullable
        public final Integer getSessionLimit() {
            return this.sessionLimit;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableStringEx getLocalized() {
            return this.localized;
        }

        @Nullable
        public final String component1() {
            return this.errorMessage;
        }

        @Nullable
        public final Integer component2() {
            return this.sessionLimit;
        }

        @NotNull
        public final SessionsLimitReached copy(@Nullable String errorMessage, @Nullable Integer sessionLimit) {
            return new SessionsLimitReached(errorMessage, sessionLimit);
        }

        public static /* synthetic */ SessionsLimitReached copy$default(SessionsLimitReached sessionsLimitReached, String string, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = sessionsLimitReached.errorMessage;
            }
            if ((n2 & 2) != 0) {
                n = sessionsLimitReached.sessionLimit;
            }
            return sessionsLimitReached.copy(string, n);
        }

        @Override
        @NotNull
        public String toString() {
            return "SessionsLimitReached(errorMessage=" + this.errorMessage + ", sessionLimit=" + this.sessionLimit + ")";
        }

        public int hashCode() {
            int result2 = this.errorMessage == null ? 0 : this.errorMessage.hashCode();
            result2 = result2 * 31 + (this.sessionLimit == null ? 0 : ((Object)this.sessionLimit).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SessionsLimitReached)) {
                return false;
            }
            SessionsLimitReached sessionsLimitReached = (SessionsLimitReached)other;
            if (!Intrinsics.areEqual((Object)this.errorMessage, (Object)sessionsLimitReached.errorMessage)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sessionLimit, (Object)sessionsLimitReached.sessionLimit);
        }
    }
}

