/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.deploy;

import java.io.FilterInputStream;
import java.io.InputStream;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nProgressInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressInputStream.kt\ncom/jetbrains/toolbox/gateway/deploy/ProgressInputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class ProgressInputStream
extends FilterInputStream {
    private final long notifyEachNBytes;
    @NotNull
    private final Listener listener;
    private long total;
    private long notifiedAt;

    public ProgressInputStream(@NotNull InputStream inputStream, long notifyEachNBytes, @NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        super(inputStream);
        this.notifyEachNBytes = notifyEachNBytes;
        this.listener = listener;
    }

    public final long getTotal() {
        return this.total;
    }

    public final void setTotal(long l) {
        this.total = l;
    }

    public final long getNotifiedAt() {
        return this.notifiedAt;
    }

    public final void setNotifiedAt(long l) {
        this.notifiedAt = l;
    }

    @Override
    public int read() {
        int n;
        int it = n = super.read();
        boolean bl = false;
        if (it != -1) {
            this.increaseAndNotify(1L);
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        int n;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int it = n = super.read(b, off, len);
        boolean bl = false;
        this.increaseAndNotify(it);
        return n;
    }

    @Override
    public long skip(long n) {
        long l;
        long p0 = l = super.skip(n);
        boolean bl = false;
        this.increaseAndNotify(p0);
        return l;
    }

    private final void increaseAndNotify(long read2) {
        this.total += read2;
        long x = this.total / this.notifyEachNBytes;
        if (x != this.notifiedAt) {
            this.notifiedAt = x;
            this.listener.onProgress(this.total);
        }
    }

    public static interface Listener {
        public void onProgress(long var1);
    }
}

