/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.deploy;

import com.jetbrains.toolbox.agent.ListenOn;
import com.jetbrains.toolbox.api.remoteDev.connection.AgentConnectionHandle;
import com.jetbrains.toolbox.api.remoteDev.connection.HostTunnelConnector;
import com.jetbrains.toolbox.api.remoteDev.deploy.DeploymentSettings;
import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentDescription;
import com.jetbrains.toolbox.gateway.deploy.DeployProcess;
import com.jetbrains.toolbox.gateway.deploy.ssh.RunningAgentData;
import com.jetbrains.toolbox.gateway.deploy.ssh.SshToolboxAgentDeployer;
import com.jetbrains.toolbox.gateway.error.DeployError;
import com.jetbrains.toolbox.gateway.ssh.SshConnection;
import com.jetbrains.toolbox.gateway.ssh.SshPortForwarder;
import com.jetbrains.toolbox.gateway.ssh.SshProcess;
import com.jetbrains.toolbox.gateway.ssh.connection.SshHostTunnelConnector;
import com.jetbrains.toolbox.gateway.states.AgentState;
import java.net.InetAddress;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeployProcess {
    @NotNull
    private final SshToolboxAgentDeployer toolboxAgentDeployer;
    @NotNull
    private final CoroutineScope globalCoroutineScope;

    public DeployProcess(@NotNull SshToolboxAgentDeployer toolboxAgentDeployer, @NotNull CoroutineScope globalCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)toolboxAgentDeployer, (String)"toolboxAgentDeployer");
        Intrinsics.checkNotNullParameter((Object)globalCoroutineScope, (String)"globalCoroutineScope");
        this.toolboxAgentDeployer = toolboxAgentDeployer;
        this.globalCoroutineScope = globalCoroutineScope;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object startDeploy(@NotNull DeploymentInputs inputs, @NotNull CoroutineContext connectionContext, @NotNull Continuation<? super DeploymentOutputs> $completion) {
        if (!($completion instanceof startDeploy.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DeployProcess this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startDeploy(null, null, (Continuation<? super DeploymentOutputs>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                agentConnectionScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)connectionContext.plus((CoroutineContext)SupervisorKt.SupervisorJob((Job)JobKt.getJob((CoroutineContext)connectionContext))).plus((CoroutineContext)Dispatchers.getIO()));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)inputs);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)connectionContext);
                $continuation.L$2 = agentConnectionScope;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super RunningAgentData>, Object>(this, inputs, agentConnectionScope, null){
                    int label;
                    final /* synthetic */ DeployProcess this$0;
                    final /* synthetic */ DeploymentInputs $inputs;
                    final /* synthetic */ CoroutineScope $agentConnectionScope;
                    {
                        this.this$0 = $receiver;
                        this.$inputs = $inputs;
                        this.$agentConnectionScope = $agentConnectionScope;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = DeployProcess.access$getToolboxAgentDeployer$p(this.this$0).startAgent(this.$inputs.getSshConnection(), this.$inputs.getDeploymentSettings(), this.$agentConnectionScope, this.$inputs.getAgentState(), this.$inputs.getDescriptionState(), this.$inputs.getEnvironmentId(), this.$inputs.getForcefulDeploy(), (Continuation<? super RunningAgentData>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super RunningAgentData> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                agentConnectionScope = (CoroutineScope)$continuation.L$2;
                connectionContext = (CoroutineContext)$continuation.L$1;
                inputs = (DeploymentInputs)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                v1 = (RunningAgentData)v0;
                if (v1 == null) {
                    throw new DeployError.DeployTimeout(DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.SECONDS), null);
                }
                var5_8 = v1;
                agentCommand = var5_8.component1();
                connectionDetails = var5_8.component2();
                agentConnectionHandle = this.forwardAgentPort(agentCommand, connectionDetails.getListenOn(), connectionDetails.getAuthToken(), agentConnectionScope);
                return new DeploymentOutputs(agentConnectionHandle, new SshHostTunnelConnector(agentCommand, this.globalCoroutineScope));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final AgentConnectionHandle forwardAgentPort(SshProcess agentCommand, ListenOn listenOn, String authToken, CoroutineScope agentConnectionScope) {
        ListenOn listenOn2 = listenOn;
        if (!(listenOn2 instanceof ListenOn.Tcp)) {
            if (listenOn2 instanceof ListenOn.Uds) {
                throw new DeployError.SshDeployFailed("Toolbox Agent listens on unsupported protocol: " + ((ListenOn.Uds)listenOn).getPresentableAddress());
            }
            if (listenOn2 instanceof ListenOn.Udp) {
                throw new DeployError.SshDeployFailed("Toolbox Agent listens on unsupported protocol: " + ((ListenOn.Udp)listenOn).getPresentableAddress());
            }
            throw new NoWhenBranchMatchedException();
        }
        InetAddress inetAddress = InetAddress.getLoopbackAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getLoopbackAddress(...)");
        InetAddress inetAddress2 = InetAddress.getByName(((ListenOn.Tcp)listenOn).getAddress());
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getByName(...)");
        return SshPortForwarder.INSTANCE.forwardAgentConnection(inetAddress, inetAddress2, ((ListenOn.Tcp)listenOn).getPort(), authToken, agentCommand, agentConnectionScope);
    }

    public static final /* synthetic */ SshToolboxAgentDeployer access$getToolboxAgentDeployer$p(DeployProcess $this) {
        return $this.toolboxAgentDeployer;
    }

    public static final class DeploymentInputs {
        @NotNull
        private final String environmentId;
        @NotNull
        private final SshConnection sshConnection;
        @NotNull
        private final MutableStateFlow<AgentState> agentState;
        @NotNull
        private final MutableStateFlow<EnvironmentDescription> descriptionState;
        @NotNull
        private final DeploymentSettings deploymentSettings;
        private final boolean forcefulDeploy;

        public DeploymentInputs(@NotNull String environmentId, @NotNull SshConnection sshConnection, @NotNull MutableStateFlow<AgentState> agentState, @NotNull MutableStateFlow<EnvironmentDescription> descriptionState, @NotNull DeploymentSettings deploymentSettings, boolean forcefulDeploy) {
            Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
            Intrinsics.checkNotNullParameter((Object)sshConnection, (String)"sshConnection");
            Intrinsics.checkNotNullParameter(agentState, (String)"agentState");
            Intrinsics.checkNotNullParameter(descriptionState, (String)"descriptionState");
            Intrinsics.checkNotNullParameter((Object)deploymentSettings, (String)"deploymentSettings");
            this.environmentId = environmentId;
            this.sshConnection = sshConnection;
            this.agentState = agentState;
            this.descriptionState = descriptionState;
            this.deploymentSettings = deploymentSettings;
            this.forcefulDeploy = forcefulDeploy;
        }

        @NotNull
        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @NotNull
        public final SshConnection getSshConnection() {
            return this.sshConnection;
        }

        @NotNull
        public final MutableStateFlow<AgentState> getAgentState() {
            return this.agentState;
        }

        @NotNull
        public final MutableStateFlow<EnvironmentDescription> getDescriptionState() {
            return this.descriptionState;
        }

        @NotNull
        public final DeploymentSettings getDeploymentSettings() {
            return this.deploymentSettings;
        }

        public final boolean getForcefulDeploy() {
            return this.forcefulDeploy;
        }
    }

    public static final class DeploymentOutputs {
        @NotNull
        private final AgentConnectionHandle agentConnectionHandle;
        @NotNull
        private final HostTunnelConnector tunnelConnector;

        public DeploymentOutputs(@NotNull AgentConnectionHandle agentConnectionHandle, @NotNull HostTunnelConnector tunnelConnector) {
            Intrinsics.checkNotNullParameter((Object)agentConnectionHandle, (String)"agentConnectionHandle");
            Intrinsics.checkNotNullParameter((Object)tunnelConnector, (String)"tunnelConnector");
            this.agentConnectionHandle = agentConnectionHandle;
            this.tunnelConnector = tunnelConnector;
        }

        @NotNull
        public final AgentConnectionHandle getAgentConnectionHandle() {
            return this.agentConnectionHandle;
        }

        @NotNull
        public final HostTunnelConnector getTunnelConnector() {
            return this.tunnelConnector;
        }

        @NotNull
        public final AgentConnectionHandle component1() {
            return this.agentConnectionHandle;
        }

        @NotNull
        public final HostTunnelConnector component2() {
            return this.tunnelConnector;
        }

        @NotNull
        public final DeploymentOutputs copy(@NotNull AgentConnectionHandle agentConnectionHandle, @NotNull HostTunnelConnector tunnelConnector) {
            Intrinsics.checkNotNullParameter((Object)agentConnectionHandle, (String)"agentConnectionHandle");
            Intrinsics.checkNotNullParameter((Object)tunnelConnector, (String)"tunnelConnector");
            return new DeploymentOutputs(agentConnectionHandle, tunnelConnector);
        }

        public static /* synthetic */ DeploymentOutputs copy$default(DeploymentOutputs deploymentOutputs, AgentConnectionHandle agentConnectionHandle, HostTunnelConnector hostTunnelConnector, int n, Object object) {
            if ((n & 1) != 0) {
                agentConnectionHandle = deploymentOutputs.agentConnectionHandle;
            }
            if ((n & 2) != 0) {
                hostTunnelConnector = deploymentOutputs.tunnelConnector;
            }
            return deploymentOutputs.copy(agentConnectionHandle, hostTunnelConnector);
        }

        @NotNull
        public String toString() {
            return "DeploymentOutputs(agentConnectionHandle=" + this.agentConnectionHandle + ", tunnelConnector=" + this.tunnelConnector + ")";
        }

        public int hashCode() {
            int result2 = this.agentConnectionHandle.hashCode();
            result2 = result2 * 31 + this.tunnelConnector.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeploymentOutputs)) {
                return false;
            }
            DeploymentOutputs deploymentOutputs = (DeploymentOutputs)other;
            if (!Intrinsics.areEqual((Object)this.agentConnectionHandle, (Object)deploymentOutputs.agentConnectionHandle)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tunnelConnector, (Object)deploymentOutputs.tunnelConnector);
        }
    }
}

