/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway;

import com.jetbrains.toolbox.api.ui.DescriptionTree;
import com.jetbrains.toolbox.api.ui.components.TextType;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GatewayUiDialogsHandler {
    @NotNull
    public StateFlow<DialogModel> getCurrentDialog();

    public static sealed interface DialogModel {
        @NotNull
        public CompletableFuture<?> getFuture();

        public static final class Description
        implements DialogModel {
            @NotNull
            private final String title;
            @NotNull
            private final List<DescriptionTree> body;
            @NotNull
            private final List<String> buttons;
            @NotNull
            private final CompletableFuture<Integer> future;

            public Description(@NotNull String title2, @NotNull List<? extends DescriptionTree> body, @NotNull List<String> buttons, @NotNull CompletableFuture<Integer> future) {
                Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
                Intrinsics.checkNotNullParameter(body, (String)"body");
                Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
                Intrinsics.checkNotNullParameter(future, (String)"future");
                this.title = title2;
                this.body = body;
                this.buttons = buttons;
                this.future = future;
            }

            @NotNull
            public final String getTitle() {
                return this.title;
            }

            @NotNull
            public final List<DescriptionTree> getBody() {
                return this.body;
            }

            @NotNull
            public final List<String> getButtons() {
                return this.buttons;
            }

            @NotNull
            public CompletableFuture<Integer> getFuture() {
                return this.future;
            }

            @NotNull
            public final String component1() {
                return this.title;
            }

            @NotNull
            public final List<DescriptionTree> component2() {
                return this.body;
            }

            @NotNull
            public final List<String> component3() {
                return this.buttons;
            }

            @NotNull
            public final CompletableFuture<Integer> component4() {
                return this.future;
            }

            @NotNull
            public final Description copy(@NotNull String title2, @NotNull List<? extends DescriptionTree> body, @NotNull List<String> buttons, @NotNull CompletableFuture<Integer> future) {
                Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
                Intrinsics.checkNotNullParameter(body, (String)"body");
                Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
                Intrinsics.checkNotNullParameter(future, (String)"future");
                return new Description(title2, body, buttons, future);
            }

            public static /* synthetic */ Description copy$default(Description description2, String string, List list2, List list3, CompletableFuture completableFuture, int n, Object object) {
                if ((n & 1) != 0) {
                    string = description2.title;
                }
                if ((n & 2) != 0) {
                    list2 = description2.body;
                }
                if ((n & 4) != 0) {
                    list3 = description2.buttons;
                }
                if ((n & 8) != 0) {
                    completableFuture = description2.future;
                }
                return description2.copy(string, list2, list3, completableFuture);
            }

            @NotNull
            public String toString() {
                return "Description(title=" + this.title + ", body=" + this.body + ", buttons=" + this.buttons + ", future=" + this.future + ")";
            }

            public int hashCode() {
                int result2 = this.title.hashCode();
                result2 = result2 * 31 + ((Object)this.body).hashCode();
                result2 = result2 * 31 + ((Object)this.buttons).hashCode();
                result2 = result2 * 31 + this.future.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Description)) {
                    return false;
                }
                Description description2 = (Description)other;
                if (!Intrinsics.areEqual((Object)this.title, (Object)description2.title)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.body, description2.body)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.buttons, description2.buttons)) {
                    return false;
                }
                return Intrinsics.areEqual(this.future, description2.future);
            }
        }

        public static final class ErrorDescription
        implements DialogModel {
            @NotNull
            private final Throwable error;
            @NotNull
            private final CompletableFuture<Unit> future;

            public ErrorDescription(@NotNull Throwable error2, @NotNull CompletableFuture<Unit> future) {
                Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                Intrinsics.checkNotNullParameter(future, (String)"future");
                this.error = error2;
                this.future = future;
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }

            @NotNull
            public CompletableFuture<Unit> getFuture() {
                return this.future;
            }

            @NotNull
            public final Throwable component1() {
                return this.error;
            }

            @NotNull
            public final CompletableFuture<Unit> component2() {
                return this.future;
            }

            @NotNull
            public final ErrorDescription copy(@NotNull Throwable error2, @NotNull CompletableFuture<Unit> future) {
                Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                Intrinsics.checkNotNullParameter(future, (String)"future");
                return new ErrorDescription(error2, future);
            }

            public static /* synthetic */ ErrorDescription copy$default(ErrorDescription errorDescription, Throwable throwable, CompletableFuture completableFuture, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = errorDescription.error;
                }
                if ((n & 2) != 0) {
                    completableFuture = errorDescription.future;
                }
                return errorDescription.copy(throwable, completableFuture);
            }

            @NotNull
            public String toString() {
                return "ErrorDescription(error=" + this.error + ", future=" + this.future + ")";
            }

            public int hashCode() {
                int result2 = this.error.hashCode();
                result2 = result2 * 31 + this.future.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ErrorDescription)) {
                    return false;
                }
                ErrorDescription errorDescription = (ErrorDescription)other;
                if (!Intrinsics.areEqual((Object)this.error, (Object)errorDescription.error)) {
                    return false;
                }
                return Intrinsics.areEqual(this.future, errorDescription.future);
            }
        }

        public static final class Message
        implements DialogModel {
            @NotNull
            private final String title;
            @NotNull
            private final String body;
            @NotNull
            private final List<String> buttons;
            @NotNull
            private final CompletableFuture<Integer> future;

            public Message(@NotNull String title2, @NotNull String body, @NotNull List<String> buttons, @NotNull CompletableFuture<Integer> future) {
                Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
                Intrinsics.checkNotNullParameter(future, (String)"future");
                this.title = title2;
                this.body = body;
                this.buttons = buttons;
                this.future = future;
            }

            @NotNull
            public final String getTitle() {
                return this.title;
            }

            @NotNull
            public final String getBody() {
                return this.body;
            }

            @NotNull
            public final List<String> getButtons() {
                return this.buttons;
            }

            @NotNull
            public CompletableFuture<Integer> getFuture() {
                return this.future;
            }

            @NotNull
            public final String component1() {
                return this.title;
            }

            @NotNull
            public final String component2() {
                return this.body;
            }

            @NotNull
            public final List<String> component3() {
                return this.buttons;
            }

            @NotNull
            public final CompletableFuture<Integer> component4() {
                return this.future;
            }

            @NotNull
            public final Message copy(@NotNull String title2, @NotNull String body, @NotNull List<String> buttons, @NotNull CompletableFuture<Integer> future) {
                Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
                Intrinsics.checkNotNullParameter(future, (String)"future");
                return new Message(title2, body, buttons, future);
            }

            public static /* synthetic */ Message copy$default(Message message2, String string, String string2, List list2, CompletableFuture completableFuture, int n, Object object) {
                if ((n & 1) != 0) {
                    string = message2.title;
                }
                if ((n & 2) != 0) {
                    string2 = message2.body;
                }
                if ((n & 4) != 0) {
                    list2 = message2.buttons;
                }
                if ((n & 8) != 0) {
                    completableFuture = message2.future;
                }
                return message2.copy(string, string2, list2, completableFuture);
            }

            @NotNull
            public String toString() {
                return "Message(title=" + this.title + ", body=" + this.body + ", buttons=" + this.buttons + ", future=" + this.future + ")";
            }

            public int hashCode() {
                int result2 = this.title.hashCode();
                result2 = result2 * 31 + this.body.hashCode();
                result2 = result2 * 31 + ((Object)this.buttons).hashCode();
                result2 = result2 * 31 + this.future.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Message)) {
                    return false;
                }
                Message message2 = (Message)other;
                if (!Intrinsics.areEqual((Object)this.title, (Object)message2.title)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.body, (Object)message2.body)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.buttons, message2.buttons)) {
                    return false;
                }
                return Intrinsics.areEqual(this.future, message2.future);
            }
        }

        public static final class TextInput
        implements DialogModel {
            @NotNull
            private final String title;
            @NotNull
            private final String body;
            @NotNull
            private final TextType textType;
            @Nullable
            private final String initialValue;
            @NotNull
            private final String acceptButtonText;
            @NotNull
            private final String cancelButtonText;
            @NotNull
            private final CompletableFuture<String> future;

            public TextInput(@NotNull String title2, @NotNull String body, @NotNull TextType textType, @Nullable String initialValue, @NotNull String acceptButtonText, @NotNull String cancelButtonText, @NotNull CompletableFuture<String> future) {
                Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter((Object)textType, (String)"textType");
                Intrinsics.checkNotNullParameter((Object)acceptButtonText, (String)"acceptButtonText");
                Intrinsics.checkNotNullParameter((Object)cancelButtonText, (String)"cancelButtonText");
                Intrinsics.checkNotNullParameter(future, (String)"future");
                this.title = title2;
                this.body = body;
                this.textType = textType;
                this.initialValue = initialValue;
                this.acceptButtonText = acceptButtonText;
                this.cancelButtonText = cancelButtonText;
                this.future = future;
            }

            @NotNull
            public final String getTitle() {
                return this.title;
            }

            @NotNull
            public final String getBody() {
                return this.body;
            }

            @NotNull
            public final TextType getTextType() {
                return this.textType;
            }

            @Nullable
            public final String getInitialValue() {
                return this.initialValue;
            }

            @NotNull
            public final String getAcceptButtonText() {
                return this.acceptButtonText;
            }

            @NotNull
            public final String getCancelButtonText() {
                return this.cancelButtonText;
            }

            @NotNull
            public CompletableFuture<String> getFuture() {
                return this.future;
            }

            @NotNull
            public final String component1() {
                return this.title;
            }

            @NotNull
            public final String component2() {
                return this.body;
            }

            @NotNull
            public final TextType component3() {
                return this.textType;
            }

            @Nullable
            public final String component4() {
                return this.initialValue;
            }

            @NotNull
            public final String component5() {
                return this.acceptButtonText;
            }

            @NotNull
            public final String component6() {
                return this.cancelButtonText;
            }

            @NotNull
            public final CompletableFuture<String> component7() {
                return this.future;
            }

            @NotNull
            public final TextInput copy(@NotNull String title2, @NotNull String body, @NotNull TextType textType, @Nullable String initialValue, @NotNull String acceptButtonText, @NotNull String cancelButtonText, @NotNull CompletableFuture<String> future) {
                Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter((Object)textType, (String)"textType");
                Intrinsics.checkNotNullParameter((Object)acceptButtonText, (String)"acceptButtonText");
                Intrinsics.checkNotNullParameter((Object)cancelButtonText, (String)"cancelButtonText");
                Intrinsics.checkNotNullParameter(future, (String)"future");
                return new TextInput(title2, body, textType, initialValue, acceptButtonText, cancelButtonText, future);
            }

            public static /* synthetic */ TextInput copy$default(TextInput textInput, String string, String string2, TextType textType, String string3, String string4, String string5, CompletableFuture completableFuture, int n, Object object) {
                if ((n & 1) != 0) {
                    string = textInput.title;
                }
                if ((n & 2) != 0) {
                    string2 = textInput.body;
                }
                if ((n & 4) != 0) {
                    textType = textInput.textType;
                }
                if ((n & 8) != 0) {
                    string3 = textInput.initialValue;
                }
                if ((n & 0x10) != 0) {
                    string4 = textInput.acceptButtonText;
                }
                if ((n & 0x20) != 0) {
                    string5 = textInput.cancelButtonText;
                }
                if ((n & 0x40) != 0) {
                    completableFuture = textInput.future;
                }
                return textInput.copy(string, string2, textType, string3, string4, string5, completableFuture);
            }

            @NotNull
            public String toString() {
                return "TextInput(title=" + this.title + ", body=" + this.body + ", textType=" + this.textType + ", initialValue=" + this.initialValue + ", acceptButtonText=" + this.acceptButtonText + ", cancelButtonText=" + this.cancelButtonText + ", future=" + this.future + ")";
            }

            public int hashCode() {
                int result2 = this.title.hashCode();
                result2 = result2 * 31 + this.body.hashCode();
                result2 = result2 * 31 + this.textType.hashCode();
                result2 = result2 * 31 + (this.initialValue == null ? 0 : this.initialValue.hashCode());
                result2 = result2 * 31 + this.acceptButtonText.hashCode();
                result2 = result2 * 31 + this.cancelButtonText.hashCode();
                result2 = result2 * 31 + this.future.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextInput)) {
                    return false;
                }
                TextInput textInput = (TextInput)other;
                if (!Intrinsics.areEqual((Object)this.title, (Object)textInput.title)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.body, (Object)textInput.body)) {
                    return false;
                }
                if (this.textType != textInput.textType) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.initialValue, (Object)textInput.initialValue)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.acceptButtonText, (Object)textInput.acceptButtonText)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.cancelButtonText, (Object)textInput.cancelButtonText)) {
                    return false;
                }
                return Intrinsics.areEqual(this.future, textInput.future);
            }
        }
    }
}

