/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway;

import com.jetbrains.toolbox.protocolhandler.ProtocolHandler;
import com.jetbrains.toolbox.settings.InternalSettings;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import java.net.URI;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GatewayEnableProtocolHandler
implements ProtocolHandler {
    @NotNull
    private final SettingsManager settingsManager;

    public GatewayEnableProtocolHandler(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        this.settingsManager = settingsManager;
    }

    @Override
    public boolean canHandle(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)uri.getHost(), (Object)"gateway") && (Intrinsics.areEqual((Object)uri.getPath(), (Object)"/enable") || Intrinsics.areEqual((Object)uri.getPath(), (Object)"/disable"));
    }

    @Override
    @Nullable
    public Object handle(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        if (Intrinsics.areEqual((Object)uri.getPath(), (Object)"/enable")) {
            this.enable(true);
        } else if (Intrinsics.areEqual((Object)uri.getPath(), (Object)"/disable")) {
            this.enable(false);
        }
        return Unit.INSTANCE;
    }

    private final void enable(boolean value2) {
        this.settingsManager.updateSettings((Function1<? super SelfSettings, SelfSettings>)((Function1)arg_0 -> GatewayEnableProtocolHandler.enable$lambda$0(value2, arg_0)));
    }

    @Override
    public boolean getImpliesUiMode() {
        return ProtocolHandler.super.getImpliesUiMode();
    }

    private static final SelfSettings enable$lambda$0(boolean $value, SelfSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SelfSettings.copy$default(it, InternalSettings.copy-U8J3xAA$default(it.getInternal(), false, null, null, null, 0L, 0L, 0L, false, 0L, $value, false, false, false, false, false, false, null, 0L, false, 0L, 0L, 0L, 0L, false, false, false, null, 0L, null, null, null, null, false, false, false, false, false, false, false, -513, 127, null), null, false, false, null, 0, null, null, null, null, null, null, null, null, null, null, null, 131070, null);
    }
}

