/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.feed.SignatureManagerKt;
import java.io.Closeable;
import java.io.InputStream;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSignatureManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureManager.kt\ncom/jetbrains/toolbox/feed/SignatureManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1#2:126\n1#2:141\n1563#3:127\n1634#3,3:128\n1617#3,9:131\n1869#3:140\n1870#3:142\n1626#3:143\n1563#3:144\n1634#3,3:145\n1563#3:148\n1634#3,3:149\n*S KotlinDebug\n*F\n+ 1 SignatureManager.kt\ncom/jetbrains/toolbox/feed/SignatureManager\n*L\n75#1:141\n47#1:127\n47#1:128,3\n75#1:131,9\n75#1:140\n75#1:142\n75#1:143\n78#1:144\n78#1:145,3\n88#1:148\n88#1:149,3\n*E\n"})
public final class SignatureManager {
    @NotNull
    private final Lazy trustedRoot$delegate;

    public SignatureManager(@NotNull InputStream trustedRootStream) {
        Intrinsics.checkNotNullParameter((Object)trustedRootStream, (String)"trustedRootStream");
        this.trustedRoot$delegate = LazyKt.lazy(() -> SignatureManager.trustedRoot_delegate$lambda$2(trustedRootStream));
    }

    public /* synthetic */ SignatureManager(InputStream inputStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            InputStream inputStream2 = SignatureManager.class.getClassLoader().getResourceAsStream("feed-ca.crt");
            if (inputStream2 == null) {
                boolean bl = false;
                String string = "Failed to get rootCA";
                throw new IllegalStateException(string.toString());
            }
            inputStream = inputStream2;
        }
        this(inputStream);
    }

    private final X509Certificate getTrustedRoot() {
        Lazy lazy = this.trustedRoot$delegate;
        return (X509Certificate)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final <T> ResultWithCerts<T> consumeAndVerify(@NotNull InputStream feedXzSignedInputStream, @NotNull Function1<? super InputStream, ? extends T> consume) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        SignerInformation signer;
        Collection collection;
        Iterator $this$mapTo$iv$iv2;
        Object it;
        CMSSignedDataParser cMSSignedDataParser;
        Intrinsics.checkNotNullParameter((Object)feedXzSignedInputStream, (String)"feedXzSignedInputStream");
        Intrinsics.checkNotNullParameter(consume, (String)"consume");
        BcDigestCalculatorProvider digestCalculatorProvider = new BcDigestCalculatorProvider();
        try {
            cMSSignedDataParser = new CMSSignedDataParser(digestCalculatorProvider, feedXzSignedInputStream);
        }
        catch (Throwable t2) {
            SignatureManagerKt.access$getLogger$p().warn("Unable to read DER-encoded CMS from input data. " + t2.getMessage(), t2);
            throw new Exception("Unable to read DER-encoded CMS from input data", t2);
        }
        CMSSignedDataParser parser = cMSSignedDataParser;
        Closeable t2 = parser.getSignedContent().getContentStream();
        Throwable throwable = null;
        try {
            it = (InputStream)t2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            it = consume.invoke(it);
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)t2, (Throwable)throwable);
        }
        Object result2 = it;
        CertStore certStore = new JcaCertStoreBuilder().addCertificates(parser.getCertificates()).build();
        Collection<? extends Certificate> collection2 = certStore.getCertificates(null);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getCertificates(...)");
        Iterable $this$map$iv2 = collection2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv322 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            void it2;
            Object item$iv$iv = iterator2.next();
            Certificate certificate2 = (Certificate)item$iv$iv;
            collection = destination$iv$iv322;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            collection.add((X509Certificate)it2);
        }
        Set intermediateCerts = CollectionsKt.toSet((Iterable)((List)destination$iv$iv322));
        WhitelistedSignatureAlgorithmIdentifierFinder algorithmIdentifierFinder = new WhitelistedSignatureAlgorithmIdentifierFinder();
        SignerInformationStore signerInformationStore = parser.getSignerInfos();
        Intrinsics.checkNotNullExpressionValue((Object)signerInformationStore, (String)"getSignerInfos(...)");
        List signers = CollectionsKt.toList((Iterable)signerInformationStore);
        if (signers.isEmpty()) {
            throw new IllegalStateException("CMS content is not signed (empty signers list)".toString());
        }
        $this$mapTo$iv$iv2 = ((Iterable)signers).iterator();
        int destination$iv$iv322 = 0;
        while ($this$mapTo$iv$iv2.hasNext()) {
            Certificate cert;
            JcaSignerInfoVerifierBuilder bl;
            int index = destination$iv$iv322++;
            signer = (SignerInformation)$this$mapTo$iv$iv2.next();
            Collection<? extends Certificate> collection3 = certStore.getCertificates(new JcaX509CertSelectorConverter().getCertSelector(signer.getSID()));
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"getCertificates(...)");
            if ((Certificate)CollectionsKt.firstOrNull((Iterable)collection3) == null) {
                throw new IllegalStateException(("Can't find signer certificate in embedded certificates for signature #" + index).toString());
            }
            JcaSignerInfoVerifierBuilder it3 = bl = new JcaSignerInfoVerifierBuilder(digestCalculatorProvider);
            boolean bl2 = false;
            it3.setSignatureAlgorithmFinder(algorithmIdentifierFinder);
            SignerInformationVerifier verifier = bl.build((X509Certificate)cert);
            if (!signer.verify(verifier)) {
                throw new IllegalStateException(("Can't verify signature hash correctness for signature #" + index).toString());
            }
            this.verifyCertificate((X509Certificate)cert, SetsKt.setOf((Object)this.getTrustedRoot()), intermediateCerts);
        }
        Iterable destination$iv$iv322 = signers;
        boolean $i$f$mapNotNull = false;
        signer = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object bl2 = $this$forEach$iv$iv$iv.iterator();
        while (bl2.hasNext()) {
            Certificate it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl2.next();
            boolean bl = false;
            SignerInformation signer2 = (SignerInformation)element$iv$iv;
            boolean bl3 = false;
            Collection<? extends Certificate> collection4 = certStore.getCertificates(new JcaX509CertSelectorConverter().getCertSelector(signer2.getSID()));
            Intrinsics.checkNotNullExpressionValue(collection4, (String)"getCertificates(...)");
            if ((Certificate)CollectionsKt.firstOrNull((Iterable)collection4) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map2 = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cert;
            bl2 = (Certificate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)cert, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            collection.add((X509Certificate)cert);
        }
        List dataCerts = (List)destination$iv$iv;
        return new ResultWithCerts<Object>(result2, dataCerts);
    }

    /*
     * WARNING - void declaration
     */
    private final PKIXCertPathBuilderResult verifyCertificate(X509Certificate cert, Set<? extends X509Certificate> trustedRootCerts, Set<? extends X509Certificate> intermediateCerts) {
        void $this$mapTo$iv$iv;
        X509CertSelector x509CertSelector;
        X509CertSelector it = x509CertSelector = new X509CertSelector();
        boolean bl = false;
        it.setCertificate(cert);
        X509CertSelector targetCertificateSelector = x509CertSelector;
        Iterable $this$map$iv = trustedRootCerts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            X509Certificate x509Certificate = (X509Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new TrustAnchor((X509Certificate)it2, null));
        }
        Set trustAnchors = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)targetCertificateSelector);
        pkixParams.setRevocationEnabled(false);
        CertStore intermediateCertStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters((Collection)intermediateCerts));
        pkixParams.addCertStore(intermediateCertStore);
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
        CertPathBuilderResult certPathBuilderResult = builder.build(pkixParams);
        Intrinsics.checkNotNull((Object)certPathBuilderResult, (String)"null cannot be cast to non-null type java.security.cert.PKIXCertPathBuilderResult");
        return (PKIXCertPathBuilderResult)certPathBuilderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final X509Certificate trustedRoot_delegate$lambda$2(InputStream $trustedRootStream) {
        X509Certificate x509Certificate;
        Closeable closeable = $trustedRootStream;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            CertificateFactory factory2 = CertificateFactory.getInstance("X.509");
            Certificate certificate2 = factory2.generateCertificate(input);
            Intrinsics.checkNotNull((Object)certificate2, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            x509Certificate = (X509Certificate)certificate2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return x509Certificate;
    }

    public SignatureManager() {
        this(null, 1, null);
    }

    public static final class ResultWithCerts<T> {
        private final T result;
        @NotNull
        private final Iterable<X509Certificate> certs;

        public ResultWithCerts(T result2, @NotNull Iterable<? extends X509Certificate> certs) {
            Intrinsics.checkNotNullParameter(certs, (String)"certs");
            this.result = result2;
            this.certs = certs;
        }

        public final T getResult() {
            return this.result;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @SourceDebugExtension(value={"SMAP\nSignatureManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureManager.kt\ncom/jetbrains/toolbox/feed/SignatureManager$WhitelistedSignatureAlgorithmIdentifierFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n2746#2,3:126\n*S KotlinDebug\n*F\n+ 1 SignatureManager.kt\ncom/jetbrains/toolbox/feed/SignatureManager$WhitelistedSignatureAlgorithmIdentifierFinder\n*L\n117#1:126,3\n*E\n"})
    private static final class WhitelistedSignatureAlgorithmIdentifierFinder
    implements SignatureAlgorithmIdentifierFinder {
        @NotNull
        private final List<String> whitelistedAlgNamePrefixes;
        @NotNull
        private final DefaultSignatureAlgorithmIdentifierFinder default;

        public WhitelistedSignatureAlgorithmIdentifierFinder() {
            Object[] objectArray = new String[]{"SHA256", "SHA384", "SHA512", "SHA3-256", "SHA3-384", "SHA3-512"};
            this.whitelistedAlgNamePrefixes = CollectionsKt.listOf((Object[])objectArray);
            this.default = new DefaultSignatureAlgorithmIdentifierFinder();
        }

        @Override
        @NotNull
        public AlgorithmIdentifier find(@NotNull String algName) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)algName, (String)"algName");
                Iterable $this$none$iv = this.whitelistedAlgNamePrefixes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String prefix = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)algName, (String)prefix, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (bl) {
                throw new IllegalStateException(("Signature algorithm " + algName + " is not whitelisted").toString());
            }
            AlgorithmIdentifier algorithmIdentifier2 = this.default.find(algName);
            Intrinsics.checkNotNullExpressionValue((Object)algorithmIdentifier2, (String)"find(...)");
            return algorithmIdentifier2;
        }
    }
}

