/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

public final class IsoLocalDateTimeSerializer
implements KSerializer<kotlinx.datetime.LocalDateTime> {
    @NotNull
    public static final IsoLocalDateTimeSerializer INSTANCE = new IsoLocalDateTimeSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"LocalDateTime", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

    private IsoLocalDateTimeSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public kotlinx.datetime.LocalDateTime deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        LocalDateTime localDateTime = LocalDateTime.from(DateTimeFormatter.ISO_DATE_TIME.parse(decoder.decodeString()));
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"from(...)");
        return ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime);
    }

    public void serialize(@NotNull Encoder encoder, @NotNull kotlinx.datetime.LocalDateTime value2) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        String string = DateTimeFormatter.ISO_DATE_TIME.format(ConvertersKt.toJavaLocalDateTime((kotlinx.datetime.LocalDateTime)value2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        encoder.encodeString(string);
    }
}

