/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.RemoteFeed;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.feed.ApplicationMajorVersionKt;
import com.jetbrains.toolbox.feed.Build;
import com.jetbrains.toolbox.feed.DataPiecesKt;
import com.jetbrains.toolbox.feed.FeedConvertorKt;
import com.jetbrains.toolbox.feed.FeedProviderImpl;
import com.jetbrains.toolbox.feed.FeedV1;
import com.jetbrains.toolbox.feed.FeedV2;
import com.jetbrains.toolbox.feed.PluginId;
import com.jetbrains.toolbox.feed.RemoteFeedItem;
import com.jetbrains.toolbox.feed.RemoteOs;
import com.jetbrains.toolbox.feed.RemotePatchItem;
import com.jetbrains.toolbox.feed.Service;
import com.jetbrains.toolbox.feed.Tool;
import com.jetbrains.toolbox.feed.ToolVersion;
import com.jetbrains.toolbox.manager.FeedProvider;
import com.jetbrains.toolbox.manager.FeedV2WithSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nFeedProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeedProviderImpl.kt\ncom/jetbrains/toolbox/feed/FeedProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1563#2:38\n1634#2,2:39\n1491#2:41\n1516#2,3:42\n1519#2,3:52\n1969#2,5:58\n1975#2,8:64\n1636#2:73\n382#3,7:45\n126#4:55\n153#4,2:56\n155#4:72\n1#5:63\n*S KotlinDebug\n*F\n+ 1 FeedProviderImpl.kt\ncom/jetbrains/toolbox/feed/FeedProviderImpl\n*L\n24#1:38\n24#1:39,2\n25#1:41\n25#1:42,3\n25#1:52,3\n27#1:58,5\n27#1:64,8\n24#1:73\n25#1:45,7\n26#1:55\n26#1:56,2\n26#1:72\n*E\n"})
public final class FeedProviderImpl
implements FeedProvider {
    @NotNull
    private final RemoteOs currentRemoteOs;
    @NotNull
    private final StateFlow<FeedV2WithSource> feed;

    public FeedProviderImpl(@NotNull StateFlow<RemoteFeed> feedV1, @NotNull RemoteOs currentRemoteOs) {
        Intrinsics.checkNotNullParameter(feedV1, (String)"feedV1");
        Intrinsics.checkNotNullParameter((Object)((Object)currentRemoteOs), (String)"currentRemoteOs");
        this.currentRemoteOs = currentRemoteOs;
        this.feed = FlowExtensionsKt.mapState(feedV1, arg_0 -> FeedProviderImpl.feed$lambda$5(this, arg_0));
    }

    @Override
    @NotNull
    public StateFlow<FeedV2WithSource> getFeed() {
        return this.feed;
    }

    /*
     * WARNING - void declaration
     */
    private static final FeedV2WithSource feed$lambda$5(FeedProviderImpl this$0, RemoteFeed f) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        FeedV1 v1WithoutToolboxAndForeignPatches2 = new FeedV1(f, this$0){
            private final List<RemoteFeedItem> feedItems;
            private final List<Service> services;
            private final List<RemotePatchItem> patches;
            private final Map<PluginId, List<String>> enterprisePluginHashes;
            {
                Object it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = $f.getFeedItems();
                feed.1.v1WithoutToolboxAndForeignPatches.1 var12_4 = this;
                boolean $i$f$filter = false;
                void var5_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (RemoteFeedItem)element$iv$iv;
                    boolean bl = false;
                    if (!(((RemoteFeedItem)it).getPackage().getOs() == FeedProviderImpl.access$getCurrentRemoteOs$p($receiver))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var12_4.feedItems = (List)destination$iv$iv;
                this.services = $f.getServices();
                $this$filter$iv = $f.getPatches();
                var12_4 = this;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (RemotePatchItem)element$iv$iv;
                    boolean bl = false;
                    if (!(((RemotePatchItem)it).getOs() == FeedProviderImpl.access$getCurrentRemoteOs$p($receiver))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var12_4.patches = (List)destination$iv$iv;
                this.enterprisePluginHashes = $f.getEnterprisePluginHashes();
            }

            public List<RemoteFeedItem> getFeedItems() {
                return this.feedItems;
            }

            public List<Service> getServices() {
                return this.services;
            }

            public List<RemotePatchItem> getPatches() {
                return this.patches;
            }

            public Map<PluginId, List<String>> getEnterprisePluginHashes() {
                return this.enterprisePluginHashes;
            }
        };
        FeedV2 v2full = FeedConvertorKt.toV2(v1WithoutToolboxAndForeignPatches2);
        Iterable $this$map$iv = v2full.getTools();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void $this$groupByTo$iv$iv;
            void tool;
            Tool tool2 = (Tool)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object $this$groupBy$iv = tool.getToolVersions();
            boolean $i$f$groupBy = false;
            Iterable iterable2 = $this$groupBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                ToolVersion it = (ToolVersion)element$iv$iv;
                boolean bl2 = false;
                Pair key$iv$iv = TuplesKt.to((Object)ApplicationMajorVersionKt.orMax(it.getMajorVersion()), (Object)DataPiecesKt.orDefault(it.getQuality()));
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$groupByTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator<Object> iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object t2;
                Map.Entry item$iv$iv2;
                Map.Entry entry = item$iv$iv2 = (Map.Entry)iterator2.next();
                Object object = destination$iv$iv2;
                boolean bl4 = false;
                List versions = (List)entry.getValue();
                Iterable $this$maxBy$iv = versions;
                boolean $i$f$maxByOrThrow = false;
                Iterator iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t2 = maxElem$iv;
                } else {
                    ToolVersion version = (ToolVersion)maxElem$iv;
                    boolean bl5 = false;
                    Iterator iterator3 = ((Iterable)version.getBuilds()).iterator();
                    if (!iterator3.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object it = (Build)iterator3.next();
                    boolean bl6 = false;
                    it = BuildNumber.box-impl(((Build)it).getNumber-Y_E1uuk());
                    while (iterator3.hasNext()) {
                        Build it2 = (Build)iterator3.next();
                        $i$a$-maxOf-FeedProviderImpl$feed$1$1$lastPatchVersions$2$1$1 = false;
                        Comparable comparable = BuildNumber.box-impl(it2.getNumber-Y_E1uuk());
                        if (it.compareTo(comparable) >= 0) continue;
                        it = comparable;
                    }
                    Comparable maxValue$iv = BuildNumber.box-impl(((BuildNumber)it).unbox-impl());
                    do {
                        Object e$iv = iterator$iv.next();
                        ToolVersion version2 = (ToolVersion)e$iv;
                        $i$a$-maxByOrThrow-FeedProviderImpl$feed$1$1$lastPatchVersions$2$1 = false;
                        Iterator iterator4 = ((Iterable)version2.getBuilds()).iterator();
                        if (!iterator4.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Build it3 = (Build)iterator4.next();
                        $i$a$-maxOf-FeedProviderImpl$feed$1$1$lastPatchVersions$2$1$1 = false;
                        Comparable comparable = BuildNumber.box-impl(it3.getNumber-Y_E1uuk());
                        while (iterator4.hasNext()) {
                            Build it4 = (Build)iterator4.next();
                            $i$a$-maxOf-FeedProviderImpl$feed$1$1$lastPatchVersions$2$1$1 = false;
                            Comparable comparable2 = BuildNumber.box-impl(it4.getNumber-Y_E1uuk());
                            if (comparable.compareTo(comparable2) >= 0) continue;
                            comparable = comparable2;
                        }
                        Comparable v$iv = BuildNumber.box-impl(((BuildNumber)comparable).unbox-impl());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t2 = maxElem$iv;
                }
                object.add((ToolVersion)t2);
            }
            List lastPatchVersions = (List)destination$iv$iv2;
            collection.add(Tool.copy-84cb8go$default((Tool)tool, null, null, null, null, null, null, 0, null, null, null, null, null, false, null, null, lastPatchVersions, null, null, false, 491519, null));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        Map<PluginId, Set<String>> map2 = v2full.getEnterprisePluginHashes();
        String string = f.getSource-PEmOHMg();
        Collection collection = v2full.getServices();
        Collection collection2 = (List)destination$iv$iv;
        return new FeedV2WithSource(collection2, collection, string, map2, defaultConstructorMarker);
    }

    public static final /* synthetic */ RemoteOs access$getCurrentRemoteOs$p(FeedProviderImpl $this) {
        return $this.currentRemoteOs;
    }
}

