/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.DataUrl;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nDataUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataUrl.kt\ncom/jetbrains/toolbox/feed/DataUrlKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class DataUrlKt {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.jetbrains.toolbox.feed.DataUrl");
    private static final Pattern dataUrlRegex = Pattern.compile("data:([^;]+)((?:;base64)?),(.*)");

    @Nullable
    public static final Pair<String, byte[]> mediaTypeToRawData-Cn57Q5E(@NotNull String dataUrl) {
        Pair pair;
        byte[] rawData;
        Object object;
        Matcher matcher;
        Intrinsics.checkNotNullParameter((Object)dataUrl, (String)"dataUrl");
        Matcher it = matcher = dataUrlRegex.matcher(dataUrl);
        boolean bl = false;
        Matcher matcher2 = it.matches() ? matcher : null;
        if (matcher2 == null) {
            return null;
        }
        Matcher groups = matcher2;
        String string = groups.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        boolean isBase64 = ((CharSequence)string).length() > 0;
        String mediaType = groups.group(1);
        String data2 = groups.group(3);
        try {
            Object object2;
            if (isBase64) {
                try {
                    object = Base64.getUrlDecoder().decode(data2);
                }
                catch (IllegalArgumentException e) {
                    object = Base64.getDecoder().decode(data2);
                }
                object2 = object;
            } else {
                String string2 = URLDecoder.decode(data2, StandardCharsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"decode(...)");
                object = string2;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = ((String)object).getBytes(charset);
                object2 = byArray;
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            }
            object = object2;
        }
        catch (Throwable throwable) {
            logger.warn("Failed to decode malformed raw data for " + mediaType + " media type");
            object = null;
        }
        if (rawData != null) {
            byte[] it2 = rawData = object;
            boolean bl2 = false;
            pair = TuplesKt.to((Object)mediaType, (Object)rawData);
        } else {
            pair = null;
        }
        return pair;
    }

    @NotNull
    public static final String dataUrl(@NotNull String type2, @NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        byte[] byArray = Base64.getEncoder().encode(bytes2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        return DataUrl.constructor-impl("data:" + type2 + ";base64," + new String(byArray2, charset));
    }
}

