/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.feed.ParsedFeed;
import com.jetbrains.toolbox.feed.PluginId;
import com.jetbrains.toolbox.feed.RemoteFeedItem;
import com.jetbrains.toolbox.feed.RemotePatchItem;
import com.jetbrains.toolbox.feed.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationFeedDownloaderResult {
    @NotNull
    private final List<RemoteFeedItem> feedItems;
    @NotNull
    private final List<Service> services;
    @NotNull
    private final List<RemotePatchItem> patchItems;
    @NotNull
    private final Map<String, String> poUrls;
    private final boolean success;
    @NotNull
    private final Map<PluginId, List<String>> enterprisePluginHashes;

    public ApplicationFeedDownloaderResult(@NotNull List<RemoteFeedItem> feedItems, @NotNull List<Service> services, @NotNull List<RemotePatchItem> patchItems, @NotNull Map<String, String> poUrls, boolean success, @NotNull Map<PluginId, ? extends List<String>> enterprisePluginHashes) {
        Intrinsics.checkNotNullParameter(feedItems, (String)"feedItems");
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter(patchItems, (String)"patchItems");
        Intrinsics.checkNotNullParameter(poUrls, (String)"poUrls");
        Intrinsics.checkNotNullParameter(enterprisePluginHashes, (String)"enterprisePluginHashes");
        this.feedItems = feedItems;
        this.services = services;
        this.patchItems = patchItems;
        this.poUrls = poUrls;
        this.success = success;
        this.enterprisePluginHashes = enterprisePluginHashes;
    }

    @NotNull
    public final List<RemoteFeedItem> getFeedItems() {
        return this.feedItems;
    }

    @NotNull
    public final List<Service> getServices() {
        return this.services;
    }

    @NotNull
    public final List<RemotePatchItem> getPatchItems() {
        return this.patchItems;
    }

    @NotNull
    public final Map<String, String> getPoUrls() {
        return this.poUrls;
    }

    public final boolean getSuccess() {
        return this.success;
    }

    @NotNull
    public final Map<PluginId, List<String>> getEnterprisePluginHashes() {
        return this.enterprisePluginHashes;
    }

    @NotNull
    public final ApplicationFeedDownloaderResult copy(@NotNull List<RemoteFeedItem> feedItems, @NotNull List<Service> services, @NotNull List<RemotePatchItem> patchItems, @NotNull Map<String, String> poUrls, boolean success, @NotNull Map<PluginId, ? extends List<String>> enterprisePluginHashes) {
        Intrinsics.checkNotNullParameter(feedItems, (String)"feedItems");
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter(patchItems, (String)"patchItems");
        Intrinsics.checkNotNullParameter(poUrls, (String)"poUrls");
        Intrinsics.checkNotNullParameter(enterprisePluginHashes, (String)"enterprisePluginHashes");
        return new ApplicationFeedDownloaderResult(feedItems, services, patchItems, poUrls, success, enterprisePluginHashes);
    }

    public static /* synthetic */ ApplicationFeedDownloaderResult copy$default(ApplicationFeedDownloaderResult applicationFeedDownloaderResult, List list2, List list3, List list4, Map map2, boolean bl, Map map3, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = applicationFeedDownloaderResult.feedItems;
        }
        if ((n & 2) != 0) {
            list3 = applicationFeedDownloaderResult.services;
        }
        if ((n & 4) != 0) {
            list4 = applicationFeedDownloaderResult.patchItems;
        }
        if ((n & 8) != 0) {
            map2 = applicationFeedDownloaderResult.poUrls;
        }
        if ((n & 0x10) != 0) {
            bl = applicationFeedDownloaderResult.success;
        }
        if ((n & 0x20) != 0) {
            map3 = applicationFeedDownloaderResult.enterprisePluginHashes;
        }
        return applicationFeedDownloaderResult.copy(list2, list3, list4, map2, bl, map3);
    }

    @NotNull
    public String toString() {
        return "ApplicationFeedDownloaderResult(feedItems=" + this.feedItems + ", services=" + this.services + ", patchItems=" + this.patchItems + ", poUrls=" + this.poUrls + ", success=" + this.success + ", enterprisePluginHashes=" + this.enterprisePluginHashes + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.feedItems).hashCode();
        result2 = result2 * 31 + ((Object)this.services).hashCode();
        result2 = result2 * 31 + ((Object)this.patchItems).hashCode();
        result2 = result2 * 31 + ((Object)this.poUrls).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.success);
        result2 = result2 * 31 + ((Object)this.enterprisePluginHashes).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ApplicationFeedDownloaderResult)) {
            return false;
        }
        ApplicationFeedDownloaderResult applicationFeedDownloaderResult = (ApplicationFeedDownloaderResult)other;
        if (!Intrinsics.areEqual(this.feedItems, applicationFeedDownloaderResult.feedItems)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.services, applicationFeedDownloaderResult.services)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.patchItems, applicationFeedDownloaderResult.patchItems)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.poUrls, applicationFeedDownloaderResult.poUrls)) {
            return false;
        }
        if (this.success != applicationFeedDownloaderResult.success) {
            return false;
        }
        return Intrinsics.areEqual(this.enterprisePluginHashes, applicationFeedDownloaderResult.enterprisePluginHashes);
    }

    @SourceDebugExtension(value={"SMAP\nApplicationFeedDownloaderResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationFeedDownloaderResult.kt\ncom/jetbrains/toolbox/feed/ApplicationFeedDownloaderResult$Factory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,37:1\n1374#2:38\n1460#2,5:39\n1374#2:44\n1460#2,5:45\n1374#2:50\n1460#2,5:51\n1803#2,3:56\n1374#2:59\n1460#2,5:60\n1504#2:65\n1534#2,3:66\n1537#2,3:76\n1252#2,4:81\n382#3,7:69\n463#3:79\n413#3:80\n*S KotlinDebug\n*F\n+ 1 ApplicationFeedDownloaderResult.kt\ncom/jetbrains/toolbox/feed/ApplicationFeedDownloaderResult$Factory\n*L\n19#1:38\n19#1:39,5\n20#1:44\n20#1:45,5\n21#1:50\n21#1:51,5\n22#1:56,3\n24#1:59\n24#1:60,5\n25#1:65\n25#1:66,3\n25#1:76,3\n26#1:81,4\n25#1:69,7\n26#1:79\n26#1:80\n*E\n"})
    public static final class Factory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ApplicationFeedDownloaderResult create(boolean success, @NotNull List<ParsedFeed> parseResults) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv;
            Iterable $this$fold$iv;
            void initial$iv;
            Object list$iv$iv;
            ParsedFeed it;
            Iterable $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(parseResults, (String)"parseResults");
            Iterable $this$flatMap$iv = parseResults;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (ParsedFeed)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getItems().getFeedItems();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = parseResults;
            List list2 = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (ParsedFeed)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getItems().getServices();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = parseResults;
            List list3 = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (ParsedFeed)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getItems().getPatches();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list4 = (List)destination$iv$iv;
            $this$flatMap$iv = parseResults;
            Map $i$f$flatMap2 = MapsKt.emptyMap();
            boolean $i$f$fold22 = false;
            Map accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void r;
                Object element$iv$iv;
                element$iv$iv = (ParsedFeed)element$iv;
                void acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = MapsKt.plus((Map)acc, r.getItems().getPoUrls());
            }
            void var22_25 = accumulator$iv;
            $this$fold$iv = parseResults;
            boolean bl = success;
            $i$f$flatMap = false;
            Iterable $i$f$fold22 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                it = (ParsedFeed)element$iv$iv;
                boolean bl2 = false;
                list$iv$iv = it.getItems().getEnterprisePluginHashes().entrySet();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Object object = (List)destination$iv$iv;
            $this$flatMap$iv = (Iterable)object;
            boolean $i$f$groupBy = false;
            void $this$flatMapTo$iv$iv2 = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                list$iv$iv = (Map.Entry)element$iv$iv;
                boolean $i$a$-groupBy-ApplicationFeedDownloaderResult$Factory$create$82 = false;
                String pluginId = ((PluginId)list$iv$iv.getKey()).unbox-impl();
                PluginId key$iv$iv = PluginId.box-impl(pluginId);
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                Map.Entry $i$a$-groupBy-ApplicationFeedDownloaderResult$Factory$create$82 = (Map.Entry)element$iv$iv;
                object = list$iv$iv;
                boolean bl4 = false;
                List pluginHashes = (List)$i$a$-groupBy-ApplicationFeedDownloaderResult$Factory$create$82.getValue();
                object.add(pluginHashes);
            }
            $this$groupBy$iv = object = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry bl4 = (Map.Entry)element$iv$iv$iv;
                Object object3 = destination$iv$iv;
                boolean bl5 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = object3;
                boolean bl6 = false;
                List pluginHashes = (List)entry.getValue();
                List list5 = CollectionsKt.flatten((Iterable)pluginHashes);
                object.put(k, list5);
            }
            Object object4 = object = destination$iv$iv;
            boolean bl7 = bl;
            void var29_45 = var22_25;
            List list6 = list4;
            List list7 = list3;
            List list8 = list2;
            return new ApplicationFeedDownloaderResult(list8, list7, list6, (Map<String, String>)var29_45, bl7, (Map<PluginId, ? extends List<String>>)object4);
        }
    }
}

