/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feature.mcp.client;

import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface McpServerConfig {

    public static final class Remote
    implements McpServerConfig {
        @NotNull
        private final String url;
        @Nullable
        private final String authToken;

        public Remote(@NotNull String url, @Nullable String authToken) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            this.authToken = authToken;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final String getAuthToken() {
            return this.authToken;
        }
    }

    public static final class Stdio
    implements McpServerConfig {
        @NotNull
        private final String command;
        @NotNull
        private final List<String> args;
        @NotNull
        private final Map<String, String> env;

        public Stdio(@NotNull String command2, @NotNull List<String> args, @NotNull Map<String, String> env) {
            Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter(env, (String)"env");
            this.command = command2;
            this.args = args;
            this.env = env;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @NotNull
        public final List<String> getArgs() {
            return this.args;
        }

        @NotNull
        public final Map<String, String> getEnv() {
            return this.env;
        }
    }
}

