/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.extension.registration.strategy;

import com.jetbrains.toolbox.extension.manifest.creator.ManifestCreator;
import com.jetbrains.toolbox.extension.manifest.model.Manifest;
import com.jetbrains.toolbox.extension.registration.strategy.RegistrationStrategy;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nCreateFileStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateFileStrategy.kt\ncom/jetbrains/toolbox/extension/registration/strategy/CreateFileStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,33:1\n1#2:34\n80#3:35\n165#3:36\n81#3:37\n82#3:42\n52#4,4:38\n60#4,10:43\n56#4,18:53\n*S KotlinDebug\n*F\n+ 1 CreateFileStrategy.kt\ncom/jetbrains/toolbox/extension/registration/strategy/CreateFileStrategy\n*L\n23#1:35\n23#1:36\n23#1:37\n23#1:42\n23#1:38,4\n23#1:43,10\n23#1:53,18\n*E\n"})
public final class CreateFileStrategy<T extends Manifest>
implements RegistrationStrategy {
    @NotNull
    private final ManifestCreator<T> manifestCreator;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Json json;

    public CreateFileStrategy(@NotNull ManifestCreator<T> manifestCreator, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter(manifestCreator, (String)"manifestCreator");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.manifestCreator = manifestCreator;
        this.fileSystem = fileSystem;
        this.json = JsonKt.Json$default(null, CreateFileStrategy::json$lambda$0, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onRegister(@NotNull Path manifestFile) {
        Unit unit;
        Throwable thrown$iv$iv;
        block15: {
            void $this$iv;
            Intrinsics.checkNotNullParameter((Object)manifestFile, (String)"manifestFile");
            Logger.INSTANCE.debug("Writing manifest to '" + manifestFile + "'");
            T manifest = this.manifestCreator.createManifest();
            Path path2 = manifestFile.parent();
            if (path2 != null) {
                Path path3 = path2;
                FileSystem fileSystem = this.fileSystem;
                Path p0 = path3;
                boolean bl = false;
                fileSystem.createDirectories(p0);
            }
            FileSystem fileSystem = this.fileSystem;
            Path file$iv = manifestFile;
            boolean mustCreate$iv = false;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSink $this$onRegister_u24lambda_u241 = it$iv;
                boolean bl3 = false;
                OkioStreamsKt.encodeToBufferedSink((Json)this.json, this.manifestCreator.getSerializer(), manifest, (BufferedSink)$this$onRegister_u24lambda_u241);
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    unit = null;
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block16: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block16;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable == null) return;
        throw throwable;
    }

    @Override
    public void onDeregister(@NotNull Path manifestFile) {
        Intrinsics.checkNotNullParameter((Object)manifestFile, (String)"manifestFile");
        Logger.INSTANCE.debug("Removing manifest file '" + manifestFile + "'");
        this.fileSystem.delete(manifestFile);
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setEncodeDefaults(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }
}

