/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.entry;

import com.jetbrains.toolbox.AppFlavor;
import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.CommandLine;
import com.jetbrains.toolbox.log.BootstrapLogger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.configuration.Configuration;
import org.tinylog.writers.ConsoleWriter;
import org.tinylog.writers.RollingFileWriter;
import org.tinylog.writers.Writer;

public final class AppBootstrapLogger
extends BootstrapLogger {
    @NotNull
    private final CommandLine commandLine;
    @NotNull
    private final Path logsDirectory;

    public AppBootstrapLogger(@NotNull CommandLine commandLine, @NotNull Path logsDirectory) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)logsDirectory, (String)"logsDirectory");
        super(commandLine);
        this.commandLine = commandLine;
        this.logsDirectory = logsDirectory;
    }

    @Override
    @NotNull
    protected List<Class<Writer>> getExpectedWriters() {
        List list2;
        List $this$_get_expectedWriters__u24lambda_u240 = list2 = (List)new ArrayList();
        boolean bl = false;
        $this$_get_expectedWriters__u24lambda_u240.add(RollingFileWriter.class);
        if (this.commandLine.isDebug()) {
            $this$_get_expectedWriters__u24lambda_u240.add(ConsoleWriter.class);
        }
        return list2;
    }

    @Override
    @NotNull
    public Path configureTinyLog(@NotNull AppFlavor appFlavor) {
        Intrinsics.checkNotNullParameter((Object)((Object)appFlavor), (String)"appFlavor");
        Configuration.set((String)"toolboxLevel", (String)(this.commandLine.isTrace() ? "trace" : (this.commandLine.isDebug() ? "debug" : this.getDefaultLogLevel())));
        Configuration.set((String)"level", (String)"trace");
        if (this.commandLine.isDebug() && !this.commandLine.getDisableStdioLogging()) {
            Configuration.set((String)"writer2", (String)"console");
            String prefix = Build.INSTANCE.isSNAPSHOT() ? "{date:HH:mm:ss.SSS}" : "\u001b[37m{pid}\u001b[0m {date:yyyy-MM-dd HH:mm:ss.SSS}";
            Configuration.set((String)"writer2.format", (String)(prefix + " \u001b[1m{level|size=5}\u001b[0m \u001b[34m{thread|size=13}\u001b[0m \u001b[1m{class-name|size=25}\u001b[0m {context: prefix}{message}"));
        }
        String logfileSizeLimit = "5mb";
        Path logFilePrefix = switch (WhenMappings.$EnumSwitchMapping$0[appFlavor.ordinal()]) {
            case 1 -> this.logsDirectory.resolve("toolbox");
            case 2 -> {
                String dateTimePattern = "YYYYMMdd.HHmmss.SSS";
                String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern(dateTimePattern));
                Path subDir = this.logsDirectory.resolve("secondary");
                yield subDir.resolve("toolbox." + timestamp + "." + ProcessHandle.current().pid());
            }
            case 3 -> this.logsDirectory.resolve("toolbox-ui");
            default -> throw new NoWhenBranchMatchedException();
        };
        Configuration.set((String)"writer1", (String)"rolling file");
        Configuration.set((String)"writer1.policies", (String)("size: " + logfileSizeLimit));
        Configuration.set((String)"writer1.format", (String)(System.getProperty("TOOLBOX_VERSION") + " {pid} {date:yyyy-MM-dd HH:mm:ss.SSS} {level|size=5} {thread|size=13} {class-name|size=25} {context: prefix}{message}"));
        Configuration.set((String)"writer1.file", (String)(logFilePrefix + ".{count}.log"));
        Configuration.set((String)"writer1.latest", (String)(logFilePrefix + ".latest.log"));
        Configuration.set((String)"writer1.charset", (String)"UTF-8");
        Configuration.set((String)"writer1.backups", (String)"100");
        String string = Configuration.get((String)"writer1.file");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AppFlavor.values().length];
            try {
                nArray[AppFlavor.MainInstance.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFlavor.SecondaryInstance.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFlavor.Frontend.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

