/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.vmoptions;

import com.jetbrains.toolbox.enterprise.rest.VmOptionsV2;
import com.jetbrains.toolbox.enterprise.settings.EnterpriseChannelExtensionModifier;
import com.jetbrains.toolbox.enterprise.settings.EnterpriseVmOption;
import com.jetbrains.toolbox.enterprise.settings.ProvisionMode;
import com.jetbrains.toolbox.enterprise.vmoptions.EnterprisePredefinedVmOptionsProvider;
import com.jetbrains.toolbox.enterprise.vmoptions.EnterpriseVmOptionsChangesCalculator;
import com.jetbrains.toolbox.enterprise.vmoptions.EnterpriseVmOptionsPreprocessor;
import com.jetbrains.toolbox.intellij.vmoptions.VmOption;
import com.jetbrains.toolbox.intellij.vmoptions.VmOptionsManager;
import com.jetbrains.toolbox.intellij.vmoptions.VmOptionsProvider;
import com.jetbrains.toolbox.intellij.vmoptions.VmOptionsUtil;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nEnterpriseVmOptionsChangesCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterpriseVmOptionsChangesCalculator.kt\ncom/jetbrains/toolbox/enterprise/vmoptions/EnterpriseVmOptionsChangesCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n774#2:110\n865#2,2:111\n295#2,2:113\n295#2,2:115\n1761#2,3:117\n*S KotlinDebug\n*F\n+ 1 EnterpriseVmOptionsChangesCalculator.kt\ncom/jetbrains/toolbox/enterprise/vmoptions/EnterpriseVmOptionsChangesCalculator\n*L\n48#1:110\n48#1:111,2\n77#1:113,2\n78#1:115,2\n104#1:117,3\n*E\n"})
public final class EnterpriseVmOptionsChangesCalculator {
    @NotNull
    private final VmOptionsManager vmOptionsManager;
    @NotNull
    private final EnterprisePredefinedVmOptionsProvider predefinedVmOptionsProvider;
    @NotNull
    private final EnterpriseVmOptionsPreprocessor vmOptionsPreprocessor;
    @NotNull
    private final EnterpriseChannelExtensionModifier enterpriseChannelExtensionModifier;
    @NotNull
    private final VmOptionsUtil vmOptionsUtil;

    public EnterpriseVmOptionsChangesCalculator(@NotNull VmOptionsManager vmOptionsManager, @NotNull EnterprisePredefinedVmOptionsProvider predefinedVmOptionsProvider, @NotNull EnterpriseVmOptionsPreprocessor vmOptionsPreprocessor, @NotNull EnterpriseChannelExtensionModifier enterpriseChannelExtensionModifier, @NotNull VmOptionsUtil vmOptionsUtil) {
        Intrinsics.checkNotNullParameter((Object)vmOptionsManager, (String)"vmOptionsManager");
        Intrinsics.checkNotNullParameter((Object)predefinedVmOptionsProvider, (String)"predefinedVmOptionsProvider");
        Intrinsics.checkNotNullParameter((Object)vmOptionsPreprocessor, (String)"vmOptionsPreprocessor");
        Intrinsics.checkNotNullParameter((Object)enterpriseChannelExtensionModifier, (String)"enterpriseChannelExtensionModifier");
        Intrinsics.checkNotNullParameter((Object)vmOptionsUtil, (String)"vmOptionsUtil");
        this.vmOptionsManager = vmOptionsManager;
        this.predefinedVmOptionsProvider = predefinedVmOptionsProvider;
        this.vmOptionsPreprocessor = vmOptionsPreprocessor;
        this.enterpriseChannelExtensionModifier = enterpriseChannelExtensionModifier;
        this.vmOptionsUtil = vmOptionsUtil;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object calculateChanges(@NotNull ToolInstance toolInstance, @NotNull VmOptionsV2 enterpriseVmOptions, @NotNull Path configPath, @NotNull Continuation<? super Result> $completion) {
        if (!($completion instanceof calculateChanges.1)) ** GOTO lbl-1000
        var21_5 = $completion;
        if ((var21_5.label & -2147483648) != 0) {
            var21_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ EnterpriseVmOptionsChangesCalculator this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.calculateChanges(null, null, null, (Continuation<? super Result>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var22_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                vmOptionsPath = this.vmOptionsUtil.vmoptionsPath(toolInstance);
                if (vmOptionsPath == null) {
                    Logger.INSTANCE.warn("Can't calculate VM options changes. VM options file location can not be determined for " + InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool()));
                    return Result.MissingVmOptionsFile.INSTANCE;
                }
                Logger.INSTANCE.info("Filtering out TBE VM options to apply to " + InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool()));
                $continuation.L$0 = toolInstance;
                $continuation.L$1 = enterpriseVmOptions;
                $continuation.L$2 = configPath;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)vmOptionsPath);
                $continuation.label = 1;
                v0 = this.vmOptionsManager.createProvider(vmOptionsPath, (Continuation<? super VmOptionsProvider>)$continuation);
                if (v0 == var22_7) {
                    return var22_7;
                }
                ** GOTO lbl33
            }
            case 1: {
                vmOptionsPath = (Path)$continuation.L$3;
                configPath = (Path)$continuation.L$2;
                enterpriseVmOptions = (VmOptionsV2)$continuation.L$1;
                toolInstance = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                vmOptionsProvider = (VmOptionsProvider)v0;
                existingVmOptions = vmOptionsProvider.getOptions();
                var9_11 = this.enterpriseChannelExtensionModifier.enterprise(toolInstance.getChannel());
                v1 = var9_11 != null ? var9_11.getEnterpriseVmOptions() : null;
                if (v1 == null) {
                    v1 = CollectionsKt.emptyList();
                }
                existingEnterpriseVmOptions = v1;
                processedEnterpriseVmOptions = this.vmOptionsPreprocessor.process(enterpriseVmOptions.getEnterpriseVmOptions(), existingVmOptions, existingEnterpriseVmOptions);
                $this$filter$iv = processedEnterpriseVmOptions;
                $i$f$filter = false;
                var13_16 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    enterpriseVmOption = (EnterpriseVmOption)element$iv$iv;
                    $i$a$-filter-EnterpriseVmOptionsChangesCalculator$calculateChanges$enterpriseVmOptionsChanges$1 = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[enterpriseVmOption.getProvisionMode().ordinal()]) {
                        case 1: 
                        case 2: {
                            v2 = this.shouldApplyVmOption(enterpriseVmOption, existingVmOptions, existingEnterpriseVmOptions);
                            break;
                        }
                        case 3: 
                        case 4: {
                            v2 = this.shouldRemoveVmOption(enterpriseVmOption, existingVmOptions, existingEnterpriseVmOptions);
                            break;
                        }
                        case 5: {
                            v2 = false;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    if (!v2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                enterpriseVmOptionsChanges = (List)destination$iv$iv;
                unappliedPredefinedVmOptions = new ArrayList<E>();
                predefinedVmOptions = this.predefinedVmOptionsProvider.getPredefinedSystemVmOptions(toolInstance, configPath);
                for (VmOption.System predefinedVmOption : predefinedVmOptions) {
                    if (existingVmOptions.contains(predefinedVmOption)) continue;
                    unappliedPredefinedVmOptions.add(predefinedVmOption.toString());
                }
                if (enterpriseVmOptionsChanges.isEmpty()) {
                    return ((Collection)unappliedPredefinedVmOptions).isEmpty() == false != false ? (Result)new Result.ChangesInPredefinedOptions(unappliedPredefinedVmOptions) : (Result)Result.NoChanges.INSTANCE;
                }
                return new Result.Changes(enterpriseVmOptionsChanges);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean shouldApplyVmOption(EnterpriseVmOption enterpriseVmOptionToAdd, List<? extends VmOption> existingVmOptions, List<EnterpriseVmOption> existingEnterpriseVmOptions) {
        Object v1;
        VmOption existingVmOption;
        VmOption vmOption;
        block3: {
            Object v0;
            block2: {
                vmOption = VmOption.Companion.createVmOption(enterpriseVmOptionToAdd.getOption().getValue());
                Iterable $this$firstOrNull$iv = existingVmOptions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VmOption it = (VmOption)element$iv;
                    boolean bl = false;
                    if (!it.isSameAs(vmOption)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            existingVmOption = v0;
            Iterable $this$firstOrNull$iv = existingEnterpriseVmOptions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EnterpriseVmOption it = (EnterpriseVmOption)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)enterpriseVmOptionToAdd)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        EnterpriseVmOption existingEnterpriseVmOption = v1;
        return existingVmOption == null ? enterpriseVmOptionToAdd.getProvisionMode().isForced() || existingEnterpriseVmOption == null || !Intrinsics.areEqual((Object)enterpriseVmOptionToAdd, (Object)existingEnterpriseVmOption) : !Intrinsics.areEqual((Object)vmOption.getValue(), (Object)existingVmOption.getValue()) && (enterpriseVmOptionToAdd.getProvisionMode().isForced() || !Intrinsics.areEqual((Object)enterpriseVmOptionToAdd, (Object)existingEnterpriseVmOption));
    }

    private final boolean shouldRemoveVmOption(EnterpriseVmOption enterpriseVmOptionToRemove, List<? extends VmOption> existingVmOptions, List<EnterpriseVmOption> existingEnterpriseVmOptions) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = existingVmOptions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VmOption it = (VmOption)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)it.toString(), (String)enterpriseVmOptionToRemove.getOption().getValue(), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && (enterpriseVmOptionToRemove.getProvisionMode().isForced() || !existingEnterpriseVmOptions.contains(enterpriseVmOptionToRemove));
    }

    public static abstract sealed class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class Changes
        extends Result {
            @NotNull
            private final List<EnterpriseVmOption> vmOptions;

            public Changes(@NotNull List<EnterpriseVmOption> vmOptions) {
                Intrinsics.checkNotNullParameter(vmOptions, (String)"vmOptions");
                super(null);
                this.vmOptions = vmOptions;
            }

            @NotNull
            public final List<EnterpriseVmOption> getVmOptions() {
                return this.vmOptions;
            }

            @NotNull
            public String toString() {
                return "Changes(vmOptions=" + this.vmOptions + ")";
            }

            public int hashCode() {
                return ((Object)this.vmOptions).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Changes)) {
                    return false;
                }
                Changes changes = (Changes)other;
                return Intrinsics.areEqual(this.vmOptions, changes.vmOptions);
            }
        }

        public static final class ChangesInPredefinedOptions
        extends Result {
            @NotNull
            private final List<String> vmOptions;

            public ChangesInPredefinedOptions(@NotNull List<String> vmOptions) {
                Intrinsics.checkNotNullParameter(vmOptions, (String)"vmOptions");
                super(null);
                this.vmOptions = vmOptions;
            }

            @NotNull
            public final List<String> getVmOptions() {
                return this.vmOptions;
            }

            @NotNull
            public String toString() {
                return "ChangesInPredefinedOptions(vmOptions=" + this.vmOptions + ")";
            }

            public int hashCode() {
                return ((Object)this.vmOptions).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ChangesInPredefinedOptions)) {
                    return false;
                }
                ChangesInPredefinedOptions changesInPredefinedOptions = (ChangesInPredefinedOptions)other;
                return Intrinsics.areEqual(this.vmOptions, changesInPredefinedOptions.vmOptions);
            }
        }

        public static final class MissingVmOptionsFile
        extends Result {
            @NotNull
            public static final MissingVmOptionsFile INSTANCE = new MissingVmOptionsFile();

            private MissingVmOptionsFile() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "MissingVmOptionsFile";
            }

            public int hashCode() {
                return 558698323;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MissingVmOptionsFile)) {
                    return false;
                }
                MissingVmOptionsFile cfr_ignored_0 = (MissingVmOptionsFile)other;
                return true;
            }
        }

        public static final class NoChanges
        extends Result {
            @NotNull
            public static final NoChanges INSTANCE = new NoChanges();

            private NoChanges() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "NoChanges";
            }

            public int hashCode() {
                return 749341292;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NoChanges)) {
                    return false;
                }
                NoChanges cfr_ignored_0 = (NoChanges)other;
                return true;
            }
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProvisionMode.values().length];
            try {
                nArray[ProvisionMode.ADD_ONCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProvisionMode.ADD_PERMANENTLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProvisionMode.REMOVE_ONCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProvisionMode.REMOVE_PERMANENTLY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProvisionMode.UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

