/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.rest;

import com.jetbrains.toolbox.enterprise.rest.AppTypeAndBuild;
import com.jetbrains.toolbox.enterprise.rest.AutoInstalledToolV2;
import com.jetbrains.toolbox.enterprise.rest.ServiceV2;
import com.jetbrains.toolbox.enterprise.rest.ToolV2;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolOptions {
    @NotNull
    private final Map<AppTypeAndBuild, ToolV2> toolOptions;
    @NotNull
    private final List<AutoInstalledToolV2> autoInstalledTools;
    @NotNull
    private final List<ServiceV2> services;

    public ToolOptions(@NotNull Map<AppTypeAndBuild, ToolV2> toolOptions, @NotNull List<AutoInstalledToolV2> autoInstalledTools, @NotNull List<? extends ServiceV2> services) {
        Intrinsics.checkNotNullParameter(toolOptions, (String)"toolOptions");
        Intrinsics.checkNotNullParameter(autoInstalledTools, (String)"autoInstalledTools");
        Intrinsics.checkNotNullParameter(services, (String)"services");
        this.toolOptions = toolOptions;
        this.autoInstalledTools = autoInstalledTools;
        this.services = services;
    }

    @NotNull
    public final Map<AppTypeAndBuild, ToolV2> getToolOptions() {
        return this.toolOptions;
    }

    @NotNull
    public final List<AutoInstalledToolV2> getAutoInstalledTools() {
        return this.autoInstalledTools;
    }

    @NotNull
    public final List<ServiceV2> getServices() {
        return this.services;
    }

    @NotNull
    public String toString() {
        return "ToolOptions(toolOptions=" + this.toolOptions + ", autoInstalledTools=" + this.autoInstalledTools + ", services=" + this.services + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.toolOptions).hashCode();
        result2 = result2 * 31 + ((Object)this.autoInstalledTools).hashCode();
        result2 = result2 * 31 + ((Object)this.services).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ToolOptions)) {
            return false;
        }
        ToolOptions toolOptions = (ToolOptions)other;
        if (!Intrinsics.areEqual(this.toolOptions, toolOptions.toolOptions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.autoInstalledTools, toolOptions.autoInstalledTools)) {
            return false;
        }
        return Intrinsics.areEqual(this.services, toolOptions.services);
    }
}

