/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.plugins.disabled;

import com.jetbrains.toolbox.enterprise.rest.Channel;
import com.jetbrains.toolbox.enterprise.rest.InternalRepositoryVersion;
import com.jetbrains.toolbox.enterprise.rest.MarketplaceVersion;
import com.jetbrains.toolbox.enterprise.rest.PluginRule;
import com.jetbrains.toolbox.enterprise.rest.PluginRuleAction;
import com.jetbrains.toolbox.enterprise.rest.SinglePluginTypeRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompiledPluginRules {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginRuleAction allPluginsAllowed;
    @NotNull
    private final PluginRuleAction corporatePluginsAllowed;
    @NotNull
    private final Map<String, PluginRuleAction> vendorPlugins;
    @NotNull
    private final Map<String, PluginRuleAction> individualBundledPlugins;
    @NotNull
    private final Map<String, Map<String, PluginRuleAction>> individualCorporatePluginsByVersion;
    @NotNull
    private final Map<String, Map<String, PluginRuleAction>> individualCorporatePluginsByChannel;
    @NotNull
    private final Map<String, Map<String, PluginRuleAction>> individualMarketplacePlugins;

    public CompiledPluginRules(@NotNull PluginRuleAction allPluginsAllowed, @NotNull PluginRuleAction corporatePluginsAllowed, @NotNull Map<String, ? extends PluginRuleAction> vendorPlugins, @NotNull Map<String, ? extends PluginRuleAction> individualBundledPlugins, @NotNull Map<String, ? extends Map<String, ? extends PluginRuleAction>> individualCorporatePluginsByVersion, @NotNull Map<String, ? extends Map<String, ? extends PluginRuleAction>> individualCorporatePluginsByChannel, @NotNull Map<String, ? extends Map<String, ? extends PluginRuleAction>> individualMarketplacePlugins) {
        Intrinsics.checkNotNullParameter((Object)((Object)allPluginsAllowed), (String)"allPluginsAllowed");
        Intrinsics.checkNotNullParameter((Object)((Object)corporatePluginsAllowed), (String)"corporatePluginsAllowed");
        Intrinsics.checkNotNullParameter(vendorPlugins, (String)"vendorPlugins");
        Intrinsics.checkNotNullParameter(individualBundledPlugins, (String)"individualBundledPlugins");
        Intrinsics.checkNotNullParameter(individualCorporatePluginsByVersion, (String)"individualCorporatePluginsByVersion");
        Intrinsics.checkNotNullParameter(individualCorporatePluginsByChannel, (String)"individualCorporatePluginsByChannel");
        Intrinsics.checkNotNullParameter(individualMarketplacePlugins, (String)"individualMarketplacePlugins");
        this.allPluginsAllowed = allPluginsAllowed;
        this.corporatePluginsAllowed = corporatePluginsAllowed;
        this.vendorPlugins = vendorPlugins;
        this.individualBundledPlugins = individualBundledPlugins;
        this.individualCorporatePluginsByVersion = individualCorporatePluginsByVersion;
        this.individualCorporatePluginsByChannel = individualCorporatePluginsByChannel;
        this.individualMarketplacePlugins = individualMarketplacePlugins;
    }

    @NotNull
    public final PluginRuleAction getAllPluginsAllowed() {
        return this.allPluginsAllowed;
    }

    @NotNull
    public final PluginRuleAction getCorporatePluginsAllowed() {
        return this.corporatePluginsAllowed;
    }

    @NotNull
    public final Map<String, PluginRuleAction> getVendorPlugins() {
        return this.vendorPlugins;
    }

    @NotNull
    public final Map<String, PluginRuleAction> getIndividualBundledPlugins() {
        return this.individualBundledPlugins;
    }

    @NotNull
    public final Map<String, Map<String, PluginRuleAction>> getIndividualCorporatePluginsByVersion() {
        return this.individualCorporatePluginsByVersion;
    }

    @NotNull
    public final Map<String, Map<String, PluginRuleAction>> getIndividualCorporatePluginsByChannel() {
        return this.individualCorporatePluginsByChannel;
    }

    @NotNull
    public final Map<String, Map<String, PluginRuleAction>> getIndividualMarketplacePlugins() {
        return this.individualMarketplacePlugins;
    }

    @NotNull
    public String toString() {
        return "CompiledPluginRules(allPluginsAllowed=" + this.allPluginsAllowed + ", corporatePluginsAllowed=" + this.corporatePluginsAllowed + ", vendorPlugins=" + this.vendorPlugins + ", individualBundledPlugins=" + this.individualBundledPlugins + ", individualCorporatePluginsByVersion=" + this.individualCorporatePluginsByVersion + ", individualCorporatePluginsByChannel=" + this.individualCorporatePluginsByChannel + ", individualMarketplacePlugins=" + this.individualMarketplacePlugins + ")";
    }

    public int hashCode() {
        int result2 = this.allPluginsAllowed.hashCode();
        result2 = result2 * 31 + this.corporatePluginsAllowed.hashCode();
        result2 = result2 * 31 + ((Object)this.vendorPlugins).hashCode();
        result2 = result2 * 31 + ((Object)this.individualBundledPlugins).hashCode();
        result2 = result2 * 31 + ((Object)this.individualCorporatePluginsByVersion).hashCode();
        result2 = result2 * 31 + ((Object)this.individualCorporatePluginsByChannel).hashCode();
        result2 = result2 * 31 + ((Object)this.individualMarketplacePlugins).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompiledPluginRules)) {
            return false;
        }
        CompiledPluginRules compiledPluginRules = (CompiledPluginRules)other;
        if (this.allPluginsAllowed != compiledPluginRules.allPluginsAllowed) {
            return false;
        }
        if (this.corporatePluginsAllowed != compiledPluginRules.corporatePluginsAllowed) {
            return false;
        }
        if (!Intrinsics.areEqual(this.vendorPlugins, compiledPluginRules.vendorPlugins)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.individualBundledPlugins, compiledPluginRules.individualBundledPlugins)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.individualCorporatePluginsByVersion, compiledPluginRules.individualCorporatePluginsByVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.individualCorporatePluginsByChannel, compiledPluginRules.individualCorporatePluginsByChannel)) {
            return false;
        }
        return Intrinsics.areEqual(this.individualMarketplacePlugins, compiledPluginRules.individualMarketplacePlugins);
    }

    @SourceDebugExtension(value={"SMAP\nCompiledPluginRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompiledPluginRules.kt\ncom/jetbrains/toolbox/enterprise/plugins/disabled/CompiledPluginRules$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,119:1\n808#2,11:120\n808#2,11:131\n808#2,11:142\n808#2,11:153\n1193#2,2:164\n1267#2,4:166\n774#2:170\n865#2,2:171\n1193#2,2:173\n1267#2,4:175\n774#2:179\n865#2,2:180\n774#2:182\n865#2,2:183\n1491#2:185\n1516#2,3:186\n1519#2,3:196\n1252#2,2:201\n1193#2,2:203\n1267#2,4:205\n1255#2:209\n774#2:210\n865#2,2:211\n774#2:213\n865#2,2:214\n1491#2:216\n1516#2,3:217\n1519#2,3:227\n1252#2,2:232\n1193#2,2:234\n1267#2,4:236\n1255#2:240\n774#2:241\n865#2,2:242\n1491#2:244\n1516#2,3:245\n1519#2,3:255\n1252#2,2:260\n1193#2,2:262\n1267#2,4:264\n1255#2:268\n382#3,7:189\n463#3:199\n413#3:200\n382#3,7:220\n463#3:230\n413#3:231\n382#3,7:248\n463#3:258\n413#3:259\n*S KotlinDebug\n*F\n+ 1 CompiledPluginRules.kt\ncom/jetbrains/toolbox/enterprise/plugins/disabled/CompiledPluginRules$Companion\n*L\n36#1:120,11\n37#1:131,11\n38#1:142,11\n39#1:153,11\n48#1:164,2\n48#1:166,4\n59#1:170\n59#1:171,2\n60#1:173,2\n60#1:175,4\n65#1:179\n65#1:180,2\n66#1:182\n66#1:183,2\n67#1:185\n67#1:186,3\n67#1:196,3\n69#1:201,2\n70#1:203,2\n70#1:205,4\n69#1:209\n76#1:210\n76#1:211,2\n77#1:213\n77#1:214,2\n78#1:216\n78#1:217,3\n78#1:227,3\n80#1:232,2\n81#1:234,2\n81#1:236,4\n80#1:240\n87#1:241\n87#1:242,2\n88#1:244\n88#1:245,3\n88#1:255,3\n90#1:260,2\n91#1:262,2\n91#1:264,4\n90#1:268\n67#1:189,7\n69#1:199\n69#1:200\n78#1:220,7\n80#1:230\n80#1:231\n88#1:248,7\n90#1:258\n90#1:259\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CompiledPluginRules from(@Nullable List<? extends PluginRule> rules) {
            void $this$mapValuesTo$iv$iv;
            Object marketplacePluginById;
            Object $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            void $this$filterTo$iv$iv;
            void $this$mapValuesTo$iv$iv2;
            Object corporatePluginsByChannel;
            Object key$iv$iv;
            Object $this$groupByTo$iv$iv2;
            void $this$groupBy$iv2;
            Iterable $this$filterTo$iv$iv2;
            Map map2;
            Object rule;
            Object destination$iv$iv;
            Object object;
            Object k;
            void $this$mapValuesTo$iv$iv3;
            Object corporatePluginsByVersion;
            Object value$iv$iv$iv;
            Object $this$getOrPut$iv$iv$iv;
            Object $this$groupByTo$iv$iv3;
            void $this$groupBy$iv3;
            Iterable $this$filterTo$iv$iv3;
            Iterable $this$associateTo$iv$iv;
            Object element$iv$iv7;
            void $this$filterTo$iv$iv4;
            Object element$iv$iv22;
            void $this$associateTo$iv$iv2;
            Object object2;
            Object allPluginsAllowed;
            Object element$iv$iv32;
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstanceTo$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv3;
            void $this$filterIsInstanceTo$iv$iv4;
            Collection collection = rules;
            if (collection == null || collection.isEmpty()) {
                return new CompiledPluginRules(PluginRuleAction.ALLOW, PluginRuleAction.ALLOW, MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap());
            }
            Iterable $this$filterIsInstance$iv = rules;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv4 : $this$filterIsInstanceTo$iv$iv4) {
                if (!(element$iv$iv4 instanceof PluginRule.AllPluginsRule)) continue;
                destination$iv$iv2.add(element$iv$iv4);
            }
            List allRules = (List)destination$iv$iv2;
            Iterable $this$filterIsInstance$iv2 = rules;
            boolean $i$f$filterIsInstance2 = false;
            destination$iv$iv2 = $this$filterIsInstance$iv2;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv5 : $this$filterIsInstanceTo$iv$iv3) {
                if (!(element$iv$iv5 instanceof PluginRule.InternalPluginsRule)) continue;
                destination$iv$iv3.add(element$iv$iv5);
            }
            List corporateRules = (List)destination$iv$iv3;
            Iterable $this$filterIsInstance$iv3 = rules;
            boolean $i$f$filterIsInstance3 = false;
            destination$iv$iv3 = $this$filterIsInstance$iv3;
            Iterable destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterIsInstanceTo3 = false;
            for (Object element$iv$iv6 : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv6 instanceof PluginRule.VendorPluginRule)) continue;
                destination$iv$iv4.add(element$iv$iv6);
            }
            List vendorRules = (List)destination$iv$iv4;
            Iterable $this$filterIsInstance$iv4 = rules;
            boolean $i$f$filterIsInstance4 = false;
            destination$iv$iv4 = $this$filterIsInstance$iv4;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$filterIsInstanceTo4 = false;
            for (Object element$iv$iv32 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv32 instanceof PluginRule.SinglePluginRule)) continue;
                destination$iv$iv5.add(element$iv$iv32);
            }
            List individualPlugins = (List)destination$iv$iv5;
            Object object3 = (PluginRule.AllPluginsRule)CollectionsKt.firstOrNull((List)allRules);
            if (object3 == null || (object3 = object3.getAction()) == null) {
                object3 = allPluginsAllowed = PluginRuleAction.ALLOW;
            }
            if ((object2 = (PluginRule.InternalPluginsRule)CollectionsKt.firstOrNull((List)corporateRules)) == null || (object2 = object2.getAction()) == null) {
                PluginRule.AllPluginsRule allPluginsRule = (PluginRule.AllPluginsRule)CollectionsKt.firstOrNull((List)allRules);
                object2 = allPluginsRule != null ? allPluginsRule.getAction() : PluginRuleAction.ALLOW;
            }
            Object corporatePluginsAllowed = object2;
            Iterable $this$associate$iv = vendorRules;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            element$iv$iv32 = $this$associate$iv;
            Map destination$iv$iv6 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv22 : $this$associateTo$iv$iv2) {
                Map map3 = destination$iv$iv6;
                PluginRule.VendorPluginRule it = (PluginRule.VendorPluginRule)element$iv$iv22;
                boolean bl = false;
                it = TuplesKt.to((Object)it.getVendor().getId(), (Object)((Object)it.getAction()));
                map3.put(it.getFirst(), it.getSecond());
            }
            Map vendorPluginsMap = destination$iv$iv6;
            Object individualMarketplacePlugins = null;
            Object individualCorporatePluginsByVersion = null;
            Object individualCorporatePluginsByChannel = null;
            Map individualBundledPlugins = null;
            Iterable $this$filter$iv = individualPlugins;
            boolean $i$f$filter = false;
            element$iv$iv22 = $this$filter$iv;
            Iterable destination$iv$iv7 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv7 : $this$filterTo$iv$iv4) {
                PluginRule.SinglePluginRule it = (PluginRule.SinglePluginRule)element$iv$iv7;
                boolean bl = false;
                if (!(it.getSinglePluginTypeRule() instanceof SinglePluginTypeRule.BundledPluginTypeRule)) continue;
                destination$iv$iv7.add(element$iv$iv7);
            }
            List bundledPlugins = (List)destination$iv$iv7;
            Iterable $this$associate$iv2 = bundledPlugins;
            boolean $i$f$associate2 = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
            destination$iv$iv7 = $this$associate$iv2;
            Object destination$iv$iv8 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateTo2 = false;
            for (Object element$iv$iv8 : $this$associateTo$iv$iv) {
                Map bl = destination$iv$iv8;
                PluginRule.SinglePluginRule it = (PluginRule.SinglePluginRule)element$iv$iv8;
                boolean bl2 = false;
                it = TuplesKt.to((Object)it.getSinglePluginTypeRule().getPluginDefinition().getId(), (Object)((Object)it.getAction()));
                bl.put(it.getFirst(), it.getSecond());
            }
            individualBundledPlugins = destination$iv$iv8;
            Iterable $this$filter$iv2 = individualPlugins;
            boolean $i$f$filter2 = false;
            $this$associateTo$iv$iv = $this$filter$iv2;
            destination$iv$iv8 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv8 : $this$filterTo$iv$iv3) {
                PluginRule.SinglePluginRule it = (PluginRule.SinglePluginRule)element$iv$iv8;
                boolean bl = false;
                if (!(it.getSinglePluginTypeRule() instanceof SinglePluginTypeRule.InternalRepositoryRule)) continue;
                destination$iv$iv8.add(element$iv$iv8);
            }
            $this$filter$iv2 = (List)destination$iv$iv8;
            $i$f$filter2 = false;
            $this$filterTo$iv$iv3 = $this$filter$iv2;
            destination$iv$iv8 = new ArrayList();
            $i$f$filterTo2 = false;
            for (Object element$iv$iv8 : $this$filterTo$iv$iv3) {
                PluginRule.SinglePluginRule it = (PluginRule.SinglePluginRule)element$iv$iv8;
                boolean bl = false;
                SinglePluginTypeRule singlePluginTypeRule = it.getSinglePluginTypeRule();
                Intrinsics.checkNotNull((Object)singlePluginTypeRule, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.enterprise.rest.SinglePluginTypeRule.InternalRepositoryRule");
                if (!(((SinglePluginTypeRule.InternalRepositoryRule)singlePluginTypeRule).getVersion() != null)) continue;
                destination$iv$iv8.add(element$iv$iv8);
            }
            $this$filter$iv2 = (List)destination$iv$iv8;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv3 = $this$groupBy$iv3;
            destination$iv$iv8 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            element$iv$iv7 = $this$groupByTo$iv$iv3.iterator();
            while (element$iv$iv7.hasNext()) {
                Object object4;
                Object element$iv$iv8;
                element$iv$iv8 = element$iv$iv7.next();
                PluginRule.SinglePluginRule it = (PluginRule.SinglePluginRule)element$iv$iv8;
                boolean bl = false;
                String key$iv$iv2 = it.getSinglePluginTypeRule().getPluginDefinition().getId();
                $this$getOrPut$iv$iv$iv = destination$iv$iv8;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                    object4 = answer$iv$iv$iv;
                } else {
                    object4 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object4;
                list$iv$iv.add(element$iv$iv8);
            }
            Object $this$mapValues$iv = corporatePluginsByVersion = destination$iv$iv8;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv3 = $this$mapValues$iv;
            destination$iv$iv8 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv3.entrySet();
            boolean $i$f$associateByTo22 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$associateTo$iv$iv3;
                void entry;
                void it$iv$iv;
                Map.Entry key$iv$iv2 = (Map.Entry)element$iv$iv$iv;
                $this$getOrPut$iv$iv$iv = destination$iv$iv8;
                boolean bl = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object = $this$getOrPut$iv$iv$iv;
                boolean bl4 = false;
                Iterable $this$associate$iv3 = (Iterable)entry.getValue();
                boolean $i$f$associate3 = false;
                int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv3, (int)10)), (int)16);
                Iterable iterable2 = $this$associate$iv3;
                destination$iv$iv = new LinkedHashMap(capacity$iv3);
                boolean $i$f$associateTo3 = false;
                for (Object element$iv$iv9 : $this$associateTo$iv$iv3) {
                    Object object5 = destination$iv$iv;
                    rule = (PluginRule.SinglePluginRule)element$iv$iv9;
                    boolean bl5 = false;
                    SinglePluginTypeRule singlePluginTypeRule = ((PluginRule.SinglePluginRule)rule).getSinglePluginTypeRule();
                    Intrinsics.checkNotNull((Object)singlePluginTypeRule, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.enterprise.rest.SinglePluginTypeRule.InternalRepositoryRule");
                    InternalRepositoryVersion internalRepositoryVersion = ((SinglePluginTypeRule.InternalRepositoryRule)singlePluginTypeRule).getVersion();
                    Intrinsics.checkNotNull((Object)internalRepositoryVersion);
                    rule = TuplesKt.to((Object)Companion.asKey(internalRepositoryVersion), (Object)((Object)((PluginRule.SinglePluginRule)rule).getAction()));
                    object5.put(rule.getFirst(), rule.getSecond());
                }
                map2 = destination$iv$iv;
                object.put(k, map2);
            }
            individualCorporatePluginsByVersion = destination$iv$iv8;
            Iterable $this$filter$iv3 = individualPlugins;
            boolean $i$f$filter3 = false;
            destination$iv$iv8 = $this$filter$iv3;
            Object destination$iv$iv9 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv10 : $this$filterTo$iv$iv2) {
                PluginRule.SinglePluginRule it = (PluginRule.SinglePluginRule)element$iv$iv10;
                boolean bl = false;
                if (!(it.getSinglePluginTypeRule() instanceof SinglePluginTypeRule.InternalRepositoryRule)) continue;
                destination$iv$iv9.add(element$iv$iv10);
            }
            $this$filter$iv3 = (List)destination$iv$iv9;
            $i$f$filter3 = false;
            $this$filterTo$iv$iv2 = $this$filter$iv3;
            destination$iv$iv9 = new ArrayList();
            $i$f$filterTo3 = false;
            for (Object element$iv$iv10 : $this$filterTo$iv$iv2) {
                PluginRule.SinglePluginRule it = (PluginRule.SinglePluginRule)element$iv$iv10;
                boolean bl = false;
                SinglePluginTypeRule singlePluginTypeRule = it.getSinglePluginTypeRule();
                Intrinsics.checkNotNull((Object)singlePluginTypeRule, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.enterprise.rest.SinglePluginTypeRule.InternalRepositoryRule");
                if (!(((SinglePluginTypeRule.InternalRepositoryRule)singlePluginTypeRule).getChannel() != null)) continue;
                destination$iv$iv9.add(element$iv$iv10);
            }
            $this$filter$iv3 = (List)destination$iv$iv9;
            boolean $i$f$groupBy2 = false;
            $this$filterTo$iv$iv2 = $this$groupBy$iv2;
            destination$iv$iv9 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            Iterator $i$f$associateByTo22 = $this$groupByTo$iv$iv2.iterator();
            while ($i$f$associateByTo22.hasNext()) {
                Object object6;
                Object element$iv$iv10;
                element$iv$iv10 = $i$f$associateByTo22.next();
                PluginRule.SinglePluginRule it = (PluginRule.SinglePluginRule)element$iv$iv10;
                boolean bl = false;
                key$iv$iv = it.getSinglePluginTypeRule().getPluginDefinition().getId();
                Object $this$getOrPut$iv$iv$iv2 = destination$iv$iv9;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
                if (value$iv$iv$iv2 == null) {
                    boolean bl6 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                    object6 = answer$iv$iv$iv;
                } else {
                    object6 = value$iv$iv$iv2;
                }
                List list$iv$iv = (List)object6;
                list$iv$iv.add(element$iv$iv10);
            }
            Object $this$mapValues$iv2 = corporatePluginsByChannel = destination$iv$iv9;
            boolean $i$f$mapValues2 = false;
            $this$groupByTo$iv$iv2 = $this$mapValues$iv2;
            destination$iv$iv9 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
            boolean $i$f$mapValuesTo2 = false;
            Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv2.entrySet();
            boolean $i$f$associateByTo32 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void $this$associateTo$iv$iv4;
                void entry;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object $this$getOrPut$iv$iv$iv2 = destination$iv$iv9;
                boolean bl = false;
                Map.Entry value$iv$iv$iv2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object = $this$getOrPut$iv$iv$iv2;
                boolean bl7 = false;
                Iterable $this$associate$iv4 = (Iterable)entry.getValue();
                boolean $i$f$associate4 = false;
                int capacity$iv4 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv4, (int)10)), (int)16);
                destination$iv$iv = $this$associate$iv4;
                Map destination$iv$iv10 = new LinkedHashMap(capacity$iv4);
                boolean $i$f$associateTo4 = false;
                for (Object element$iv$iv11 : $this$associateTo$iv$iv4) {
                    rule = destination$iv$iv10;
                    PluginRule.SinglePluginRule rule2 = (PluginRule.SinglePluginRule)element$iv$iv11;
                    boolean bl8 = false;
                    SinglePluginTypeRule singlePluginTypeRule = rule2.getSinglePluginTypeRule();
                    Intrinsics.checkNotNull((Object)singlePluginTypeRule, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.enterprise.rest.SinglePluginTypeRule.InternalRepositoryRule");
                    Channel channel = ((SinglePluginTypeRule.InternalRepositoryRule)singlePluginTypeRule).getChannel();
                    Intrinsics.checkNotNull((Object)channel);
                    Pair pair = TuplesKt.to((Object)channel.getName(), (Object)((Object)rule2.getAction()));
                    rule.put(pair.getFirst(), pair.getSecond());
                }
                map2 = destination$iv$iv10;
                object.put(k, map2);
            }
            individualCorporatePluginsByChannel = destination$iv$iv9;
            Iterable $this$filter$iv4 = individualPlugins;
            boolean $i$f$filter4 = false;
            destination$iv$iv9 = $this$filter$iv4;
            Object destination$iv$iv11 = new ArrayList();
            boolean $i$f$filterTo4 = false;
            for (Object element$iv$iv12 : $this$filterTo$iv$iv) {
                PluginRule.SinglePluginRule it = (PluginRule.SinglePluginRule)element$iv$iv12;
                boolean bl = false;
                if (!(it.getSinglePluginTypeRule() instanceof SinglePluginTypeRule.MarketplacePluginTypeRule)) continue;
                destination$iv$iv11.add(element$iv$iv12);
            }
            $this$filter$iv4 = (List)destination$iv$iv11;
            boolean $i$f$groupBy3 = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv11 = new LinkedHashMap();
            boolean $i$f$groupByTo3 = false;
            Iterator $i$f$associateByTo32 = $this$groupByTo$iv$iv.iterator();
            while ($i$f$associateByTo32.hasNext()) {
                Object object7;
                Object element$iv$iv12;
                element$iv$iv12 = $i$f$associateByTo32.next();
                PluginRule.SinglePluginRule it = (PluginRule.SinglePluginRule)element$iv$iv12;
                boolean bl = false;
                String key$iv$iv3 = it.getSinglePluginTypeRule().getPluginDefinition().getId();
                Object $this$getOrPut$iv$iv$iv3 = destination$iv$iv11;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv3 = $this$getOrPut$iv$iv$iv3.get(key$iv$iv3);
                if (value$iv$iv$iv3 == null) {
                    boolean bl9 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv3.put(key$iv$iv3, answer$iv$iv$iv);
                    object7 = answer$iv$iv$iv;
                } else {
                    object7 = value$iv$iv$iv3;
                }
                List list$iv$iv = (List)object7;
                list$iv$iv.add(element$iv$iv12);
            }
            Object $this$mapValues$iv3 = marketplacePluginById = destination$iv$iv11;
            boolean $i$f$mapValues3 = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv3;
            destination$iv$iv11 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv3.size()));
            boolean $i$f$mapValuesTo3 = false;
            Iterable $this$associateByTo$iv$iv$iv3 = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv3) {
                void $this$associateTo$iv$iv5;
                void entry;
                void it$iv$iv;
                Map.Entry key$iv$iv3 = (Map.Entry)element$iv$iv$iv;
                Object object8 = destination$iv$iv11;
                boolean bl = false;
                Map.Entry value$iv$iv$iv3 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object = object8;
                boolean bl10 = false;
                Iterable $this$associate$iv5 = (Iterable)entry.getValue();
                boolean $i$f$associate5 = false;
                int capacity$iv5 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv5, (int)10)), (int)16);
                Iterable destination$iv$iv10 = $this$associate$iv5;
                Map destination$iv$iv12 = new LinkedHashMap(capacity$iv5);
                boolean $i$f$associateTo5 = false;
                for (Object element$iv$iv13 : $this$associateTo$iv$iv5) {
                    Map map4 = destination$iv$iv12;
                    PluginRule.SinglePluginRule rule3 = (PluginRule.SinglePluginRule)element$iv$iv13;
                    boolean bl11 = false;
                    SinglePluginTypeRule singlePluginTypeRule = rule3.getSinglePluginTypeRule();
                    Intrinsics.checkNotNull((Object)singlePluginTypeRule, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.enterprise.rest.SinglePluginTypeRule.MarketplacePluginTypeRule");
                    Pair pair = TuplesKt.to((Object)Companion.asKey(((SinglePluginTypeRule.MarketplacePluginTypeRule)singlePluginTypeRule).getVersion()), (Object)((Object)rule3.getAction()));
                    map4.put(pair.getFirst(), pair.getSecond());
                }
                map2 = destination$iv$iv12;
                object.put(k, map2);
            }
            individualMarketplacePlugins = destination$iv$iv11;
            return new CompiledPluginRules((PluginRuleAction)((Object)allPluginsAllowed), (PluginRuleAction)((Object)corporatePluginsAllowed), vendorPluginsMap, individualBundledPlugins, (Map<String, ? extends Map<String, ? extends PluginRuleAction>>)individualCorporatePluginsByVersion, (Map<String, ? extends Map<String, ? extends PluginRuleAction>>)individualCorporatePluginsByChannel, (Map<String, ? extends Map<String, ? extends PluginRuleAction>>)individualMarketplacePlugins);
        }

        private final String asKey(MarketplaceVersion $this$asKey) {
            if ($this$asKey instanceof MarketplaceVersion.CustomMarketplaceVersion) {
                return ((MarketplaceVersion.CustomMarketplaceVersion)$this$asKey).getVersion();
            }
            return "ALL";
        }

        private final String asKey(InternalRepositoryVersion $this$asKey) {
            if ($this$asKey instanceof InternalRepositoryVersion.LatestInternalRepositoryVersion) {
                return "LATEST";
            }
            if ($this$asKey instanceof InternalRepositoryVersion.SpecificInternalRepositoryVersion) {
                return ((InternalRepositoryVersion.SpecificInternalRepositoryVersion)$this$asKey).getVersion().getName();
            }
            return "ALL";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

