/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.plugins;

import com.jetbrains.toolbox.common.extensions.ByteArrayExtensionsKt;
import com.jetbrains.toolbox.common.security.ShaKt;
import com.jetbrains.toolbox.enterprise.EnterpriseConfig;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManager;
import com.jetbrains.toolbox.feed.PluginId;
import com.jetbrains.toolbox.intellij.plugins.IntelliJPluginVerifier;
import com.jetbrains.toolbox.manager.FeedProvider;
import com.jetbrains.toolbox.manager.FeedV2WithSource;
import java.net.URI;
import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nEnterprisePluginVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterprisePluginVerifier.kt\ncom/jetbrains/toolbox/enterprise/plugins/EnterprisePluginVerifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class EnterprisePluginVerifier
implements IntelliJPluginVerifier {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final FeedProvider feedProvider;
    @NotNull
    private final EnterpriseConfigManager configManager;
    @NotNull
    private final String DEFAULT_IDES_CLOUD_DOMAIN;

    public EnterprisePluginVerifier(@NotNull FileSystem fileSystem, @NotNull FeedProvider feedProvider, @NotNull EnterpriseConfigManager configManager) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)feedProvider, (String)"feedProvider");
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
        this.fileSystem = fileSystem;
        this.feedProvider = feedProvider;
        this.configManager = configManager;
        this.DEFAULT_IDES_CLOUD_DOMAIN = ".jetbrains-ide-services.com";
    }

    @Override
    @NotNull
    public IntelliJPluginVerifier.Result verifyZippedPlugin-3arw3uo(@NotNull Path path2, @NotNull String pluginId) {
        boolean isCloudDeployment;
        Object object;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
                object = (EnterpriseConfig)this.configManager.getConfig().getValue();
                if (object == null || (object = ((EnterpriseConfig)object).getMachineConfig()) == null || (object = object.getTbeServerUrl()) == null) break block8;
                Object it = object;
                boolean bl = false;
                URI uRI = URI.create((String)it);
                object = uRI;
                if (uRI != null) break block9;
            }
            return IntelliJPluginVerifier.Result.Failure.INSTANCE;
        }
        Object idesServerUrl = object;
        String string = System.getenv("IDES_CLOUD_DOMAIN");
        if (string == null) {
            string = this.DEFAULT_IDES_CLOUD_DOMAIN;
        }
        String cloudDomain = string;
        String string2 = ((URI)idesServerUrl).getHost();
        boolean bl = isCloudDeployment = string2 != null ? StringsKt.endsWith$default((String)string2, (String)cloudDomain, (boolean)false, (int)2, null) : false;
        if (!isCloudDeployment) {
            Logger.INSTANCE.debug("Running outside of cloud, skipping checksum verification for plugin " + PluginId.toString-impl(pluginId));
            return IntelliJPluginVerifier.Result.Skipped.INSTANCE;
        }
        Logger.INSTANCE.debug("Running in cloud mode, proceeding to checksum verification of plugin " + PluginId.toString-impl(pluginId));
        Set<String> set2 = ((FeedV2WithSource)this.feedProvider.getFeed().getValue()).getEnterprisePluginHashes().get(PluginId.box-impl(pluginId));
        if (set2 == null) {
            return IntelliJPluginVerifier.Result.Failure.INSTANCE;
        }
        Set<String> pluginChecksums = set2;
        try {
            String pluginZipChecksum = ByteArrayExtensionsKt.toHex$default(ShaKt.sha512(this.fileSystem, path2), null, false, 3, null);
            return pluginChecksums.contains(pluginZipChecksum) ? (IntelliJPluginVerifier.Result)IntelliJPluginVerifier.Result.Success.INSTANCE : (IntelliJPluginVerifier.Result)IntelliJPluginVerifier.Result.Failure.INSTANCE;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "TBE plugin checksum calculation has ended with error");
            return IntelliJPluginVerifier.Result.Failure.INSTANCE;
        }
    }
}

