/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.fleet;

import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.enterprise.fleet.EnterpriseFleetInfo;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nEnterpriseFleetInfoFileEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterpriseFleetInfoFileEditor.kt\ncom/jetbrains/toolbox/enterprise/fleet/EnterpriseFleetInfoFileEditor\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 OkioStreams.kt\nkotlinx/serialization/json/okio/OkioStreamsKt\n*L\n1#1,65:1\n66#2:66\n52#2,4:68\n60#2,10:74\n56#2,3:84\n71#2,3:87\n52#2,4:93\n60#2,10:99\n56#2,18:109\n67#3:67\n68#3:72\n80#3:90\n165#3:91\n81#3:92\n82#3:97\n78#4:73\n46#4:98\n*S KotlinDebug\n*F\n+ 1 EnterpriseFleetInfoFileEditor.kt\ncom/jetbrains/toolbox/enterprise/fleet/EnterpriseFleetInfoFileEditor\n*L\n28#1:66\n28#1:68,4\n28#1:74,10\n28#1:84,3\n28#1:87,3\n47#1:93,4\n47#1:99,10\n47#1:109,18\n28#1:67\n28#1:72\n47#1:90\n47#1:91\n47#1:92\n47#1:97\n29#1:73\n48#1:98\n*E\n"})
public final class EnterpriseFleetInfoFileEditor {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path enterpriseFleetInfoFilePath;

    public EnterpriseFleetInfoFileEditor(@NotNull FileSystem fileSystem, @NotNull Path enterpriseFleetInfoFilePath) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)enterpriseFleetInfoFilePath, (String)"enterpriseFleetInfoFilePath");
        this.fileSystem = fileSystem;
        this.enterpriseFleetInfoFilePath = enterpriseFleetInfoFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void saveEnterpriseFleetInfo(@NotNull EnterpriseFleetInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        try {
            Unit unit;
            Throwable thrown$iv$iv;
            block17: {
                void $this$iv;
                FileSystem parent;
                if (!this.fileSystem.exists(this.enterpriseFleetInfoFilePath) && (parent = this.enterpriseFleetInfoFilePath.parent()) != null) {
                    this.fileSystem.createDirectories((Path)parent);
                }
                parent = this.fileSystem;
                Path file$iv = this.enterpriseFleetInfoFilePath;
                boolean mustCreate$iv = false;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    void value$iv;
                    void $this$encodeToBufferedSink$iv;
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSink $this$saveEnterpriseFleetInfo_u24lambda_u241 = it$iv;
                    boolean bl3 = false;
                    Json json2 = JsonKt.getJsonx();
                    EnterpriseFleetInfo enterpriseFleetInfo = info;
                    BufferedSink sink$iv = $this$saveEnterpriseFleetInfo_u24lambda_u241;
                    boolean $i$f$encodeToBufferedSink = false;
                    $this$encodeToBufferedSink$iv.getSerializersModule();
                    OkioStreamsKt.encodeToBufferedSink((Json)$this$encodeToBufferedSink$iv, (SerializationStrategy)((SerializationStrategy)EnterpriseFleetInfo.Companion.serializer()), (Object)value$iv, (BufferedSink)sink$iv);
                    unit = Unit.INSTANCE;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        unit = null;
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block18: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block18;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            Unit result$iv$iv = unit;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) return;
            throw throwable;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Unable to save Fleet info file at " + this.enterpriseFleetInfoFilePath);
        }
    }

    public final void removeEnterpriseFleetInfo() {
        try {
            if (this.fileSystem.exists(this.enterpriseFleetInfoFilePath)) {
                this.fileSystem.delete(this.enterpriseFleetInfoFilePath);
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Unable to remove Fleet info at " + this.enterpriseFleetInfoFilePath);
        }
    }
}

