/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.feed;

import com.jetbrains.tbe.config.machine.TbeMachineConfig;
import com.jetbrains.toolbox.ErrorsHelperKt;
import com.jetbrains.toolbox.accounts.ToolboxEnterpriseAccountProvider;
import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.enterprise.EnterpriseConfig;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManager;
import com.jetbrains.toolbox.enterprise.feed.EnterpriseFeedFilterProvider;
import com.jetbrains.toolbox.enterprise.feed.EnterpriseFeedFilterProviderCache;
import com.jetbrains.toolbox.enterprise.feed.FeedFilterDto;
import com.jetbrains.toolbox.enterprise.feed.FeedFilterDtoKt;
import com.jetbrains.toolbox.enterprise.rest.EnterpriseRequestKt;
import com.jetbrains.toolbox.enterprise.rest.EnterpriseSettingsRequestsKt;
import com.jetbrains.toolbox.feed.FeedFilter;
import com.jetbrains.toolbox.feed.FeedFilterProvider;
import com.jetbrains.toolbox.feed.FeedLocation;
import com.jetbrains.toolbox.network.DownloadManager;
import com.jetbrains.toolbox.network.DownloadResult;
import com.jetbrains.toolbox.network.DownloadSession;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.serialization.DeserializationStrategy;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nEnterpriseFeedFilterProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterpriseFeedFilterProvider.kt\ncom/jetbrains/toolbox/enterprise/feed/EnterpriseFeedFilterProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1563#2:110\n1634#2,3:111\n*S KotlinDebug\n*F\n+ 1 EnterpriseFeedFilterProvider.kt\ncom/jetbrains/toolbox/enterprise/feed/EnterpriseFeedFilterProvider\n*L\n58#1:110\n58#1:111,3\n*E\n"})
public final class EnterpriseFeedFilterProvider
implements FeedFilterProvider {
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final EnterpriseConfigManager enterpriseConfigManager;
    @NotNull
    private final ToolboxEnterpriseAccountProvider enterpriseAccountProvider;
    @NotNull
    private final MutableStateFlow<FeedFilter> state;

    public EnterpriseFeedFilterProvider(@NotNull DownloadManager downloadManager, @NotNull EnterpriseConfigManager enterpriseConfigManager, @NotNull ToolboxEnterpriseAccountProvider enterpriseAccountProvider, @NotNull EnterpriseFeedFilterProviderCache enterpriseFeedFilterProviderCache) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)enterpriseConfigManager, (String)"enterpriseConfigManager");
        Intrinsics.checkNotNullParameter((Object)enterpriseAccountProvider, (String)"enterpriseAccountProvider");
        Intrinsics.checkNotNullParameter((Object)enterpriseFeedFilterProviderCache, (String)"enterpriseFeedFilterProviderCache");
        this.downloadManager = downloadManager;
        this.enterpriseConfigManager = enterpriseConfigManager;
        this.enterpriseAccountProvider = enterpriseAccountProvider;
        this.state = enterpriseFeedFilterProviderCache.getCache();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getFeedFilter(@NotNull Continuation<? super FeedFilter> $completion) {
        if (!($completion instanceof getFeedFilter.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ EnterpriseFeedFilterProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getFeedFilter((Continuation<? super FeedFilter>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = (EnterpriseConfig)this.enterpriseConfigManager.getConfig().getValue();
                if (v0 == null || (v0 = v0.getMachineConfig()) == null) {
                    return null;
                }
                config = v0;
                if (this.enterpriseAccountProvider.getActiveAccount().getValue() == null) {
                    return this.state.getValue();
                }
                var5_7 = this;
                $continuation.L$0 = config;
                $continuation.L$1 = var5_7;
                $continuation.label = 1;
                v1 = this.loadFeedFilter((TbeMachineConfig)config, (Continuation<? super FeedFilter>)$continuation);
                ** if (v1 != var8_4) goto lbl27
lbl26:
                // 1 sources

                return var8_4;
lbl27:
                // 1 sources

                ** GOTO lbl35
            }
            case 1: {
                var5_7 = (EnterpriseFeedFilterProvider)$continuation.L$1;
                config = (TbeMachineConfig)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                feedFilter = var5_7.addUrlPrefixToFeedsIfApplicable$enterprise((FeedFilter)v1, config.getTbeServerUrl());
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)config);
                $continuation.L$1 = feedFilter;
                $continuation.label = 2;
                v2 = this.state.emit((Object)feedFilter, (Continuation)$continuation);
                ** if (v2 != var8_4) goto lbl42
lbl41:
                // 1 sources

                return var8_4;
lbl42:
                // 1 sources

                ** GOTO lbl54
            }
            case 2: {
                feedFilter = (FeedFilter)$continuation.L$1;
                config = (TbeMachineConfig)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                }
                catch (Exception e) {
                    Logger.INSTANCE.error((Throwable)e, "Unexpected error occurred when fetching TBE Filters. Switching to caches.");
                    var3_8 = (FeedFilter)this.state.getValue();
                }
lbl54:
                // 3 sources

                return var3_8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public FeedFilter getFeedFilterForPreloadedFeed() {
        EnterpriseConfig enterpriseConfig = (EnterpriseConfig)this.enterpriseConfigManager.getConfig().getValue();
        if ((enterpriseConfig != null ? enterpriseConfig.getMachineConfig() : null) == null) {
            return null;
        }
        return (FeedFilter)this.state.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FeedFilter addUrlPrefixToFeedsIfApplicable$enterprise(@NotNull FeedFilter $this$addUrlPrefixToFeedsIfApplicable, @NotNull String prefix) {
        Collection<void> collection;
        Intrinsics.checkNotNullParameter((Object)$this$addUrlPrefixToFeedsIfApplicable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String normalizedPrefix = this.normalizeLink(prefix);
        FeedFilter feedFilter = $this$addUrlPrefixToFeedsIfApplicable;
        Map map2 = null;
        Map map3 = null;
        Collection<FeedLocation> collection2 = $this$addUrlPrefixToFeedsIfApplicable.getFeeds();
        if (collection2 != null) {
            Collection<void> collection3;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = collection2;
            Map map4 = map3;
            Map map5 = map2;
            FeedFilter feedFilter2 = feedFilter;
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FeedLocation feedLocation = (FeedLocation)item$iv$iv;
                collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add((void)(!StringsKt.startsWith$default((String)it.getUrl(), (String)"http", (boolean)false, (int)2, null) ? this.addUrlPrefix((FeedLocation)it, normalizedPrefix) : it));
            }
            collection3 = (List)destination$iv$iv;
            feedFilter = feedFilter2;
            map2 = map5;
            map3 = map4;
            collection = collection3;
        } else {
            collection = null;
        }
        return FeedFilter.copy-Tbs9qNw$default(feedFilter, map2, map3, collection, false, 11, null);
    }

    private final FeedLocation addUrlPrefix(FeedLocation $this$addUrlPrefix, String prefix) {
        return FeedLocation.copy$default($this$addUrlPrefix, prefix + $this$addUrlPrefix.getUrl(), null, false, 6, null);
    }

    private final String normalizeLink(String url) {
        return StringsKt.removeSuffix((String)url, (CharSequence)"/") + "/";
    }

    /*
     * Unable to fully structure code
     */
    private final Object loadFeedFilter(TbeMachineConfig config, Continuation<? super FeedFilter> $completion) {
        if (!($completion instanceof loadFeedFilter.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ EnterpriseFeedFilterProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EnterpriseFeedFilterProvider.access$loadFeedFilter(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.debug("TBE Filter loading has been started");
                $continuation.L$0 = config;
                $continuation.label = 1;
                v0 = this.downloadManager.createSession((Continuation<? super DownloadSession>)$continuation);
                if (v0 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                config = (TbeMachineConfig)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                session = (DownloadSession)v0;
                url = this.buildToolsUrl(config);
                megabyte = 0x100000;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)config);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)session);
                $continuation.L$2 = url;
                $continuation.I$0 = megabyte;
                $continuation.label = 2;
                v1 = DownloadSession.getAsync$default(session, url, 5L * (long)megabyte, null, null, false, false, (Continuation)$continuation, 60, null);
                if (v1 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl42
            }
            case 2: {
                megabyte = $continuation.I$0;
                url = (String)$continuation.L$2;
                session = (DownloadSession)$continuation.L$1;
                config = (TbeMachineConfig)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl42:
                // 2 sources

                var6_11 = (Pair)v1;
                result = (DownloadResult)var6_11.component1();
                content = (byte[])var6_11.component2();
                if (!result.isSuccessful()) {
                    ErrorsHelperKt.errorResult$default("Could not download TBE Filter from " + url + ", reason: " + result, null, 2, null);
                    throw new KotlinNothingValueException();
                }
                try {
                    var10_14 = (FeedFilterDto)JsonKt.getJsonx().decodeFromString((DeserializationStrategy)FeedFilterDto.Companion.serializer(), StringsKt.decodeToString((byte[])content));
                }
                catch (Exception e) {
                    ErrorsHelperKt.errorResult("Failed to parse TBE Filter response: " + e.getMessage(), e);
                    throw new KotlinNothingValueException();
                }
                filter = var10_14;
                Logger.INSTANCE.info("TBE Filter received: includes " + filter.getTools().size() + " tools");
                Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, loadFeedFilter$lambda$1(com.jetbrains.toolbox.enterprise.feed.FeedFilterDto ), ()Ljava/lang/String;)((FeedFilterDto)filter));
                return FeedFilterDtoKt.toFeedFilter(filter);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String buildToolsUrl(TbeMachineConfig config) {
        String toolsUrl = this.normalizeLink(config.getTbeServerUrl()) + "api/tools";
        return EnterpriseSettingsRequestsKt.addEnterpriseSettingsRequest(HttpUrl.Companion.get(toolsUrl).newBuilder(), EnterpriseRequestKt.enterpriseSettingsRequest$default(null, false, 3, null)).build().toString();
    }

    private static final String loadFeedFilter$lambda$1(FeedFilterDto $filter) {
        return "TBE Filter received contents: " + $filter;
    }

    public static final /* synthetic */ Object access$loadFeedFilter(EnterpriseFeedFilterProvider $this, TbeMachineConfig config, Continuation $completion) {
        return $this.loadFeedFilter(config, (Continuation<? super FeedFilter>)$completion);
    }
}

