/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.configuration.steps;

import com.jetbrains.toolbox.ExecutablePathProvider;
import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.common.WellKnownPaths;
import com.jetbrains.toolbox.enterprise.EnterpriseConfig;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManager;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.model.SideEffect;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolRefreshHandler;
import com.jetbrains.toolbox.tools.model.VSCodeConfig;
import com.jetbrains.toolbox.tools.model.VSCodeTbaConfig;
import com.jetbrains.toolbox.tools.model.WithSideEffects;
import java.io.Closeable;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nVSCodeConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSCodeConfigurator.kt\ncom/jetbrains/toolbox/enterprise/configuration/steps/VSCodeConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 Okio.kt\nokio/Okio__OkioKt\n+ 5 OkioStreams.kt\nkotlinx/serialization/json/okio/OkioStreamsKt\n*L\n1#1,51:1\n1#2:52\n80#3:53\n165#3:54\n81#3:55\n82#3:60\n52#4,4:56\n60#4,10:62\n56#4,18:72\n46#5:61\n*S KotlinDebug\n*F\n+ 1 VSCodeConfigurator.kt\ncom/jetbrains/toolbox/enterprise/configuration/steps/VSCodeConfigurator\n*L\n47#1:53\n47#1:54\n47#1:55\n47#1:60\n47#1:56,4\n47#1:62,10\n47#1:72,18\n47#1:61\n*E\n"})
public final class VSCodeConfigurator
implements ToolRefreshHandler {
    @NotNull
    private final FileSystem filesystem;
    @NotNull
    private final WellKnownPaths wellKnownPaths;
    @NotNull
    private final EnterpriseConfigManager enterpriseConfigManager;
    @NotNull
    private final ExecutablePathProvider executablePathProvider;
    @NotNull
    private final AtomicBoolean wroteConfigOnInit;

    public VSCodeConfigurator(@NotNull FileSystem filesystem, @NotNull WellKnownPaths wellKnownPaths, @NotNull EnterpriseConfigManager enterpriseConfigManager, @NotNull ExecutablePathProvider executablePathProvider) {
        Intrinsics.checkNotNullParameter((Object)filesystem, (String)"filesystem");
        Intrinsics.checkNotNullParameter((Object)wellKnownPaths, (String)"wellKnownPaths");
        Intrinsics.checkNotNullParameter((Object)enterpriseConfigManager, (String)"enterpriseConfigManager");
        Intrinsics.checkNotNullParameter((Object)executablePathProvider, (String)"executablePathProvider");
        this.filesystem = filesystem;
        this.wellKnownPaths = wellKnownPaths;
        this.enterpriseConfigManager = enterpriseConfigManager;
        this.executablePathProvider = executablePathProvider;
        this.wroteConfigOnInit = new AtomicBoolean(false);
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        if (!this.wroteConfigOnInit.getAndSet(true) && WellKnownApplications.INSTANCE.isVSCodeType-lOMW6pk(toolInstance.getTool().getToolId-UtVBrGo())) {
            this.writeConfig();
        }
        return toolInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeConfig() {
        Unit unit;
        Throwable thrown$iv$iv;
        Path configPath;
        block16: {
            void $this$iv;
            boolean bl;
            EnterpriseConfig enterpriseConfig;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String token2 = string;
            VSCodeConfig config = new VSCodeConfig(new VSCodeTbaConfig(token2, this.executablePathProvider.getAbsolutePath()), (enterpriseConfig = (EnterpriseConfig)this.enterpriseConfigManager.getConfig().getValue()) != null && (enterpriseConfig = enterpriseConfig.getConfigPath()) != null ? enterpriseConfig.toString() : null);
            configPath = this.wellKnownPaths.getVSCodeConfigDir().resolve("config.json");
            Path path2 = configPath.parent();
            if (path2 != null) {
                Path it = path2;
                bl = false;
                this.filesystem.createDirectories(it);
            }
            FileSystem fileSystem = this.filesystem;
            Path file$iv = configPath;
            boolean mustCreate$iv = false;
            bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                void value$iv;
                void $this$encodeToBufferedSink$iv;
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSink $this$writeConfig_u24lambda_u241 = it$iv;
                boolean bl3 = false;
                Json json2 = JsonKt.getJsonx();
                VSCodeConfig vSCodeConfig = config;
                BufferedSink sink$iv = $this$writeConfig_u24lambda_u241;
                boolean $i$f$encodeToBufferedSink = false;
                $this$encodeToBufferedSink$iv.getSerializersModule();
                OkioStreamsKt.encodeToBufferedSink((Json)$this$encodeToBufferedSink$iv, (SerializationStrategy)((SerializationStrategy)VSCodeConfig.Companion.serializer()), (Object)value$iv, (BufferedSink)sink$iv);
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    unit = null;
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block17: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block17;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable != null) {
            throw throwable;
        }
        Logger.INSTANCE.debug("Wrote vscode configuration to " + configPath);
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull ToolInstance initial, @NotNull Continuation<? super ToolInstance> $completion) {
        return ToolRefreshHandler.super.onRefresh(toolInstance, initial, $completion);
    }

    @Override
    public boolean dependsOn(@NotNull WithSideEffects other) {
        return ToolRefreshHandler.super.dependsOn(other);
    }

    @Override
    @NotNull
    public Collection<SideEffect> getSideEffects() {
        return ToolRefreshHandler.super.getSideEffects();
    }

    @Override
    @NotNull
    public Collection<SideEffect> getRunAfter() {
        return ToolRefreshHandler.super.getRunAfter();
    }
}

