/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.configuration.steps;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.enterprise.configuration.EnterpriseToolInstanceUpdater;
import com.jetbrains.toolbox.enterprise.configuration.steps.EnterpriseToolConfigurationStep;
import com.jetbrains.toolbox.enterprise.rest.ToolNotification;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class EnterpriseRestrictionNotificationConfigurationStep
implements EnterpriseToolConfigurationStep {
    @Nullable
    private final ToolNotification ideExpiration;
    @NotNull
    private final EnterpriseToolInstanceUpdater enterpriseToolInstanceUpdater;

    public EnterpriseRestrictionNotificationConfigurationStep(@Nullable ToolNotification ideExpiration, @NotNull EnterpriseToolInstanceUpdater enterpriseToolInstanceUpdater) {
        Intrinsics.checkNotNullParameter((Object)enterpriseToolInstanceUpdater, (String)"enterpriseToolInstanceUpdater");
        this.ideExpiration = ideExpiration;
        this.enterpriseToolInstanceUpdater = enterpriseToolInstanceUpdater;
    }

    @Override
    @Nullable
    public Object execute(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        Logger.INSTANCE.info("Applying restriction notification " + this.ideExpiration + " to " + InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool()));
        return this.enterpriseToolInstanceUpdater.updateToolInstanceWithRestrictionNotification(toolInstance, this.ideExpiration);
    }

    @Override
    @NotNull
    public LocalizableString getDisplayName() {
        return EnterpriseToolConfigurationStep.super.getDisplayName();
    }
}

