/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.enterprise.rest.ToolNotification;
import com.jetbrains.toolbox.manager.ToolboxVersionUpdateDialog;
import com.jetbrains.toolbox.manager.ToolboxVersionUpdateDialogPresenter;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.tools.WellKnownChannelId;
import com.jetbrains.toolbox.tools.model.ChangeOptions;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ChannelState;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class EnterpriseToolboxVersionController {
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ToolboxVersionUpdateDialogPresenter toolboxVersionUpdateDialogPresenter;

    public EnterpriseToolboxVersionController(@NotNull ToolManager toolManager, @NotNull SettingsManager settingsManager, @NotNull Clock clock, @NotNull ToolboxVersionUpdateDialogPresenter toolboxVersionUpdateDialogPresenter) {
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)toolboxVersionUpdateDialogPresenter, (String)"toolboxVersionUpdateDialogPresenter");
        this.toolManager = toolManager;
        this.settingsManager = settingsManager;
        this.clock = clock;
        this.toolboxVersionUpdateDialogPresenter = toolboxVersionUpdateDialogPresenter;
    }

    public final void ensureVersionCompatibility-Vfb5HhE(@NotNull String minimumSupportedVersion, @Nullable ToolNotification restrictionNotification) {
        Intrinsics.checkNotNullParameter((Object)minimumSupportedVersion, (String)"minimumSupportedVersion");
        String currentVersion = Build.INSTANCE.getBuildNumber-Y_E1uuk();
        if (BuildNumber.compareTo-Szkhn3Q(currentVersion, minimumSupportedVersion) < 0) {
            this.toolboxVersionUpdateDialogPresenter.presentDialog(new ToolboxVersionUpdateDialog.UnsupportedVersion(minimumSupportedVersion, null));
        } else if (restrictionNotification != null) {
            boolean hasToolboxAvailableVersionToUpdate;
            boolean canToolboxBeAutomaticallyUpdated = ((SelfSettings)this.settingsManager.getSettings().getValue()).getUpdate().getInstallAutomatically();
            Object object = this.toolManager.getChannelState().get(ChannelId.box-impl(WellKnownChannelId.INSTANCE.getToolbox-5CZByfs()));
            boolean bl = hasToolboxAvailableVersionToUpdate = (object != null && (object = (ChannelState)object.getValue()) != null && (object = object.getChangeOptions()) != null ? ((ChangeOptions)object).getUpdate() : null) != null;
            if (this.clock.now().compareTo(restrictionNotification.getDeadline()) < 0 && canToolboxBeAutomaticallyUpdated && hasToolboxAvailableVersionToUpdate) {
                this.toolManager.update-CH08qv8(WellKnownChannelId.INSTANCE.getToolbox-5CZByfs());
                return;
            }
            this.toolboxVersionUpdateDialogPresenter.presentDialog(new ToolboxVersionUpdateDialog.RestrictedVersion(restrictionNotification.getDeadline(), restrictionNotification.getDescription()));
        } else {
            this.toolboxVersionUpdateDialogPresenter.hideDialog();
        }
    }
}

