/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise;

import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.enterprise.EnterpriseSettingsControlIntervals;
import com.jetbrains.toolbox.enterprise.settings.EnterpriseToolboxSetting;
import com.jetbrains.toolbox.enterprise.settings.EnterpriseToolboxSettings;
import com.jetbrains.toolbox.enterprise.settings.EnterpriseToolboxSettingsProvider;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

public final class EnterpriseSettingsControlIntervalsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StateFlow<EnterpriseSettingsControlIntervals> intervals;
    private static final long defaultForcedSettingsCheckInterval = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES);
    private static final long defaultSettingsRefreshInterval = DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.HOURS);

    public EnterpriseSettingsControlIntervalsProvider(@NotNull EnterpriseToolboxSettingsProvider enterpriseToolboxSettingsProvider) {
        Intrinsics.checkNotNullParameter((Object)enterpriseToolboxSettingsProvider, (String)"enterpriseToolboxSettingsProvider");
        this.intervals = FlowExtensionsKt.mapState(enterpriseToolboxSettingsProvider.getSettings(), EnterpriseSettingsControlIntervalsProvider::intervals$lambda$1);
    }

    @NotNull
    public final StateFlow<EnterpriseSettingsControlIntervals> getIntervals() {
        return this.intervals;
    }

    private static final EnterpriseSettingsControlIntervals intervals$lambda$1(EnterpriseToolboxSettings settings2) {
        EnterpriseSettingsControlIntervals enterpriseSettingsControlIntervals;
        EnterpriseToolboxSettings enterpriseToolboxSettings2 = settings2;
        if (enterpriseToolboxSettings2 != null) {
            EnterpriseToolboxSettings it = enterpriseToolboxSettings2;
            boolean bl = false;
            EnterpriseToolboxSetting<Duration> enterpriseToolboxSetting = it.getForcedSettingsUpdateInterval();
            EnterpriseToolboxSetting<Duration> enterpriseToolboxSetting2 = it.getSettingsUpdateInterval();
            enterpriseSettingsControlIntervals = new EnterpriseSettingsControlIntervals(enterpriseToolboxSetting != null ? enterpriseToolboxSetting.getValue().unbox-impl() : defaultForcedSettingsCheckInterval, enterpriseToolboxSetting2 != null ? enterpriseToolboxSetting2.getValue().unbox-impl() : defaultSettingsRefreshInterval, null);
        } else {
            enterpriseSettingsControlIntervals = null;
        }
        return enterpriseSettingsControlIntervals;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

