/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise;

import com.jetbrains.tbe.config.machine.TbeMachineConfig;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnterpriseConfig {
    @NotNull
    private final TbeMachineConfig machineConfig;
    private final boolean isAdminLevel;
    @NotNull
    private final Path configPath;

    public EnterpriseConfig(@NotNull TbeMachineConfig machineConfig, boolean isAdminLevel, @NotNull Path configPath) {
        Intrinsics.checkNotNullParameter((Object)machineConfig, (String)"machineConfig");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        this.machineConfig = machineConfig;
        this.isAdminLevel = isAdminLevel;
        this.configPath = configPath;
    }

    @NotNull
    public final TbeMachineConfig getMachineConfig() {
        return this.machineConfig;
    }

    public final boolean isAdminLevel() {
        return this.isAdminLevel;
    }

    @NotNull
    public final Path getConfigPath() {
        return this.configPath;
    }

    @NotNull
    public String toString() {
        return "EnterpriseConfig(machineConfig=" + this.machineConfig + ", isAdminLevel=" + this.isAdminLevel + ", configPath=" + this.configPath + ")";
    }

    public int hashCode() {
        int result2 = this.machineConfig.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isAdminLevel);
        result2 = result2 * 31 + this.configPath.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EnterpriseConfig)) {
            return false;
        }
        EnterpriseConfig enterpriseConfig = (EnterpriseConfig)other;
        if (!Intrinsics.areEqual((Object)this.machineConfig, (Object)enterpriseConfig.machineConfig)) {
            return false;
        }
        if (this.isAdminLevel != enterpriseConfig.isAdminLevel) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.configPath, (Object)enterpriseConfig.configPath);
    }
}

