/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.educational;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.Notifications;
import com.jetbrains.toolbox.WindowManager;
import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.educational.EducationalJBALoginManager;
import com.jetbrains.toolbox.educational.EducationalProtocolHandler;
import com.jetbrains.toolbox.educational.EducationalToolManager;
import com.jetbrains.toolbox.educational.EducationalToolReconfigurator;
import com.jetbrains.toolbox.educational.EducationalToolReconfiguratorFactory;
import com.jetbrains.toolbox.educational.OpenCourseRequest;
import com.jetbrains.toolbox.educational.progress.EducationalProgressManager;
import com.jetbrains.toolbox.educational.progress.ProgressEvent;
import com.jetbrains.toolbox.educational.progress.SessionId;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.fus.FusFieldDescriptions;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.manager.StatisticsManager;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.protocolhandler.ProtocolHandler;
import com.jetbrains.toolbox.tools.launcher.ToolLauncher;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nEducationalProtocolHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EducationalProtocolHandler.kt\ncom/jetbrains/toolbox/educational/EducationalProtocolHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,310:1\n1#2:311\n1563#3:312\n1634#3,3:313\n77#4:316\n97#4,5:317\n205#5:322\n*S KotlinDebug\n*F\n+ 1 EducationalProtocolHandler.kt\ncom/jetbrains/toolbox/educational/EducationalProtocolHandler\n*L\n265#1:312\n265#1:313,3\n284#1:316\n284#1:317,5\n288#1:322\n*E\n"})
public final class EducationalProtocolHandler
implements ProtocolHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EducationalJBALoginManager educationalJBALoginManager;
    @NotNull
    private final EducationalToolManager educationalToolManager;
    @NotNull
    private final EducationalToolReconfiguratorFactory educationalToolReconfiguratorFactory;
    @NotNull
    private final EducationalProgressManager educationalProgressManager;
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final ToolLauncher toolLauncher;
    @NotNull
    private final StatisticsManager statisticsManager;
    @NotNull
    private final I18n i18n;
    @NotNull
    private final Notifications notifications;
    @NotNull
    private final WindowManager windowManager;
    @NotNull
    private final OS.Type os;
    @NotNull
    private final Set<URI> processingUris;
    private final boolean impliesUiMode;
    private static final long SESSION_CONNECTION_MAX_WAITING_TIME = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
    private static final long SESSION_CONNECTION_CHECK_INTERVAL = DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS);
    @NotNull
    private static final String PLUGIN_2025_3 = BuildNumber.constructor-impl("2025.3");
    @NotNull
    private static final String PLUGIN_2025_7 = BuildNumber.constructor-impl("2025.7");

    public EducationalProtocolHandler(@NotNull EducationalJBALoginManager educationalJBALoginManager, @NotNull EducationalToolManager educationalToolManager, @NotNull EducationalToolReconfiguratorFactory educationalToolReconfiguratorFactory, @NotNull EducationalProgressManager educationalProgressManager, @NotNull ToolManager toolManager, @NotNull ToolLauncher toolLauncher, @NotNull StatisticsManager statisticsManager, @NotNull I18n i18n, @NotNull Notifications notifications, @NotNull WindowManager windowManager, @NotNull OS.Type os) {
        Intrinsics.checkNotNullParameter((Object)educationalJBALoginManager, (String)"educationalJBALoginManager");
        Intrinsics.checkNotNullParameter((Object)educationalToolManager, (String)"educationalToolManager");
        Intrinsics.checkNotNullParameter((Object)educationalToolReconfiguratorFactory, (String)"educationalToolReconfiguratorFactory");
        Intrinsics.checkNotNullParameter((Object)educationalProgressManager, (String)"educationalProgressManager");
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter((Object)toolLauncher, (String)"toolLauncher");
        Intrinsics.checkNotNullParameter((Object)statisticsManager, (String)"statisticsManager");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Intrinsics.checkNotNullParameter((Object)notifications, (String)"notifications");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        this.educationalJBALoginManager = educationalJBALoginManager;
        this.educationalToolManager = educationalToolManager;
        this.educationalToolReconfiguratorFactory = educationalToolReconfiguratorFactory;
        this.educationalProgressManager = educationalProgressManager;
        this.toolManager = toolManager;
        this.toolLauncher = toolLauncher;
        this.statisticsManager = statisticsManager;
        this.i18n = i18n;
        this.notifications = notifications;
        this.windowManager = windowManager;
        this.os = os;
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.processingUris = keySetView;
        this.impliesUiMode = true;
    }

    @Override
    public boolean canHandle(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)uri.getHost(), (Object)"educational");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object handle(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        block14: {
            if (!($completion instanceof handle.1)) ** GOTO lbl-1000
            var6_3 = $completion;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ EducationalProtocolHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handle(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = this.parse(uri);
                    if (v0 == null) {
                        return Unit.INSTANCE;
                    }
                    openCourseRequest = v0;
                    $continuation.L$0 = uri;
                    $continuation.L$1 = openCourseRequest;
                    $continuation.label = 1;
                    v1 = this.windowManager.showWindow((Continuation<? super Unit>)$continuation);
                    if (v1 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl28
                }
                case 1: {
                    openCourseRequest = (OpenCourseRequest)$continuation.L$1;
                    uri = (URI)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl28:
                    // 2 sources

                    if (!this.processingUris.add(uri)) break;
                    $continuation.L$0 = uri;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)openCourseRequest);
                    $continuation.label = 2;
                    v2 = this.processOpenCourseRequest(openCourseRequest, (Continuation<? super Unit>)$continuation);
                    ** if (v2 != var7_5) goto lbl37
lbl36:
                    // 1 sources

                    return var7_5;
lbl37:
                    // 1 sources

                    break block14;
                }
                case 2: {
                    openCourseRequest = (OpenCourseRequest)$continuation.L$1;
                    uri = (URI)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break block14;
                    }
                    catch (Throwable var4_8) {
                        throw var4_8;
                    }
                    finally {
                        this.processingUris.remove(uri);
                    }
                }
            }
            Logger.INSTANCE.info(uri + " is already processing");
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object processOpenCourseRequest(OpenCourseRequest openCourseRequest, Continuation<? super Unit> $completion) {
        if (!($completion instanceof processOpenCourseRequest.1)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ EducationalProtocolHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EducationalProtocolHandler.access$processOpenCourseRequest(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = openCourseRequest;
                $continuation.label = 1;
                v0 = this.waitForProgressSessionConnection(openCourseRequest, (Continuation<? super Unit>)$continuation);
                if (v0 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                openCourseRequest = (OpenCourseRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                this.educationalProgressManager.reportProgress-_TKwOzk(openCourseRequest.getSessionId-TGm0tZ4(), ProgressEvent.Started.INSTANCE);
                this.statisticsManager.getLogger().logVararg(Fus.Counters.Educational.INSTANCE.getOpenCourseRequest(), (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, processOpenCourseRequest$lambda$0(com.jetbrains.toolbox.educational.OpenCourseRequest com.jetbrains.toolbox.fus.FusFieldDescriptions$EducationalAction ), (Lcom/jetbrains/toolbox/fus/FusFieldDescriptions$EducationalAction;)Lkotlin/Unit;)((OpenCourseRequest)openCourseRequest));
                if (!openCourseRequest.getNeedToLogin()) ** GOTO lbl48
                $continuation.L$0 = openCourseRequest;
                $continuation.label = 2;
                v1 = this.educationalJBALoginManager.initiateJBALoginAndWait((Continuation<? super Boolean>)$continuation);
                if (v1 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl35
            }
            case 2: {
                openCourseRequest = (OpenCourseRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                if (loggedIn = ((Boolean)v1).booleanValue()) {
                    $continuation.L$0 = openCourseRequest;
                    $continuation.Z$0 = loggedIn;
                    $continuation.label = 3;
                    v2 = this.windowManager.showWindow((Continuation<? super Unit>)$continuation);
                    if (v2 == var13_5) {
                        return var13_5;
                    }
                }
                ** GOTO lbl48
            }
            case 3: {
                loggedIn = $continuation.Z$0;
                openCourseRequest = (OpenCourseRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl48:
                // 3 sources

                $continuation.L$0 = openCourseRequest;
                $continuation.label = 4;
                v3 = this.findSuitableToolOrInstall(openCourseRequest, (Continuation<? super EducationalToolManager.InstalledToolInfo>)$continuation);
                if (v3 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl58
            }
            case 4: {
                openCourseRequest = (OpenCourseRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl58:
                // 2 sources

                toolInstallationInfo = (EducationalToolManager.InstalledToolInfo)v3;
                this.statisticsManager.getLogger().logVararg(Fus.Counters.Educational.INSTANCE.getToolInstallation(), (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, processOpenCourseRequest$lambda$1(com.jetbrains.toolbox.educational.OpenCourseRequest com.jetbrains.toolbox.educational.EducationalToolManager$InstalledToolInfo com.jetbrains.toolbox.fus.FusFieldDescriptions$EducationalToolInstallationAction ), (Lcom/jetbrains/toolbox/fus/FusFieldDescriptions$EducationalToolInstallationAction;)Lkotlin/Unit;)((OpenCourseRequest)openCourseRequest, (EducationalToolManager.InstalledToolInfo)toolInstallationInfo));
                v4 = toolInstallationInfo;
                v5 = channelId = v4 != null ? v4.getChannelId-5CZByfs() : null;
                if (channelId != null) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)openCourseRequest);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)toolInstallationInfo);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)channelId);
                $continuation.label = 5;
                v6 = this.notifications.showErrorMessage(this.i18n.tr("Failed to find or install IDE to open a course"), (Continuation<? super Unit>)$continuation);
                if (v6 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl77
            }
            case 5: {
                channelId = (String)$continuation.L$2;
                toolInstallationInfo = (EducationalToolManager.InstalledToolInfo)$continuation.L$1;
                openCourseRequest = (OpenCourseRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl77:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        this.educationalProgressManager.reportProgress-_TKwOzk(openCourseRequest.getSessionId-TGm0tZ4(), ProgressEvent.Configuring.INSTANCE);
        configurator = this.educationalToolReconfiguratorFactory.createToolReconfigurator(openCourseRequest);
        this.toolManager.reconfigure-R5oYZt4(channelId, configurator);
        $continuation.L$0 = openCourseRequest;
        $continuation.L$1 = toolInstallationInfo;
        $continuation.L$2 = channelId;
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)configurator);
        $continuation.label = 6;
        v7 = FlowKt.first((Flow)((Flow)configurator.getProgress()), (Function2)((Function2)new Function2<EducationalToolReconfigurator.State, Continuation<? super Boolean>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                EducationalToolReconfigurator.State state2 = (EducationalToolReconfigurator.State)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        return Boxing.boxBoolean((boolean)(it instanceof EducationalToolReconfigurator.State.Finished));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(EducationalToolReconfigurator.State p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Continuation)$continuation);
        if (v7 == var13_5) {
            return var13_5;
        }
        ** GOTO lbl97
        {
            case 6: {
                configurator = (EducationalToolReconfigurator)$continuation.L$3;
                channelId = (String)$continuation.L$2;
                toolInstallationInfo = (EducationalToolManager.InstalledToolInfo)$continuation.L$1;
                openCourseRequest = (OpenCourseRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl97:
                // 2 sources

                Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.educational.EducationalToolReconfigurator.State.Finished");
                result = (EducationalToolReconfigurator.State.Finished)v7;
                if (result.getJetBrainsAcademyPluginInstalled()) break;
                this.educationalProgressManager.reportProgress-_TKwOzk(openCourseRequest.getSessionId-TGm0tZ4(), new ProgressEvent.Error(ProgressEvent.ErrorKind.ConfigurationFailed));
                toolVersion = toolInstallationInfo.getTool().getVersionName();
                toolName = toolInstallationInfo.getTool().getToolName();
                var10_26 = new Pair[]{TuplesKt.to((Object)"toolName", (Object)toolName), TuplesKt.to((Object)"toolVersion", (Object)toolVersion)};
                notificationMessage = this.i18n.tr("Failed to configure {{toolName}} {{toolVersion}} to open a course", var10_26);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)openCourseRequest);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)toolInstallationInfo);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)channelId);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)configurator);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)result);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)toolVersion);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)toolName);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)notificationMessage);
                $continuation.label = 7;
                v8 = this.notifications.showErrorMessage(notificationMessage, (Continuation<? super Unit>)$continuation);
                if (v8 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl129
            }
            case 7: {
                notificationMessage = (String)$continuation.L$7;
                toolName = (String)$continuation.L$6;
                toolVersion = (String)$continuation.L$5;
                result = (EducationalToolReconfigurator.State.Finished)$continuation.L$4;
                configurator = (EducationalToolReconfigurator)$continuation.L$3;
                channelId = (String)$continuation.L$2;
                toolInstallationInfo = (EducationalToolManager.InstalledToolInfo)$continuation.L$1;
                openCourseRequest = (OpenCourseRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl129:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        this.educationalProgressManager.reportProgress-_TKwOzk(openCourseRequest.getSessionId-TGm0tZ4(), ProgressEvent.Configured.INSTANCE);
        launchArgs = this.createOpenCourseCommandArgs(openCourseRequest);
        $continuation.L$0 = openCourseRequest;
        $continuation.L$1 = toolInstallationInfo;
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)channelId);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)configurator);
        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)result);
        $continuation.L$5 = SpillingKt.nullOutSpilledVariable(launchArgs);
        $continuation.label = 8;
        v9 = this.toolLauncher.launchTool-dSwq_qA(channelId, null, false, null, launchArgs).await((Continuation)$continuation);
        if (v9 == var13_5) {
            return var13_5;
        }
        ** GOTO lbl152
        {
            case 8: {
                launchArgs = (List)$continuation.L$5;
                result = (EducationalToolReconfigurator.State.Finished)$continuation.L$4;
                configurator = (EducationalToolReconfigurator)$continuation.L$3;
                channelId = (String)$continuation.L$2;
                toolInstallationInfo = (EducationalToolManager.InstalledToolInfo)$continuation.L$1;
                openCourseRequest = (OpenCourseRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl152:
                // 2 sources

                this.educationalProgressManager.reportProgress-_TKwOzk(openCourseRequest.getSessionId-TGm0tZ4(), ProgressEvent.Finished.INSTANCE);
                this.statisticsManager.getLogger().logVararg(Fus.Counters.Educational.INSTANCE.getOpenCourseDialog(), (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, processOpenCourseRequest$lambda$2(com.jetbrains.toolbox.educational.OpenCourseRequest com.jetbrains.toolbox.educational.EducationalToolManager$InstalledToolInfo com.jetbrains.toolbox.fus.FusFieldDescriptions$EducationalOpenCourseAction ), (Lcom/jetbrains/toolbox/fus/FusFieldDescriptions$EducationalOpenCourseAction;)Lkotlin/Unit;)((OpenCourseRequest)openCourseRequest, (EducationalToolManager.InstalledToolInfo)toolInstallationInfo));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public boolean getImpliesUiMode() {
        return this.impliesUiMode;
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitForProgressSessionConnection(OpenCourseRequest openCourseRequest, Continuation<? super Unit> $completion) {
        if (!($completion instanceof waitForProgressSessionConnection.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ EducationalProtocolHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EducationalProtocolHandler.access$waitForProgressSessionConnection(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (SessionId.equals-impl0(openCourseRequest.getSessionId-TGm0tZ4(), SessionId.Companion.getNULL-TGm0tZ4())) ** GOTO lbl27
                $continuation.L$0 = openCourseRequest;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)EducationalProtocolHandler.SESSION_CONNECTION_MAX_WAITING_TIME, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, openCourseRequest, null){
                    int label;
                    final /* synthetic */ EducationalProtocolHandler this$0;
                    final /* synthetic */ OpenCourseRequest $openCourseRequest;
                    {
                        this.this$0 = $receiver;
                        this.$openCourseRequest = $openCourseRequest;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
lbl5:
                                // 3 sources

                                while (!EducationalProtocolHandler.access$getEducationalProgressManager$p(this.this$0).getSessions().containsKey(SessionId.box-impl(this.$openCourseRequest.getSessionId-TGm0tZ4()))) {
                                    Logger.INSTANCE.debug("Can't find connection for sessionId " + SessionId.toString-impl(this.$openCourseRequest.getSessionId-TGm0tZ4()));
                                    this.label = 1;
                                    v0 = DelayKt.delay-VtjQ1oo((long)EducationalProtocolHandler.access$getSESSION_CONNECTION_CHECK_INTERVAL$cp(), (Continuation)((Continuation)this));
                                    if (v0 != var2_2) continue;
                                    return var2_2;
                                }
                                break;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl5
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                openCourseRequest = (OpenCourseRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                if (this.educationalProgressManager.getSessions().containsKey(SessionId.box-impl(openCourseRequest.getSessionId-TGm0tZ4()))) {
                    Logger.INSTANCE.debug("Connection for sessionId " + SessionId.toString-impl(openCourseRequest.getSessionId-TGm0tZ4()) + " found!");
                } else {
                    Logger.INSTANCE.debug("No connection for sessionId " + SessionId.toString-impl(openCourseRequest.getSessionId-TGm0tZ4()));
                }
lbl27:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object findSuitableToolOrInstall(OpenCourseRequest openCourseRequest, Continuation<? super EducationalToolManager.InstalledToolInfo> $completion) {
        if (!($completion instanceof findSuitableToolOrInstall.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ EducationalProtocolHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EducationalProtocolHandler.access$findSuitableToolOrInstall(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                state = this.educationalToolManager.findSuitableToolOrInstall-nDJfUvo(openCourseRequest.getCompatibleToolIds(), openCourseRequest.getMinToolVersion-Y_E1uuk());
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)openCourseRequest);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(state);
                $continuation.label = 1;
                v0 = FlowKt.first((Flow)FlowKt.onEach(state, (Function2)((Function2)new Function2<EducationalToolManager.ToolInstallationState, Continuation<? super Unit>, Object>(this, openCourseRequest, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ EducationalProtocolHandler this$0;
                    final /* synthetic */ OpenCourseRequest $openCourseRequest;
                    {
                        this.this$0 = $receiver;
                        this.$openCourseRequest = $openCourseRequest;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        EducationalToolManager.ToolInstallationState toolInstallationState = (EducationalToolManager.ToolInstallationState)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                ProgressEvent message2 = EducationalProtocolHandler.access$toProgressMessage(this.this$0, (EducationalToolManager.ToolInstallationState)it);
                                EducationalProtocolHandler.access$getEducationalProgressManager$p(this.this$0).reportProgress-_TKwOzk(this.$openCourseRequest.getSessionId-TGm0tZ4(), message2);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(EducationalToolManager.ToolInstallationState p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                })), (Function2)((Function2)new Function2<EducationalToolManager.ToolInstallationState, Continuation<? super Boolean>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        EducationalToolManager.ToolInstallationState toolInstallationState = (EducationalToolManager.ToolInstallationState)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                return Boxing.boxBoolean((boolean)(it instanceof EducationalToolManager.TerminalToolInstallationState));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(EducationalToolManager.ToolInstallationState p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                state = (Flow)$continuation.L$1;
                openCourseRequest = (OpenCourseRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                v1 = (terminalState = (EducationalToolManager.ToolInstallationState)v0) instanceof EducationalToolManager.InstalledOrFound != false ? (EducationalToolManager.InstalledOrFound)terminalState : null;
                return v1 != null ? v1.getInfo() : null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final ProgressEvent toProgressMessage(EducationalToolManager.ToolInstallationState $this$toProgressMessage) {
        ProgressEvent progressEvent;
        EducationalToolManager.ToolInstallationState toolInstallationState = $this$toProgressMessage;
        if (Intrinsics.areEqual((Object)toolInstallationState, (Object)EducationalToolManager.Started.INSTANCE)) {
            progressEvent = ProgressEvent.ToolInstallationStarted.INSTANCE;
        } else if (Intrinsics.areEqual((Object)toolInstallationState, (Object)EducationalToolManager.NotFound.INSTANCE)) {
            progressEvent = new ProgressEvent.Error(ProgressEvent.ErrorKind.ToolNotFound);
        } else if (toolInstallationState instanceof EducationalToolManager.Installing) {
            progressEvent = new ProgressEvent.ToolInstallation(((EducationalToolManager.Installing)$this$toProgressMessage).getBuild());
        } else if (Intrinsics.areEqual((Object)toolInstallationState, (Object)EducationalToolManager.Failed.INSTANCE)) {
            progressEvent = new ProgressEvent.Error(ProgressEvent.ErrorKind.ToolInstallationFailed);
        } else if (toolInstallationState instanceof EducationalToolManager.InstalledOrFound) {
            progressEvent = new ProgressEvent.ToolInstalledOrFound(((EducationalToolManager.InstalledOrFound)$this$toProgressMessage).getInfo());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return progressEvent;
    }

    /*
     * WARNING - void declaration
     */
    private final OpenCourseRequest parse(URI $this$parse) {
        Collection<ApplicationType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        String minPluginVersion;
        String string2;
        Map parsedQuery = MapsKt.toMutableMap(URIExtensionsKt.parseQuery($this$parse));
        String string3 = (String)parsedQuery.remove("courseId");
        if (string3 == null) {
            return null;
        }
        String courseId = string3;
        String string4 = (String)parsedQuery.remove("source");
        if (string4 == null) {
            return null;
        }
        String source = string4;
        String string5 = (String)parsedQuery.remove("tools");
        if (string5 == null) {
            return null;
        }
        String tools2 = string5;
        if (StringsKt.isBlank((CharSequence)tools2)) {
            return null;
        }
        String string6 = (String)parsedQuery.remove("minToolVersion");
        if (string6 != null) {
            String p0 = string6;
            boolean bl = false;
            string2 = BuildNumber.constructor-impl(p0);
        } else {
            string2 = BuildNumber.Companion.getZERO-Y_E1uuk();
        }
        String minToolVersion = string2;
        String string7 = (String)parsedQuery.remove("minPluginVersion");
        if (string7 != null) {
            String p0 = string7;
            boolean bl = false;
            v6 = BuildNumber.constructor-impl(p0);
        } else {
            v6 = minPluginVersion = BuildNumber.Companion.getZERO-Y_E1uuk();
        }
        if ((string = (String)parsedQuery.remove("pluginChannel")) == null) {
            string = "stable";
        }
        String pluginChannel = string;
        String sessionId = SessionId.Companion.from-3NcgI9c((String)parsedQuery.remove("sessionId"));
        String string8 = (String)parsedQuery.remove("login");
        boolean needToLogin = string8 != null ? Boolean.parseBoolean(string8) : false;
        Object p0 = new String[]{","};
        p0 = StringsKt.split$default((CharSequence)tools2, (String[])p0, (boolean)false, (int)0, (int)6, null);
        String string9 = source;
        String string10 = courseId;
        boolean $i$f$map = false;
        void var13_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p02;
            String string11 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApplicationType.box-impl(ApplicationType.constructor-impl((String)p02)));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        Map map2 = parsedQuery;
        boolean bl = needToLogin;
        String string12 = sessionId;
        String string13 = pluginChannel;
        String string14 = minPluginVersion;
        String string15 = minToolVersion;
        List list2 = collection;
        String string16 = string9;
        String string17 = string10;
        return new OpenCourseRequest(string17, string16, list2, string15, string14, string13, string12, bl, map2, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> createOpenCourseCommandArgs(OpenCourseRequest openCourseRequest) {
        Object object = new String[]{"openCourse", "--" + openCourseRequest.getSource(), openCourseRequest.getCourseId()};
        List args = CollectionsKt.mutableListOf((Object[])object);
        if (BuildNumber.compareTo-Szkhn3Q(openCourseRequest.getMinPluginVersion-Y_E1uuk(), PLUGIN_2025_7) >= 0) {
            void $this$flatMapTo$iv$iv;
            object = args;
            Object $this$flatMap$iv = openCourseRequest.getCourseParams();
            boolean $i$f$flatMap = false;
            Map<String, String> map2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator2.next();
                boolean bl = false;
                String name2 = (String)entry.getKey();
                String value2 = (String)entry.getValue();
                Object[] objectArray = new String[]{"--" + name2, value2};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)object, (Iterable)$this$flatMap$iv);
        } else if (BuildNumber.compareTo-Szkhn3Q(openCourseRequest.getMinPluginVersion-Y_E1uuk(), PLUGIN_2025_3) >= 0) {
            void this_$iv;
            Json $this$flatMap$iv = (Json)Json.Default;
            Map<String, String> value$iv = openCourseRequest.getCourseParams();
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String courseParams = this_$iv.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), value$iv);
            if (this.os.isWindows()) {
                courseParams = StringsKt.replace$default((String)courseParams, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
            }
            Collection collection = args;
            Object[] objectArray = new String[]{"--course-params", courseParams};
            CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }
        return args;
    }

    private static final Unit processOpenCourseRequest$lambda$0(OpenCourseRequest $openCourseRequest, FusFieldDescriptions.EducationalAction $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setCourseId($openCourseRequest.getCourseId());
        $this$logVararg.setSource($openCourseRequest.getSource());
        return Unit.INSTANCE;
    }

    private static final Unit processOpenCourseRequest$lambda$1(OpenCourseRequest $openCourseRequest, EducationalToolManager.InstalledToolInfo $toolInstallationInfo, FusFieldDescriptions.EducationalToolInstallationAction $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setCourseId($openCourseRequest.getCourseId());
        $this$logVararg.setSource($openCourseRequest.getSource());
        Object object = $toolInstallationInfo;
        $this$logVararg.setTool-sDA0F08(object != null && (object = ((EducationalToolManager.InstalledToolInfo)object).getTool()) != null ? ((InstalledTool)object).getToolId-UtVBrGo() : null);
        Object object2 = $toolInstallationInfo;
        $this$logVararg.setVersion-7xp1vhg(object2 != null && (object2 = ((EducationalToolManager.InstalledToolInfo)object2).getTool()) != null ? ((InstalledTool)object2).getBuildNumber-Y_E1uuk() : null);
        $this$logVararg.setInstallation($toolInstallationInfo == null ? FusEnums.EducationalToolInstallation.FAILED_TO_INSTALL : ($toolInstallationInfo.getInstalled() ? FusEnums.EducationalToolInstallation.INSTALLED : FusEnums.EducationalToolInstallation.FOUND));
        return Unit.INSTANCE;
    }

    private static final Unit processOpenCourseRequest$lambda$2(OpenCourseRequest $openCourseRequest, EducationalToolManager.InstalledToolInfo $toolInstallationInfo, FusFieldDescriptions.EducationalOpenCourseAction $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setCourseId($openCourseRequest.getCourseId());
        $this$logVararg.setSource($openCourseRequest.getSource());
        $this$logVararg.setTool-sDA0F08($toolInstallationInfo.getTool().getToolId-UtVBrGo());
        $this$logVararg.setVersion-7xp1vhg($toolInstallationInfo.getTool().getBuildNumber-Y_E1uuk());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$processOpenCourseRequest(EducationalProtocolHandler $this, OpenCourseRequest openCourseRequest, Continuation $completion) {
        return $this.processOpenCourseRequest(openCourseRequest, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$waitForProgressSessionConnection(EducationalProtocolHandler $this, OpenCourseRequest openCourseRequest, Continuation $completion) {
        return $this.waitForProgressSessionConnection(openCourseRequest, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ EducationalProgressManager access$getEducationalProgressManager$p(EducationalProtocolHandler $this) {
        return $this.educationalProgressManager;
    }

    public static final /* synthetic */ long access$getSESSION_CONNECTION_CHECK_INTERVAL$cp() {
        return SESSION_CONNECTION_CHECK_INTERVAL;
    }

    public static final /* synthetic */ Object access$findSuitableToolOrInstall(EducationalProtocolHandler $this, OpenCourseRequest openCourseRequest, Continuation $completion) {
        return $this.findSuitableToolOrInstall(openCourseRequest, (Continuation<? super EducationalToolManager.InstalledToolInfo>)$completion);
    }

    public static final /* synthetic */ ProgressEvent access$toProgressMessage(EducationalProtocolHandler $this, EducationalToolManager.ToolInstallationState $receiver) {
        return $this.toProgressMessage($receiver);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

