/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.dotDesktopFiles;

import com.jetbrains.toolbox.common.io.PathExtensionsKt;
import com.jetbrains.toolbox.dotDesktopFiles.DotDesktopAccessor;
import com.jetbrains.toolbox.dotDesktopFiles.DotDesktopFileChannelExtension;
import com.jetbrains.toolbox.dotDesktopFiles.IconUtilKt;
import com.jetbrains.toolbox.dotDesktopFiles.UtilKt;
import com.jetbrains.toolbox.tools.ExtensionsKt;
import com.jetbrains.toolbox.tools.image.ImageManager;
import com.jetbrains.toolbox.tools.model.AvailableTools;
import com.jetbrains.toolbox.tools.model.DetectedToolInstance;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.OsIntegration;
import com.jetbrains.toolbox.tools.model.SideEffect;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolIconSideEffect;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolRefreshHandler;
import com.jetbrains.toolbox.tools.model.WithSideEffects;
import com.jetbrains.toolbox.tools.provider.LocalToolScanner;
import java.util.Collection;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nDotDesktopFileRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotDesktopFileRefresher.kt\ncom/jetbrains/toolbox/dotDesktopFiles/DotDesktopFileRefresher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class DotDesktopFileRefresher
implements OsIntegration,
ToolRefreshHandler {
    @NotNull
    private final StateFlow<AvailableTools> availableTools;
    @NotNull
    private final DotDesktopAccessor dotDesktopAccessor;
    @NotNull
    private final ImageManager imageManager;
    @NotNull
    private final LocalToolScanner toolScanner;
    @NotNull
    private final Path dotDesktopFileCommonPath;
    @NotNull
    private final Path dotDesktopIconsCachePath;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Collection<SideEffect> runAfter;

    public DotDesktopFileRefresher(@NotNull StateFlow<AvailableTools> availableTools2, @NotNull DotDesktopAccessor dotDesktopAccessor, @NotNull ImageManager imageManager, @NotNull LocalToolScanner toolScanner, @NotNull Path dotDesktopFileCommonPath, @NotNull Path dotDesktopIconsCachePath, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter(availableTools2, (String)"availableTools");
        Intrinsics.checkNotNullParameter((Object)dotDesktopAccessor, (String)"dotDesktopAccessor");
        Intrinsics.checkNotNullParameter((Object)imageManager, (String)"imageManager");
        Intrinsics.checkNotNullParameter((Object)toolScanner, (String)"toolScanner");
        Intrinsics.checkNotNullParameter((Object)dotDesktopFileCommonPath, (String)"dotDesktopFileCommonPath");
        Intrinsics.checkNotNullParameter((Object)dotDesktopIconsCachePath, (String)"dotDesktopIconsCachePath");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.availableTools = availableTools2;
        this.dotDesktopAccessor = dotDesktopAccessor;
        this.imageManager = imageManager;
        this.toolScanner = toolScanner;
        this.dotDesktopFileCommonPath = dotDesktopFileCommonPath;
        this.dotDesktopIconsCachePath = dotDesktopIconsCachePath;
        this.fileSystem = fileSystem;
        this.runAfter = CollectionsKt.listOf((Object)ToolIconSideEffect.INSTANCE);
    }

    @Override
    @NotNull
    public Collection<SideEffect> getRunAfter() {
        return this.runAfter;
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        Path previousIconPath;
        Object it;
        String string;
        Path dotDesktopFilePath;
        DotDesktopFileChannelExtension dotDesktopFileName;
        Path command2;
        block13: {
            block12: {
                Path path2 = ExtensionsKt.getLaunchCommand(toolInstance);
                if (path2 == null) {
                    return toolInstance;
                }
                command2 = path2;
                DotDesktopFileChannelExtension dotDesktopFileChannelExtension = UtilKt.getDotDesktopFileChannelExtension(toolInstance.getChannel());
                if (dotDesktopFileChannelExtension == null || (dotDesktopFileChannelExtension = dotDesktopFileChannelExtension.getDotDesktopFileName()) == null) {
                    return toolInstance;
                }
                dotDesktopFileName = dotDesktopFileChannelExtension;
                dotDesktopFilePath = this.dotDesktopFileCommonPath.resolve((Path)dotDesktopFileName);
                String string2 = toolInstance.getTool().getBundledIcon-CQRfofY();
                if (string2 == null) {
                    string2 = string = toolInstance.getTool().getIcon-CQRfofY();
                }
                if (string2 == null) break block12;
                it = string;
                boolean bl = false;
                Path path3 = this.imageManager.getPathOrNull--_CWKLA((String)it);
                string = path3;
                if (path3 != null) break block13;
            }
            DetectedToolInstance detectedToolInstance = this.toolScanner.scanTool(toolInstance.getChannel().getInstallationDirectory());
            string = detectedToolInstance != null ? detectedToolInstance.getIconPath() : null;
        }
        String localToolIcon = string;
        ToolBuild dataFromFeed = ((AvailableTools)this.availableTools.getValue()).get-pxhtFfg(toolInstance.getTool().getToolId-UtVBrGo(), toolInstance.getTool().getVersionName(), toolInstance.getTool().getBuildNumber-Y_E1uuk());
        String string3 = localToolIcon;
        if (string3 == null) {
            string3 = IconUtilKt.writeIconIfNecessary(this.fileSystem, this.imageManager, this.dotDesktopIconsCachePath, toolInstance, (Path)dotDesktopFileName);
        }
        String newIconPath = string3;
        Object $this$onRefresh_u24lambda_u243 = it = MapsKt.createMapBuilder();
        boolean $i$a$-buildMap-DotDesktopFileRefresher$onRefresh$additionalDotDesktopEntries$22 = false;
        String string4 = newIconPath;
        if (string4 != null) {
            String it2 = string4;
            boolean bl = false;
            $this$onRefresh_u24lambda_u243.put("Icon", it2.toString());
        }
        if (dataFromFeed != null) {
            $this$onRefresh_u24lambda_u243.put("Comment", dataFromFeed.getTool().getDescription());
            String string5 = dataFromFeed.getBuild().getStartupWmClass();
            if (string5 != null) {
                String it3 = string5;
                boolean bl = false;
                $this$onRefresh_u24lambda_u243.put("StartupWMClass", it3);
            }
            $this$onRefresh_u24lambda_u243.putAll(dataFromFeed.getBuild().getDotDesktopExtraEntries());
        }
        Map additionalDotDesktopEntries = MapsKt.build((Map)it);
        String name2 = InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool());
        Pair[] $i$a$-buildMap-DotDesktopFileRefresher$onRefresh$additionalDotDesktopEntries$22 = new Pair[]{TuplesKt.to((Object)"Name", (Object)name2), TuplesKt.to((Object)"Exec", (Object)("\"" + command2 + "\" %u")), TuplesKt.to((Object)"Version", (Object)"1.0"), TuplesKt.to((Object)"Type", (Object)"Application"), TuplesKt.to((Object)"Categories", (Object)"Development;IDE;"), TuplesKt.to((Object)"Terminal", (Object)"false")};
        Map updatedDotDesktopEntries = MapsKt.plus((Map)MapsKt.mapOf((Pair[])$i$a$-buildMap-DotDesktopFileRefresher$onRefresh$additionalDotDesktopEntries$22), (Map)additionalDotDesktopEntries);
        Map previousContents = DotDesktopAccessor.ensureDotDesktopFile$default(this.dotDesktopAccessor, dotDesktopFilePath, updatedDotDesktopEntries, null, 4, null);
        String string6 = (String)previousContents.get("Icon");
        Path path4 = previousIconPath = string6 != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string6, (boolean)false, (int)1, null) : null;
        if (previousIconPath != null && !Intrinsics.areEqual((Object)previousIconPath, (Object)newIconPath) && PathExtensionsKt.contains(this.dotDesktopIconsCachePath, previousIconPath)) {
            this.fileSystem.delete(previousIconPath);
        }
        return toolInstance;
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull ToolInstance initial, @NotNull Continuation<? super ToolInstance> $completion) {
        return ToolRefreshHandler.super.onRefresh(toolInstance, initial, $completion);
    }

    @Override
    public boolean dependsOn(@NotNull WithSideEffects other) {
        return ToolRefreshHandler.super.dependsOn(other);
    }

    @Override
    @NotNull
    public Collection<SideEffect> getSideEffects() {
        return ToolRefreshHandler.super.getSideEffects();
    }
}

